/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.system.Os;
import android.text.TextUtils;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.MainDex;
import com.tencent.liteav.base.b;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;

@MainDex
public abstract class PathUtils {
    private static final String TAG = "PathUtils";
    private static final String THUMBNAIL_DIRECTORY_NAME = "textures";
    private static final int DATA_DIRECTORY = 0;
    private static final int THUMBNAIL_DIRECTORY = 1;
    private static final int CACHE_DIRECTORY = 2;
    private static final int LOG_DIRECTORY = 3;
    private static final int NUM_DIRECTORIES = 4;
    private static final AtomicBoolean sInitializationStarted = new AtomicBoolean();
    private static FutureTask<String[]> sDirPathFetchTask;
    private static String sDataDirectorySuffix;
    private static String sCacheSubDirectory;

    private PathUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getOrComputeDirectoryPaths() {
        if (!sDirPathFetchTask.cancel(false)) return sDirPathFetchTask.get();
        b b2 = b.a();
        Throwable throwable = null;
        try {
            String[] stringArray = PathUtils.setPrivateDataDirectorySuffixInternal();
            b2.close();
            return stringArray;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            b2.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {}
                        throw throwable4;
                    } else {
                        b2.close();
                    }
                    throw throwable4;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (ExecutionException executionException) {}
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private static void chmod(String path, int mode) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        try {
            Os.chmod((String)path, (int)mode);
            return;
        }
        catch (Exception exception) {
            Log.e(TAG, "Failed to set permissions for path \"" + path + "\"", new Object[0]);
            return;
        }
    }

    private static String[] setPrivateDataDirectorySuffixInternal() {
        File file;
        String[] stringArray = new String[4];
        Context context = ContextUtils.getApplicationContext();
        stringArray[0] = context.getDir(sDataDirectorySuffix, 0).getPath();
        PathUtils.chmod(stringArray[0], 448);
        stringArray[1] = context.getDir(THUMBNAIL_DIRECTORY_NAME, 0).getPath();
        if (context.getCacheDir() != null) {
            stringArray[2] = sCacheSubDirectory == null ? context.getCacheDir().getPath() : new File(context.getCacheDir(), sCacheSubDirectory).getPath();
        }
        if ((file = context.getExternalFilesDir(null)) != null) {
            stringArray[3] = file.getAbsolutePath() + "/log/liteav";
        }
        return stringArray;
    }

    public static void setPrivateDataDirectorySuffix(String suffix, String cacheSubDir) {
        if (!sInitializationStarted.getAndSet(true)) {
            assert (ContextUtils.getApplicationContext() != null);
            sDataDirectorySuffix = suffix;
            sCacheSubDirectory = cacheSubDir;
            sDirPathFetchTask = new FutureTask(com.tencent.liteav.base.a.a());
            return;
        }
        assert (TextUtils.equals((CharSequence)sDataDirectorySuffix, (CharSequence)suffix)) : String.format("%s != %s", suffix, sDataDirectorySuffix);
        assert (TextUtils.equals((CharSequence)sCacheSubDirectory, (CharSequence)cacheSubDir)) : String.format("%s != %s", cacheSubDir, sCacheSubDirectory);
    }

    public static void setPrivateDataDirectorySuffix(String suffix) {
        PathUtils.setPrivateDataDirectorySuffix(suffix, null);
    }

    private static String getDirectoryPath(int index) {
        return a.a[index];
    }

    @CalledByNative
    public static String getDataDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(0);
    }

    @CalledByNative
    public static String getCacheDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(2);
    }

    @CalledByNative
    public static String getThumbnailCacheDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(1);
    }

    @CalledByNative
    public static String getLogDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(3);
    }

    static /* synthetic */ String[] access$000() {
        return PathUtils.getOrComputeDirectoryPaths();
    }

    static /* synthetic */ String[] access$lambda$0() {
        return PathUtils.setPrivateDataDirectorySuffixInternal();
    }

    static final class a {
        private static final String[] a = PathUtils.access$000();
    }
}

