/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.thumbplayer;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.r;
import com.tencent.liteav.thumbplayer.ThumbMediaPlayerListener;
import com.tencent.liteav.txcplayer.a;
import com.tencent.liteav.txcplayer.b;
import com.tencent.liteav.txcplayer.c;
import com.tencent.liteav.txcplayer.e;
import com.tencent.liteav.txcplayer.model.TXSubtitleRenderModel;
import com.tencent.liteav.txcplayer.model.c;
import com.tencent.thumbplayer.api.ITPModuleLoader;
import com.tencent.thumbplayer.api.ITPPlayer;
import com.tencent.thumbplayer.api.ITPPlayerListener;
import com.tencent.thumbplayer.api.TPAudioFrameBuffer;
import com.tencent.thumbplayer.api.TPOptionalParam;
import com.tencent.thumbplayer.api.TPPlayerFactory;
import com.tencent.thumbplayer.api.TPPlayerMgr;
import com.tencent.thumbplayer.api.TPProgramInfo;
import com.tencent.thumbplayer.api.TPSubtitleRenderModel;
import com.tencent.thumbplayer.api.TPTrackInfo;
import com.tencent.thumbplayer.api.TPVideoInfo;
import com.tencent.thumbplayer.api.composition.ITPMediaAsset;
import com.tencent.thumbplayer.api.composition.ITPMediaAssetExtraParam;
import com.tencent.thumbplayer.api.composition.ITPMediaAssetOrderedMap;
import com.tencent.thumbplayer.api.composition.ITPMediaDRMAsset;
import com.tencent.thumbplayer.api.composition.ITPMediaUrlAsset;
import com.tencent.thumbplayer.api.composition.TPMediaCompositionFactory;
import com.tencent.thumbplayer.api.proxy.TPDownloadParamData;
import com.tencent.thumbplayer.api.report.ITPBusinessReportManager;
import com.tencent.thumbplayer.api.report.TPDefaultReportInfo;
import com.tencent.thumbplayer.config.TPPlayerConfig;
import com.tencent.thumbplayer.core.common.TPSystemInfo;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDLProxyLogListener;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDownloadProxy;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadProxyFactory;
import com.tencent.thumbplayer.utils.TPLogUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ThumbMediaPlayer
extends a
implements b {
    private final String TAG = ThumbMediaPlayer.class.getName();
    private static volatile boolean mSDKInited = false;
    private volatile ITPPlayer mTPPPlayer;
    private boolean mEnableAccurateSeek = false;
    private Surface mSurface;
    private String mDataSource;
    private float mRate;
    private boolean mIsLooping;
    private boolean mScreenOnWhilePlaying;
    private SurfaceHolder mSurfaceHolder;
    private PowerManager.WakeLock mWakeLock = null;
    private int mBitrateIndex = -1000;
    private long mCachedBytes = 0L;
    private long mBitrate = 0L;
    private long mTcpSpeed = 0L;
    private long mTotalFileSize = 0L;
    private e mConfig;
    private Map<String, Object> mPrivateConfig;
    private boolean mHasReceiveFirstVideoRenderEvent = false;
    private Object mTrtcCloud = null;
    private static final String THUMB_PLAYER_GUID = "liteav_tbplayer_android_";
    private static final int THUMB_PLAYER_PLATFORM_ID = 2330303;
    private SurfaceTexture mSurfaceTexture;
    private c mSurfaceTextureHost;
    private boolean mReuseSurfaceTexture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThumbMediaPlayer(Context context) {
        Class<ThumbMediaPlayer> clazz = ThumbMediaPlayer.class;
        synchronized (ThumbMediaPlayer.class) {
            if (!mSDKInited) {
                this.setTPSystemInfo();
                this.setTPPLibCustomLoader();
                TPPlayerMgr.initSdk(context, THUMB_PLAYER_GUID + context.getPackageName(), 2330303);
                TPPlayerMgr.setDebugEnable(false);
                TPPlayerMgr.setOnLogListener(new TXCTPPlayerOnLogListener());
                mSDKInited = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.mTPPPlayer == null) {
                TPPlayerMgr.setDebugEnable(false);
                this.mTPPPlayer = TPPlayerFactory.createTPPlayer(context);
                new ThumbMediaPlayerListener(this).attachToPlayer();
            }
            this.setCustomReportData();
            return;
        }
    }

    private void setTPPLibCustomLoader() {
        try {
            if (!TextUtils.isEmpty((CharSequence)r.b())) {
                TPPlayerMgr.setLibLoader(new ITPModuleLoader(){

                    @Override
                    public void loadLibrary(String libName, String apkSoVer) {
                        r.a(libName);
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.TAG, "setTPPLibCustomLoader, ex = " + throwable.getMessage());
            return;
        }
    }

    private void setCustomReportData() {
        ITPBusinessReportManager iTPBusinessReportManager = this.mTPPPlayer.getReportManager();
        TPDefaultReportInfo tPDefaultReportInfo = new TPDefaultReportInfo(){

            @Override
            public int getPlayType() {
                return 0;
            }
        };
        if (!TextUtils.isEmpty(null)) {
            try {
                tPDefaultReportInfo.scenesId = Integer.parseInt(null);
            }
            catch (Exception exception) {
                LiteavLog.w(this.TAG, "set scenesId fail for parse appid:" + null + " ,error=" + exception.getMessage());
            }
            iTPBusinessReportManager.setReportInfoGetter(tPDefaultReportInfo);
        }
    }

    private void setTPSystemInfo() {
        TPSystemInfo.setProperty("ro.product.model", LiteavSystemInfo.getModel());
        TPSystemInfo.setProperty("ro.product.manufacturer", LiteavSystemInfo.getManufacturer());
        TPSystemInfo.setProperty("ro.build.version.release", LiteavSystemInfo.getSystemOSVersion());
        TPSystemInfo.setProperty("ro.product.board", LiteavSystemInfo.getBoard());
    }

    @Override
    public void setDisplay(SurfaceHolder sh) {
        if (this.mSurfaceTexture != null) {
            return;
        }
        if (sh != null) {
            this.mSurface = sh.getSurface();
        }
        this.mSurfaceHolder = sh;
        this.mTPPPlayer.setSurfaceHolder(sh);
    }

    @Override
    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    @Override
    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        ITPMediaAsset iTPMediaAsset;
        String string;
        this.mDataSource = string = uri.toString();
        if (this.isOfflinePlay(string)) {
            String string2 = string;
            string = string2.substring(string2.indexOf("?") + 1);
        }
        if ((iTPMediaAsset = this.handleDRMAsset(string)) != null) {
            ITPMediaUrlAsset iTPMediaUrlAsset = this.handleUrlAsset(string);
            if (iTPMediaUrlAsset != null) {
                iTPMediaAsset.setExtraParam(iTPMediaUrlAsset.getExtraParam());
            }
            if (headers != null && headers.size() > 0) {
                iTPMediaAsset.setHttpHeader(headers);
            }
            this.mTPPPlayer.setDataSource(iTPMediaAsset);
            return;
        }
        ITPMediaUrlAsset iTPMediaUrlAsset = this.handleUrlAsset(string);
        if (iTPMediaUrlAsset != null) {
            if (headers != null && headers.size() > 0) {
                iTPMediaUrlAsset.setHttpHeader(headers);
            }
            this.mTPPPlayer.setDataSource(iTPMediaUrlAsset);
            return;
        }
        this.mTPPPlayer.setDataSource(string, headers);
    }

    @Override
    public void setDataSource(FileDescriptor fd2) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mTPPPlayer.setDataSource(ParcelFileDescriptor.dup((FileDescriptor)fd2));
    }

    @Override
    public void setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(null, Uri.parse((String)path));
    }

    private ITPMediaAsset handleDRMAsset(String playUrl) {
        Object object;
        if (this.mPrivateConfig != null && (object = this.mPrivateConfig.get("TXC_DRM_ENABLE")) instanceof Boolean && ((Boolean)object).booleanValue()) {
            Object object2 = this.mPrivateConfig.get("TXC_DRM_KEY_URL");
            Object object3 = this.mPrivateConfig.get("TXC_DRM_PROVISION_URL");
            if (object2 instanceof String && object3 instanceof String && !TextUtils.isEmpty((CharSequence)((String)object2)) && !TextUtils.isEmpty((CharSequence)((String)object3))) {
                ITPMediaDRMAsset iTPMediaDRMAsset = TPMediaCompositionFactory.createMediaDRMAsset(0, playUrl);
                iTPMediaDRMAsset.setDrmProperty("drm_property_provision_url", (String)object3);
                iTPMediaDRMAsset.setDrmProperty("drm_property_license_url", (String)object2);
                iTPMediaDRMAsset.setDrmProperty("drm_property_license_standardization", "1");
                return iTPMediaDRMAsset;
            }
            Object object4 = this.mPrivateConfig.get("TXC_DRM_SIMPLE_AES_URL");
            if (object4 instanceof String && !TextUtils.isEmpty((CharSequence)((String)object4))) {
                return TPMediaCompositionFactory.createMediaUrlAsset((String)object4);
            }
        }
        return null;
    }

    private ITPMediaUrlAsset handleUrlAsset(String playUrl) {
        if (this.mConfig != null) {
            int n2 = this.mConfig.r;
            ThumbMediaPlayer thumbMediaPlayer = this;
            long l2 = thumbMediaPlayer.resolveAdaptivePreferredResolution(thumbMediaPlayer.mConfig.u);
            if (n2 > 0 || l2 > 0L) {
                ITPMediaUrlAsset iTPMediaUrlAsset = TPMediaCompositionFactory.createMediaUrlAsset(playUrl);
                ITPMediaAssetExtraParam iTPMediaAssetExtraParam = TPMediaCompositionFactory.createMediaAssetExtraParam();
                ITPMediaAssetOrderedMap iTPMediaAssetOrderedMap = TPMediaCompositionFactory.createMediaAssetOrderedMap();
                String string = com.tencent.liteav.txcplayer.a.a.a(playUrl);
                boolean bl2 = false;
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    if (string.toLowerCase().endsWith("m3u8")) {
                        if (n2 > 0) {
                            iTPMediaAssetOrderedMap.addKeyValue("hls_track_bandwidth", String.valueOf(n2));
                        } else {
                            iTPMediaAssetOrderedMap.addKeyValue("hls_track_luma_samples", String.valueOf(l2));
                        }
                        bl2 = true;
                    } else if (string.toLowerCase().endsWith("mpd")) {
                        if (n2 > 0) {
                            iTPMediaAssetOrderedMap.addKeyValue("dash_track_bandwidth", String.valueOf(n2));
                        } else {
                            iTPMediaAssetOrderedMap.addKeyValue("dash_track_luma_samples", String.valueOf(l2));
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    iTPMediaAssetExtraParam.setExtraObject("preferred_video", iTPMediaAssetOrderedMap);
                    iTPMediaUrlAsset.setExtraParam(iTPMediaAssetExtraParam);
                    return iTPMediaUrlAsset;
                }
            }
        }
        return null;
    }

    @Override
    public void setConfig(e playerConfig) {
        if (playerConfig == null) {
            return;
        }
        this.mConfig = playerConfig;
        String string = com.tencent.liteav.txcplayer.common.b.a();
        TPPlayerConfig.setProxyDataDir(string);
        int n2 = com.tencent.liteav.txcplayer.common.b.b() >= 0 ? com.tencent.liteav.txcplayer.common.b.b() : this.mConfig.f * 100;
        if (n2 > 0) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("VodCacheReserveSizeMB", n2);
                TPPlayerConfig.parseHostConfig(new JSONObject().put("httpproxy_config", (Object)jSONObject).toString());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        this.setEnableAccurateSeek(playerConfig.i);
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(100, playerConfig.o));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildBoolean(101, playerConfig.i));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(102, 1000L));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(117, 40000L));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(103, 200L));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(105, 1000L));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(106, 8000L));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(107, 30000L));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(108, (long)((float)playerConfig.c * 1000.0f)));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(109, (long)((float)playerConfig.a)));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(504, playerConfig.y ? 1 : 0));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildString(180, playerConfig.w));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildString(181, playerConfig.x));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(200, 80L));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildBoolean(201, true));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildBoolean(401, true));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(202, 2L));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(203, playerConfig.d ? 2L : 4L));
        int n3 = -1000;
        if (this.mConfig.s == -1000) {
            if (this.mBitrateIndex != -1000) {
                n3 = this.mBitrateIndex;
            }
        } else {
            n3 = this.mConfig.s;
        }
        if (n3 != -1000) {
            this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(132, n3));
        }
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(133, this.resolveAdaptivePreferredResolution(playerConfig.u)));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(450, 1L));
        TPPlayerConfig.setP2PEnable(true);
        ITPDownloadProxy iTPDownloadProxy = TPDownloadProxyFactory.getTPDownloadProxy(2330303);
        if (iTPDownloadProxy != null) {
            iTPDownloadProxy.updateStoragePath(string);
            iTPDownloadProxy.setMaxStorageSizeMB(n2);
            iTPDownloadProxy.setLogListener(new TXCDLProxyLogListener());
        }
        this.setVideoInfo(playerConfig.q);
    }

    @Override
    public void setSubtitleStyle(TXSubtitleRenderModel renderModel) {
        if (this.mTPPPlayer != null) {
            TPSubtitleRenderModel tPSubtitleRenderModel = this.convertToTPSubtitleRenderModel(renderModel);
            this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildObject(507, tPSubtitleRenderModel));
        }
    }

    private TPSubtitleRenderModel convertToTPSubtitleRenderModel(TXSubtitleRenderModel txSubtitleRenderModel) {
        TPSubtitleRenderModel tPSubtitleRenderModel = new TPSubtitleRenderModel();
        if (txSubtitleRenderModel.canvasHeight != 0 && txSubtitleRenderModel.canvasWidth != 0) {
            tPSubtitleRenderModel.canvasWidth = txSubtitleRenderModel.canvasWidth;
            tPSubtitleRenderModel.canvasHeight = txSubtitleRenderModel.canvasHeight;
            tPSubtitleRenderModel.paramFlags |= 1L;
            tPSubtitleRenderModel.paramFlags |= 2L;
            if (txSubtitleRenderModel.fontSize != 0.0f) {
                tPSubtitleRenderModel.fontSize = txSubtitleRenderModel.fontSize;
                tPSubtitleRenderModel.paramFlags |= 4L;
            }
            if (txSubtitleRenderModel.outlineWidth != 0.0f) {
                tPSubtitleRenderModel.outlineWidth = txSubtitleRenderModel.outlineWidth;
                tPSubtitleRenderModel.paramFlags |= 0x10L;
            }
            if (txSubtitleRenderModel.lineSpace != 0.0f) {
                tPSubtitleRenderModel.lineSpace = txSubtitleRenderModel.lineSpace;
                tPSubtitleRenderModel.paramFlags |= 0x40L;
            }
        }
        if (txSubtitleRenderModel.fontScale != 0.0f) {
            tPSubtitleRenderModel.fontScale = txSubtitleRenderModel.fontScale;
            tPSubtitleRenderModel.paramFlags |= 0x800L;
        }
        if (txSubtitleRenderModel.familyName != null) {
            tPSubtitleRenderModel.familyName = txSubtitleRenderModel.familyName;
        }
        if (txSubtitleRenderModel.fontColor != 0) {
            tPSubtitleRenderModel.fontColor = txSubtitleRenderModel.fontColor;
            tPSubtitleRenderModel.paramFlags |= 8L;
        }
        if (txSubtitleRenderModel.isBondFontStyle) {
            tPSubtitleRenderModel.fontStyleFlags |= 1;
            tPSubtitleRenderModel.paramFlags |= 0x400L;
        }
        if (txSubtitleRenderModel.outlineColor != 0) {
            tPSubtitleRenderModel.outlineColor = txSubtitleRenderModel.outlineColor;
            tPSubtitleRenderModel.paramFlags |= 0x20L;
        }
        if (txSubtitleRenderModel.startMargin != 0.0f) {
            tPSubtitleRenderModel.lineSpace = txSubtitleRenderModel.startMargin;
            tPSubtitleRenderModel.paramFlags |= 0x80L;
        }
        if (txSubtitleRenderModel.endMargin != 0.0f) {
            tPSubtitleRenderModel.endMargin = txSubtitleRenderModel.endMargin;
            tPSubtitleRenderModel.paramFlags |= 0x100L;
        }
        if (txSubtitleRenderModel.verticalMargin != 0.0f) {
            tPSubtitleRenderModel.verticalMargin = txSubtitleRenderModel.verticalMargin;
            tPSubtitleRenderModel.paramFlags |= 0x200L;
        }
        return tPSubtitleRenderModel;
    }

    private void setVideoInfo(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (this.mTPPPlayer != null) {
            Object object;
            String string;
            TPVideoInfo.Builder builder = new TPVideoInfo.Builder();
            TPDownloadParamData tPDownloadParamData = new TPDownloadParamData(0);
            if (!this.isOfflinePlay(url)) {
                string = com.tencent.liteav.txcplayer.a.a.d(url);
            } else {
                object = url.substring(0, url.indexOf("?"));
                string = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
                TPDownloadProxyFactory.getTPDownloadProxy(2330303).updateStoragePath(((String)object).substring(0, ((String)object).lastIndexOf(47)));
                tPDownloadParamData.setOffline(true);
            }
            builder.fileId(string);
            if (this.mConfig != null && this.mConfig.y && string.endsWith(".hls")) {
                if (this.mConfig.C == 2) {
                    tPDownloadParamData.setDlType(5);
                } else {
                    tPDownloadParamData.setDlType(3);
                }
            }
            object = new HashMap();
            if (this.mConfig.n > 0 && !this.mConfig.p) {
                object.put("dl_param_buffer_size", this.mConfig.n * 1024 * 1024);
            } else if (this.mConfig.m > 0) {
                object.put("dl_param_buffer_size", this.mConfig.m * 1024 * 1024);
            }
            if (this.mConfig.s != -1000) {
                object.put("dl_param_preferred_bitrate_index", this.mConfig.s);
            } else if (this.mBitrateIndex != -1000) {
                object.put("dl_param_preferred_bitrate_index", this.mBitrateIndex);
            }
            if (this.mConfig.u > 0L) {
                object.put("dl_param_preferred_resolution", this.mConfig.u);
            }
            if (object.size() > 0) {
                tPDownloadParamData.setExtInfoMap((Map<String, String>)object);
            }
            builder.downloadParam(tPDownloadParamData);
            this.mTPPPlayer.setVideoInfo(builder.build());
        }
    }

    private boolean isOfflinePlay(String url) {
        if (TextUtils.isEmpty((CharSequence)url) || !url.contains("?") || url.startsWith("http")) {
            return false;
        }
        String string = url;
        String string2 = com.tencent.liteav.txcplayer.a.a.d(string.substring(string.indexOf("?") + 1));
        return !TextUtils.isEmpty((CharSequence)string2) && url.contains(string2 + "?");
    }

    public e getConfig() {
        return this.mConfig;
    }

    @Override
    public long getPropertyLong(int paramId) throws IllegalStateException {
        int n2 = paramId;
        switch (paramId) {
            case 100: {
                n2 = 100;
                break;
            }
            case 101: {
                n2 = 101;
                break;
            }
            case 102: {
                n2 = 102;
                break;
            }
            case 103: {
                n2 = 103;
                break;
            }
            case 201: {
                n2 = 201;
                break;
            }
            case 202: {
                n2 = 202;
                break;
            }
            case 203: {
                n2 = 203;
                break;
            }
            case 204: {
                n2 = 204;
                break;
            }
            case 205: {
                n2 = 205;
                break;
            }
            case 206: {
                n2 = 206;
                break;
            }
            case 208: {
                n2 = 208;
                break;
            }
            case 209: {
                n2 = 209;
                break;
            }
            case 301: {
                return this.mBitrate;
            }
            case 302: {
                long l2 = this.mBitrate * (this.mTPPPlayer.getPlayableDurationMs() - this.mTPPPlayer.getCurrentPositionMs()) / 1000L / 8L;
                if (l2 < 0L) {
                    l2 = 0L;
                }
                return l2;
            }
            case 303: {
                return this.mTcpSpeed;
            }
        }
        return this.mTPPPlayer.getPropertyLong(n2);
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        try {
            LiteavLog.i(this.TAG, "prepareAsync");
            this.mTPPPlayer.prepareAsync();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            throw new IllegalStateException(throwable2);
        }
    }

    @Override
    public void start() throws IllegalStateException {
        LiteavLog.i(this.TAG, "TPPlayer start");
        if (this.mHasReceiveFirstVideoRenderEvent) {
            this.notifyOnInfo(2017, 0, 0, null);
            this.notifyOnInfo(2026, 0, 0, null);
            this.notifyOnInfo(2003, 0, 0, null);
            this.mHasReceiveFirstVideoRenderEvent = false;
        }
        if (this.mConfig.m > 0) {
            this.mTPPPlayer.updateTaskInfo("taskinfo_buffer_size_byte", this.mConfig.m * 1024 * 1024);
        }
        this.mTPPPlayer.updateTaskInfo("taskInfo_player_start", Boolean.TRUE);
        this.mTPPPlayer.start();
    }

    @Override
    public void stop() throws IllegalStateException {
        try {
            this.mTPPPlayer.stopAsync();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public void pause() throws IllegalStateException {
        this.mTPPPlayer.pause();
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        LiteavLog.i(this.TAG, "setScreenOnWhilePlaying(true) screenOn:".concat(String.valueOf(screenOn)));
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                LiteavLog.w(this.TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            if (this.mSurfaceHolder != null) {
                this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying);
            }
        }
    }

    @Override
    public int getVideoWidth() {
        try {
            return this.mTPPPlayer.getVideoWidth();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    @Override
    public int getVideoHeight() {
        try {
            return this.mTPPPlayer.getVideoHeight();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean isPlaying() {
        try {
            return this.mTPPPlayer.getCurrentState() == 5;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    @Override
    public void seekTo(long msec) throws IllegalStateException {
        LiteavLog.i(this.TAG, "seekTo msec: " + msec + "\uff1amEnableAccurateSeek\uff1a" + this.mEnableAccurateSeek);
        if (this.mEnableAccurateSeek) {
            this.mTPPPlayer.seekTo((int)msec, 3);
            return;
        }
        this.mTPPPlayer.seekTo((int)msec);
    }

    @Override
    public long getCurrentPosition() {
        return this.mTPPPlayer.getCurrentPositionMs();
    }

    @Override
    public long getDuration() {
        return this.mTPPPlayer.getDurationMs();
    }

    @Override
    public long getPlayableDurationMs() {
        return this.mTPPPlayer.getPlayableDurationMs();
    }

    @Override
    public void release() {
        this.releaseSurfaceTexture();
        this.detachTRTC();
        com.tencent.liteav.txcplayer.common.a.a().execute(new Runnable(){

            @Override
            public void run() {
                ThumbMediaPlayer.this.mTPPPlayer.release();
            }
        });
    }

    @Override
    public void reset() {
        this.releaseSurfaceTexture();
        this.mTPPPlayer.updateTaskInfo("taskInfo_player_start", Boolean.FALSE);
        if (this.mTPPPlayer != null) {
            this.mTPPPlayer.reset();
        }
    }

    @Override
    public void setRate(float rate) {
        LiteavLog.i(this.TAG, "setRate " + this.mRate);
        this.mRate = rate;
        this.mTPPPlayer.setPlaySpeedRatio(rate);
    }

    @Override
    public float getRate() {
        return this.mRate;
    }

    @Override
    public void setAudioVolume(int volume) {
        LiteavLog.i(this.TAG, "setAudioVolume\uff1a ".concat(String.valueOf(volume)));
        if (volume == 0) {
            this.mTPPPlayer.setOutputMute(true);
        } else {
            this.mTPPPlayer.setOutputMute(false);
            this.mTPPPlayer.setAudioGainRatio((float)volume / 100.0f);
        }
        if (this.mTrtcCloud != null) {
            try {
                this.mTrtcCloud.getClass().getDeclaredMethod("setMixExternalAudioVolume", Integer.TYPE, Integer.TYPE).invoke(this.mTrtcCloud, volume, volume);
                return;
            }
            catch (Exception exception) {
                LiteavLog.e(this.TAG, "setAudioVolume exception : " + exception.toString());
            }
        }
    }

    @Override
    public com.tencent.liteav.txcplayer.model.b getMediaInfo() {
        String[] stringArray;
        LiteavLog.i(this.TAG, "getMediaInfo");
        com.tencent.liteav.txcplayer.model.b b2 = new com.tencent.liteav.txcplayer.model.b();
        new com.tencent.liteav.txcplayer.model.b().a = "thumbplayer";
        b2.f = new com.tencent.liteav.txcplayer.model.c();
        String string = this.mTPPPlayer.getPropertyString(0);
        if (string != null && string.length() > 0 && (stringArray = string.split("\\n")) != null && stringArray.length > 0) {
            b2.f.b = this.getSupportedBitrates();
            int n2 = this.mBitrateIndex;
            if (n2 == -1000) {
                n2 = 0;
            }
            b2.f.e = new c.a(n2);
            b2.f.d = new c.a(n2);
            b2.f.c.add(b2.f.e);
            b2.f.c.add(b2.f.d);
            String[] stringArray2 = stringArray;
            int n3 = stringArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                String string2 = stringArray2[i2];
                if (string2 == null) continue;
                String string3 = string2;
                String string4 = string3.substring(string3.indexOf("=") + 1, string2.length()).trim();
                if (string2.contains("ContainerFormat=")) {
                    b2.f.a = string4;
                    continue;
                }
                if (string2.contains("VideoCodec=")) {
                    b2.b = "avcodec";
                    b2.c = string4;
                    b2.f.d.b = string4;
                    continue;
                }
                if (string2.contains("VideoProfile=")) {
                    b2.f.d.c = string4;
                    continue;
                }
                if (string2.contains("Width=")) {
                    b2.f.d.e = Integer.valueOf(string4);
                    continue;
                }
                if (string2.contains("Height=")) {
                    b2.f.d.f = Integer.valueOf(string4);
                    continue;
                }
                if (string2.contains("VideoBitRate=")) {
                    b2.f.d.d = Integer.valueOf(string4).intValue();
                    continue;
                }
                if (string2.contains("AudioCodec=")) {
                    b2.d = "avcodec";
                    b2.e = string4;
                    b2.f.e.b = string4;
                    continue;
                }
                if (string2.contains("AudioProfile=")) {
                    b2.f.e.c = string4;
                    continue;
                }
                if (string2.contains("AudioBitRate=")) {
                    b2.f.e.d = Integer.valueOf(string4).intValue();
                    continue;
                }
                if (!string2.contains("SampleRate=")) continue;
                b2.f.e.g = Integer.valueOf(string4);
            }
        }
        return b2;
    }

    @Override
    public void setLogEnabled(boolean enable) {
        TPLogUtil.setDebugEnable(enable);
    }

    @Override
    public boolean isPlayable() {
        return true;
    }

    @Override
    public void setAudioStreamType(int streamtype) {
        LiteavLog.i(this.TAG, "setAudioStreamType\uff1a".concat(String.valueOf(streamtype)));
    }

    @Override
    public void setKeepInBackground(boolean keepInBackground) {
        LiteavLog.i(this.TAG, "setKeepInBackground none\uff1a".concat(String.valueOf(keepInBackground)));
    }

    @Override
    public int getVideoSarNum() {
        return 0;
    }

    @Override
    public int getVideoSarDen() {
        return 0;
    }

    @Override
    public void setWakeMode(Context context, int mode) {
        LiteavLog.i(this.TAG, "setWakeMode \uff1a".concat(String.valueOf(mode)));
        boolean bl2 = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                bl2 = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(mode | 0x20000000, ThumbMediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (bl2) {
            this.mWakeLock.acquire();
        }
    }

    @Override
    public void setLooping(boolean looping) {
        LiteavLog.i(this.TAG, "setLooping \uff1a".concat(String.valueOf(looping)));
        this.mIsLooping = looping;
        this.mTPPPlayer.setLoopback(looping);
    }

    @Override
    public boolean isLooping() {
        LiteavLog.i(this.TAG, "isLooping \uff1a" + this.mIsLooping);
        return this.mIsLooping;
    }

    @Override
    public void setSurface(Surface surface) {
        if (this.mSurfaceTexture == null) {
            this.setSurfaceToPlayer(surface);
        }
        LiteavLog.i(this.TAG, "setSurface mSurface:" + this.mSurface);
    }

    private void setSurfaceToPlayer(Surface surface) {
        this.mSurfaceHolder = null;
        this.mSurface = surface;
        this.mTPPPlayer.setSurface(surface);
        LiteavLog.i(this.TAG, "setSurface mSurface:" + this.mSurface);
    }

    @Override
    public Surface getSurface() {
        LiteavLog.i(this.TAG, "getSurface \uff1a" + this.mSurface);
        return this.mSurface;
    }

    @Override
    public int getBitrateIndex() {
        if (this.mBitrateIndex == -1) {
            return this.mBitrateIndex;
        }
        TPProgramInfo[] tPProgramInfoArray = this.mTPPPlayer.getProgramInfo();
        if (tPProgramInfoArray != null && tPProgramInfoArray.length > 0) {
            TPProgramInfo[] tPProgramInfoArray2 = tPProgramInfoArray;
            int n2 = tPProgramInfoArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                TPProgramInfo tPProgramInfo = tPProgramInfoArray2[i2];
                if (!tPProgramInfo.actived || TextUtils.isEmpty((CharSequence)tPProgramInfo.resolution)) continue;
                this.mBitrateIndex = tPProgramInfo.programId;
                break;
            }
        }
        LiteavLog.i(this.TAG, "getBitrateIndex \uff1a" + this.mBitrateIndex);
        return this.mBitrateIndex;
    }

    @Override
    public void setBitrateIndex(int index) {
        TPProgramInfo[] tPProgramInfoArray;
        LiteavLog.i(this.TAG, "setBitrateIndex \uff1a".concat(String.valueOf(index)));
        if (this.mBitrateIndex == -1) {
            this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(504, 0L));
        }
        if (index != -1 && (tPProgramInfoArray = this.mTPPPlayer.getProgramInfo()) != null && index >= 0 && index < tPProgramInfoArray.length) {
            this.mTPPPlayer.selectProgram(index, 0L);
        }
        this.mBitrateIndex = index;
    }

    @Override
    public void enableAdaptiveBitrate() {
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(504, 1L));
        this.mBitrateIndex = -1;
    }

    @Override
    public ArrayList<com.tencent.liteav.txcplayer.model.a> getSupportedBitrates() {
        TPProgramInfo[] tPProgramInfoArray = this.mTPPPlayer.getProgramInfo();
        ArrayList<com.tencent.liteav.txcplayer.model.a> arrayList = null;
        if (tPProgramInfoArray != null && tPProgramInfoArray.length > 0) {
            arrayList = new ArrayList<com.tencent.liteav.txcplayer.model.a>(tPProgramInfoArray.length);
            TPProgramInfo[] tPProgramInfoArray2 = tPProgramInfoArray;
            int n2 = tPProgramInfoArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                TPProgramInfo tPProgramInfo = tPProgramInfoArray2[i2];
                if (tPProgramInfo == null) continue;
                com.tencent.liteav.txcplayer.model.a a2 = new com.tencent.liteav.txcplayer.model.a();
                String[] stringArray = tPProgramInfo.resolution.split("x");
                if (stringArray == null || stringArray.length != 2) continue;
                a2.b = Integer.valueOf(stringArray[0]);
                a2.c = Integer.valueOf(stringArray[1]);
                a2.d = (int)tPProgramInfo.bandwidth;
                a2.a = tPProgramInfo.programId;
                if (tPProgramInfo.actived) {
                    this.mBitrate = a2.d;
                }
                arrayList.add(a2);
                LiteavLog.i(this.TAG, "getSupportedBitrates item index\uff1a" + a2.a + ":width:" + a2.b + ":height:" + a2.c + ":bitrate:" + a2.d);
            }
        }
        LiteavLog.i(this.TAG, "mBitrateIndex:" + this.mBitrateIndex + ":mBitrate:" + this.mBitrate);
        return arrayList;
    }

    @Override
    public void publishAudioToNetwork() {
        LiteavLog.i(this.TAG, "publishAudioToNetwork");
        if (this.mTrtcCloud != null) {
            try {
                this.mTrtcCloud.getClass().getDeclaredMethod("enableMixExternalAudioFrame", Boolean.TYPE, Boolean.TYPE).invoke(this.mTrtcCloud, Boolean.TRUE, Boolean.TRUE);
                return;
            }
            catch (Exception exception) {
                LiteavLog.e(this.TAG, "publishAudioToNetwork exception : " + exception.toString());
            }
        }
    }

    @Override
    public void unpublishAudioToNetwork() {
        LiteavLog.i(this.TAG, "unpublishAudioToNetwork \uff1anone");
        if (this.mTrtcCloud != null) {
            try {
                this.mTrtcCloud.getClass().getDeclaredMethod("enableMixExternalAudioFrame", Boolean.TYPE, Boolean.TYPE).invoke(this.mTrtcCloud, Boolean.FALSE, Boolean.TRUE);
                return;
            }
            catch (Exception exception) {
                LiteavLog.e(this.TAG, "unpublishAudioToNetwork exception : " + exception.toString());
            }
        }
    }

    @Override
    public void attachTRTC(Object trtcCloud) {
        this.mTrtcCloud = trtcCloud;
        if (this.mTrtcCloud != null) {
            try {
                this.mTrtcCloud.getClass().getDeclaredMethod("enableMixExternalAudioFrame", Boolean.TYPE, Boolean.TYPE).invoke(this.mTrtcCloud, Boolean.FALSE, Boolean.TRUE);
                LiteavLog.i(this.TAG, "attachTRTC enableMixExternalAudioFrame");
                this.setEnableMixExternalAudioFrame();
                return;
            }
            catch (Exception exception) {
                LiteavLog.e(this.TAG, "attachTRTC exception : " + exception.toString());
            }
        }
    }

    @Override
    public void detachTRTC() {
        LiteavLog.i(this.TAG, "detachTRTC");
        if (this.mTrtcCloud != null) {
            try {
                this.mTrtcCloud.getClass().getDeclaredMethod("enableMixExternalAudioFrame", Boolean.TYPE, Boolean.TYPE).invoke(this.mTrtcCloud, Boolean.FALSE, Boolean.FALSE);
            }
            catch (Exception exception) {
                LiteavLog.e(this.TAG, "detachTRTC exception : " + exception.toString());
            }
            this.mTrtcCloud = null;
            TRTCCloudClassInvokeHelper.mInstance = null;
        }
    }

    private void setEnableMixExternalAudioFrame() {
        LiteavLog.i(this.TAG, "setEnableMixExternalAudioFrame");
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildLong(404, -1L));
        this.mTPPPlayer.setPlayerOptionalParam(new TPOptionalParam().buildBoolean(120, true));
        this.mTPPPlayer.setOnAudioFrameOutputListener(new ITPPlayerListener.IOnAudioFrameOutputListener(){

            @Override
            public void onAudioFrameOut(ITPPlayer itpPlayer, TPAudioFrameBuffer tpAudioFrameBuffer) {
                if (ThumbMediaPlayer.this.mTrtcCloud != null) {
                    TRTCCloudClassInvokeHelper.getInstance(ThumbMediaPlayer.this.mTrtcCloud).mixExternalAudioFrame(ThumbMediaPlayer.this.mTrtcCloud, tpAudioFrameBuffer);
                }
            }
        });
    }

    public void setMaxCacheSize(int sizeMB) {
        TPPlayerMgr.setProxyMaxStorageSizeMB(sizeMB);
    }

    ITPPlayer getTPPPlayer() {
        return this.mTPPPlayer;
    }

    void setEnableAccurateSeek(boolean isEnableAccurateSeek) {
        this.mEnableAccurateSeek = isEnableAccurateSeek;
    }

    void updateTcpSpeed(long speed) {
        this.mTcpSpeed = speed;
    }

    void updateBitrate(long fileTotalSize) {
        if (fileTotalSize > 0L && this.mTotalFileSize != fileTotalSize) {
            this.mTotalFileSize = fileTotalSize;
            long l2 = this.getDuration();
            if (l2 > 0L && fileTotalSize > 0L) {
                this.mBitrate = fileTotalSize * 1000L * 8L / l2;
            }
        }
    }

    public void onReceiveFirstVideoRenderEvent() {
        if (this.getTXCVodVideoViewTargetState() != 4 && (this.getConfig().p || this.mTPPPlayer.getCurrentState() == 5)) {
            this.notifyOnInfo(2017, 0, 0, null);
            this.notifyOnInfo(2026, 0, 0, null);
            this.notifyOnInfo(2003, 0, 0, null);
            this.mHasReceiveFirstVideoRenderEvent = false;
            return;
        }
        this.mHasReceiveFirstVideoRenderEvent = true;
    }

    public void releaseSurfaceTexture() {
        if (this.mSurfaceTexture != null && !this.mReuseSurfaceTexture) {
            if (this.mSurfaceTextureHost != null) {
                this.mSurfaceTextureHost.a(this.mSurfaceTexture);
            } else {
                this.mSurfaceTexture.release();
            }
            this.mSurfaceTexture = null;
        }
    }

    @Override
    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        if (this.mSurfaceTexture == surfaceTexture) {
            return;
        }
        this.releaseSurfaceTexture();
        this.mSurfaceTexture = surfaceTexture;
        if (surfaceTexture == null) {
            this.mSurface = null;
            this.setSurfaceToPlayer(null);
            return;
        }
        if (this.mSurface == null) {
            this.mSurface = new Surface(surfaceTexture);
        }
        ThumbMediaPlayer thumbMediaPlayer = this;
        thumbMediaPlayer.setSurfaceToPlayer(thumbMediaPlayer.mSurface);
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    @Override
    public void setSurfaceTextureHost(c surfaceTextureHost) {
        this.mSurfaceTextureHost = surfaceTextureHost;
    }

    @Override
    public void setPrivateConfig(Map<String, Object> configure) {
        this.mPrivateConfig = configure;
    }

    @Override
    public void addSubtitleSource(String url, String name, String mimeType) {
        this.mTPPPlayer.addSubtitleSource(url, mimeType, name);
    }

    @Override
    public void selectTrack(int trackIndex) {
        int n2 = trackIndex;
        this.mTPPPlayer.selectTrack(n2, n2);
    }

    @Override
    public void deselectTrack(int trackIndex) {
        int n2 = trackIndex;
        this.mTPPPlayer.deselectTrack(n2, n2);
    }

    @Override
    public TPTrackInfo[] getTrackInfo() {
        return this.mTPPPlayer.getTrackInfo();
    }

    private long resolveAdaptivePreferredResolution(long preferredResolution) {
        long l2;
        if (this.mBitrateIndex == -1 && preferredResolution <= 0L && (l2 = this.mConfig.t) > 0L) {
            return l2;
        }
        return preferredResolution;
    }

    static class TRTCCloudClassInvokeHelper {
        private static final String TAG = TRTCCloudClassInvokeHelper.class.getName();
        private Class mClazzTRTCCloud;
        private Class mClazzTRTCAudioFrame;
        private Field mFieldData;
        private Field mFieldSampleRate;
        private Field mFieldChannel;
        private Method mMethodMixExternalAudioFrame;
        private static TRTCCloudClassInvokeHelper mInstance;

        private TRTCCloudClassInvokeHelper(Object trtcCloud) {
            if (trtcCloud != null) {
                try {
                    this.mClazzTRTCCloud = trtcCloud.getClass();
                    this.mClazzTRTCAudioFrame = Class.forName("com.tencent.trtc.TRTCCloudDef$TRTCAudioFrame");
                    this.mFieldData = this.mClazzTRTCAudioFrame.getDeclaredField("data");
                    this.mFieldSampleRate = this.mClazzTRTCAudioFrame.getDeclaredField("sampleRate");
                    this.mFieldChannel = this.mClazzTRTCAudioFrame.getDeclaredField("channel");
                    this.mMethodMixExternalAudioFrame = this.mClazzTRTCCloud.getDeclaredMethod("mixExternalAudioFrame", this.mClazzTRTCAudioFrame);
                    return;
                }
                catch (Exception exception) {
                    LiteavLog.e(TAG, "init TRTCCloudClassInvokeWrapper error: " + exception.getMessage());
                }
            }
        }

        private static TRTCCloudClassInvokeHelper getInstance(Object trtcCloud) {
            if (mInstance == null) {
                mInstance = new TRTCCloudClassInvokeHelper(trtcCloud);
            }
            return mInstance;
        }

        private void mixExternalAudioFrame(Object trtcCloud, TPAudioFrameBuffer tpAudioFrameBuffer) {
            if (trtcCloud != null) {
                try {
                    Object t2 = this.mClazzTRTCAudioFrame.newInstance();
                    this.mFieldData.set(t2, tpAudioFrameBuffer.data[0]);
                    this.mFieldSampleRate.set(t2, tpAudioFrameBuffer.sampleRate);
                    this.mFieldChannel.set(t2, tpAudioFrameBuffer.channels);
                    this.mMethodMixExternalAudioFrame.invoke(trtcCloud, t2);
                    return;
                }
                catch (Exception exception) {
                    LiteavLog.e(TAG, "mixExternalAudioFrame method error ", exception);
                }
            }
        }
    }

    static class TXCDLProxyLogListener
    implements ITPDLProxyLogListener {
        int logLevel = LiteavLog.getLogLevel();

        private TXCDLProxyLogListener() {
        }

        @Override
        public int d(String fileName, int line, String tag, String msg) {
            if (this.logLevel <= LiteavLog.b.a.mNativeValue) {
                LiteavLog.d(tag, "[" + fileName + "," + line + "] " + msg);
            }
            return 0;
        }

        @Override
        public int i(String fileName, int line, String tag, String msg) {
            if (this.logLevel <= LiteavLog.b.b.mNativeValue) {
                LiteavLog.i(tag, "[" + fileName + "," + line + "] " + msg);
            }
            return 0;
        }

        @Override
        public int w(String fileName, int line, String tag, String msg) {
            if (this.logLevel <= LiteavLog.b.c.mNativeValue) {
                LiteavLog.w(tag, "[" + fileName + "," + line + "] " + msg);
            }
            return 0;
        }

        @Override
        public int e(String fileName, int line, String tag, String msg) {
            if (this.logLevel <= LiteavLog.b.d.mNativeValue) {
                LiteavLog.e(tag, "[" + fileName + "," + line + "] " + msg);
            }
            return 0;
        }
    }

    static class TXCTPPlayerOnLogListener
    implements TPPlayerMgr.OnLogListener {
        int logLevel = LiteavLog.getLogLevel();

        private TXCTPPlayerOnLogListener() {
        }

        @Override
        public int v(String tag, String msg) {
            if (this.logLevel <= LiteavLog.b.a.mNativeValue) {
                LiteavLog.v(tag, msg);
            }
            return 0;
        }

        @Override
        public int d(String tag, String msg) {
            if (this.logLevel <= LiteavLog.b.a.mNativeValue) {
                LiteavLog.d(tag, msg);
            }
            return 0;
        }

        @Override
        public int i(String tag, String msg) {
            if (this.logLevel <= LiteavLog.b.b.mNativeValue) {
                LiteavLog.i(tag, msg);
            }
            return 0;
        }

        @Override
        public int w(String tag, String msg) {
            if (this.logLevel <= LiteavLog.b.c.mNativeValue) {
                LiteavLog.w(tag, msg);
            }
            return 0;
        }

        @Override
        public int e(String tag, String msg) {
            if (this.logLevel <= LiteavLog.b.d.mNativeValue) {
                LiteavLog.e(tag, msg);
            }
            return 0;
        }
    }
}

