/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.text.TextUtils;
import cn.rongcloud.rtc.base.RCRTCRect;
import cn.rongcloud.rtc.core.MediaSource;
import cn.rongcloud.rtc.core.NativeAndroidVideoTrackSource;
import cn.rongcloud.rtc.core.PreVideoEncodeSink;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoProcessor;
import cn.rongcloud.rtc.core.VideoSink;
import cn.rongcloud.rtc.core.VideoSourceObserver;
import cn.rongcloud.rtc.jni.video.RCWaterMarkFilter;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import java.nio.ByteBuffer;

public class VideoSource
extends MediaSource
implements NativeAndroidVideoTrackSource.RotatedBufferListener {
    private String TAG = "VideoSource";
    private RCWaterMarkFilter waterMarkFilter;
    private PreVideoEncodeSink encodeSink;
    private long nativeEncodeSink = 0L;
    private final NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource;
    private NativeAndroidVideoTrackSource.FrameAdaptationParameters mAdaptationParameters;
    private final Object videoProcessorLock = new Object();
    private VideoProcessor videoProcessor;
    private boolean isCapturerRunning = true;
    private final VideoSourceObserver capturerObserver = new VideoSourceObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCapturerStarted(boolean success) {
            if (VideoSource.this.nativeSource != 0L) {
                VideoSource.this.nativeAndroidVideoTrackSource.setState(success);
            }
            Object object = VideoSource.this.videoProcessorLock;
            synchronized (object) {
                VideoSource.this.isCapturerRunning = success;
                if (VideoSource.this.videoProcessor != null) {
                    VideoSource.this.videoProcessor.onCapturerStarted(success);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCapturerStopped() {
            if (VideoSource.this.nativeSource != 0L) {
                VideoSource.this.nativeAndroidVideoTrackSource.setState(false);
            }
            Object object = VideoSource.this.videoProcessorLock;
            synchronized (object) {
                VideoSource.this.isCapturerRunning = false;
                if (VideoSource.this.videoProcessor != null) {
                    VideoSource.this.videoProcessor.onCapturerStopped();
                }
            }
        }

        @Override
        public void onFrameCaptured(VideoFrame frame) {
            this.onFrameCaptured(frame, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameCaptured(VideoFrame frame, VideoSourceObserver.VideoFrameCallBack callBack) {
            if (VideoSource.this.nativeSource == 0L || !VideoSource.this.isCapturerRunning) {
                return;
            }
            NativeAndroidVideoTrackSource.FrameAdaptationParameters parameters = VideoSource.this.nativeAndroidVideoTrackSource.adaptFrame(frame);
            if (parameters == null) {
                return;
            }
            VideoSource.this.mAdaptationParameters = parameters;
            VideoFrame.Buffer adaptedBuffer = frame.getBuffer().cropAndScale(parameters.cropX, parameters.cropY, parameters.cropWidth, parameters.cropHeight, parameters.scaleWidth, parameters.scaleHeight);
            VideoFrame adaptedFrame = new VideoFrame(adaptedBuffer, frame.getRotation(), parameters.timestampNs);
            if (frame.getMirror()) {
                adaptedFrame.setMirror(true);
            }
            Object object = VideoSource.this.videoProcessorLock;
            synchronized (object) {
                if (VideoSource.this.videoProcessor != null && VideoSource.this.isCapturerRunning) {
                    VideoSource.this.videoProcessor.onFrameCaptured(adaptedFrame);
                    adaptedBuffer.release();
                    return;
                }
                if (VideoSource.this.nativeSource != 0L && VideoSource.this.isCapturerRunning) {
                    VideoSource.this.nativeAndroidVideoTrackSource.onFrameCaptured(adaptedFrame);
                }
                if (callBack != null) {
                    callBack.onFrame(adaptedFrame);
                }
            }
            frame.updateAdaptedSize(adaptedBuffer.getWidth(), adaptedBuffer.getHeight());
            adaptedBuffer.release();
        }
    };

    public void initWatermarkEnv(String waterPath, RCRTCRect rect, int waterWidth, int waterHeight) {
        if (this.waterMarkFilter != null) {
            this.waterMarkFilter.destroyWatermarkEnv();
            this.waterMarkFilter = null;
        }
        if (!TextUtils.isEmpty((CharSequence)waterPath)) {
            this.waterMarkFilter = new RCWaterMarkFilter();
            if (!this.waterMarkFilter.isInitWatermarkEnv()) {
                this.waterMarkFilter.setWatermarkParams(waterPath, rect, waterWidth, waterHeight);
            }
        } else {
            RLog.d((String)this.TAG, (String)"- initWatermarkEnv(): waterPath == null !");
        }
        boolean existed = !TextUtils.isEmpty((CharSequence)waterPath);
        ReportUtil.libStatus(ReportUtil.TAG.INITWATERMARKENV, "status|haswm", "- initWatermarkEnv", existed);
    }

    public void destroyWatermarkEnv() {
        if (this.waterMarkFilter != null) {
            RLog.d((String)this.TAG, (String)"- destroyWatermarkEnv()");
            this.waterMarkFilter.destroyWatermarkEnv();
            this.waterMarkFilter = null;
            this.nativeAndroidVideoTrackSource.setRotatedBufferListener(null);
        }
    }

    @Override
    public void onBufferRotated(ByteBuffer y, ByteBuffer u, ByteBuffer v, int rotation) {
        NativeAndroidVideoTrackSource.FrameAdaptationParameters parameters = this.mAdaptationParameters;
        if (parameters != null) {
            boolean ret;
            if (this.waterMarkFilter != null && !(ret = this.waterMarkFilter.reInitWatermarkEnv(parameters.scaleHeight, parameters.scaleWidth, rotation)) && this.waterMarkFilter != null) {
                this.waterMarkFilter.destroyWatermarkEnv();
                this.waterMarkFilter = null;
            }
            if (this.waterMarkFilter != null && this.waterMarkFilter.isInitWatermarkEnv()) {
                this.waterMarkFilter.drawWatermark(y, u, v, parameters.scaleHeight, parameters.scaleWidth, rotation);
            }
        }
    }

    public VideoSource(long nativeSource) {
        super(nativeSource);
        this.nativeAndroidVideoTrackSource = new NativeAndroidVideoTrackSource(nativeSource);
        this.nativeAndroidVideoTrackSource.setRotatedBufferListener(this);
    }

    public void adaptOutputFormat(int width, int height, int fps) {
        int maxSide = Math.max(width, height);
        int minSide = Math.min(width, height);
        this.adaptOutputFormat(maxSide, minSide, minSide, maxSide, fps);
    }

    public void adaptExactOutputFormat(int width, int height, int fps) {
        int maxSide = Math.max(width, height);
        int minSide = Math.min(width, height);
        this.adaptExactOutputFormat(maxSide, minSide, minSide, maxSide, fps);
    }

    public void adaptOutputFormat(int landscapeWidth, int landscapeHeight, int portraitWidth, int portraitHeight, int fps) {
        this.adaptOutputFormat(new AspectRatio(landscapeWidth, landscapeHeight), (Integer)(landscapeWidth * landscapeHeight), new AspectRatio(portraitWidth, portraitHeight), (Integer)(portraitWidth * portraitHeight), (Integer)fps);
    }

    public void adaptOutputFormat(AspectRatio targetLandscapeAspectRatio, Integer maxLandscapePixelCount, AspectRatio targetPortraitAspectRatio, Integer maxPortraitPixelCount, Integer maxFps) {
        if (this.nativeSource != 0L) {
            this.nativeAndroidVideoTrackSource.adaptOutputFormat(targetLandscapeAspectRatio, maxLandscapePixelCount, targetPortraitAspectRatio, maxPortraitPixelCount, maxFps);
        }
    }

    public void adaptExactOutputFormat(int landscapeWidth, int landscapeHeight, int portraitWidth, int portraitHeight, int fps) {
        this.adaptExactOutputFormat(new AspectRatio(landscapeWidth, landscapeHeight), (Integer)(landscapeWidth * landscapeHeight), new AspectRatio(portraitWidth, portraitHeight), (Integer)(portraitWidth * portraitHeight), (Integer)fps);
    }

    public void adaptExactOutputFormat(AspectRatio targetLandscapeAspectRatio, Integer maxLandscapePixelCount, AspectRatio targetPortraitAspectRatio, Integer maxPortraitPixelCount, Integer maxFps) {
        if (this.nativeSource != 0L) {
            this.nativeAndroidVideoTrackSource.adaptExactOutputFormat(targetLandscapeAspectRatio, maxLandscapePixelCount, targetPortraitAspectRatio, maxPortraitPixelCount, maxFps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoProcessor(VideoProcessor newVideoProcessor) {
        Object object = this.videoProcessorLock;
        synchronized (object) {
            if (this.videoProcessor != null) {
                this.videoProcessor.setSink(null);
                if (this.isCapturerRunning) {
                    this.videoProcessor.onCapturerStopped();
                }
            }
            this.videoProcessor = newVideoProcessor;
            if (newVideoProcessor != null) {
                newVideoProcessor.setSink(new VideoSink(){

                    @Override
                    public void onFrame(VideoFrame frame) {
                        if (VideoSource.this.nativeSource != 0L) {
                            VideoSource.this.nativeAndroidVideoTrackSource.onFrameCaptured(frame);
                        }
                    }
                });
                if (this.isCapturerRunning) {
                    newVideoProcessor.onCapturerStarted(true);
                }
            }
        }
    }

    public VideoSourceObserver getCapturerObserver() {
        return this.capturerObserver;
    }

    long getNativeVideoTrackSource() {
        return this.getNativeMediaSource();
    }

    @Override
    public void dispose() {
        this.setVideoProcessor(null);
        super.dispose();
    }

    public void setPreVideoEncodeSink(PreVideoEncodeSink encodeSink) {
        if (this.encodeSink != null && this.nativeEncodeSink != 0L) {
            this.disposeEncodeSink();
        }
        this.nativeEncodeSink = this.nativeAndroidVideoTrackSource.wrapPreEncodeSink(encodeSink);
        this.nativeAndroidVideoTrackSource.setPreEncodeSink(this.nativeEncodeSink);
        this.encodeSink = encodeSink;
    }

    public void removePreVideoEncodeSink(PreVideoEncodeSink encodeSink) {
        if (this.encodeSink == encodeSink && this.nativeEncodeSink != 0L) {
            this.disposeEncodeSink();
        }
    }

    private void disposeEncodeSink() {
        this.nativeAndroidVideoTrackSource.removePreEncodeSink(this.nativeEncodeSink);
        this.nativeAndroidVideoTrackSource.freePreEncodeSink(this.nativeEncodeSink);
        this.encodeSink = null;
        this.nativeEncodeSink = 0L;
    }

    public static class AspectRatio {
        public static final AspectRatio UNDEFINED = new AspectRatio(0, 0);
        public final int width;
        public final int height;

        public AspectRatio(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

