/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.recordcallback;

import android.media.AudioManager;
import android.media.AudioRecordingConfiguration;
import android.os.Build;
import androidx.annotation.RequiresApi;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.base.RCRTCAudioEventCode;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.recordcallback.AbstractRecordCallbackObserver;
import cn.rongcloud.rtc.recordcallback.RecordCallBackManger;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.List;

public class AudioRecordCallbackObserver
extends AbstractRecordCallbackObserver {
    IConditions conditions;
    AudioManager audioManager;
    volatile Boolean isSilenced = false;
    volatile int activeRecordingCount = -1;

    public AudioRecordCallbackObserver(int id, RecordCallBackManger subject, IConditions conditions, AudioManager audioManager) {
        super(id, subject);
        this.conditions = conditions;
        this.audioManager = audioManager;
        if (null != this.subJectManger) {
            this.subJectManger.registerObserves(this);
        }
    }

    @Override
    void monitor(List<AudioRecordingConfiguration> configs) {
        ReportUtil.libTask(ReportUtil.TAG.AUDIORECORDMONITOR, "configSize|android", configs.size(), Build.VERSION.SDK_INT);
        if (Build.VERSION.SDK_INT >= 29) {
            this.handlePreemptedEvent(configs);
        } else if (Build.VERSION.SDK_INT >= 24) {
            this.handleActiveRecordingChange(configs);
        }
    }

    @RequiresApi(api=24)
    private void handleActiveRecordingChange(List<AudioRecordingConfiguration> configs) {
        List activeRecordingConfigurations = this.audioManager.getActiveRecordingConfigurations();
        if (activeRecordingConfigurations.size() == this.activeRecordingCount) {
            return;
        }
        this.activeRecordingCount = activeRecordingConfigurations.size();
        if (this.activeRecordingCount == 0) {
            this.onOthersRecorderReleased();
        }
    }

    @RequiresApi(api=29)
    private void handlePreemptedEvent(List<AudioRecordingConfiguration> configs) {
        for (AudioRecordingConfiguration config : configs) {
            boolean clientSilenced;
            if (config.getClientAudioSessionId() != this.sessionId || (clientSilenced = config.isClientSilenced()) == this.isSilenced) continue;
            this.isSilenced = clientSilenced;
            if (this.isSilenced.booleanValue()) {
                this.onLoseAudioRecordFocus();
                continue;
            }
            this.onRegainAudioRecordFocus();
        }
    }

    private void onLoseAudioRecordFocus() {
        RTCEngineImpl.getInstance().engineLocalAudioEventNotify(RCRTCAudioEventCode.IN_INTERRUPTION);
    }

    private void onRegainAudioRecordFocus() {
        RCMicOutputStreamImpl stream;
        if (null != this.subJectManger) {
            this.subJectManger.unregisterObserves(this);
        }
        boolean isReset = this.conditions.isReset();
        ReportUtil.libStatus(ReportUtil.TAG.AUDIORECORDMONITOR, "isReset", isReset);
        if (this.conditions.isReset() && null != (stream = (RCMicOutputStreamImpl)RCRTCEngine.getInstance().getDefaultAudioStream())) {
            ReportUtil.libTask(ReportUtil.TAG.RESETAUDIOINPUT, "reason", "onRegainAudioRecordFocus");
            stream.resetAudioInput();
        }
        RTCEngineImpl.getInstance().engineLocalAudioEventNotify(RCRTCAudioEventCode.END_INTERRUPTION);
    }

    private void onOthersRecorderReleased() {
        if (null != this.subJectManger) {
            this.subJectManger.unregisterObserves(this);
        }
        boolean isReset = this.conditions.isReset();
        ReportUtil.libStatus(ReportUtil.TAG.AUDIORECORDMONITOR, "isReset", isReset);
        if (isReset) {
            RCMicOutputStreamImpl stream = (RCMicOutputStreamImpl)RCRTCEngine.getInstance().getDefaultAudioStream();
            if (null != stream) {
                ReportUtil.libTask(ReportUtil.TAG.RESETAUDIOINPUT, "reason", "onOthersRecorderReleased");
                stream.resetAudioInput();
            }
            RTCEngineImpl.getInstance().engineLocalAudioEventNotify(RCRTCAudioEventCode.END_INTERRUPTION);
        }
    }

    public static interface IConditions {
        public boolean isReset();
    }
}

