/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_scroller.view;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.HorizontalScrollView;
import com.taobao.weex.ui.component.DCWXScroller;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.ui.blur.AppEventForBlurManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class DCWXHorizontalScrollView
extends HorizontalScrollView
implements IWXScroller,
WXGestureObservable {
    private WXGesture wxGesture;
    private ScrollViewListener mScrollViewListener;
    private List<ScrollViewListener> mScrollViewListeners;
    private boolean scrollable = true;
    private Field scroller = null;
    private boolean isTouch = false;
    int mScrollX;
    int mScrollY;
    private boolean shouldBeTriggerUpper = true;
    private boolean shouldBeTriggerLower = true;
    private float upper = 50.0f;
    private float lowwer = 50.0f;

    public DCWXHorizontalScrollView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setOverScrollMode(2);
        try {
            this.scroller = HorizontalScrollView.class.getDeclaredField("mScroller");
            this.scroller.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DCWXHorizontalScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        AppEventForBlurManager.onScrollChanged((int)l, (int)t);
        this.mScrollX = this.getScrollX();
        this.mScrollY = this.getScrollY();
        if ((float)this.getScrollX() <= this.upper && !this.shouldBeTriggerUpper) {
            this.scrollToTop();
            this.shouldBeTriggerUpper = true;
        } else if ((float)this.getScrollX() > this.upper) {
            this.shouldBeTriggerUpper = false;
        }
        View view = this.getChildAt(this.getChildCount() - 1);
        if (view == null) {
            return;
        }
        int d = view.getRight();
        if ((float)(d -= this.getWidth() + this.mScrollX) <= this.lowwer && !this.shouldBeTriggerLower) {
            this.scrollToBottom();
            this.shouldBeTriggerLower = true;
        } else if ((float)d > this.lowwer) {
            this.shouldBeTriggerLower = false;
        }
        if (this.mScrollViewListener != null) {
            this.mScrollViewListener.onScrollChanged(this, l, t, oldl - l, oldt - t);
        }
        if (this.mScrollViewListeners != null) {
            for (ScrollViewListener listener : this.mScrollViewListeners) {
                listener.onScrollChanged(this, l, t, oldl - l, oldt - t);
            }
        }
    }

    private void scrollToTop() {
        if (this.mScrollViewListener != null) {
            this.mScrollViewListener.onScrolltoTop();
        }
        if (this.mScrollViewListeners != null) {
            for (ScrollViewListener listener : this.mScrollViewListeners) {
                listener.onScrolltoTop();
            }
        }
    }

    public void stopScroll() {
        if (this.scroller != null && !this.isTouch) {
            try {
                Class<?> clazz = this.scroller.getType();
                Method method = clazz.getMethod("abortAnimation", new Class[0]);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke(this.scroller.get(this), new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setUpperLength(float length) {
        this.upper = length;
    }

    public void setLowwerLength(float length) {
        this.lowwer = length;
    }

    private void scrollToBottom() {
        if (this.mScrollViewListener != null) {
            this.mScrollViewListener.onScrollToBottom();
        }
        if (this.mScrollViewListeners != null) {
            for (ScrollViewListener listener : this.mScrollViewListeners) {
                listener.onScrollToBottom();
            }
        }
    }

    public void setScrollViewListener(ScrollViewListener scrollViewListener) {
        this.mScrollViewListener = scrollViewListener;
    }

    @Override
    public void destroy() {
        if (this.mScrollViewListeners != null) {
            this.mScrollViewListeners.clear();
        }
    }

    public void addScrollViewListener(ScrollViewListener scrollViewListener) {
        if (this.mScrollViewListeners == null) {
            this.mScrollViewListeners = new ArrayList<ScrollViewListener>();
        }
        if (!this.mScrollViewListeners.contains(scrollViewListener)) {
            this.mScrollViewListeners.add(scrollViewListener);
        }
    }

    public void removeScrollViewListener(ScrollViewListener scrollViewListener) {
        this.mScrollViewListeners.remove(scrollViewListener);
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean result = super.dispatchTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.isTouch = true;
                break;
            }
            case 1: {
                this.isTouch = false;
                break;
            }
            case 3: {
                this.isTouch = false;
            }
        }
        return super.onTouchEvent(ev);
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public Rect getContentFrame() {
        return new Rect(0, 0, this.computeHorizontalScrollRange(), this.computeVerticalScrollRange());
    }

    public void setWAScroller(DCWXScroller mWAScroller) {
        this.upper = WXViewUtils.getRealPxByWidth(50.0f, mWAScroller.getViewPortWidth());
        this.lowwer = WXViewUtils.getRealPxByWidth(50.0f, mWAScroller.getViewPortWidth());
    }

    public static interface ScrollViewListener {
        public void onScrollChanged(DCWXHorizontalScrollView var1, int var2, int var3, int var4, int var5);

        public void onScrolltoTop();

        public void onScrollToBottom();
    }
}

