/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.media.audiofx.AudioEffect;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import cn.rongcloud.rtc.base.RCRTCAudioEventCode;
import cn.rongcloud.rtc.core.audio.CustomAudioRecord;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.core.voiceengine.RongRtcAudioEffects;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.plugin.VoiceBeautifierPlugin;
import cn.rongcloud.rtc.recordcallback.AudioRecordCallbackObserver;
import cn.rongcloud.rtc.recordcallback.RecordCallBackManger;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.PCMFileWriter;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.TimeCorrector;
import io.rong.common.RLog;
import java.nio.ByteBuffer;
import java.util.Random;

public class RongAudioRecord
implements CustomAudioRecord.AudioRecordProxy,
AudioRecordCallbackObserver.IConditions {
    private static final int TIME_INTERVAL_MILLIS = 10;
    private static final int CACHE_FRAME_COUNT = 3;
    private AudioRecord audioRecord;
    AudioRecordCallbackObserver audioRecordCallbackObserve;
    private int sampleRate;
    private int channelCount;
    private int audioFormat;
    private int channelConfig;
    private int bufferSizeInBytes;
    private OnAudioBufferAvailableListener onAudioBufferAvailableListener;
    private static final boolean isDump = false;
    private static final String TAG = "RongAudioRecord";
    private TimeCorrector timeCorrector;
    private boolean initialized = false;
    private static final Object audioLock = new Object();
    private boolean isRecording = false;
    private AudioManager audioManager;
    private VoiceBeautifierPlugin audioBeautifierPlugin;
    private PCMFileWriter fileWriter;
    private RongRtcAudioEffects audioEffects;
    private RecordCallBackManger recordCallBackManger;
    private boolean enableEffect;
    private boolean rtcProbeEnable = false;
    private Random random;
    private byte[][] analogAudioBuffer;
    private int frameIndex = 0;

    public RongAudioRecord(AudioManager audioManager, RecordCallBackManger callBackManger) {
        this.audioManager = audioManager;
        this.recordCallBackManger = callBackManger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(int audioSource, int sampleRate, int channelConfig, int audioFormat, int bufferSizeInBytes) {
        Object object = audioLock;
        synchronized (object) {
            this.audioEffects = RongRtcAudioEffects.create();
            this.sampleRate = sampleRate;
            this.channelConfig = channelConfig;
            this.channelCount = this.channelConfigToCount(channelConfig);
            this.audioFormat = audioFormat;
            this.bufferSizeInBytes = bufferSizeInBytes;
            this.timeCorrector = new TimeCorrector(10L);
            if (RTCEngineImpl.getInstance().isMicrophoneEnabled()) {
                if (audioSource != RTCEngineImpl.getInstance().getRecordAudioSource()) {
                    audioSource = RTCEngineImpl.getInstance().getRecordAudioSource();
                }
                FinLog.d(TAG, "- init() audioSource:" + audioSource);
                this.audioRecord = new AudioRecord(audioSource, sampleRate, channelConfig, audioFormat, bufferSizeInBytes);
                this.audioEffects.setAEC(true);
                this.audioEffects.setNS(this.enableEffect);
                this.audioEffects.enable(this.audioRecord.getAudioSessionId());
                if (Build.VERSION.SDK_INT >= 24) {
                    this.audioRecordCallbackObserve = new AudioRecordCallbackObserver(this.audioRecord.getAudioSessionId(), this.recordCallBackManger, this, this.audioManager);
                }
            }
            this.initialized = true;
        }
    }

    @Override
    public void setVoiceBeautifier(VoiceBeautifierPlugin beautifier) {
        this.audioBeautifierPlugin = beautifier;
    }

    private void setAudioManagerMode(int mode) {
        if (this.audioManager != null) {
            this.audioManager.setMode(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer, int sizeInBytes) {
        int size;
        Object object = audioLock;
        synchronized (object) {
            if (this.audioRecord != null && this.isRecording && !this.rtcProbeEnable) {
                size = this.audioRecord.read(byteBuffer, sizeInBytes);
                this.timeCorrector.increaseTime(false);
                this.analogAudioBuffer = null;
            } else {
                if (this.rtcProbeEnable) {
                    this.analogAudioData(byteBuffer, sizeInBytes);
                }
                this.timeCorrector.increaseTime(true);
                size = sizeInBytes;
            }
        }
        return size;
    }

    private void analogAudioData(ByteBuffer byteBuffer, int size) {
        byteBuffer.clear();
        byteBuffer.rewind();
        if (this.random == null) {
            this.random = new Random();
        }
        if (this.analogAudioBuffer == null) {
            this.analogAudioBuffer = new byte[3][size];
            for (int i = 0; i < 3; ++i) {
                this.random.nextBytes(this.analogAudioBuffer[i]);
            }
        }
        this.frameIndex %= 3;
        byteBuffer.put(this.analogAudioBuffer[this.frameIndex]);
        ++this.frameIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchAudioSource() {
        Object object = audioLock;
        synchronized (object) {
            if (this.audioRecord == null) {
                FinLog.i(TAG, "audioRecord is null return ");
                return;
            }
            int audioSource = RTCEngineImpl.getInstance().getRecordAudioSource();
            Log.d((String)TAG, (String)("- switchAudioSource() sampleRate:" + this.sampleRate + ", channel:" + this.channelConfig + ", audioSource:" + audioSource));
            if (this.audioRecord.getAudioSource() != audioSource) {
                if (null != this.audioRecordCallbackObserve && null != this.recordCallBackManger) {
                    this.recordCallBackManger.unregisterObserves(this.audioRecordCallbackObserve);
                }
                this.audioRecord.stop();
                this.audioRecord.release();
                AudioRecord newAudioRecord = new AudioRecord(audioSource, this.sampleRate, this.channelConfig, this.audioFormat, this.bufferSizeInBytes);
                newAudioRecord.startRecording();
                this.audioEffects.release();
                this.audioEffects.setNS(this.enableEffect);
                this.audioEffects.setAEC(true);
                this.audioEffects.enable(newAudioRecord.getAudioSessionId());
                if (Build.VERSION.SDK_INT >= 24) {
                    this.audioRecordCallbackObserve = new AudioRecordCallbackObserver(newAudioRecord.getAudioSessionId(), this.recordCallBackManger, this, this.audioManager);
                }
                FinLog.i(TAG, "audio source: " + audioSource + ", recording state: " + newAudioRecord.getRecordingState());
                this.audioRecord = newAudioRecord;
            } else {
                FinLog.i(TAG, "audioSource already is :: " + audioSource);
            }
        }
    }

    @RequiresApi(api=29)
    private void checkRecoder() {
        Log.d((String)TAG, (String)("checkRecoder: " + this.audioManager.getActivePlaybackConfigurations()));
        for (AudioRecordingConfiguration config : this.audioManager.getActiveRecordingConfigurations()) {
            for (AudioEffect.Descriptor des : config.getEffects()) {
                Log.d((String)TAG, (String)("checkRecoder: " + des));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = audioLock;
        synchronized (object) {
            if (this.rtcProbeEnable) {
                this.isRecording = true;
                FinLog.w(TAG, "[start] ==> rtcProbeEnable: " + this.rtcProbeEnable);
                return;
            }
            if (!RTCEngineImpl.getInstance().isMicrophoneEnabled()) {
                this.isRecording = true;
                return;
            }
            if (this.audioRecord != null) {
                ReportUtil.libStatus(ReportUtil.TAG.SETMICROPHONEDISABLE, "disable", false);
                int activeRecord = 0;
                if (Build.VERSION.SDK_INT >= 24) {
                    activeRecord = this.audioManager.getActiveRecordingConfigurations().size();
                }
                this.audioRecord.startRecording();
                if (Build.VERSION.SDK_INT >= 24) {
                    if (this.audioRecord.getRecordingState() != 3 && 0 != activeRecord) {
                        this.audioRecord.release();
                        RTCEngineImpl.getInstance().engineLocalAudioEventNotify(RCRTCAudioEventCode.AUDIO_RECORD_START_FAILED);
                    }
                } else if (this.audioRecord.getRecordingState() != 3) {
                    this.audioRecord.release();
                    RTCEngineImpl.getInstance().engineLocalAudioEventNotify(RCRTCAudioEventCode.AUDIO_RECORD_START_FAILED);
                }
                this.isRecording = true;
            }
            if (this.audioBeautifierPlugin != null) {
                this.audioBeautifierPlugin.start(this.sampleRate, 16, this.channelCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = audioLock;
        synchronized (object) {
            this.isRecording = false;
            if (this.audioRecord != null) {
                ReportUtil.libStatus(ReportUtil.TAG.SETMICROPHONEDISABLE, "disable", true);
                try {
                    this.audioRecord.stop();
                }
                catch (IllegalStateException e) {
                    RLog.e((String)TAG, (String)("Audio record exception. e:" + e));
                }
            }
            if (this.audioBeautifierPlugin != null) {
                this.audioBeautifierPlugin.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Log.d((String)TAG, (String)"release");
        Object object = audioLock;
        synchronized (object) {
            this.isRecording = false;
            if (null != this.recordCallBackManger) {
                this.recordCallBackManger.unregisterObserves(this.audioRecordCallbackObserve);
            }
            if (this.audioRecord != null) {
                this.audioRecord.release();
                this.audioRecord = null;
            }
            this.initialized = false;
        }
        if (this.audioEffects != null) {
            this.audioEffects.release();
            this.audioEffects = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRecording() {
        Object object = audioLock;
        synchronized (object) {
            if (!this.isRecording) {
                return false;
            }
            if (this.audioRecord != null) {
                return this.audioRecord.getRecordingState() == 3 || this.rtcProbeEnable;
            }
        }
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialized() {
        Object object = audioLock;
        synchronized (object) {
            if (this.audioRecord != null) {
                return this.audioRecord.getState() == 1;
            }
        }
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnAudioBufferAvailableListener(OnAudioBufferAvailableListener listener) {
        Object object = audioLock;
        synchronized (object) {
            this.onAudioBufferAvailableListener = listener;
        }
    }

    private int channelConfigToCount(int channelConfig) {
        return channelConfig == 12 ? 2 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEarphoneState(boolean earphone) {
        Object object = audioLock;
        synchronized (object) {
            this.enableEffect = !earphone;
            Log.d((String)TAG, (String)("enableEffect: " + this.enableEffect));
            if (this.audioRecord != null) {
                this.audioEffects.release();
                this.audioEffects.setAEC(true);
                this.audioEffects.setNS(this.enableEffect);
                this.audioEffects.enable(this.audioRecord.getAudioSessionId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReset() {
        boolean ret = false;
        Object object = audioLock;
        synchronized (object) {
            if (Build.VERSION.SDK_INT >= 29) {
                if (this.isRecording) {
                    ret = true;
                }
            } else if (Build.VERSION.SDK_INT >= 24 && this.isRecording && this.audioRecord.getRecordingState() != 3) {
                ret = true;
            }
        }
        return ret;
    }

    public void enableRTCProbe(boolean enable) {
        this.rtcProbeEnable = enable;
    }
}

