/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.tools.multiroom;

import android.text.TextUtils;
import cn.rongcloud.rtc.engine.tools.multiroom.AbstractMultipleRoom;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InviteMessageElement
extends AbstractMultipleRoom {
    public static final String TAG = "InviteMessageElement";
    private Map<String, InviteTimeoutStatistics> concurrentHashMap = new ConcurrentHashMap<String, InviteTimeoutStatistics>(16);

    public void put(String inviteeUserid, InviteTimeoutStatistics obj) {
        if (TextUtils.isEmpty((CharSequence)inviteeUserid) || obj == null) {
            return;
        }
        FinLog.d(TAG, "put.inviteeUserid : " + inviteeUserid);
        this.concurrentHashMap.put(inviteeUserid, obj);
    }

    public InviteTimeoutStatistics get(String inviteeUserid) {
        FinLog.d(TAG, "get.inviteeUserid : " + inviteeUserid);
        return this.concurrentHashMap.get(inviteeUserid);
    }

    public InviteTimeoutStatistics remove(String inviteeUserid) {
        FinLog.d(TAG, "remove.inviteeUserid : " + inviteeUserid);
        return this.concurrentHashMap.remove(inviteeUserid);
    }

    @Override
    public void release() {
        super.release();
        if (this.concurrentHashMap != null) {
            this.concurrentHashMap.clear();
        }
    }

    public static class InviteTimeoutStatistics {
        private String inviteSessionId;
        private long startInviteTime;

        public InviteTimeoutStatistics(String inviteSessionId, long startInviteTime) {
            this.inviteSessionId = inviteSessionId;
            this.startInviteTime = startInviteTime;
        }

        public String getInviteSessionId() {
            return this.inviteSessionId;
        }

        public long getStartInviteTime() {
            return this.startInviteTime;
        }
    }
}

