/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.opengl.GLES20;
import android.util.Log;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.a.b;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.c;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.k;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCRotateScaleFilter;
import com.tencent.ugc.UGCTransitionProcessor;
import com.tencent.ugc.UGCWatermarkAlphaTextureFilter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.List;

public class UGCCombineFrameFilter {
    private static final String TAG = "UGCCombineFrameFilter";
    private final FloatBuffer mNormalCubeVerticesBuffer;
    private final FloatBuffer mNormalTextureCoordsBuffer;
    private final e mTexturePool;
    private UGCRotateScaleFilter mRotateScaleFilter = null;
    private b mCropFilter = null;
    private UGCWatermarkAlphaTextureFilter mAlphaBlendFilter;
    private Size mCanvasSize;
    private TXVideoEditConstants.TXAbsoluteRect mCropRect = null;
    private d mBackgroundTexture = null;
    private c mFrameBufferForClear;
    private FloatBuffer mCropRectTextureCoordsBuffer;

    public UGCCombineFrameFilter(e texturePool) {
        this.mTexturePool = texturePool;
        this.mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
        this.mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(Rotation.a, false, false);
    }

    public void setCanvasSize(int width, int height) {
        if (this.mCanvasSize != null && width == this.mCanvasSize.width && height == this.mCanvasSize.height) {
            return;
        }
        this.mCanvasSize = new Size(width, height);
        this.mCropRectTextureCoordsBuffer = UGCCombineFrameFilter.getCropRectTextureCoords(this.mCanvasSize.width, this.mCanvasSize.height, this.mCropRect);
    }

    public void setCropRect(TXVideoEditConstants.TXAbsoluteRect cropRect) {
        if (this.mCropRect != null && cropRect != null && this.mCropRect.width == cropRect.width && this.mCropRect.height == cropRect.height && this.mCropRect.x == cropRect.x && this.mCropRect.y == cropRect.y) {
            return;
        }
        this.mCropRect = cropRect;
        this.mCropRectTextureCoordsBuffer = UGCCombineFrameFilter.getCropRectTextureCoords(this.mCanvasSize.width, this.mCanvasSize.height, this.mCropRect);
    }

    public d combineFrame(List<UGCTransitionProcessor.TXCCombineFrame> txCombineFrames) {
        if (txCombineFrames == null || txCombineFrames.size() <= 0) {
            Log.e((String)TAG, (String)"frames is null or no frames!");
            return null;
        }
        this.initFilter();
        this.processRotateScale(txCombineFrames);
        d d2 = this.combineFrameWithAlphaBlendFilter(txCombineFrames);
        return this.cropTexture(d2);
    }

    public void release() {
        this.unInitFilter();
    }

    private void processRotateScale(List<UGCTransitionProcessor.TXCCombineFrame> txCombineFrames) {
        for (int i2 = 0; i2 < txCombineFrames.size(); ++i2) {
            UGCTransitionProcessor.TXCCombineFrame tXCCombineFrame = txCombineFrames.get(i2);
            if (this.mRotateScaleFilter == null || tXCCombineFrame.transformParams == null) {
                return;
            }
            this.mRotateScaleFilter.setRotateAndScale(tXCCombineFrame.transformParams.rotate, tXCCombineFrame.transformParams.scale);
            this.mRotateScaleFilter.setAlpha(tXCCombineFrame.transformParams.alpha);
            GLES20.glViewport((int)0, (int)0, (int)tXCCombineFrame.drawRect.width, (int)tXCCombineFrame.drawRect.height);
            d d2 = this.mTexturePool.a(tXCCombineFrame.drawRect.width, tXCCombineFrame.drawRect.height);
            this.clearTexture(d2);
            this.mRotateScaleFilter.onDraw(tXCCombineFrame.drawInputFrame.getTextureId(), d2, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
            PixelFrame pixelFrame = tXCCombineFrame.drawInputFrame;
            tXCCombineFrame.drawInputFrame = d2.a(pixelFrame.getGLContext());
            pixelFrame.release();
            d2.release();
        }
    }

    private d combineFrameWithAlphaBlendFilter(List<UGCTransitionProcessor.TXCCombineFrame> txCombineFrames) {
        k k2 = null;
        int n2 = this.getBackgroundTextureId();
        for (int i2 = 0; i2 < txCombineFrames.size(); ++i2) {
            UGCTransitionProcessor.TXCCombineFrame tXCCombineFrame = txCombineFrames.get(i2);
            this.setAlphaBlendFilterParameter(tXCCombineFrame);
            GLES20.glViewport((int)0, (int)0, (int)this.mCanvasSize.width, (int)this.mCanvasSize.height);
            Size size = this.mAlphaBlendFilter.getOutputSize();
            d d2 = this.mTexturePool.a(size.width, size.height);
            this.mAlphaBlendFilter.onDraw(n2, d2, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
            if (k2 != null) {
                k2.release();
            }
            k2 = d2;
            n2 = d2.a();
        }
        return k2;
    }

    private d cropTexture(d glTexture) {
        if (glTexture == null || this.mCropFilter == null) {
            return glTexture;
        }
        Size size = this.mCropFilter.getOutputSize();
        d d2 = this.mTexturePool.a(size.width, size.height);
        GLES20.glViewport((int)0, (int)0, (int)size.width, (int)size.height);
        this.mCropFilter.onDraw(glTexture.a(), d2, this.mNormalCubeVerticesBuffer, this.mCropRectTextureCoordsBuffer);
        glTexture.release();
        return d2;
    }

    private void setAlphaBlendFilterParameter(UGCTransitionProcessor.TXCCombineFrame txcCombineFrame) {
        if (txcCombineFrame.transformParams != null) {
            this.mAlphaBlendFilter.setAlpha(txcCombineFrame.transformParams.alpha);
            this.mAlphaBlendFilter.setShowBackImageMoment(txcCombineFrame.transformParams.isBackgroundTransparent);
        } else {
            this.mAlphaBlendFilter.setAlpha(1.0f);
            this.mAlphaBlendFilter.setShowBackImageMoment(false);
        }
        int n2 = txcCombineFrame.drawInputFrame.getTextureId();
        int n3 = txcCombineFrame.drawRect.width;
        int n4 = txcCombineFrame.drawRect.height;
        float f2 = (float)txcCombineFrame.drawRect.x * 1.0f / (float)this.mCanvasSize.width;
        float f3 = (float)txcCombineFrame.drawRect.y * 1.0f / (float)this.mCanvasSize.height;
        float f4 = (float)txcCombineFrame.drawRect.width * 1.0f / (float)this.mCanvasSize.width;
        this.mAlphaBlendFilter.setTextureWatermark(n2, n3, n4, f2, f3, f4);
    }

    private void initFilter() {
        if (this.mRotateScaleFilter == null) {
            this.mRotateScaleFilter = new UGCRotateScaleFilter();
            this.mRotateScaleFilter.initialize(this.mTexturePool);
        }
        if (this.mAlphaBlendFilter == null) {
            this.mAlphaBlendFilter = new UGCWatermarkAlphaTextureFilter();
            this.mAlphaBlendFilter.initialize(this.mTexturePool);
        }
        this.mAlphaBlendFilter.enableWatermark(true);
        this.mAlphaBlendFilter.onOutputSizeChanged(this.mCanvasSize.width, this.mCanvasSize.height);
        if (this.mCropRect != null) {
            if (this.mCropFilter == null) {
                this.mCropFilter = new b();
                this.mCropFilter.initialize(this.mTexturePool);
            }
            this.mCropFilter.onOutputSizeChanged(this.mCropRect.width, this.mCropRect.height);
            return;
        }
        if (this.mCropFilter != null) {
            this.mCropFilter.uninitialize();
            this.mCropFilter = null;
        }
    }

    private void unInitFilter() {
        if (this.mRotateScaleFilter != null) {
            this.mRotateScaleFilter.uninitialize();
            this.mRotateScaleFilter = null;
        }
        if (this.mAlphaBlendFilter != null) {
            this.mAlphaBlendFilter.uninitialize();
            this.mAlphaBlendFilter = null;
        }
        if (this.mCropFilter != null) {
            this.mCropFilter.uninitialize();
            this.mCropFilter = null;
        }
        if (this.mBackgroundTexture != null) {
            this.mBackgroundTexture.release();
            this.mBackgroundTexture = null;
        }
        if (this.mFrameBufferForClear != null) {
            this.mFrameBufferForClear.d();
            this.mFrameBufferForClear = null;
        }
    }

    private void clearTexture(d glTexture) {
        if (this.mFrameBufferForClear == null) {
            this.mFrameBufferForClear = new c();
            this.mFrameBufferForClear.a();
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        if (glTexture == null) {
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GLES20.glClear((int)16640);
            return;
        }
        this.mFrameBufferForClear.a(glTexture.a());
        this.mFrameBufferForClear.b();
        GLES20.glClear((int)16640);
        OpenGlUtils.bindFramebuffer(36160, 0);
        this.mFrameBufferForClear.c();
    }

    private int getBackgroundTextureId() {
        if (this.mBackgroundTexture == null) {
            this.mBackgroundTexture = this.mTexturePool.a(this.mCanvasSize.width, this.mCanvasSize.height);
            UGCCombineFrameFilter uGCCombineFrameFilter = this;
            uGCCombineFrameFilter.clearTexture(uGCCombineFrameFilter.mBackgroundTexture);
        }
        return this.mBackgroundTexture.a();
    }

    private static FloatBuffer getCropRectTextureCoords(int width, int height, TXVideoEditConstants.TXAbsoluteRect cropRect) {
        float[] fArray = new float[GLConstants.d.length];
        OpenGlUtils.initTextureCoordsBuffer(fArray, Rotation.a, false, false);
        if (cropRect != null) {
            float f2 = (float)cropRect.x / ((float)width * 1.0f);
            float f3 = (float)(width - cropRect.x - cropRect.width) / ((float)width * 1.0f);
            float f4 = (float)cropRect.y / ((float)height * 1.0f);
            float f5 = (float)(height - cropRect.y - cropRect.height) / ((float)height * 1.0f);
            for (int i2 = 0; i2 < fArray.length / 2; ++i2) {
                if (fArray[2 * i2] < 0.5f) {
                    int n2 = 2 * i2;
                    fArray[n2] = fArray[n2] + f2;
                } else {
                    int n3 = 2 * i2;
                    fArray[n3] = fArray[n3] - f3;
                }
                if (fArray[2 * i2 + 1] < 0.5f) {
                    int n4 = 2 * i2 + 1;
                    fArray[n4] = fArray[n4] + f4;
                    continue;
                }
                int n5 = 2 * i2 + 1;
                fArray[n5] = fArray[n5] - f5;
            }
        }
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(GLConstants.d.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray).position(0);
        return floatBuffer;
    }
}

