/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.ugc.UGCWatermarkAlphaTextureFilter;
import com.tencent.ugc.videoprocessor.videoeffect.TXCGPUEffectFilterBase;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCZoomInOutFilter;
import java.nio.FloatBuffer;

public class TXCGPUSpiritOutFilter
extends TXCGPUEffectFilterBase {
    private static final String TAG = "TXCGPUSpiritOutFilter";
    private static final int DURATION_SPIRITOUT_LVMIN = 120;
    private static final int DURATION_SPIRITOUT_LV1 = 230;
    private static final int DURATION_SPIRITOUT_LV2 = 274;
    private static final int DURATION_SPIRITOUT_LV3 = 318;
    private static final int DURATION_SPIRITOUT_LV4 = 362;
    private static final int DURATION_SPIRITOUT_LV5 = 406;
    private static final int DURATION_SPIRITOUT_LV6 = 450;
    private static final int DURATION_SPIRITOUT_LV7 = 494;
    private static final int DURATION_SPIRITOUT_LV8 = 538;
    private static final int DURATION_SPIRITOUT_LV9 = 582;
    private static final int DURATION_SPIRITOUT_LV10 = 560;
    private static final int DURATION_SPIRITOUT_LVMAX = 1120;
    protected TXCZoomInOutFilter mZoomInOutFilter = null;
    private UGCWatermarkAlphaTextureFilter mTextureWaterMarkFilter = null;
    private SpiritOutEffectParam mSpritParams = null;
    private int mTextureWidth = -1;
    private int mTextureHeight = -1;
    private e mTexturePool;

    @Override
    public void onInit(e texturePool) {
        super.onInit(texturePool);
        this.mTexturePool = texturePool;
        if (this.mZoomInOutFilter == null) {
            this.mZoomInOutFilter = new TXCZoomInOutFilter();
            this.mZoomInOutFilter.initialize(texturePool);
        }
        if (this.mTextureWaterMarkFilter == null) {
            this.mTextureWaterMarkFilter = new UGCWatermarkAlphaTextureFilter();
            this.mTextureWaterMarkFilter.initialize(texturePool);
            this.mTextureWaterMarkFilter.setAlpha(0.5f);
            this.mTextureWaterMarkFilter.enableWatermark(true);
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.mTextureWidth = width;
        this.mTextureHeight = height;
        if (this.mZoomInOutFilter != null) {
            this.mZoomInOutFilter.onOutputSizeChanged(width, height);
        }
        if (this.mTextureWaterMarkFilter != null) {
            this.mTextureWaterMarkFilter.onOutputSizeChanged(width, height);
        }
    }

    @Override
    public void onUninit() {
        super.onUninit();
        if (this.mZoomInOutFilter != null) {
            this.mZoomInOutFilter.uninitialize();
            this.mZoomInOutFilter = null;
        }
        if (this.mTextureWaterMarkFilter != null) {
            this.mTextureWaterMarkFilter.uninitialize();
            this.mTextureWaterMarkFilter = null;
        }
    }

    @Override
    public void setNextFrameTimestamp(long pts) {
        long l2;
        super.setNextFrameTimestamp(pts);
        if (this.mSpritParams == null) {
            this.mSpritParams = new SpiritOutEffectParam();
            this.mSpritParams.fringeNumber = 1;
            this.mSpritParams.alpahLevel = 0.3f;
        }
        if ((l2 = Math.abs(pts - this.mEffectStartTime)) < 120L) {
            this.mSpritParams.zoomOutLevel = 0;
            return;
        }
        if (l2 < 230L) {
            this.mSpritParams.zoomOutLevel = 1;
            return;
        }
        if (l2 < 274L) {
            this.mSpritParams.zoomOutLevel = 2;
            return;
        }
        if (l2 < 318L) {
            this.mSpritParams.zoomOutLevel = 3;
            return;
        }
        if (l2 < 362L) {
            this.mSpritParams.zoomOutLevel = 4;
            return;
        }
        if (l2 < 406L) {
            this.mSpritParams.zoomOutLevel = 5;
            return;
        }
        if (l2 < 450L) {
            this.mSpritParams.zoomOutLevel = 6;
            return;
        }
        if (l2 < 494L) {
            this.mSpritParams.zoomOutLevel = 7;
            return;
        }
        if (l2 < 538L) {
            this.mSpritParams.zoomOutLevel = 8;
            return;
        }
        if (l2 < 582L) {
            this.mSpritParams.zoomOutLevel = 9;
            return;
        }
        if (l2 < 1120L) {
            this.mSpritParams.zoomOutLevel = 0;
            return;
        }
        this.mEffectStartTime = -1L;
    }

    @Override
    public void onDraw(int inTextureId, d outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        if (!this.isInitialized()) {
            return;
        }
        this.runPendingOnDrawTasks();
        if (this.mSpritParams == null || this.mZoomInOutFilter == null || this.mTextureWaterMarkFilter == null) {
            return;
        }
        this.mZoomInOutFilter.setZoomLevel(0.96f, this.mSpritParams.zoomOutLevel);
        this.mZoomInOutFilter.setAlphaLevel(this.mSpritParams.alpahLevel);
        d d2 = this.mTexturePool.a(this.mTextureWidth, this.mTextureHeight);
        this.mZoomInOutFilter.onDraw(inTextureId, d2, cubeCoordsBuffer, textureCoordsBuffer);
        this.mTextureWaterMarkFilter.setTextureWatermark(d2.a(), this.mTextureWidth, this.mTextureHeight, 0.0f, 0.0f, 1.0f);
        this.mTextureWaterMarkFilter.setAlpha(this.mSpritParams.alpahLevel);
        this.mTextureWaterMarkFilter.onDraw(inTextureId, outTexture, cubeCoordsBuffer, textureCoordsBuffer);
        d2.release();
    }

    public static class SpiritOutEffectParam
    extends TXCGPUEffectFilterBase.VideoEffectParams {
        public float zoomCenterX = 0.5f;
        public float zoomCenterY = 0.5f;
        public int fringeNumber = 1;
        public int zoomOutLevel = 1;
        public float alpahLevel = 0.5f;
    }
}

