/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.extend;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.R;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.ui.component.DCWXInput;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.common.DHInterface.IActivityHandler;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaUniWebView;
import io.dcloud.common.adapter.ui.webview.WebResUtil;
import io.dcloud.common.adapter.ui.webview.WebViewFactory;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.EventActionInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.common.util.language.LanguageUtil;
import io.dcloud.feature.internal.sdk.SDK;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.weex.WXBaseWrapper;
import io.dcloud.feature.weex.WXServiceWrapper;
import io.dcloud.feature.weex.WeexInstanceMgr;
import io.dcloud.weex.WXDotDataUtil;
import io.src.dcloud.adapter.DCloudAdapterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PlusModule
extends WXModule {
    private String EVENTS_DOCUMENT_EXECUTE = "javascript:!function(){(window.__html5plus__&&__html5plus__.isReady?__html5plus__:navigator.plus&&navigator.plus.isReady?navigator.plus:window.plus)||window.__load__plus__&&window.__load__plus__();var _=document.createEvent(\"HTMLEvents\");_.initEvent(\"%s\",!1,!0),_.targetId=\"%s\",_.originId=\"%s\",_.data=%s,document.dispatchEvent(_)}();";
    ArrayList<JsData> chs = new ArrayList();

    @JSMethod
    public void postMessage(String data, String id2) {
        WXServiceWrapper serviceWrapper;
        IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        IWebview webview = null;
        String sp = StringUtil.format((String)this.EVENTS_DOCUMENT_EXECUTE, (Object[])new Object[]{"uniNViewMessage", null != webview ? webview.obtainFrameId() : "", null != hostWebview ? hostWebview.obtainFrameId() : "", data});
        if (hostWebview == null && (serviceWrapper = WeexInstanceMgr.self().findWXServiceWrapper(this.mWXSDKInstance)) != null && !BaseInfo.isWeexUniJs((IApp)serviceWrapper.obtanApp())) {
            serviceWrapper.findWebViewToLoadUrL(sp, id2);
            return;
        }
        if (hostWebview != null && (webview = PdrUtil.isEmpty((Object)id2) ? hostWebview : WeexInstanceMgr.self().findWebview(hostWebview, hostWebview.obtainApp(), hostWebview.obtainApp().obtainAppId(), id2)) != null) {
            if (webview instanceof AdaUniWebView) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("targetId", id2);
                params.put("originId", null != hostWebview ? hostWebview.obtainFrameId() : "");
                try {
                    JSONObject object = JSONObject.parseObject((String)data);
                    params.put("data", (String)object);
                }
                catch (Exception e) {
                    params.put("data", data);
                }
                EventActionInfo info = new EventActionInfo("uniNViewMessage", params);
                ((AdaUniWebView)webview).fireEvent(info);
            } else {
                webview.loadUrl(sp);
            }
        }
    }

    @JSMethod(uiThread=true)
    public void exec(String data, String value) {
        if (this.mWXSDKInstance != null && this.mWXSDKInstance.isDestroy()) {
            return;
        }
        IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        if (hostWebview instanceof AdaUniWebView) {
            ((AdaUniWebView)hostWebview).prompt(data, value);
        }
    }

    @JSMethod(uiThread=false)
    public String execSync(String data, String value) {
        if (this.mWXSDKInstance != null && this.mWXSDKInstance.isDestroy()) {
            return "";
        }
        IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        if (hostWebview instanceof AdaUniWebView) {
            return ((AdaUniWebView)hostWebview).prompt(data, value);
        }
        return "";
    }

    @JSMethod(uiThread=true)
    public void uniReady() {
        WXBaseWrapper wrapper = WeexInstanceMgr.self().findWXBaseWrapper(this.mWXSDKInstance);
        if (wrapper != null) {
            wrapper.onReady();
        }
    }

    @JSMethod(uiThread=false)
    @RequiresApi(api=21)
    public void setLanguage(String languageTagParam) {
        if (this.mWXSDKInstance == null || this.mWXSDKInstance.getContext() == null) {
            return;
        }
        if (SDK.isUniMPSDK()) {
            return;
        }
        if (this.mWXSDKInstance.isDestroy()) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if ("auto".equalsIgnoreCase(languageTagParam)) {
            languageTagParam = "";
        }
        LanguageUtil.updateLanguage((Context)this.mWXSDKInstance.getContext(), (String)languageTagParam);
        LocalBroadcastManager.getInstance((Context)this.mWXSDKInstance.getContext()).sendBroadcast(new Intent("language_uni_broad_cast_intent"));
    }

    @JSMethod(uiThread=false)
    @RequiresApi(api=21)
    public String getLanguage() {
        if (this.mWXSDKInstance == null || this.mWXSDKInstance.getContext() == null) {
            return "";
        }
        return LanguageUtil.getCurrentLocaleLanguage((Context)this.mWXSDKInstance.getContext());
    }

    private void runChData() {
        if (!this.chs.isEmpty()) {
            ArrayList<JsData> runList = new ArrayList<JsData>();
            for (JsData data : this.chs) {
                this.exec(data.data, data.value);
                runList.add(data);
            }
            this.chs.removeAll(runList);
        }
    }

    @JSMethod(uiThread=false)
    public Object getConfigInfo() {
        IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        if (hostWebview instanceof AdaUniWebView) {
            return ((AdaUniWebView)hostWebview).getConfigInfo();
        }
        return null;
    }

    @JSMethod(uiThread=false)
    public Object getRedirectInfo() {
        IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        JSONObject v = null;
        if (hostWebview != null) {
            String extraInfoStr;
            JSONObject jsonObject;
            String uniDirectDataStr;
            JSONObject info;
            boolean isReDirect = Boolean.valueOf(hostWebview.obtainApp().obtainConfigProperty("uni_restart_to_direct"));
            if (isReDirect && (info = JSON.parseObject((String)(uniDirectDataStr = hostWebview.obtainApp().obtainConfigProperty("debugRefresh")))) != null && info.containsKey((Object)"arguments")) {
                try {
                    String arguments = info.getString("arguments");
                    v = JSON.parseObject((String)arguments);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                hostWebview.obtainApp().setConfigProperty("debugRefresh", "");
            }
            if ((jsonObject = JSON.parseObject((String)(extraInfoStr = hostWebview.obtainApp().obtainConfigProperty("unimp_run_extra_info")))) != null) {
                if (v == null) {
                    v = new JSONObject();
                }
                v.putAll((Map)jsonObject);
                hostWebview.obtainApp().setConfigProperty("unimp_run_extra_info", "");
            }
        }
        return v;
    }

    @JSMethod(uiThread=false)
    public void setDefaultFontSize(String value) {
        int size = Integer.valueOf(value);
        if (size > 0) {
            this.mWXSDKInstance.setDefaultFontSize(size);
        }
    }

    @JSMethod(uiThread=true)
    public void log(String msg) {
        msg = "[LOG] " + msg;
        Logger.d((String)"console", (String)msg);
    }

    @JSMethod(uiThread=false)
    public String getValue(String ref) {
        DCWXInput dcwxInput = (DCWXInput)WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.mWXSDKInstance.getInstanceId(), ref);
        return dcwxInput.getValue();
    }

    @JSMethod(uiThread=true)
    public void sendNativeEvent(String event, Object data, JSCallback callback) {
        IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        if (hostWebview != null && hostWebview.getActivity() != null && hostWebview.getActivity() instanceof IActivityHandler) {
            Bundle bundle = new Bundle();
            bundle.putString("event", event);
            bundle.putString("dataType", "String");
            if (data instanceof String) {
                bundle.putString("data", String.valueOf(data));
            } else if (data instanceof JSON) {
                JSON json = (JSON)data;
                bundle.putString("data", json.toJSONString());
                bundle.putString("dataType", "JSON");
            }
            if (callback instanceof SimpleJSCallback) {
                bundle.putString("instanceId", this.mWXSDKInstance.getInstanceId());
                bundle.putString("callbackId", ((SimpleJSCallback)callback).getCallbackId());
            }
            ((IActivityHandler)hostWebview.getActivity()).callBack("unimp_js_to_native", bundle);
        }
    }

    @JSMethod(uiThread=false)
    public JSONObject getDotData() {
        JSONObject info = WXDotDataUtil.getDeviceInfo();
        if (BaseInfo.SyncDebug) {
            info.put("maxMemory", (Object)(Runtime.getRuntime().maxMemory() / 0x100000L + "M"));
            info.put("totalMemory", (Object)(Runtime.getRuntime().totalMemory() / 0x100000L + "M"));
            info.put("appRuningTitme", (Object)(BaseInfo.splashCloseTime - BaseInfo.startTime));
        }
        return info;
    }

    @JSMethod(uiThread=false)
    public JSONObject pushDebugData(Object data) {
        JSONObject info = new JSONObject();
        info.put("data", data);
        return info;
    }

    @JSMethod
    public void preloadReady(String appid) {
        ICallBack callBack = WeexInstanceMgr.self().getPreUniMPCallBack(appid);
        if (callBack != null) {
            callBack.onCallBack(1, (Object)appid);
        }
    }

    @JSMethod(uiThread=true)
    public void evalJSFiles(String list, final JSCallback callback) {
        final HashMap<String, Object> data = new HashMap<String, Object>();
        if (list != null) {
            final JSONArray listJson = JSON.parseArray((String)list);
            if (listJson == null) {
                if (callback != null) {
                    data.put("type", -1);
                    data.put("msg", DCLoudApplicationImpl.self().getContext().getString(R.string.dcloud_feature_weex_msg_param_invalid));
                    callback.invoke(data);
                }
                return;
            }
            ThreadPool.self().addThreadTask(new Runnable(){

                @Override
                public void run() {
                    IWebview hostWebview = WeexInstanceMgr.self().findWebview(PlusModule.this.mWXSDKInstance);
                    if (hostWebview == null) {
                        if (callback != null) {
                            data.put("type", -1);
                            data.put("msg", DCLoudApplicationImpl.self().getContext().getString(R.string.dcloud_feature_weex_msg_page_destroyed));
                            callback.invoke(data);
                        }
                        return;
                    }
                    byte mode = hostWebview.obtainApp().obtainRunningAppMode();
                    String js = "";
                    for (int i = 0; i < listJson.size(); ++i) {
                        String path = listJson.getString(i);
                        File file = new File(path);
                        InputStream is = null;
                        if (file.exists()) {
                            try {
                                is = new FileInputStream(file);
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                            }
                        } else {
                            if (!path.startsWith("/storage") && mode == 1) {
                                String url = hostWebview.obtainApp().convert2AbsFullPath(hostWebview.obtainFullUrl(), path);
                                if (url.startsWith("/")) {
                                    url = url.substring(1, url.length());
                                }
                                path = url;
                            } else {
                                path = hostWebview.obtainApp().convert2WebviewFullPath(hostWebview.obtainFullUrl(), path);
                            }
                            is = WebResUtil.getEncryptionInputStream((String)path, (IApp)hostWebview.obtainApp());
                        }
                        if (is != null) {
                            try {
                                String itemStr = new String(IOUtil.toString((InputStream)is));
                                if (TextUtils.isEmpty((CharSequence)itemStr)) continue;
                                js = js + itemStr;
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (callback == null) continue;
                        data.put("type", -1);
                        data.put("msg", path + DCLoudApplicationImpl.self().getContext().getString(R.string.dcloud_feature_weex_msg_cannot_find_file_by_path));
                        callback.invoke(data);
                    }
                    if (!TextUtils.isEmpty((CharSequence)js)) {
                        WXBridgeManager.getInstance().syncExecJsOnInstanceWithResult(PlusModule.this.mWXSDKInstance.getInstanceId(), js, -1);
                        if (callback != null) {
                            data.put("type", 1);
                            callback.invoke(data);
                        }
                        return;
                    }
                }
            }, true);
        } else if (callback != null) {
            data.put("type", -1);
            data.put("msg", DCLoudApplicationImpl.self().getContext().getString(R.string.dcloud_feature_weex_msg_param_empty));
            callback.invoke(data);
        }
    }

    @JSMethod
    public void getHostInfo(JSCallback callback) {
        if (callback == null) {
            return;
        }
        JSONObject info = new JSONObject();
        IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        if (hostWebview == null || hostWebview.obtainApp() == null) {
            callback.invoke(info);
            return;
        }
        String infoStr = hostWebview.obtainApp().obtainAppInfo();
        if (PdrUtil.isEmpty((Object)infoStr)) {
            callback.invoke(info);
            return;
        }
        if (PdrUtil.isUniMPHostForUniApp()) {
            if (SDK.isUniMP) {
                JSONObject hostinfo;
                if (!PdrUtil.isEmpty((Object)SDK.mHostInfo) && (hostinfo = JSON.parseObject((String)SDK.mHostInfo)) != null) {
                    info.putAll((Map)hostinfo);
                }
            } else {
                JSONObject hostinfo = JSON.parseObject((String)infoStr);
                if (hostinfo != null) {
                    info.putAll((Map)hostinfo);
                }
            }
        }
        if (info != null) {
            info.put("nativeName", (Object)AndroidResources.appName);
            info.put("nativeAppid", (Object)AndroidResources.packageName);
            info.put("nativeVersionName", (Object)AndroidResources.versionName);
            info.put("nativeVersionCode", (Object)AndroidResources.versionCode);
        }
        callback.invoke(info);
    }

    @JSMethod(uiThread=false)
    public int getAppState() {
        IActivityHandler handler;
        IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
        if (hostWebview != null && (handler = DCloudAdapterUtil.getIActivityHandler((Activity)hostWebview.getActivity())) != null) {
            return handler.getActivityState();
        }
        return 0;
    }

    @JSMethod(uiThread=false)
    public JSONObject getSystemInfoSync() {
        JSONObject info = new JSONObject();
        try {
            IWebview hostWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
            if (hostWebview != null && hostWebview.obtainApp() != null) {
                IApp app = hostWebview.obtainApp();
                info = JSON.parseObject((String)app.getSystemInfo());
                info.put("osTheme", (Object)(DeviceInfo.isSystemNightMode((Activity)hostWebview.getActivity()) != false ? "dark" : "light"));
                String userAgent = hostWebview.getWebviewProperty("User-Agent");
                info.put("ua", (Object)userAgent);
                info.put("browserVersion", (Object)WebViewFactory.getWebViewUserAgentVersion((Context)hostWebview.getContext()));
                int activityOrientation = hostWebview.getActivity().getResources().getConfiguration().orientation;
                String outOrientation = "portrait";
                if (activityOrientation == 2) {
                    outOrientation = "landscape";
                }
                info.put("deviceOrientation", (Object)outOrientation);
                if (SDK.isUniMP) {
                    info.put("hostPackageName", (Object)hostWebview.getContext().getPackageName());
                    info.put("hostVersion", (Object)AndroidResources.versionName);
                    info.put("hostName", (Object)AndroidResources.appName);
                    info.put("hostTheme", (Object)(SDK.hostAppThemeDark ? "dark" : "light"));
                    if (PdrUtil.isUniMPHostForUniApp()) {
                        info.put("hostLanguage", (Object)LanguageUtil.getDeviceDefLocalLanguage());
                        if (SDK.isUniMP) {
                            // empty if block
                        }
                    } else {
                        info.put("hostLanguage", (Object)LanguageUtil.getDeviceDefLocalLanguage());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    @JSMethod(uiThread=true)
    public void getSystemInfo(UniJSCallback jsCallback) {
        JSONObject info = this.getSystemInfoSync();
        jsCallback.invoke(info);
    }

    class JsData {
        public String data;
        public String value;

        JsData(String data, String value) {
            this.data = data;
            this.value = value;
        }
    }
}

