/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import androidx.annotation.Nullable;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.BitrateAdjuster;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.EglBase14;
import cn.rongcloud.rtc.core.EncodedImage;
import cn.rongcloud.rtc.core.GlRectDrawer;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.MediaCodecWrapper;
import cn.rongcloud.rtc.core.MediaCodecWrapperFactory;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.VideoCodecStatus;
import cn.rongcloud.rtc.core.VideoCodecType;
import cn.rongcloud.rtc.core.VideoEncoder;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoFrameDrawer;
import cn.rongcloud.rtc.core.YuvHelper;
import cn.rongcloud.rtc.core.rongRTC.DevicesUtils;
import cn.rongcloud.rtc.core.rongRTC.EncodedFrameStatistics;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

@TargetApi(value=19)
class HardwareVideoEncoder
extends VideoEncoder {
    private static final String TAG = "HardwareVideoEncoder";
    private static final int VIDEO_ControlRateConstant = 2;
    private static final String KEY_BITRATE_MODE = "bitrate-mode";
    private static final int VIDEO_AVC_PROFILE_HIGH = 8;
    private static final int VIDEO_AVC_LEVEL_3 = 256;
    private static final int MAX_VIDEO_FRAMERATE = 30;
    private static final int MAX_ENCODER_Q_SIZE = 2;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final int ENCODE_FRAME_ERROR_MAX = 8;
    private static final int RATIO_SIZE = 15;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final VideoCodecType codecType;
    private final Integer surfaceColorFormat;
    private final Integer yuvColorFormat;
    private final YuvFormat yuvFormat;
    private final Map<String, String> params;
    private final Map<Long, Vector<Integer>> rateStatics;
    private final int keyFrameIntervalSec;
    private final long forcedKeyFrameNs;
    private final BitrateAdjuster bitrateAdjuster;
    private final EglBase14.Context sharedContext;
    private int encodeNum;
    private final GlRectDrawer textureDrawer = new GlRectDrawer();
    private final VideoFrameDrawer videoFrameDrawer = new VideoFrameDrawer();
    private final BlockingDeque<EncodedImage.Builder> outputBuilders = new LinkedBlockingDeque<EncodedImage.Builder>();
    private final ThreadUtils.ThreadChecker encodeThreadChecker = new ThreadUtils.ThreadChecker();
    private final ThreadUtils.ThreadChecker outputThreadChecker = new ThreadUtils.ThreadChecker();
    private VideoEncoder.Callback callback;
    private boolean automaticResizeOn;
    @Nullable
    private MediaCodecWrapper codec;
    @Nullable
    private Thread outputThread;
    @Nullable
    private EglBase14 textureEglBase;
    @Nullable
    private Surface textureInputSurface;
    private int width;
    private int height;
    private int maxBitrate;
    private boolean useSurfaceMode;
    private long lastKeyFrameNs;
    @Nullable
    private ByteBuffer configBuffer;
    private int adjustedBitrate;
    private volatile boolean running;
    @Nullable
    private Exception shutdownException;
    private boolean mDequeueOutputFailed = false;
    private int encodeFailedCount = 0;
    private EncodedFrameStatistics encodedFrameStatistics = new EncodedFrameStatistics();
    private static final String[] HIGH_PROFILE_BLACK_LIST = new String[]{"DSJ-HECH1A1", "C350"};
    long preTime = 0L;
    long curTime = 0L;
    long intervalTime = 200L;
    long oldest_time_ = 0L;
    int totalSize = 0;
    int window_size = 2000;
    int avgAdjustbitrate = 0;
    int currEncBitrate = 0;
    double[] ratios = new double[15];
    int current_idx = 0;

    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String codecName, VideoCodecType codecType, Integer surfaceColorFormat, Integer yuvColorFormat, Map<String, String> params, int keyFrameIntervalSec, int forceKeyFrameIntervalMs, BitrateAdjuster bitrateAdjuster, EglBase14.Context sharedContext) {
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = codecName;
        this.codecType = codecType;
        this.surfaceColorFormat = surfaceColorFormat;
        this.yuvColorFormat = yuvColorFormat;
        this.yuvFormat = YuvFormat.valueOf(yuvColorFormat);
        this.params = params;
        this.keyFrameIntervalSec = keyFrameIntervalSec;
        this.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(forceKeyFrameIntervalMs);
        this.bitrateAdjuster = bitrateAdjuster;
        this.sharedContext = sharedContext;
        this.rateStatics = new HashMap<Long, Vector<Integer>>();
        this.encodeThreadChecker.detachThread();
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback callback) {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.callback = callback;
        this.automaticResizeOn = settings.automaticResizeOn;
        this.width = settings.width;
        this.height = settings.height;
        this.maxBitrate = settings.maxBitrate * 1000;
        this.useSurfaceMode = this.canUseSurface();
        this.encodeNum = 0;
        if (settings.startBitrate != 0 && settings.maxFramerate != 0) {
            this.bitrateAdjuster.setTargets(settings.startBitrate * 1000, settings.maxFramerate);
        }
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        Logging.d(TAG, "initEncode: " + this.width + " x " + this.height + ". @ " + settings.startBitrate + "maxBitrate: " + settings.maxBitrate + "kbps. Fps: " + settings.maxFramerate + " Use surface mode: " + this.useSurfaceMode);
        return this.initEncodeInternal(false);
    }

    private VideoCodecStatus initEncodeInternal(boolean isRetry) {
        Logging.d(TAG, "initEncodeInternal addr is " + this + " isRetry is " + isRetry + " w is " + this.width + " h is " + this.height);
        ReportUtil.libTask(ReportUtil.TAG.CREATEHDVIDEOENCODER, "resolution|isRetry", this.width + "x" + this.height, isRetry);
        this.encodeThreadChecker.checkIsOnValidThread();
        this.lastKeyFrameNs = -1L;
        this.mDequeueOutputFailed = false;
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (IOException | IllegalArgumentException e) {
            ReportUtil.libError(ReportUtil.TAG.CREATEHDVIDEOENCODER, "code|desc", VideoCodecStatus.FALLBACK_SOFTWARE.getNumber(), "Cannot create media encoder " + this.codecName + ": " + e);
            RTCEngineImpl.getInstance().engineError(RTCErrorCode.HARDWARE_VIDEO_ENCODER_INIT_ERROR);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        int colorFormat = this.useSurfaceMode ? this.surfaceColorFormat : this.yuvColorFormat;
        try {
            MediaFormat format = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)this.width, (int)this.height);
            format.setInteger("bitrate", this.adjustedBitrate);
            if (Build.VERSION.SDK_INT >= 21) {
                format.setInteger(KEY_BITRATE_MODE, DevicesUtils.getEnCodeBitRateMode().getValue());
                FinLog.d(TAG, "videoConfig: encode KEY_BITRATE_MODE :" + DevicesUtils.getEnCodeBitRateMode().getValue());
            }
            int finalEncodeColor = DevicesUtils.getHardWareEecodeColor() == 0 ? colorFormat : DevicesUtils.getHardWareEecodeColor();
            Logging.d(TAG, "videoConfig: encode KEY_COLOR_FORMAT " + finalEncodeColor);
            format.setInteger("color-format", finalEncodeColor);
            format.setInteger("frame-rate", this.bitrateAdjuster.getCodecConfigFramerate());
            format.setInteger("i-frame-interval", this.keyFrameIntervalSec);
            if (this.codecType == VideoCodecType.H264) {
                String profileLevelId = "42e01f";
                Logging.d(TAG, "videoConfig: isHighProfile " + DevicesUtils.isHighProfile());
                if (DevicesUtils.isHighProfile()) {
                    profileLevelId = "640c1f";
                }
                switch (profileLevelId) {
                    case "640c1f": {
                        format.setInteger("profile", 8);
                        format.setInteger("level", 256);
                        break;
                    }
                    case "42e01f": {
                        break;
                    }
                    default: {
                        Logging.w(TAG, "Unknown profile level id: " + profileLevelId);
                    }
                }
                FinLog.i(TAG, "profileLevelId: " + profileLevelId);
            }
            if (!this.codec.isSizeSupported(this.width, this.height)) {
                Logging.d(TAG, "size@" + this.width + "x" + this.height + " not supported, change to software encode");
                ReportUtil.libError(ReportUtil.TAG.CREATEHDVIDEOENCODER, "code|desc", VideoCodecStatus.FALLBACK_SOFTWARE.getNumber(), "Cannot create media encoder " + this.codecName + ", size@" + this.width + "x" + this.height + " not supported");
                RTCEngineImpl.getInstance().engineError(RTCErrorCode.HARDWARE_VIDEO_ENCODER_INIT_ERROR);
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            this.codec.configure(format, null, null, 1);
            if (this.useSurfaceMode) {
                this.textureEglBase = new EglBase14(this.sharedContext, EglBase.CONFIG_RECORDABLE);
                this.textureInputSurface = this.codec.createInputSurface();
                this.textureEglBase.createSurface(this.textureInputSurface);
                this.textureEglBase.makeCurrent();
            }
            ReportUtil.libStatus(ReportUtil.TAG.CREATEHDVIDEOENCODER, "codecName|codecType|useSurface|mediaFormat", new Object[]{this.codecName, this.codecType, this.useSurfaceMode, format.toString()});
            this.codec.start();
        }
        catch (Exception e) {
            ReportUtil.libError(ReportUtil.TAG.CREATEHDVIDEOENCODER, "code|desc", VideoCodecStatus.FALLBACK_SOFTWARE.getNumber(), "initEncodeInternal failed: " + e);
            RTCEngineImpl.getInstance().engineError(RTCErrorCode.HARDWARE_VIDEO_ENCODER_INIT_ERROR);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.running = true;
        this.outputThreadChecker.detachThread();
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        ReportUtil.libRes(ReportUtil.TAG.CREATEHDVIDEOENCODER);
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus release() {
        VideoCodecStatus returnValue;
        this.encodeThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, " Releasing MediaCodec on output thread w is " + this.width + " h is " + this.height + " addr is " + this);
        if (this.outputThread == null) {
            if (this.codec != null) {
                this.codec.release();
            }
            returnValue = VideoCodecStatus.OK;
        } else {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                returnValue = VideoCodecStatus.TIMEOUT;
            } else if (this.shutdownException != null) {
                Logging.e(TAG, "Media encoder release exception", this.shutdownException);
                returnValue = VideoCodecStatus.ERROR;
            } else {
                returnValue = VideoCodecStatus.OK;
            }
        }
        this.textureDrawer.release();
        this.videoFrameDrawer.release();
        if (this.textureEglBase != null) {
            this.textureEglBase.release();
            this.textureEglBase = null;
        }
        if (this.textureInputSurface != null) {
            this.textureInputSurface.release();
            this.textureInputSurface = null;
        }
        this.outputBuilders.clear();
        this.codec = null;
        this.outputThread = null;
        this.encodeThreadChecker.detachThread();
        return returnValue;
    }

    @Override
    public VideoCodecStatus encode(VideoFrame videoFrame, VideoEncoder.EncodeInfo encodeInfo) {
        VideoCodecStatus status;
        boolean shouldUseSurfaceMode;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.codec == null) {
            return VideoCodecStatus.UNINITIALIZED;
        }
        if (this.encodeNum >= 8) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        VideoFrame.Buffer videoFrameBuffer = videoFrame.getBuffer();
        boolean isTextureBuffer = videoFrameBuffer instanceof VideoFrame.TextureBuffer;
        int frameWidth = videoFrame.getBuffer().getWidth();
        int frameHeight = videoFrame.getBuffer().getHeight();
        boolean bl = shouldUseSurfaceMode = this.canUseSurface() && isTextureBuffer;
        if ((frameWidth != this.width || frameHeight != this.height || shouldUseSurfaceMode != this.useSurfaceMode || this.mDequeueOutputFailed) && (status = this.resetCodec(frameWidth, frameHeight, shouldUseSurfaceMode)) != VideoCodecStatus.OK) {
            return status;
        }
        if (this.outputBuilders.size() > 2) {
            Logging.e(TAG, "Dropped frame, encoder queue full");
            ++this.encodeFailedCount;
            if (this.encodeFailedCount > 10) {
                Logging.e(TAG, "encode frame Failed, use software encoder");
                RTCEngineImpl.getInstance().engineError(RTCErrorCode.HARDWARE_VIDEO_ENCODER_ERROR);
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            return VideoCodecStatus.NO_OUTPUT;
        }
        this.encodeFailedCount = 0;
        boolean requestedKeyFrame = false;
        for (EncodedImage.FrameType frameType : encodeInfo.frameTypes) {
            if (frameType != EncodedImage.FrameType.VideoFrameKey) continue;
            requestedKeyFrame = true;
        }
        if (requestedKeyFrame || this.shouldForceKeyFrame(videoFrame.getTimestampNs())) {
            this.requestKeyFrame(videoFrame.getTimestampNs());
        }
        int bufferSize = videoFrameBuffer.getHeight() * videoFrameBuffer.getWidth() * 3 / 2;
        EncodedImage.Builder builder = EncodedImage.builder().setCaptureTimeNs(videoFrame.getTimestampNs()).setCompleteFrame(true).setEncodedWidth(videoFrame.getBuffer().getWidth()).setEncodedHeight(videoFrame.getBuffer().getHeight()).setRotation(videoFrame.getRotation());
        this.outputBuilders.offer(builder);
        VideoCodecStatus returnValue = this.useSurfaceMode ? this.encodeTextureBuffer(videoFrame) : this.encodeByteBuffer(videoFrame, videoFrameBuffer, bufferSize);
        if (returnValue != VideoCodecStatus.OK) {
            this.outputBuilders.pollLast();
        }
        return returnValue;
    }

    private VideoCodecStatus encodeTextureBuffer(VideoFrame videoFrame) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            GLES20.glClear((int)16384);
            VideoFrame derotatedFrame = new VideoFrame(videoFrame.getBuffer(), 0, videoFrame.getTimestampNs());
            this.videoFrameDrawer.drawFrame(derotatedFrame, this.textureDrawer, null);
            this.textureEglBase.swapBuffers(videoFrame.getTimestampNs());
        }
        catch (Exception e) {
            Logging.e(TAG, "encodeTexture failed", e);
            return VideoCodecStatus.ERROR;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus encodeByteBuffer(VideoFrame videoFrame, VideoFrame.Buffer videoFrameBuffer, int bufferSize) {
        ByteBuffer buffer;
        int index;
        this.encodeThreadChecker.checkIsOnValidThread();
        long presentationTimestampUs = (videoFrame.getTimestampNs() + 500L) / 1000L;
        try {
            index = this.codec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "dequeueInputBuffer failed", e);
            return VideoCodecStatus.ERROR;
        }
        if (index == -1) {
            Logging.d(TAG, "Dropped frame, no input buffers available");
            return VideoCodecStatus.NO_OUTPUT;
        }
        try {
            buffer = this.codec.getInputBuffers()[index];
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "getInputBuffers failed", e);
            return VideoCodecStatus.ERROR;
        }
        this.fillInputBuffer(buffer, videoFrameBuffer);
        try {
            if (this.codecName.startsWith("OMX.Exynos.")) {
                presentationTimestampUs = 0L;
            }
            this.codec.queueInputBuffer(index, 0, bufferSize, presentationTimestampUs, 0);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "queueInputBuffer failed", e);
            return VideoCodecStatus.ERROR;
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int framerate) {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (framerate > 30) {
            framerate = 30;
        }
        this.bitrateAdjuster.setTargets(bitrateAllocation.getSum(), framerate);
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.automaticResizeOn) {
            if (this.codecType == VideoCodecType.VP8) {
                int kLowVp8QpThreshold = 29;
                int kHighVp8QpThreshold = 95;
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (this.codecType == VideoCodecType.H264) {
                int kLowH264QpThreshold = 24;
                int kHighH264QpThreshold = 37;
                return new VideoEncoder.ScalingSettings(24, 37);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    @Override
    public String getImplementationName() {
        return "HWEncoder";
    }

    private VideoCodecStatus resetCodec(int newWidth, int newHeight, boolean newUseSurfaceMode) {
        Logging.d(TAG, "resetCodec");
        this.encodeThreadChecker.checkIsOnValidThread();
        this.encodeFailedCount = 0;
        VideoCodecStatus status = this.release();
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        this.width = newWidth;
        this.height = newHeight;
        this.useSurfaceMode = newUseSurfaceMode;
        return this.initEncodeInternal(true);
    }

    private boolean shouldForceKeyFrame(long presentationTimestampNs) {
        this.encodeThreadChecker.checkIsOnValidThread();
        return this.forcedKeyFrameNs > 0L && presentationTimestampNs > this.lastKeyFrameNs + this.forcedKeyFrameNs;
    }

    private void requestKeyFrame(long presentationTimestampNs) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            Bundle b = new Bundle();
            b.putInt("request-sync", 0);
            this.codec.setParameters(b);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "requestKeyFrame failed", e);
            return;
        }
        this.lastKeyFrameNs = presentationTimestampNs;
    }

    private Thread createOutputThread() {
        return new Thread(){

            @Override
            public void run() {
                while (HardwareVideoEncoder.this.running) {
                    HardwareVideoEncoder.this.deliverEncodedImage();
                }
                HardwareVideoEncoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    protected void deliverEncodedImage() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            int index;
            MediaCodecWrapper tmpCodec = this.codec;
            if (null == tmpCodec) {
                Logging.v(TAG, "codec is release will return ");
                return;
            }
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            if (this.codecName.startsWith("OMX.Exynos.")) {
                this.DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 5000;
            }
            if ((index = tmpCodec.dequeueOutputBuffer(info, this.DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US)) < 0) {
                this.encodedFrameStatistics.reportDropFrame();
                Logging.v(TAG, "dequeueOutputBuffer returned " + index);
                return;
            }
            ByteBuffer codecOutputBuffer = tmpCodec.getOutputBuffers()[index];
            codecOutputBuffer.position(info.offset);
            codecOutputBuffer.limit(info.offset + info.size);
            if ((info.flags & 2) != 0) {
                Logging.d(TAG, "Config frame generated. Offset: " + info.offset + ". Size: " + info.size);
                this.configBuffer = ByteBuffer.allocateDirect(info.size);
                this.configBuffer.put(codecOutputBuffer);
            } else {
                VideoEncoder.Callback tmpCallback;
                ByteBuffer frameBuffer;
                boolean isKeyFrame;
                this.bitrateAdjuster.reportEncodedFrame(info.size);
                Date date = new Date();
                long now_ms = date.getTime();
                this.updateBitrateStatics(now_ms, info.size);
                int setRate = this.bitrateAdjuster.getAdjustedBitrateBps();
                double beta = this.getEncodedCompTargetRatio();
                float dropRate = this.encodedFrameStatistics.getFrameDropRate();
                if (this.currEncBitrate >= this.maxBitrate) {
                    beta = 1.0;
                }
                if (dropRate < 0.5f && dropRate > 0.1f) {
                    beta = 1.085f - 0.85f * dropRate;
                } else if (dropRate > 0.5f) {
                    beta = 0.66f;
                }
                if (beta < 0.65 && beta > 0.0) {
                    beta = beta < 0.3 ? 2.0 : 1.0 / beta * 0.85;
                }
                setRate = (int)((double)setRate * beta);
                if (this.checkTime(now_ms) && this.adjustedBitrate != setRate) {
                    this.updateBitrate(setRate);
                }
                this.getAndCaluBitrate(now_ms);
                boolean bl = isKeyFrame = (info.flags & 1) != 0;
                if (isKeyFrame) {
                    Logging.d(TAG, "Sync frame generated");
                }
                if (isKeyFrame && this.codecType == VideoCodecType.H264) {
                    Logging.d(TAG, "Prepending config frame of size " + this.configBuffer.capacity() + " to output buffer with offset " + info.offset + ", size " + info.size);
                    frameBuffer = ByteBuffer.allocateDirect(info.size + this.configBuffer.capacity());
                    this.configBuffer.rewind();
                    frameBuffer.put(this.configBuffer);
                    frameBuffer.put(codecOutputBuffer);
                    frameBuffer.rewind();
                } else {
                    frameBuffer = codecOutputBuffer.slice();
                }
                EncodedImage.FrameType frameType = isKeyFrame ? EncodedImage.FrameType.VideoFrameKey : EncodedImage.FrameType.VideoFrameDelta;
                EncodedImage.Builder builder = this.outputBuilders.poll();
                if (null != builder) {
                    builder.setBuffer(frameBuffer).setFrameType(frameType);
                }
                if (null != (tmpCallback = this.callback) && null != builder) {
                    tmpCallback.onEncodedFrame(builder.createEncodedImage(), new VideoEncoder.CodecSpecificInfo());
                }
                this.encodedFrameStatistics.reportOverFrame();
            }
            this.encodeNum = 0;
            tmpCodec.releaseOutputBuffer(index, false);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverOutput failed", e);
            this.encodedFrameStatistics.reportDropFrame();
            this.running = false;
            ++this.encodeNum;
            this.mDequeueOutputFailed = true;
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "thread Releasing MediaCodec on output thread w is " + this.width + " h is " + this.height + " addr is " + this);
        try {
            this.codec.stop();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media encoder stop failed", e);
        }
        try {
            this.codec.release();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media encoder release failed", e);
            this.shutdownException = e;
        }
        this.configBuffer = null;
        Logging.d(TAG, "Release on output thread done");
    }

    private VideoCodecStatus updateBitrate(int setRate) {
        this.outputThreadChecker.checkIsOnValidThread();
        this.adjustedBitrate = setRate;
        try {
            Bundle params = new Bundle();
            params.putInt("video-bitrate", this.adjustedBitrate);
            this.codec.setParameters(params);
            return VideoCodecStatus.OK;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "updateBitrate failed", e);
            return VideoCodecStatus.ERROR;
        }
    }

    private boolean checkTime(long now_ms) {
        if (this.preTime == 0L) {
            this.preTime = now_ms;
            return true;
        }
        if (now_ms - this.preTime > this.intervalTime) {
            this.preTime = now_ms;
            return true;
        }
        return false;
    }

    private void updateBitrateStatics(long now_ms, int size) {
        if (now_ms < this.oldest_time_) {
            return;
        }
        Vector<Integer> vec = new Vector<Integer>();
        if (this.oldest_time_ == 0L) {
            this.oldest_time_ = now_ms;
            this.totalSize = size;
            vec.addElement(size);
            vec.addElement(this.adjustedBitrate);
            this.rateStatics.put(now_ms, vec);
            return;
        }
        this.eraseOld(now_ms);
        vec.addElement(size);
        vec.addElement(this.adjustedBitrate);
        this.rateStatics.put(now_ms, vec);
        this.totalSize += size;
    }

    private void eraseOld(long now_ms) {
        long new_old_time = now_ms - (long)this.window_size;
        if (new_old_time <= this.oldest_time_) {
            return;
        }
        Iterator<Map.Entry<Long, Vector<Integer>>> it = this.rateStatics.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Vector<Integer>> item = it.next();
            if (item.getKey() >= new_old_time) continue;
            this.totalSize -= item.getValue().get(0).intValue();
            item.getValue().clear();
            it.remove();
        }
        this.oldest_time_ = new_old_time;
    }

    private int getAndCaluBitrate(long now_ms) {
        long sum = 0L;
        int sample = 0;
        this.eraseOld(now_ms);
        double sec = (double)(now_ms - this.oldest_time_) / 1000.0;
        if (sec < 1.0) {
            Logging.v(TAG, "sec is less than 1 second");
            return 0;
        }
        for (Map.Entry<Long, Vector<Integer>> item : this.rateStatics.entrySet()) {
            sum += (long)item.getValue().get(1).intValue();
            ++sample;
        }
        if (sample == 0) {
            FinLog.e(TAG, "sample = 0.");
            return sample;
        }
        this.avgAdjustbitrate = (int)((sum + (long)(sample / 2)) / (long)sample);
        this.currEncBitrate = (int)((double)this.totalSize / sec * 8.0);
        this.ratios[this.current_idx] = 1.0 * (double)this.currEncBitrate / (double)this.avgAdjustbitrate;
        Logging.v(TAG, "sum is " + sum + " sample is: " + sample + " avgAdjustbitrate: " + this.avgAdjustbitrate + " currentEnc: " + this.currEncBitrate + " ratios: " + this.ratios[this.current_idx]);
        ++this.current_idx;
        if (this.current_idx >= 15) {
            this.current_idx -= 15;
        }
        return this.currEncBitrate;
    }

    private double getEncodedCompTargetRatio() {
        double avgRatio = 0.0;
        for (int i = 0; i < 15; ++i) {
            if (this.ratios[i] < 0.001) {
                Logging.d(TAG, "ratio is 0");
                return 1.0;
            }
            avgRatio += this.ratios[i];
        }
        return avgRatio / 15.0;
    }

    private boolean canUseSurface() {
        return this.sharedContext != null && this.surfaceColorFormat != null;
    }

    protected void fillInputBuffer(ByteBuffer buffer, VideoFrame.Buffer videoFrameBuffer) {
        this.yuvFormat.fillBuffer(buffer, videoFrameBuffer);
    }

    private static enum YuvFormat {
        I420{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, VideoFrame.Buffer srcBuffer) {
                VideoFrame.I420Buffer i420 = srcBuffer.toI420();
                YuvHelper.I420Copy(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dstBuffer, i420.getWidth(), i420.getHeight());
                i420.release();
            }
        }
        ,
        NV12{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, VideoFrame.Buffer srcBuffer) {
                VideoFrame.I420Buffer i420 = srcBuffer.toI420();
                YuvHelper.I420ToNV12(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dstBuffer, i420.getWidth(), i420.getHeight());
                i420.release();
            }
        }
        ,
        NV21{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, VideoFrame.Buffer srcBuffer) {
                VideoFrame.I420Buffer i420 = srcBuffer.toI420();
                YuvHelper.I420ToNV21(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dstBuffer, i420.getWidth(), i420.getHeight());
                i420.release();
            }
        };


        abstract void fillBuffer(ByteBuffer var1, VideoFrame.Buffer var2);

        static YuvFormat valueOf(int colorFormat) {
            switch (colorFormat) {
                case 19: 
                case 2135033992: {
                    return I420;
                }
                case 21: 
                case 2141391872: 
                case 2141391876: {
                    return NV12;
                }
            }
            throw new IllegalArgumentException("Unsupported colorFormat: " + colorFormat);
        }
    }
}

