/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.os.Build;
import android.util.Log;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.base.RCRTCAudioFrame;
import cn.rongcloud.rtc.core.audio.CustomAudioTrack;
import cn.rongcloud.rtc.core.rongRTC.DevicesUtils;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.PCMFileWriter;
import java.nio.ByteBuffer;

public class RongAudioTrack
implements CustomAudioTrack.AudioTrackProxy {
    private static final int DEFAULT_USAGE = RongAudioTrack.getDefaultUsageAttribute();
    private static final boolean isDump = false;
    private static final String TAG = "RongAudioTrack";
    private int sampleRateInHz;
    private int channelCount;
    private int channelConfig;
    private int minBufferSizeInBytes;
    private byte[] localFrame;
    private RCRTCAudioFrame RCRTCAudioFrame;
    private IRCRTCAudioDataListener mAudioDataListener;
    private static final Object trackBlock = new Object();
    private PCMFileWriter fileWriter;
    private boolean rtcProbeEnable;
    private AudioTrack audioTrack;

    private static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    @Override
    public void init(int sampleRate, int channelCount, int minBufferSizeInBytes) {
        this.sampleRateInHz = sampleRate;
        this.channelCount = channelCount;
        this.channelConfig = this.channelCountToConfiguration(channelCount);
        this.minBufferSizeInBytes = minBufferSizeInBytes;
        this.createAudioTrack(sampleRate, this.channelConfig, minBufferSizeInBytes);
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 4 : 12;
    }

    private void createAudioTrack(int sampleRate, int channelConfig, int minBufferSizeInBytes) {
        Log.i((String)TAG, (String)("createAudioTrack :: " + (Object)((Object)DevicesUtils.getAudioPlayMode())));
        this.audioTrack = Build.VERSION.SDK_INT >= 21 ? RongAudioTrack.createAudioTrackOnLollipopOrHigher(sampleRate, channelConfig, minBufferSizeInBytes) : RongAudioTrack.createAudioTrackOnLowerThanLollipop(sampleRate, channelConfig, minBufferSizeInBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer, int sizeInBytes) {
        IRCRTCAudioDataListener listener = this.mAudioDataListener;
        if (listener != null) {
            if (this.localFrame == null) {
                this.localFrame = new byte[byteBuffer.capacity()];
            }
            byteBuffer.rewind();
            byteBuffer.get(this.localFrame, 0, this.localFrame.length);
            if (this.RCRTCAudioFrame == null) {
                this.RCRTCAudioFrame = new RCRTCAudioFrame();
            }
            this.RCRTCAudioFrame.setBytes(this.localFrame);
            this.RCRTCAudioFrame.setChannels(this.channelCount);
            this.RCRTCAudioFrame.setSampleRate(this.sampleRateInHz);
            this.RCRTCAudioFrame.setBytesPerSample(2);
            byte[] customAudioBuffer = null;
            try {
                customAudioBuffer = listener.onAudioFrame(this.RCRTCAudioFrame);
            }
            catch (Exception e) {
                FinLog.e(TAG, "AudioTrack.IRemoteAudioPCMBufferListener error: " + e.getMessage());
            }
            if (customAudioBuffer != null) {
                if (customAudioBuffer.length == byteBuffer.capacity()) {
                    byteBuffer.clear();
                    byteBuffer.put(customAudioBuffer);
                } else {
                    FinLog.e(TAG, "Error:The processed data is not the same length as the original data.");
                }
                byteBuffer.rewind();
                customAudioBuffer = null;
            }
        }
        Object object = trackBlock;
        synchronized (object) {
            if (Build.VERSION.SDK_INT >= 21) {
                return this.audioTrack.write(byteBuffer, sizeInBytes, 0);
            }
            return this.audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), sizeInBytes);
        }
    }

    @Override
    public void play() {
        if (this.audioTrack != null) {
            this.audioTrack.play();
        }
    }

    @Override
    public void stop() {
        if (this.audioTrack != null) {
            this.audioTrack.stop();
        }
    }

    @Override
    public void release() {
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.audioTrack != null) {
            return this.audioTrack.getPlayState() == 3;
        }
        return false;
    }

    @Override
    public boolean isInitialized() {
        if (this.audioTrack != null) {
            return this.audioTrack.getState() == 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reCreateAudioTrack() {
        Object object = trackBlock;
        synchronized (object) {
            if (this.audioTrack != null) {
                boolean isPlaying = this.isPlaying();
                Log.i((String)TAG, (String)("recreateAudioTrack :: " + (Object)((Object)DevicesUtils.getAudioPlayMode()) + "  state::" + this.audioTrack.getState()));
                this.audioTrack.release();
                this.createAudioTrack(this.sampleRateInHz, this.channelConfig, this.minBufferSizeInBytes);
                if (isPlaying) {
                    this.play();
                }
            } else {
                Log.i((String)TAG, (String)("recreateAudioTrack audioTrack is null :: " + (Object)((Object)DevicesUtils.getAudioPlayMode())));
            }
        }
    }

    @TargetApi(value=21)
    private static AudioTrack createAudioTrackOnLollipopOrHigher(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        int nativeOutputSampleRate = AudioTrack.getNativeOutputSampleRate((int)DevicesUtils.getAudioMode());
        if (sampleRateInHz != nativeOutputSampleRate) {
            // empty if block
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(DevicesUtils.getAudioTrackUsage()).setContentType(DevicesUtils.getAudioTrackContentType()).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(sampleRateInHz).setChannelMask(channelConfig).build(), bufferSizeInBytes, 1, 0);
    }

    private static AudioTrack createAudioTrackOnLowerThanLollipop(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        return new AudioTrack(DevicesUtils.getAudioMode(), sampleRateInHz, channelConfig, 2, bufferSizeInBytes, 1);
    }

    public void setAudioDataListener(IRCRTCAudioDataListener listener) {
        this.mAudioDataListener = listener;
    }

    public void enableRTCProbe(boolean enable) {
        this.rtcProbeEnable = enable;
    }
}

