/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.opengl.GLES20;
import android.util.Log;

public class ShaderUtils {
    private static final String TAG = "ShaderUtils";

    public static int compileShader(int shaderType, String shaderSource) {
        int shaderHandle = GLES20.glCreateShader((int)shaderType);
        Log.e((String)TAG, (String)("compileShader: " + GLES20.glGetShaderInfoLog((int)shaderHandle)));
        if (shaderHandle != 0) {
            Log.e((String)TAG, (String)"compileShader: ");
            GLES20.glShaderSource((int)shaderHandle, (String)shaderSource);
            GLES20.glCompileShader((int)shaderHandle);
            int[] compileStatus = new int[1];
            GLES20.glGetShaderiv((int)shaderHandle, (int)35713, (int[])compileStatus, (int)0);
            if (compileStatus[0] == 0) {
                Log.e((String)TAG, (String)("Error compiling shader: " + GLES20.glGetShaderInfoLog((int)shaderHandle)));
                GLES20.glDeleteShader((int)shaderHandle);
                shaderHandle = 0;
            }
        }
        if (shaderHandle == 0) {
            throw new RuntimeException("Error creating shader.");
        }
        return shaderHandle;
    }

    public static int createAndLinkProgram(int vertexShaderHandle, int fragmentShaderHandle) {
        int programHandle = GLES20.glCreateProgram();
        if (programHandle != 0) {
            GLES20.glAttachShader((int)programHandle, (int)vertexShaderHandle);
            GLES20.glAttachShader((int)programHandle, (int)fragmentShaderHandle);
            GLES20.glLinkProgram((int)programHandle);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)programHandle, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] == 0) {
                Log.e((String)TAG, (String)("Error compiling program: " + GLES20.glGetProgramInfoLog((int)programHandle)));
                GLES20.glDeleteProgram((int)programHandle);
                programHandle = 0;
            }
        }
        if (programHandle == 0) {
            throw new RuntimeException("Error creating program.");
        }
        return programHandle;
    }
}

