/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.audio.AudioMixerSourceEvents;
import cn.rongcloud.rtc.core.audio.EAudioInput;
import cn.rongcloud.rtc.core.audio.IAudioInput;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.core.audio.OnAudioDeviceErrorListener;
import cn.rongcloud.rtc.plugin.VoiceBeautifierPlugin;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.nio.ByteBuffer;

public class CustomEchoAudioRecorder
implements IAudioInput {
    private static final String TAG = "CustomEchoAudioRecorder";
    public static final int OpenSLESEngineError = -1;
    public static final int OpenSLESRecorderError = -2;
    public static final int OpenSLESPlayerError = -3;
    private OnAudioDeviceErrorListener onAudioDeviceErrorListener;
    private ByteBuffer byteBuffer;
    private long nativeAudioRecorder;
    private VoiceBeautifierPlugin beautifier;
    OnAudioBufferAvailableListener mPreListener;
    OnAudioBufferAvailableListener mPostListener;
    private AudioMixerSourceEvents mSourceEvents;
    boolean isEcho = false;

    public CustomEchoAudioRecorder(OnAudioBufferAvailableListener preListener, OnAudioBufferAvailableListener postListener, OnAudioDeviceErrorListener onAudioDeviceErrorListener) {
        this.mPreListener = preListener;
        this.mPostListener = postListener;
        this.onAudioDeviceErrorListener = onAudioDeviceErrorListener;
    }

    public void enableEcho(boolean enable) {
        CustomEchoAudioRecorder.nativeEnableEcho(this.nativeAudioRecorder, enable);
    }

    public void setMute(boolean mute) {
        CustomEchoAudioRecorder.nativeSetMute(this.nativeAudioRecorder, mute);
    }

    @Override
    public long createNativeObject(long builder) {
        return CustomEchoAudioRecorder.nativeCreateNativeObject(builder);
    }

    @Override
    public void setMicrophoneMute(boolean mute) {
        if (0L != this.nativeAudioRecorder) {
            CustomEchoAudioRecorder.nativeSetMute(this.nativeAudioRecorder, mute);
        }
    }

    @Override
    public void setVoiceBeautifier(VoiceBeautifierPlugin beautifier) {
        this.beautifier = beautifier;
    }

    @Override
    public void setEcho(boolean enable) {
        if (0L != this.nativeAudioRecorder) {
            CustomEchoAudioRecorder.nativeEnableEcho(this.nativeAudioRecorder, enable);
        }
        this.isEcho = enable;
    }

    @CalledByNative
    private void onNativeError(int errorCode) {
        if (this.onAudioDeviceErrorListener != null) {
            this.onAudioDeviceErrorListener.onAudioDeviceError(errorCode);
        }
    }

    @CalledByNative
    private void startRecording(int sampleRate, int bitsPerSample, int channel) {
        ReportUtil.libStatus(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status", "opensles", "startRecording");
        if (this.mSourceEvents != null) {
            this.mSourceEvents.onSourceStarted();
        }
        if (this.beautifier != null) {
            this.beautifier.start(sampleRate, bitsPerSample, channel);
        }
    }

    @CalledByNative
    private void stopRecording() {
        ReportUtil.libStatus(ReportUtil.TAG.AUDIOINPUTSTATUS, "type|status", "opensles", "stopRecording");
        if (this.mSourceEvents != null) {
            this.mSourceEvents.onSourceStopped();
        }
        if (this.beautifier != null) {
            this.beautifier.stop();
        }
    }

    @CalledByNative
    private void setNativeRecorder(long nativeAudioRecorder, int bufferSize) {
        this.nativeAudioRecorder = nativeAudioRecorder;
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        CustomEchoAudioRecorder.nativeCacheDirectBufferAddress(this.nativeAudioRecorder, this.byteBuffer);
    }

    @CalledByNative
    private void onAudioSamplesReady(int sampleRate, int channelCount, int bytesPerSample) {
        if (this.mPreListener != null) {
            int sampleFormat;
            int n = sampleFormat = bytesPerSample == 2 ? 2 : 3;
            if (null != this.mPreListener) {
                this.mPreListener.onAudioBuffer(this.byteBuffer, this.byteBuffer.capacity(), sampleRate, channelCount, sampleFormat);
            }
        }
    }

    @CalledByNative
    public void onPcmProcessed(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
        if (null != this.mPostListener) {
            this.mPostListener.onAudioBuffer(byteBuffer, sizeInBytes, sampleRate, channelCount, audioFormat);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void setMixerSourceEventsListener(AudioMixerSourceEvents eventsListener) {
        this.mSourceEvents = eventsListener;
    }

    @Override
    public EAudioInput getType() {
        return EAudioInput.OPENSLES;
    }

    private static native void nativeCacheDirectBufferAddress(long var0, ByteBuffer var2);

    private static native void nativeEnableEcho(long var0, boolean var2);

    private static native void nativeSetMute(long var0, boolean var2);

    private static native long nativeCreateNativeObject(long var0);
}

