/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.os.Build;
import android.os.Message;
import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.api.RCRTCBaseRoom;
import cn.rongcloud.rtc.api.RCRTCMixConfig;
import cn.rongcloud.rtc.api.RCRTCOtherRoom;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.RCRTCRoomConfig;
import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.callback.IRCRTCSwitchRoleDataCallback;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCConnectionState;
import cn.rongcloud.rtc.base.RCRTCJoinType;
import cn.rongcloud.rtc.base.RCRTCLiveRole;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RCRTCSubscribeState;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCLocalUserImpl;
import cn.rongcloud.rtc.center.RCOtherRoomImpl;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCRTCLiveInfoImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.center.stream.RCTinyVideoOutStream;
import cn.rongcloud.rtc.center.stream.RCVideoInputStreamImpl;
import cn.rongcloud.rtc.core.MediaConstraints;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.earmonitor.EarMonitorManager;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.action.PubSubAction;
import cn.rongcloud.rtc.engine.action.PubSubActionQueue;
import cn.rongcloud.rtc.engine.tools.HandleRTCMsgTools;
import cn.rongcloud.rtc.engine.tools.multiroom.InviteMessageElement;
import cn.rongcloud.rtc.plugin.VoiceBeautifierPlugin;
import cn.rongcloud.rtc.proto.APIType;
import cn.rongcloud.rtc.proxy.message.messagebeans.CDNResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.ExchangeSDPDataResult;
import cn.rongcloud.rtc.proxy.message.messagebeans.InviteInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.PKInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.ResourceTools;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.MediaCommonParams;
import com.google.gson.Gson;
import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.IRongCoreRTCCallback;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.RTCStatusDate;
import io.rong.imlib.model.RTCUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InRoomState
extends AbstractBaseState {
    private static final String TAG = "InRoomState";
    private PubSubActionQueue mActionQueue = new PubSubActionQueue(this);
    private RCRoomImpl mRoom;
    private RCLocalUserImpl mLocalUser;
    private HandleRTCMsgTools mReceivedMsgTools;
    private RCRTCLiveInfo mLiveInfo = null;
    private volatile long wisseStartTime = -1L;

    public InRoomState(RTCEngineImpl engine) {
        super(engine);
    }

    @Override
    public void enter() {
        this.mRoom = this.mEngine.mRoom;
        this.mLocalUser = (RCLocalUserImpl)this.mRoom.getLocalUser();
        this.mActionQueue.clear();
        this.mReceivedMsgTools = new HandleRTCMsgTools(this);
        this.wisseStartTime = -1L;
        super.enter();
    }

    @Override
    public boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 3000: {
                this.mActionQueue.offer(1, (List)obj.getData(0), (IRCRTCFailedCallback)obj.getData(1));
                break;
            }
            case 3010: {
                this.mActionQueue.offer(1, (List)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 3001: {
                this.onPublishStreamsSuccess((List)obj.getData(0), (List)obj.getData(1), (RCRTCLiveInfo)obj.getData(2), (IRCRTCResultDataCallback)obj.getData(3));
                break;
            }
            case 3080: 
            case 3083: {
                this.mActionQueue.offer(2, (List)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 3081: {
                this.onUnpublishedStreamsSuccess((List)obj.getData(0), (List)obj.getData(1), (IRCRTCResultDataCallback)obj.getData(2));
                break;
            }
            case 4000: {
                this.mActionQueue.offer(3, (List)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 3091: 
            case 4001: {
                this.onSubscribeStreamSuccess((List)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 4040: {
                this.mActionQueue.offer(5, (List)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 4041: {
                this.onUnsubscribeResourcesSuccess((List)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 3090: {
                this.mActionQueue.offer(6, Collections.singletonList((RCRTCInputStream)obj.getData(1)), obj.getData(0), (IRCRTCFailedCallback)((IRCRTCResultCallback)obj.getData(2)));
                break;
            }
            case 3092: {
                this.onSwitchStreamFailed((Boolean)obj.getData(0), (List)obj.getData(1));
                this.onPubSubFailed(msg, obj);
                break;
            }
            case 3002: 
            case 3082: 
            case 4002: 
            case 4042: {
                this.onPubSubFailed(msg, obj);
                break;
            }
            case 3050: {
                List<IStreamResource> pubList = this.getAllPubStreams();
                boolean hasPublishedVideoStream = false;
                for (IStreamResource stream : pubList) {
                    if (stream.getMediaType() != RCRTCMediaType.VIDEO) continue;
                    hasPublishedVideoStream = true;
                    break;
                }
                if (!hasPublishedVideoStream) {
                    ReportUtil.libStatus(ReportUtil.TAG.EXCHANGEVIDEOSIZE, "roomId|desc", this.getRoomId(), "hasn't publish video stream");
                    break;
                }
                this.mActionQueue.offer(7, null, null);
                break;
            }
            case 3051: {
                ((IRCRTCResultDataCallback)obj.getData(1)).onSuccess(null);
                break;
            }
            case 8104: {
                RCRTCConnectionState state = (RCRTCConnectionState)((Object)obj.getData());
                if (RTCEngineImpl.getInstance().getEngineEventListener() == null) break;
                RTCEngineImpl.getInstance().getEngineEventListener().onConnectionStateChanged(state);
                break;
            }
            case 8000: {
                this.getRTCUserData(this.getRoomId());
                break;
            }
            case 8004: {
                this.offerReconnect(true);
                break;
            }
            case 8003: {
                this.onReJoinRoomSuccess((List)obj.getData());
                break;
            }
            case 8002: {
                RTCEngineImpl.getInstance().engineError(RTCErrorCode.RECONNECT_ERROR);
                this.onPubSubFailed(msg, obj);
                break;
            }
            case 8001: {
                this.onStartReconnectSuccess((Pair<List<MediaResourceInfo>, RCRTCLiveInfo>)((Pair)obj.getData(0)));
                IRCRTCResultDataCallback successCallback = (IRCRTCResultDataCallback)obj.getData(1);
                if (null == successCallback) break;
                successCallback.onSuccess(null);
                break;
            }
            case 3100: {
                this.sendModifyResourceSignal((RCOutputStreamImpl)obj.getData(0), (Boolean)obj.getData(1));
                break;
            }
            case 7000: {
                this.mReceivedMsgTools.handleRTCMessage((io.rong.imlib.model.Message)obj.getData());
                break;
            }
            case 2060: {
                this.addTrack((String)obj.getData(0), (String)obj.getData(1), (RCRTCMediaType)((Object)obj.getData(2)), (MediaStreamTrack)obj.getData(3));
                break;
            }
            case 8101: {
                Map<String, String> localUserDatas = null;
                RCRTCJoinType joinType = null;
                if (this.mRoom.getRoomConfig() != null) {
                    localUserDatas = this.mRoom.getRoomConfig().getLocalUserDatas();
                    joinType = this.mRoom.getRoomConfig().getJoinType();
                }
                this.mRoom.getPingManager().reJoinRoom(this.mRoom.getRoomType(), localUserDatas, joinType);
                break;
            }
            case 8102: {
                Map exParams = (Map)obj.getData(1);
                HashMap roomData = null;
                roomData = (HashMap)exParams.get("joinRoomData");
                if (roomData != null && roomData.size() > 0) {
                    String tmpKey = "";
                    for (Map.Entry entry : roomData.entrySet()) {
                        tmpKey = (String)entry.getKey();
                        if (!TextUtils.equals((CharSequence)tmpKey, (CharSequence)"cdn_uris")) continue;
                        this.mRoom.setCDNResourceInfo(this.setCDNResourceInfo((String)entry.getValue()));
                    }
                }
                this.onReJoinRoomSuccess((List)obj.getData(0));
                break;
            }
            case 3301: {
                if (null == obj.getData(2) && null == obj.getData(3)) {
                    this.mRoom.getEventsListener().onFirstRemoteVideoFrame((String)obj.getData(0), (String)obj.getData(1));
                    break;
                }
                if (TextUtils.equals((CharSequence)((CharSequence)obj.getData(0)), (CharSequence)this.mLocalUser.getUserId())) {
                    this.mRoom.getEventsListener().onFirstLocalVideoFrame((String)obj.getData(1), (Integer)obj.getData(2), (Integer)obj.getData(3));
                    break;
                }
                this.mRoom.getEventsListener().onFirstRemoteVideoFrame((String)obj.getData(0), (String)obj.getData(1), (Integer)obj.getData(2), (Integer)obj.getData(3));
                break;
            }
            case 5052: {
                this.mRoom.getEventsListener().onReportFirstFrame((RCRTCInputStream)obj.getData(0), (RCRTCMediaType)((Object)obj.getData(1)));
                break;
            }
            case 3308: {
                this.mRoom.getEventsListener().onFirstRemoteAudioFrame((String)obj.getData(0), (String)obj.getData(1));
                break;
            }
            case 3302: {
                break;
            }
            case 3303: {
                SignalManager.getInstance().setAttributeValue((String)obj.getData(5), (RCAttributeType)((Object)obj.getData(0)), (String)obj.getData(1), (String)obj.getData(2), (MessageContent)obj.getData(3), (IRCRTCResultCallback)obj.getData(4));
                break;
            }
            case 3307: {
                SignalManager.getInstance().rtcPutInnerData(this.mRoom.getRoomId(), (RCAttributeType)((Object)obj.getData(0)), (String)obj.getData(1), (String)obj.getData(2), (MessageContent)obj.getData(3), (IRCRTCResultCallback)obj.getData(4));
                break;
            }
            case 3304: {
                SignalManager.getInstance().deleteAttributes((String)obj.getData(4), (RCAttributeType)((Object)obj.getData(0)), (List)obj.getData(1), (MessageContent)obj.getData(2), (IRCRTCResultCallback)obj.getData(3));
                break;
            }
            case 3305: {
                SignalManager.getInstance().getAttributes((String)obj.getData(3), (RCAttributeType)((Object)obj.getData(0)), (List)obj.getData(1), APIType.OUTER_DATA, (IRCRTCResultDataCallback)obj.getData(2));
                break;
            }
            case 3306: {
                SignalManager.getInstance().sendIMSignal(this.mRoom.getRoomId(), (MessageContent)obj.getData(0), (IRongCoreCallback.ISendMessageCallback)obj.getData(1));
                break;
            }
            case 2010: {
                this.mEngine.mRTCCore.setRTCStatusReportListener((IRCRTCStatusReportListener)obj.getData());
                break;
            }
            case 2011: {
                this.mEngine.mRTCCore.setRTCStatusReportListener(null);
                break;
            }
            case 5020: {
                boolean isEnableInnerCDN = false;
                if (this.mRoom.getCDNResourceInfo() != null) {
                    isEnableInnerCDN = this.mRoom.getCDNResourceInfo().isEnableInnerCDN();
                }
                this.setMCUConfig((String)obj.getData(0), this.mRoom.getRoomId(), this.mRoom.getSessionId(), (String)obj.getData(1), isEnableInnerCDN, (IRCRTCResultCallback)obj.getData(2));
                break;
            }
            case 9001: {
                if (RTCEngineImpl.getInstance().getEngineEventListener() != null) {
                    RTCEngineImpl.getInstance().getEngineEventListener().onKicked(this.getRoomId(), RCRTCParamsType.RCRTCKickedReason.IM_DISCONNECTED);
                }
                this.releaseRoom(null);
                break;
            }
            case 5021: {
                VoiceBeautifierPlugin voiceBeautifierPlugin = RTCEngineImpl.getInstance().getVoiceBeautyPlugin();
                boolean isEnable = (Boolean)obj.getData(0);
                if (null == voiceBeautifierPlugin) break;
                int result = voiceBeautifierPlugin.sdkEnable(isEnable);
                IRCRTCResultCallback callback = (IRCRTCResultCallback)obj.getData(1);
                if (null != callback) {
                    if (0 == result) {
                        callback.onSuccess();
                    } else {
                        if (RTCErrorCode.SERVER_NOT_CONFIG_WISSE.getValue() == result) {
                            callback.onFailed(RTCErrorCode.SERVER_NOT_CONFIG_WISSE);
                            break;
                        }
                        callback.onFailed(RTCErrorCode.UnknownError);
                    }
                }
                if (isEnable) {
                    this.wisseStartTime = System.currentTimeMillis() / 1000L;
                    break;
                }
                if (-1L == this.wisseStartTime) break;
                long time = System.currentTimeMillis() / 1000L;
                ReportUtil.libStatus(ReportUtil.TAG.VOICE_BEAUTIFIER_REPORT, "reason|startTime|endTime", "user call disable", this.wisseStartTime, time);
                SignalManager.getInstance().reportWisseInfo(this.mRoom.getRoomId(), this.mRoom.getRoomType().getRoomType(), this.mRoom.getSessionId(), this.wisseStartTime, System.currentTimeMillis() / 1000L);
                this.wisseStartTime = -1L;
                break;
            }
            case 1011: {
                this.mEngine.clearDeferredMessage();
                this.mEngine.deferMessage(msg);
                this.releaseRoom(null);
                break;
            }
            case 9000: {
                if (-1L != this.wisseStartTime) {
                    long time = System.currentTimeMillis() / 1000L;
                    ReportUtil.libStatus(ReportUtil.TAG.VOICE_BEAUTIFIER_REPORT, "reason|startTime|endTime", "sdk leave room", this.wisseStartTime, time);
                    SignalManager.getInstance().reportWisseInfo(this.mRoom.getRoomId(), this.mRoom.getRoomType().getRoomType(), this.mRoom.getSessionId(), this.wisseStartTime, System.currentTimeMillis() / 1000L);
                    this.wisseStartTime = -1L;
                }
                this.releaseRoom((IRCRTCResultCallback)obj.getData());
                break;
            }
            case 10000: {
                this.mEngine.unInitFaceBeautyPlugin();
                this.mEngine.unInitVoiceBeautyPlugin();
                this.mEngine.clearDeferredMessage();
                this.mEngine.deferMessage(msg);
                this.releaseRoom(null);
                break;
            }
            case 2070: {
                this.joinOtherRoom((String)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 2071: {
                Map joinOtherSuccess_exarams = (Map)obj.getData(3);
                IRCRTCResultDataCallback joinOtherRoomSuccess_callback = (IRCRTCResultDataCallback)obj.getData(4);
                if (joinOtherSuccess_exarams == null) {
                    this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, joinOtherRoomSuccess_callback);
                    break;
                }
                this.onJoinOtherRoomSuccess((String)obj.getData(0), (RCRTCRoomType)((Object)obj.getData(1)), (List)obj.getData(2), joinOtherSuccess_exarams, joinOtherRoomSuccess_callback);
                break;
            }
            case 2072: {
                this.leaveOtherRoom((String)obj.getData(0), (Boolean)obj.getData(1), (IRCRTCResultCallback)obj.getData(2));
                break;
            }
            case 2073: {
                this.sendRequestJoinOtherRoomMessage(obj);
                break;
            }
            case 2074: {
                this.sendCancelRequestJoinOtherRoomMessage(obj);
                break;
            }
            case 2075: {
                this.responseJoinOtherRoom(obj);
                break;
            }
            case 2076: {
                ((IRCRTCResultDataCallback)obj.getData()).onSuccess(null);
                break;
            }
            case 2077: {
                ((IRCRTCResultDataCallback)obj.getData(0)).onFailed((RTCErrorCode)((Object)obj.getData(1)));
                break;
            }
            case 2078: {
                String otherRoomId = (String)obj.getData(0);
                int pingErrorCode = (Integer)obj.getData(1);
                FinLog.e(TAG, "otherRoomId :" + otherRoomId + " pingErrorCode :" + pingErrorCode);
                RCOtherRoomImpl otherRoom = (RCOtherRoomImpl)this.getMultiRoomManager().getBaseRoomElemet().remove(otherRoomId);
                if (otherRoom != null) {
                    otherRoom.release();
                }
                if (this.mRoom == null) break;
                this.mRoom.removeOtherRoomId(otherRoomId);
                if (RTCEngineImpl.getInstance().getEngineEventListener() == null) break;
                RTCEngineImpl.getInstance().getEngineEventListener().onKicked(this.getRoomId(), RCRTCParamsType.RCRTCKickedReason.IM_DISCONNECTED);
                break;
            }
            case 2079: {
                this.sendleaveOtherRoomMessage((RCOtherRoomImpl)obj.getData(0), (Boolean)obj.getData(1), (IRCRTCResultCallback)obj.getData(2));
                break;
            }
            case 2061: {
                RCRTCParamsType.AudioQuality audioQuality = (RCRTCParamsType.AudioQuality)((Object)obj.getData());
                if (audioQuality == null) break;
                this.mEngine.mConfig.audioBitrate.setLocalValue(audioQuality.getBitrate());
                this.mActionQueue.offer(10, null, null);
                break;
            }
            case 2063: {
                ((IRCRTCResultDataCallback)obj.getData()).onSuccess(null);
                break;
            }
            case 2064: {
                ((IRCRTCResultDataCallback)obj.getData()).onFailed(null);
                break;
            }
            case 2062: {
                MediaConstraints audioConstraints = (MediaConstraints)obj.getData();
                if (audioConstraints == null) break;
                this.mEngine.mRTCCore.updateAudioConstraints(audioConstraints);
                break;
            }
            case 2065: {
                int bitrate = (Integer)obj.getData();
                this.setAudioQualityMixConfig(bitrate);
                break;
            }
            case 5035: {
                this.enableInnerCDN((String)obj.getData(0), this.mRoom.getRoomId(), this.mRoom.getSessionId(), (String)obj.getData(1), (Boolean)obj.getData(2), (IRCRTCResultCallback)obj.getData(3));
                break;
            }
            case 5051: {
                this.enableInnerCDNSuccess((String)obj.getData(0), (Boolean)obj.getData(1), (IRCRTCResultCallback)obj.getData(2));
                break;
            }
            case 5036: {
                this.onFailedCallback((RTCErrorCode)((Object)obj.getData(0)), (IRCRTCFailedCallback)obj.getData(1));
                break;
            }
            case 5038: {
                this.mRoom.updateCDNResourceInfo(this.getRoomId(), (String)obj.getData(0));
                this.onSuccessCallback((IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 5037: {
                this.onFailedCallback((RTCErrorCode)((Object)obj.getData(1)), (IRCRTCResultCallback)obj.getData(0));
                break;
            }
            case 5060: {
                msg.what = 5074;
                this.mEngine.deferMessage(msg);
                this.mEngine.transitionTo(this.mEngine.mSwitching);
                break;
            }
            case 5067: {
                this.switchToBroadcasterPublish((Pair)msg.obj);
                break;
            }
            case 2088: {
                this.mEngine.mRTCCore.setEarphoneOn((Boolean)obj.getData(), null);
                break;
            }
            case 5068: {
                this.onSuccessCallback((RCRTCLiveInfo)obj.getData(0), (IRCRTCSwitchRoleDataCallback)obj.getData(1));
                break;
            }
            case 5069: {
                this.onKickedCallback((IRCRTCSwitchRoleDataCallback)obj.getData());
                this.releaseRoom(null);
                break;
            }
            case 6000: {
                EarMonitorManager manager = (EarMonitorManager)obj.getData(0);
                Boolean enable = (Boolean)obj.getData(1);
                if (null == manager || enable == null) break;
                int oldSource = this.mEngine.getRecordAudioSource();
                manager.enable(enable);
                int newSource = this.mEngine.getRecordAudioSource();
                if (oldSource == newSource) break;
                ReportUtil.libTask(ReportUtil.TAG.RESETAUDIOINPUT, "reason", "EVENT_SWITCH_ECHO");
                this.mEngine.mDefaultAudioStream.resetAudioInput();
                break;
            }
            case 5077: {
                this.getRTCUserData((RCRTCOtherRoom)obj.getData(0), (RCRTCRemoteUser)obj.getData(1));
                break;
            }
            case 5078: {
                RCRTCOtherRoom rcrtcOtherRoom = (RCRTCOtherRoom)obj.getData(0);
                RCRemoteUserImpl remoteUser = (RCRemoteUserImpl)obj.getData(1);
                String uris = (String)obj.getData(2);
                if (!TextUtils.isEmpty((CharSequence)uris)) {
                    RCRemoteUserImpl.changeRemoteUsers(remoteUser, uris);
                }
                ((RCOtherRoomImpl)rcrtcOtherRoom).addRemoteUser(remoteUser);
                if (((RCOtherRoomImpl)rcrtcOtherRoom).getRCRoomListener() != null) {
                    ((RCOtherRoomImpl)rcrtcOtherRoom).getRCRoomListener().onUserJoined(rcrtcOtherRoom, remoteUser);
                }
                if (TextUtils.isEmpty((CharSequence)uris) || ((RCOtherRoomImpl)rcrtcOtherRoom).getRCRoomListener() == null) break;
                ((RCOtherRoomImpl)rcrtcOtherRoom).getRCRoomListener().onRemoteUserPublishResource(rcrtcOtherRoom, remoteUser, remoteUser.getStreams());
                break;
            }
            case 5076: {
                this.sendModifyResourceToMediaServer((Boolean)obj.getData());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void setMCUConfig(String serverUrl, final String roomId, String sessionId, String configJson, final boolean enableInnerCDN, final IRCRTCResultCallback callBack) {
        SignalManager.getInstance().setMCUConfig(serverUrl, roomId, sessionId, configJson, new IRCRTCResultDataCallback<String>(){

            @Override
            public void onSuccess(String data) {
                try {
                    String pullUrl = "";
                    JSONObject jsonObject = new JSONObject(data);
                    if (jsonObject.has("pull_url") && !TextUtils.isEmpty((CharSequence)(pullUrl = jsonObject.optString("pull_url")))) {
                        JSONObject objPullUrl = new JSONObject(pullUrl);
                        int broadcast = -1;
                        if (objPullUrl.has("broadcast")) {
                            broadcast = objPullUrl.optInt("broadcast");
                        }
                        if (broadcast == 0) {
                            InRoomState.this.CDNServerBroadcast(roomId, pullUrl, enableInnerCDN, callBack);
                        } else {
                            callBack.onSuccess();
                        }
                    } else {
                        callBack.onSuccess();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    ReportUtil.libError(ReportUtil.TAG.MCU_CONFIG, "code|desc", new Object[]{RTCErrorCode.JsonParseError, e.getMessage()});
                    callBack.onFailed(RTCErrorCode.JsonParseError);
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                callBack.onFailed(errorCode);
            }
        });
    }

    private void setAudioQualityMixConfig(int bitrate) {
        ReportUtil.libTask(ReportUtil.TAG.SETAUDIOQUALITYMIXCONFIG, "bitrate", bitrate);
        if (this.mLiveInfo == null) {
            ReportUtil.libError(ReportUtil.TAG.SETAUDIOQUALITYMIXCONFIG, "error", "liveInfo is null");
            return;
        }
        RCRTCMixConfig config = new RCRTCMixConfig();
        RCRTCMixConfig.MediaConfig mediaConfig = new RCRTCMixConfig.MediaConfig();
        RCRTCMixConfig.MediaConfig.AudioConfig audioConfig = new RCRTCMixConfig.MediaConfig.AudioConfig();
        audioConfig.setBitrate(bitrate);
        mediaConfig.setAudioConfig(audioConfig);
        config.setMediaConfig(mediaConfig);
        String configJson = new Gson().toJson((Object)config);
        String configUri = ((RCRTCLiveInfoImpl)this.mLiveInfo).getConfigUrl();
        ReportUtil.libStatus(ReportUtil.TAG.SETAUDIOQUALITYMIXCONFIG, "config", configJson);
        SignalManager.getInstance().setMCUConfig(configUri, this.mRoom.getRoomId(), this.mRoom.getSessionId(), configJson, new IRCRTCResultDataCallback<String>(){

            @Override
            public void onSuccess(String data) {
                ReportUtil.libRes(ReportUtil.TAG.SETAUDIOQUALITYMIXCONFIG, "code", 0);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SETAUDIOQUALITYMIXCONFIG, "code", errorCode.getValue());
            }
        });
    }

    private void sendFinishOtherRoomMessage(final String otherRoomId, final IRCRTCResultCallback callBack) {
        if (this.mRoom == null || TextUtils.isEmpty((CharSequence)this.mRoom.getRoomId()) || this.mRoom.getLocalUser() == null || TextUtils.isEmpty((CharSequence)this.mRoom.getLocalUser().getUserId())) {
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            FinLog.e(TAG, "sendFinishOtherRoomMessage. Parameter is empty.");
            return;
        }
        String[] keys = new String[1];
        String inviteSessionId = "";
        String multiRoomKey = "";
        PKInfo pkInfo = this.mMultiRoomManager.getRoomAttributesElement().get(otherRoomId);
        if (pkInfo != null && !TextUtils.isEmpty((CharSequence)pkInfo.getInviteSessionId())) {
            keys[0] = multiRoomKey = pkInfo.getMultiRoomKey();
            inviteSessionId = pkInfo.getInviteSessionId();
        }
        ReportUtil.libTask(ReportUtil.TAG.FINISHOTHERROOM, "otherRoomId|multiRoomKey|inviteSessionId", otherRoomId, multiRoomKey, inviteSessionId);
        SignalManager.getInstance().finishOtherRoom(otherRoomId, "", this.mRoom.getRoomId(), inviteSessionId, this.mRoom.getLocalUser().getUserId(), keys, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.FINISHOTHERROOM, "otherRoomId", otherRoomId);
                InRoomState.this.onSuccessCallback(callBack);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.FINISHOTHERROOM, "otherRoomId|code", otherRoomId, errorCode.getValue());
                InRoomState.this.onFailedCallback(errorCode, callBack);
            }
        });
        this.mMultiRoomManager.getRoomAttributesElement().remove(multiRoomKey);
    }

    private void sendCancelRequestJoinOtherRoomMessage(MsgObjectWraper obj) {
        String inviteeRoomId = (String)obj.getData(0);
        final IRCRTCResultCallback cancel_callback = (IRCRTCResultCallback)obj.getData(4);
        final String cancel_userId = (String)obj.getData(1);
        final String inviteSessionId = (String)obj.getData(2);
        String extra = "";
        Object cancel_extra_Obj = obj.getData(3);
        if (cancel_extra_Obj != null) {
            extra = String.valueOf(cancel_extra_Obj);
        }
        SignalManager.getInstance().cancelRequestJoinOtherRoom(inviteeRoomId, cancel_userId, this.mRoom.getRoomId(), this.mRoom.getLocalUser().getUserId(), inviteSessionId, extra, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                InRoomState.this.getMultiRoomManager().getInviteMessageElement().remove(cancel_userId);
                ReportUtil.appRes(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                InRoomState.this.onSuccessCallback(cancel_callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, "inviteSessionId", inviteSessionId, errorCode.getValue());
                InRoomState.this.onFailedCallback(errorCode, cancel_callback);
            }
        });
    }

    private void responseJoinOtherRoom(MsgObjectWraper obj) {
        final String inviterUserId = (String)obj.getData(1);
        String inviterRoomId = (String)obj.getData(0);
        boolean agree = (Boolean)obj.getData(2);
        boolean inviteeUserAutoMix = (Boolean)obj.getData(3);
        String extra = "";
        Object extra_Obj = obj.getData(6);
        if (extra_Obj != null) {
            extra = String.valueOf(extra_Obj);
        }
        final String inviteSessionId = (String)obj.getData(4);
        final IRCRTCResultCallback callback = (IRCRTCResultCallback)obj.getData(7);
        InviteInfo inviteInfo = (InviteInfo)obj.getData(5);
        String key = RongRTCUtils.createRoomKey(inviterRoomId, this.mRoom.getRoomId());
        SignalManager.getInstance().responseJoinOtherRoom(inviterRoomId, inviterUserId, agree, extra, inviteeUserAutoMix, this.mRoom.getRoomId(), inviteInfo, key, inviteSessionId, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.RESPONSEJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                InRoomState.this.mMultiRoomManager.getInviteNotifyMessageElement().remove(inviterUserId, inviteSessionId);
                InRoomState.this.onSuccessCallback(callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.RESPONSEJOINOTHERROOM, "inviteSessionId|code", inviteSessionId, errorCode.getValue());
                InRoomState.this.onFailedCallback(errorCode, callback);
            }
        });
    }

    private void sendRequestJoinOtherRoomMessage(MsgObjectWraper obj) {
        final String inviteeRoomId = (String)obj.getData(0);
        final String inviteeUserId = (String)obj.getData(1);
        int timeoutTime = (Integer)obj.getData(2);
        boolean autoMix = (Boolean)obj.getData(3);
        final String inviteSessionId = (String)obj.getData(4);
        String extra = "";
        Object extraObj = obj.getData(5);
        if (extraObj != null) {
            extra = String.valueOf(extraObj);
        }
        String mainRoomId = this.mRoom.getRoomId();
        final IRCRTCResultCallback callback = (IRCRTCResultCallback)obj.getData(6);
        String localUserId = this.mRoom.getLocalUser().getUserId();
        InviteInfo info = new InviteInfo(inviteeRoomId, inviteeUserId, timeoutTime, inviteSessionId, mainRoomId, localUserId, autoMix);
        String inviteInfo = info.toString(extra);
        long startInviteTime = System.currentTimeMillis();
        ReportUtil.appTask(ReportUtil.TAG.REQUESTJOINOTHERROOM, RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "startInviteTime"), inviteeRoomId, inviteeUserId, startInviteTime);
        InviteMessageElement.InviteTimeoutStatistics inviteTimeoutStatistics = new InviteMessageElement.InviteTimeoutStatistics(inviteSessionId, startInviteTime);
        this.mMultiRoomManager.getInviteMessageElement().put(inviteeUserId, inviteTimeoutStatistics);
        final String rkey = RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "inviteSessionId", "code");
        SignalManager.getInstance().requestJoinOtherRoom(inviteeRoomId, inviteeUserId, mainRoomId, timeoutTime, inviteSessionId, inviteInfo, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.REQUESTJOINOTHERROOM, rkey, inviteeRoomId, inviteeUserId, inviteSessionId);
                InRoomState.this.onSuccessCallback(callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.REQUESTJOINOTHERROOM, rkey, inviteeRoomId, inviteeUserId, inviteSessionId, errorCode.getValue());
                InRoomState.this.onFailedCallback(errorCode, callback);
            }
        });
    }

    private void addTrack(String userId, String tag, RCRTCMediaType mediaType, MediaStreamTrack track) {
        RCRTCBaseRoom tmpRoom;
        if (this.mLocalUser != null && !TextUtils.isEmpty((CharSequence)this.mLocalUser.getUserId())) {
            FinLog.d("BaseRoomElemet", "getRoomByUserId . localUserId :" + this.mLocalUser.getUserId());
        }
        if ((tmpRoom = this.mMultiRoomManager.getBaseRoomElemet().getRoomByUserId(userId)) == null) {
            FinLog.e(TAG, "addTrack.Room is empty.uid :" + userId + " , tag :" + tag + " , mediaType :" + mediaType.getValue());
            return;
        }
        FinLog.e(TAG, "addTrack.roomId : +" + tmpRoom.getRoomId());
        RCRTCRemoteUser remoteUser = tmpRoom.getRemoteUser(userId);
        if (remoteUser == null) {
            return;
        }
        RCRTCInputStream stream = remoteUser.getStream(tag, mediaType);
        if (stream == null) {
            return;
        }
        FinLog.d("subscribedStreams", "addTrack : " + stream.getUri());
        stream.setTrack(track);
        if (mediaType == RCRTCMediaType.VIDEO) {
            if (tmpRoom instanceof RCRTCRoom) {
                ((RCRoomImpl)tmpRoom).getEventsListener().onVideoTrackAdd(userId, tag);
            } else if (tmpRoom instanceof RCRTCOtherRoom) {
                ((RCOtherRoomImpl)tmpRoom).getRCRoomListener().onVideoTrackAdd((RCRTCOtherRoom)tmpRoom, userId, tag);
            }
        }
    }

    private void onReJoinRoomSuccess(List<RTCUser> rtcUsers) {
        this.mRoom.getPingManager().diffUsers(this.mRoom, rtcUsers);
        this.offerReconnect(true);
    }

    private void offerReconnect(final boolean forceSendSignal) {
        this.mActionQueue.offer(new PubSubAction(11, null, null, null){

            @Override
            protected void execute() {
                InRoomState.this.reconnect(forceSendSignal, this.getCallback());
            }
        });
    }

    private void reconnect(boolean forceSendSignal, final IRCRTCResultDataCallback callback) {
        FinLog.d(TAG, "reconnect");
        this.mEngine.mRTCCore.reconnectConnection(forceSendSignal, this.mLocalUser.getStreamsForInternal(), this.getAllSubscribedStreams(), new MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>>(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.e(InRoomState.TAG, "reconnectConnection Failed: " + (Object)((Object)errorCode));
                InRoomState.this.sendMessage(8002, new Object[]{callback, errorCode});
            }

            @Override
            public void onSuccess(Pair<List<MediaResourceInfo>, RCRTCLiveInfo> data) {
                InRoomState.this.reconnectSuccessGetRoomAttributes();
                InRoomState.this.sendMessage(8001, data, callback);
            }
        }));
    }

    private void onStartReconnectSuccess(Pair<List<MediaResourceInfo>, RCRTCLiveInfo> data) {
        this.mLocalUser.updateMediaInfos((List)data.first);
    }

    private void sendModifyResourceSignal(RCOutputStreamImpl stream, boolean isMute) {
        ReportUtil.appTask(ReportUtil.TAG.MODIFYRESOURCE, "media|isOpen", stream.getMediaType().getDescription(), !isMute);
        ArrayList<MediaResourceInfo> modifyResourceList = new ArrayList<MediaResourceInfo>();
        JSONArray jsonArray = new JSONArray();
        for (RCRTCOutputStream rcStream : this.mLocalUser.getStreamsForInternal()) {
            if (TextUtils.isEmpty((CharSequence)rcStream.getUri())) continue;
            MediaResourceInfo mediaResourceInfo = new MediaResourceInfo(rcStream);
            if (stream == rcStream) {
                modifyResourceList.add(mediaResourceInfo);
            }
            jsonArray.put((Object)mediaResourceInfo.getJsonObject());
        }
        if (modifyResourceList.isEmpty()) {
            FinLog.e(TAG, "sendModifyResourceSignal: modifyResourceList is Null");
            return;
        }
        String publish = jsonArray.toString();
        FinLog.i(TAG, "setRTCUserData publish " + publish);
        RTCStatusDate[] kv = new RTCStatusDate[]{ResourceTools.getStatusDate("uris", publish)};
        RTCStatusDate[] content = new RTCStatusDate[]{ResourceTools.getStatusDate("RCRTC:ModifyResource", ResourceTools.getURIS(modifyResourceList, true, ""))};
        SignalManager.getInstance().rtcSetUserResource(this.mRoom.getRoomId(), kv, "RCRTC:TotalContentResources", content, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.MODIFYRESOURCE, "code|desc", errorCode.getValue(), errorCode.getReason());
            }

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.MODIFYRESOURCE, "code", 0);
            }
        });
    }

    public void releaseRoom(IRCRTCResultCallback callBack) {
        this.releaseRoom(callBack, true);
    }

    public void releaseRoom(final IRCRTCResultCallback callBack, boolean isLeaveRoom) {
        List<String> otherRoomIds = this.getMultiRoomManager().getBaseRoomElemet().leaveAllOtherRoom();
        if (otherRoomIds != null && otherRoomIds.size() > 0) {
            for (final String otherRoomId : otherRoomIds) {
                this.getMultiRoomManager().getBaseRoomElemet().otherRoomRelease(otherRoomId);
                SignalManager.getInstance().sendleaveOtherRoomMessage(otherRoomId, new IRCRTCResultCallback(){

                    @Override
                    public void onSuccess() {
                        FinLog.d(InRoomState.TAG, "releaseRoom->leaveOtherRoom Success :" + otherRoomId);
                    }

                    @Override
                    public void onFailed(RTCErrorCode errorCode) {
                        FinLog.d(InRoomState.TAG, "releaseRoom->leaveOtherRoom Failed :" + otherRoomId + " errorCode :" + errorCode.getValue());
                    }
                });
            }
        }
        ReportUtil.libTask(ReportUtil.TAG.RELEASEROOM, "roomId", this.getRoomId());
        this.mActionQueue.clear();
        RongRtcStatMagr.instance.release();
        RongRTCUtils.customRate = false;
        this.mEngine.version2UserIDs.clear();
        this.mEngine.resetPreSpeakerphoneState();
        RongRTCUtils.customFPS = false;
        this.mEngine.mDefaultAudioStream.resetStream();
        this.mEngine.mDefaultVideoStream.resetStream();
        if (Build.VERSION.SDK_INT >= 21) {
            this.mEngine.screenShareOutputStream.resetStream();
        }
        this.mLocalUser.release();
        this.mRoom.release();
        final String roomId = this.mRoom.getRoomId();
        if (isLeaveRoom) {
            SignalManager.getInstance().leaveRoom(roomId, this.mRoom.getRoomType(), this.mRoom.getClientSessionId(), new IRCRTCResultCallback(){

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    ReportUtil.libErrorW(ReportUtil.TAG.RELEASEROOM, errorCode, "roomId", roomId);
                    InRoomState.this.onFailedCallback(errorCode, callBack);
                }

                @Override
                public void onSuccess() {
                    ReportUtil.libRes(ReportUtil.TAG.RELEASEROOM, roomId);
                    InRoomState.this.onSuccessCallback(callBack);
                }
            });
        }
        this.mLocalUser = null;
        this.mRoom = null;
        this.mEngine.mRoom = null;
        FinLog.i(TAG, "releaseAll end");
        this.mMultiRoomManager.release();
        this.mLiveInfo = null;
        this.transitionTo(this.mEngine.mDisConnectingState);
    }

    public void switchToAudienceSuccess() {
        this.mActionQueue.clear();
        RongRTCUtils.customRate = false;
        this.mEngine.version2UserIDs.clear();
        RongRTCUtils.customFPS = false;
        RongRtcStatMagr.instance.release();
        RongRtcStatMagr.instance.start(this.mRoom.getRoomId(), RCRTCLiveRole.AUDIENCE);
        this.mEngine.mDefaultAudioStream.switchToAudienceResetStream();
        this.mEngine.mDefaultVideoStream.switchToAudienceResetStream();
        if (Build.VERSION.SDK_INT >= 21) {
            this.mEngine.screenShareOutputStream.resetStream();
        }
        this.mLocalUser.release();
        this.mRoom.switchToAudienceRelease();
        this.mMultiRoomManager.release();
        this.mLiveInfo = null;
        this.mEngine.transitionTo(this.mEngine.mIdleState);
    }

    private void onPubSubFailed(Message msg, MsgObjectWraper obj) {
        Object[] data;
        RTCErrorCode errorCode = null;
        IRCRTCFailedCallback callback = null;
        for (Object v : data = (Object[])obj.getData()) {
            if (v instanceof RTCErrorCode) {
                errorCode = (RTCErrorCode)((Object)v);
                continue;
            }
            if (!(v instanceof IRCRTCFailedCallback)) continue;
            callback = (IRCRTCFailedCallback)v;
        }
        if (callback != null && errorCode != null) {
            callback.onFailed(errorCode);
        } else {
            FinLog.e(TAG, "onPubSubFailed: msg.what=" + msg.what + " , callback=" + (null == callback ? "null" : callback.toString()) + " , errorCode=" + (null == errorCode ? "null" : Integer.valueOf(errorCode.getValue())));
        }
    }

    public void unpublishedStreams(final List<RCRTCOutputStream> unpublishedStreams, final IRCRTCResultDataCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.UNPUBLISHAVSTREAM, "roomId", this.getRoomId());
        for (RCRTCOutputStream unpublishedStream : unpublishedStreams) {
            if (unpublishedStream != this.mEngine.getDefaultVideoStream() || this.mEngine.mDefaultVideoStream.getTinyVideoOutStream() == null) continue;
            unpublishedStreams.add(this.mEngine.mDefaultVideoStream.getTinyVideoOutStream());
            break;
        }
        List<RCRTCOutputStream> publishedStreams = this.mLocalUser.getStreamsForInternal();
        publishedStreams.removeAll(unpublishedStreams);
        this.mEngine.mRTCCore.unpublishedStreams(publishedStreams, this.getAllSubscribedStreams(), unpublishedStreams, new MediaCommonParams<List<MediaResourceInfo>>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<List<MediaResourceInfo>>(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.UNPUBLISHAVSTREAM, errorCode, "roomId", InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(3082, new Object[]{errorCode, callBack});
            }

            @Override
            public void onSuccess(List<MediaResourceInfo> data) {
                ReportUtil.libRes(ReportUtil.TAG.UNPUBLISHAVSTREAM, InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(3081, unpublishedStreams, data, callBack);
            }
        }));
    }

    private void onUnpublishedStreamsSuccess(List<RCRTCOutputStream> unpublishedStreams, List<MediaResourceInfo> mediaResourceInfos, IRCRTCResultDataCallback callBack) {
        for (RCRTCOutputStream stream : unpublishedStreams) {
            ((RCOutputStreamImpl)stream).stop();
            if (stream != this.mEngine.getDefaultAudioStream() && stream != this.mEngine.getDefaultVideoStream()) {
                ((RCStreamImpl)((Object)stream)).release();
                if (stream instanceof RCTinyVideoOutStream) {
                    this.mEngine.mDefaultVideoStream.setTinyVideoOutStream(null);
                }
            } else {
                ((RCOutputStreamImpl)stream).setUri(null);
            }
            this.mLocalUser.removePublishedStream(stream);
        }
        this.mLocalUser.updateMediaInfos(mediaResourceInfos);
        callBack.onSuccess(null);
    }

    public void publishStreams(final List streams, final IRCRTCResultDataCallback callBack) {
        RCTinyVideoOutStream tinyVideoOutStream;
        ReportUtil.libTask(ReportUtil.TAG.PUBLISHAVSTREAM, "roomId", this.getRoomId());
        List<RCRTCOutputStream> pubList = this.mLocalUser.getStreamsForInternal();
        if (this.mEngine.mEnableTinyStream && streams.contains(this.mEngine.getDefaultVideoStream()) && (tinyVideoOutStream = this.mEngine.mDefaultVideoStream.getTinyVideoOutStream()) == null) {
            tinyVideoOutStream = new RCTinyVideoOutStream(this.mEngine.mUserId);
            this.mEngine.mDefaultVideoStream.setTinyVideoOutStream(tinyVideoOutStream);
            streams.add(tinyVideoOutStream);
        }
        pubList.addAll(streams);
        this.mEngine.mRTCCore.publishStream(pubList, streams, this.getAllSubscribedStreams(), new MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>>(){

            @Override
            public void onSuccess(Pair<List<MediaResourceInfo>, RCRTCLiveInfo> data) {
                ReportUtil.libRes(ReportUtil.TAG.PUBLISHAVSTREAM, InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(3001, streams, data.first, data.second, callBack);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libErrorW(ReportUtil.TAG.PUBLISHAVSTREAM, errorCode, "roomId", InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(3002, new Object[]{errorCode, streams, callBack});
            }
        }));
    }

    private void onPublishStreamsSuccess(List<RCRTCOutputStream> streams, List<MediaResourceInfo> mediaResourceInfos, RCRTCLiveInfo liveInfo, IRCRTCResultDataCallback callback) {
        this.mLocalUser.addPublishedStream(streams);
        int bitrate = 32;
        this.mLiveInfo = liveInfo;
        if (this.mLiveInfo != null && this.mEngine.getDefaultAudioStream() != null && (bitrate = this.mEngine.getDefaultAudioStream().getAudioQuality().getBitrate()) != RCRTCParamsType.AudioQuality.SPEECH.getBitrate()) {
            this.setAudioQualityMixConfig(bitrate);
        }
        block0: for (RCRTCOutputStream outputStream : this.mLocalUser.getStreamsForInternal()) {
            for (MediaResourceInfo info : mediaResourceInfos) {
                if (info.getType() != outputStream.getMediaType() || !info.getTag().equals(outputStream.getTag())) continue;
                ((RCOutputStreamImpl)outputStream).updateMediaInfo(info);
                if (!streams.contains(outputStream)) continue block0;
                ((RCOutputStreamImpl)outputStream).start();
                continue block0;
            }
        }
        callback.onSuccess(liveInfo);
    }

    public void subscribeStreams(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.ENGINESUBSCRIBESTREAMS, "roomId|streams", this.mRoom.getRoomId(), ReportUtil.resourceToString(streams));
        ArrayList<RCRTCInputStream> allInputStreams = new ArrayList<RCRTCInputStream>();
        for (RCRTCRemoteUser remoteUser : this.mRoom.getRemoteUsers()) {
            allInputStreams.addAll(remoteUser.getStreams());
        }
        allInputStreams.addAll(this.getMultiRoomManager().getBaseRoomElemet().getOtherRoomInputStreams());
        if (RongRTCUtils.resourceNotExist(allInputStreams, streams)) {
            ReportUtil.libErrorW(ReportUtil.TAG.ENGINESUBSCRIBESTREAMS, RTCErrorCode.RongRTCCodeSubscribeNotExistResources, "roomId", this.mRoom.getRoomId());
            callBack.onFailed(RTCErrorCode.RongRTCCodeSubscribeNotExistResources);
            return;
        }
        List<IStreamResource> subscribedStreams = this.getAllSubscribedStreams();
        for (RCRTCInputStream rCRTCInputStream : streams) {
            Iterator<IStreamResource> iterator = subscribedStreams.iterator();
            while (iterator.hasNext()) {
                IStreamResource streamResource = iterator.next();
                RCRTCMediaType mediaType = rCRTCInputStream.getMediaType();
                if (!TextUtils.equals((CharSequence)streamResource.getStreamId(), (CharSequence)rCRTCInputStream.getStreamId()) || mediaType != streamResource.getMediaType()) continue;
                FinLog.d(TAG, "subscribedStreams.Delete duplicate.Uri : " + streamResource.getUri() + " , new :" + rCRTCInputStream.getUri());
                iterator.remove();
            }
            if (rCRTCInputStream.getType() == RCRTCStream.RCRTCType.LIVE) continue;
            subscribedStreams.add(rCRTCInputStream);
        }
        this.onSubScribeStreams(subscribedStreams, callBack, ReportUtil.TAG.ENGINESUBSCRIBESTREAMS);
    }

    public void resubscribeStreams(IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.RESUBSCRIBESTREAMS, "roomId", this.getRoomId());
        this.onSubScribeStreams(this.getAllSubscribedStreams(), callback, ReportUtil.TAG.RESUBSCRIBESTREAMS);
    }

    private void onSubScribeStreams(final List<? extends IStreamResource> allSubStreams, final IRCRTCResultDataCallback callback, final ReportUtil.TAG tag) {
        this.mEngine.mRTCCore.subscribeStreams(this.mLocalUser.getStreamsForInternal(), allSubStreams, new MediaCommonParams(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                if (tag != null) {
                    ReportUtil.libErrorW(tag, errorCode, "roomId", InRoomState.this.getRoomId());
                }
                InRoomState.this.sendMessage(4002, new Object[]{errorCode, callback});
            }

            @Override
            public void onSuccess() {
                if (tag != null) {
                    ReportUtil.libRes(tag, InRoomState.this.getRoomId());
                }
                InRoomState.this.sendMessage(4001, allSubStreams, callback);
            }
        }));
    }

    private void onSubscribeStreamSuccess(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callback) {
        for (RCRTCInputStream rCRTCInputStream : streams) {
            ((RCInputStreamImpl)rCRTCInputStream).setSubscribeState(RCRTCSubscribeState.SUBSCRIBED);
        }
        callback.onSuccess(null);
    }

    public void unsubscribeStreams(final List<? extends RCRTCInputStream> streams, boolean needExchangeSDP, String otherRoomIgnored, final IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, "roomId|streams|notifyFinished", this.getRoomId(), ReportUtil.resourceToString(streams), needExchangeSDP);
        ArrayList<RCRTCInputStream> allInputStreams = new ArrayList<RCRTCInputStream>();
        for (RCRTCRemoteUser remoteUser : this.mRoom.getRemoteUsers()) {
            allInputStreams.addAll(remoteUser.getStreams());
        }
        List<IStreamResource> subscribedStreams = this.getAllSubscribedStreams();
        subscribedStreams.removeAll(streams);
        this.mEngine.mRTCCore.unsubscribeStreams(this.mLocalUser.getStreamsForInternal(), subscribedStreams, streams, needExchangeSDP, new MediaCommonParams(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(otherRoomIgnored), this.mLocalUser.getRole(), new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libErrorW(ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, errorCode, InRoomState.this.getRoomId(), new Object[0]);
                InRoomState.this.sendMessage(4042, new Object[]{errorCode, callback});
            }

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(4041, streams, callback);
            }
        }));
    }

    private String getRoomId() {
        return this.mEngine.getRoomId();
    }

    private void onUnsubscribeResourcesSuccess(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callback) {
        for (RCRTCInputStream rCRTCInputStream : streams) {
            if (rCRTCInputStream == null) continue;
            ((RCInputStreamImpl)rCRTCInputStream).setSubscribeState(RCRTCSubscribeState.INIT);
        }
        callback.onSuccess(null);
    }

    public void switchStream(final boolean tiny, final List<RCRTCInputStream> streams, final IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "roomId|isTiny", this.getRoomId(), tiny);
        for (RCRTCStream rCRTCStream : streams) {
            ((RCVideoInputStreamImpl)rCRTCStream).setStreamType(tiny ? RCRTCStreamType.TINY : RCRTCStreamType.NORMAL);
        }
        List<IStreamResource> subStreams = this.getAllSubscribedStreams();
        for (RCRTCInputStream stream : streams) {
            if (subStreams.contains(stream)) continue;
            subStreams.add(stream);
        }
        this.mEngine.mRTCCore.subscribeStreams(this.mLocalUser.getStreamsForInternal(), subStreams, new MediaCommonParams(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "code", 0);
                InRoomState.this.sendMessage(3091, streams, callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "code|desc", errorCode.getValue(), errorCode.getReason());
                InRoomState.this.sendMessage(3092, new Object[]{tiny, streams, errorCode, callback});
            }
        }));
    }

    private void onSwitchStreamFailed(boolean tiny, List<RCRTCStream> streams) {
        for (RCRTCStream stream : streams) {
            ((RCVideoInputStreamImpl)stream).setStreamType(!tiny ? RCRTCStreamType.TINY : RCRTCStreamType.NORMAL);
        }
    }

    public void exchangeVideoSize(final IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.EXCHANGEVIDEOSIZE, "roomId", this.getRoomId());
        this.mEngine.mRTCCore.exchangeVideoSize(this.getAllPubStreams(), this.getAllSubscribedStreams(), new MediaCommonParams(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.EXCHANGEVIDEOSIZE, "code", 0);
                InRoomState.this.sendMessage(3051, null, callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.EXCHANGEVIDEOSIZE, "code|desc", errorCode.getValue(), errorCode.getReason());
                InRoomState.this.sendMessage(3051, new Object[]{errorCode, callback});
            }
        }));
    }

    private List<IStreamResource> getAllPubStreams() {
        ArrayList<IStreamResource> pubList = new ArrayList<IStreamResource>();
        pubList.addAll(this.mLocalUser.getStreamsForInternal());
        return pubList;
    }

    private List<IStreamResource> getAllSubscribedStreams() {
        List<IStreamResource> subList = this.mRoom.getAllSubscribedStreams();
        subList.addAll(this.getMultiRoomManager().getBaseRoomElemet().getOtherRoomSubscribedStreams());
        return subList;
    }

    public void joinOtherExchangeRemoteSDP(final IRCRTCResultDataCallback callback) {
        FinLog.d(TAG, "joinOtherExchangeRemoteSDP->start");
        if (!this.mActionQueue.hasPubAction()) {
            this.mEngine.mRTCCore.exchangeRemoteSDP(false, this.mLocalUser.getStreamsForInternal(), this.getAllSubscribedStreams(), new MediaCommonParams<ExchangeSDPDataResult>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<ExchangeSDPDataResult>(){

                @Override
                public void onSuccess(ExchangeSDPDataResult data) {
                    FinLog.d(InRoomState.TAG, "joinOtherExchangeRemoteSDP->onSuccess");
                    InRoomState.this.sendMessage(2076, (Object)callback);
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    FinLog.e(InRoomState.TAG, "joinOtherExchangeRemoteSDP->onFailed :" + errorCode.getValue());
                    InRoomState.this.sendMessage(2077, new Object[]{callback, errorCode});
                }
            }));
        } else {
            FinLog.e(TAG, "joinOtherExchangeRemoteSDP->onFailed hasPubAction :" + this.mActionQueue.hasPubAction());
            this.sendMessage(2077, new Object[]{callback, RTCErrorCode.RongRTCCodeParameterError});
        }
    }

    public void userLeft() {
        this.mEngine.mRTCCore.exchangeRemoteSDP(false, this.mLocalUser.getStreamsForInternal(), this.getAllSubscribedStreams(), new MediaCommonParams<ExchangeSDPDataResult>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<ExchangeSDPDataResult>(){

            @Override
            public void onSuccess(ExchangeSDPDataResult data) {
                FinLog.i(InRoomState.TAG, "exchangeRemoteSDP.onSuccess");
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.i(InRoomState.TAG, "exchangeRemoteSDP.onFailed :" + errorCode.getValue());
            }
        }));
    }

    public void reExchangeSDP(final IRCRTCResultDataCallback callback) {
        this.mEngine.mRTCCore.exchangeRemoteSDP(false, this.mLocalUser.getStreamsForInternal(), this.getAllSubscribedStreams(), new MediaCommonParams<ExchangeSDPDataResult>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<ExchangeSDPDataResult>(){

            @Override
            public void onSuccess(ExchangeSDPDataResult data) {
                FinLog.i(InRoomState.TAG, "reExchangeSDP.onSuccess");
                InRoomState.this.sendMessage(2063, (Object)callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.i(InRoomState.TAG, "reExchangeSDP.onFailed :" + errorCode.getValue());
                InRoomState.this.sendMessage(2064, (Object)callback);
            }
        }));
    }

    public PubSubActionQueue getPubSubQueue() {
        return this.mActionQueue;
    }

    @Override
    public String getName() {
        return TAG;
    }

    private void joinOtherRoom(final String roomId, final IRCRTCResultDataCallback<RCRTCOtherRoom> callBack) {
        JSONObject jsonObject = new JSONObject();
        String value = "";
        try {
            jsonObject.putOpt("roomId", (Object)this.mRoom.getRoomId());
            value = jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        RCRTCRoomConfig roomConfig = this.mRoom.getRoomConfig();
        SignalManager.getInstance().joinOtherRoom(roomId, this.mRoom.getRoomType(), roomConfig == null ? null : roomConfig.getJoinType(), "extra", value, new IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>>(){

            public void onSuccess(List<RTCUser> rtcUsers, Map<String, Object> exarams) {
                InRoomState.this.sendMessage(2071, new Object[]{roomId, InRoomState.this.mRoom.getRoomType(), rtcUsers, exarams, callBack});
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|code", roomId, errorCode.getValue());
                RTCErrorCode code = RTCErrorCode.valueOf(errorCode.getValue());
                InRoomState.this.onFailedCallback(code, callBack);
            }
        });
    }

    public void kickFromOtherRooms(String roomId) {
        RCRTCOtherRoom otherRoom = (RCRTCOtherRoom)this.mMultiRoomManager.getBaseRoomElemet().get(roomId);
        ArrayList<RCRTCInputStream> subscribedStreams = new ArrayList<RCRTCInputStream>();
        if (otherRoom != null) {
            if (otherRoom.getRemoteUsers() != null && otherRoom.getRemoteUsers().size() > 0) {
                for (RCRTCRemoteUser remoteUser : otherRoom.getRemoteUsers()) {
                    if (remoteUser.getStreams() == null || remoteUser.getStreams().size() <= 0) continue;
                    for (RCRTCInputStream stream : remoteUser.getStreams()) {
                        RCInputStreamImpl inputStream = (RCInputStreamImpl)stream;
                        if (inputStream.getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) continue;
                        subscribedStreams.add(stream);
                    }
                }
            }
        } else {
            ReportUtil.libStatus(ReportUtil.TAG.KICKEDFROMSERVER, "otherRoomId|desc", roomId, "RCRTCOtherRoom is empty.");
        }
        final int subscribedStreamSize = subscribedStreams.size();
        ReportUtil.libStatus(ReportUtil.TAG.KICKEDFROMSERVER, "otherRoomId|SubscribedStreamSize", roomId, subscribedStreamSize);
        this.unsubscribeStreams(subscribedStreams, true, roomId, new IRCRTCResultDataCallback(){

            public void onSuccess(Object data) {
                FinLog.d(InRoomState.TAG, "kickFromOtherRooms->unsubscribeStreams->onSuccess.SubscribedStreamSize:" + subscribedStreamSize);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.d(InRoomState.TAG, "kickFromOtherRooms->unsubscribeStreams->onFailed :" + errorCode.getValue() + " , SubscribedStreamSize:" + subscribedStreamSize);
            }
        });
    }

    private void leaveOtherRoom(final String roomId, final boolean notifyFinished, final IRCRTCResultCallback callBack) {
        RCRTCOtherRoom otherRoom;
        if (notifyFinished) {
            this.mRoom.removeOtherRoomId(roomId);
        }
        if ((otherRoom = (RCRTCOtherRoom)this.mMultiRoomManager.getBaseRoomElemet().remove(roomId)) == null) {
            ReportUtil.appError(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|notifyFinished|code", roomId, notifyFinished, RTCErrorCode.RongRTCCodeParameterError.getValue());
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        ArrayList<RCRTCInputStream> subscribedStreams = new ArrayList<RCRTCInputStream>();
        if (otherRoom.getRemoteUsers() != null && otherRoom.getRemoteUsers().size() > 0) {
            for (RCRTCRemoteUser remoteUser : otherRoom.getRemoteUsers()) {
                if (remoteUser.getStreams() == null || remoteUser.getStreams().size() <= 0) continue;
                for (RCRTCInputStream stream : remoteUser.getStreams()) {
                    RCInputStreamImpl inputStream = (RCInputStreamImpl)stream;
                    if (inputStream.getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) continue;
                    subscribedStreams.add(stream);
                }
            }
        }
        if (subscribedStreams.size() > 0) {
            this.mActionQueue.offer(9, subscribedStreams, new IRCRTCResultCallback(){

                @Override
                public void onSuccess() {
                    FinLog.d(InRoomState.TAG, "leaveOtherRoom->unSubscribe . onSuccess . roomId :" + roomId + " , notifyFinished :" + notifyFinished);
                    InRoomState.this.sendMessage(2079, (RCOtherRoomImpl)otherRoom, notifyFinished, callBack);
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    FinLog.d(InRoomState.TAG, "leaveOtherRoom->unSubscribe . onFailed . roomId :" + roomId + " , errorCode :" + errorCode.getValue() + " , notifyFinished :" + notifyFinished);
                    InRoomState.this.sendMessage(2079, (RCOtherRoomImpl)otherRoom, notifyFinished, callBack);
                }
            }, true, true);
        } else {
            FinLog.d(TAG, "leaveOtherRoom");
            this.mEngine.mRTCCore.exchangeRemoteSDP(false, this.mLocalUser.getStreamsForInternal(), this.getAllSubscribedStreams(), new MediaCommonParams<ExchangeSDPDataResult>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<ExchangeSDPDataResult>(){

                @Override
                public void onSuccess(ExchangeSDPDataResult data) {
                    FinLog.d(InRoomState.TAG, "leaveOtherRoom->exchangeRemoteSDP->onSuccess");
                    InRoomState.this.sendMessage(2079, (RCOtherRoomImpl)otherRoom, notifyFinished, callBack);
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    FinLog.e(InRoomState.TAG, "leaveOtherRoom->exchangeRemoteSDP->onFailed :" + errorCode.getValue());
                    InRoomState.this.sendMessage(2079, (RCOtherRoomImpl)otherRoom, notifyFinished, callBack);
                }
            }));
        }
    }

    private void onJoinOtherRoomSuccess(String roomId, RCRTCRoomType roomType, List<RTCUser> userList, Map<String, Object> exParams, IRCRTCResultDataCallback<RCRTCOtherRoom> callback) {
        RCLocalUserImpl localUser = new RCLocalUserImpl(this.mEngine.mUserId, null);
        this.mRoom.addOtherRoomId(roomId);
        String sessionId = null;
        LinkedHashMap<String, RCRTCRemoteUser> remoteUsers = new LinkedHashMap<String, RCRTCRemoteUser>();
        sessionId = (String)exParams.get("joinRoomSessionId");
        if (exParams.get("joinRoomData") != null) {
            HashMap roomData = (HashMap)exParams.get("joinRoomData");
            if (roomData != null && roomData.size() > 0) {
                PKInfo info = null;
                for (Map.Entry entry : roomData.entrySet()) {
                    info = new PKInfo((String)entry.getKey(), (String)entry.getValue());
                    if (TextUtils.equals((CharSequence)info.getInviteeRoomId(), (CharSequence)this.getRoomId()) || TextUtils.equals((CharSequence)info.getInviterRoomId(), (CharSequence)this.getRoomId())) {
                        this.mMultiRoomManager.getRoomAttributesElement().put(info);
                        continue;
                    }
                    FinLog.w(TAG, "Not part of the PK list. key :" + (String)entry.getKey());
                }
            }
        } else {
            FinLog.w(TAG, "KV not found.");
        }
        if (!RongRTCUtils.isEmpty(userList)) {
            FinLog.d(TAG, "RTCUser size : " + userList.size());
            String extra = null;
            for (RTCUser user : userList) {
                String id = user.getUid();
                FinLog.d(TAG, "uid = " + id);
                if (localUser.getUserId().equals(id)) continue;
                HashMap data = user.getData();
                String uris = null;
                if (data != null) {
                    uris = (String)data.get("uris");
                    extra = (String)data.get("extra");
                    String otherRoomId = RongRTCUtils.getUserProfile(extra);
                    if (!TextUtils.isEmpty((CharSequence)otherRoomId)) continue;
                }
                FinLog.d(TAG, "joinOtherRoom . uris = " + uris + " , extra :" + extra);
                RCRemoteUserImpl remoteUser = RCRemoteUserImpl.parseRemoteUsers(id, uris);
                remoteUsers.put(id, remoteUser);
            }
        }
        FinLog.d(TAG, "JoinOtherRoomSuccess->roomId : " + roomId + " , sessionId :" + sessionId);
        RCOtherRoomImpl otherRoom = new RCOtherRoomImpl(roomId, roomType, remoteUsers, sessionId, this.mEngine.mCallbackHandler);
        this.mMultiRoomManager.getBaseRoomElemet().put(roomId, otherRoom);
        ReportUtil.appRes(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId", roomId);
        this.onSuccessCallback(otherRoom, callback);
        this.mActionQueue.offer(8, null, null);
    }

    private void sendleaveOtherRoomMessage(RCOtherRoomImpl rcOtherRoom, final boolean notifyFinished, final IRCRTCResultCallback callBack) {
        final String roomId = rcOtherRoom.getRoomId();
        rcOtherRoom.release();
        SignalManager.getInstance().sendleaveOtherRoomMessage(roomId, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|notifyFinished", roomId, notifyFinished);
                if (notifyFinished) {
                    InRoomState.this.sendFinishOtherRoomMessage(roomId, callBack);
                } else {
                    InRoomState.this.onSuccessCallback(callBack);
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|notifyFinished|code", roomId, notifyFinished, errorCode.getValue());
                if (notifyFinished) {
                    InRoomState.this.sendFinishOtherRoomMessage(roomId, callBack);
                } else {
                    InRoomState.this.onFailedCallback(errorCode, callBack);
                }
            }
        });
    }

    private void enableInnerCDN(String serverUrl, String roomId, String sessionId, String configJson, final boolean enableInnerCDN, final IRCRTCResultCallback callBack) {
        SignalManager.getInstance().enableInnerCDN(serverUrl, roomId, sessionId, configJson, new IRCRTCResultDataCallback<String>(){

            @Override
            public void onSuccess(String pullUrl) {
                InRoomState.this.sendMessage(5051, pullUrl, enableInnerCDN, callBack);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                InRoomState.this.sendMessage(5036, new Object[]{errorCode, callBack});
            }
        });
    }

    private void enableInnerCDNSuccess(String pullUrl, boolean enableInnerCDN, IRCRTCResultCallback callBack) {
        CDNResourceInfo cdnResourceInfo = new CDNResourceInfo(pullUrl);
        int broadcast = cdnResourceInfo.getBroadcast();
        if (broadcast == 0) {
            this.CDNServerBroadcast(this.mRoom.getRoomId(), pullUrl, enableInnerCDN, callBack);
        } else {
            cdnResourceInfo.setEnableInnerCDN(enableInnerCDN);
            this.mRoom.setCDNResourceInfo(cdnResourceInfo);
            ReportUtil.libRes(ReportUtil.TAG.ENABLE_INNER_CDN, "roomId|url|broadcast", this.mRoom.getRoomId(), pullUrl, broadcast);
            this.onSuccessCallback(callBack);
        }
    }

    private void CDNServerBroadcast(String roomId, String pullUrl, boolean enableInnerCDN, final IRCRTCResultCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.BROADCAST_CDN_SERVER, "roomId|pullUrl|enableInnerCDN", this.getRoomId(), pullUrl, enableInnerCDN);
        RTCStatusDate[] kv = new RTCStatusDate[1];
        String key = "cdn_uris";
        String value = "";
        String tmpPullUrl = pullUrl;
        try {
            JSONObject tmpObj = new JSONObject(pullUrl);
            tmpObj.putOpt("enableInnerCDN", (Object)enableInnerCDN);
            tmpPullUrl = tmpObj.toString();
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)tmpObj);
            value = jsonArray.toString();
        }
        catch (JSONException e) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "CDNServerBroadcast", "JSONException : " + (Object)((Object)e));
        }
        kv[0] = ResourceTools.getStatusDate("cdn_uris", value);
        final String finalTmpPullUrl = tmpPullUrl;
        SignalManager.getInstance().diffusionKV(this.mRoom.getRoomId(), kv, "RCRTC:TotalContentResources", new RTCStatusDate[0], new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.BROADCAST_CDN_SERVER, "roomId", InRoomState.this.mRoom.getRoomId());
                InRoomState.this.sendMessage(5038, finalTmpPullUrl, callBack);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.BROADCAST_CDN_SERVER, "roomId|code", new Object[]{InRoomState.this.getRoomId(), errorCode});
                InRoomState.this.sendMessage(5037, new Object[]{callBack, errorCode});
            }
        });
        SignalManager.getInstance().rtcPutInnerData(roomId, RCAttributeType.ROOM, "cdn_uris", value, null, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.BROADCAST_CDN_SERVER, "code|desc", errorCode.getValue(), "Failed to set room properties (cdn_uris)");
            }
        });
    }

    private void reconnectSuccessGetRoomAttributes() {
        ArrayList<String> attributeKeys = new ArrayList<String>();
        attributeKeys.add("cdn_uris");
        SignalManager.getInstance().getAttributes(this.mRoom.getRoomId(), RCAttributeType.ROOM, attributeKeys, APIType.INNER_DATA, new IRCRTCResultDataCallback<Map<String, String>>(){

            @Override
            public void onSuccess(Map<String, String> data) {
                if (data.size() > 0) {
                    String json_cdnUris = data.get("cdn_uris");
                    try {
                        JSONArray jsonArray = new JSONArray(json_cdnUris);
                        JSONObject object = jsonArray.optJSONObject(0);
                        boolean enableInnerCDN = false;
                        if (object != null && object.has("enableInnerCDN")) {
                            enableInnerCDN = object.optBoolean("enableInnerCDN");
                        }
                        if (enableInnerCDN) {
                            InRoomState.this.CDNServerBroadcast(InRoomState.this.mRoom.getRoomId(), object.toString(), true, null);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
            }
        });
    }

    private void switchToBroadcasterPublish(Pair pair) {
        RCTinyVideoOutStream tinyVideoOutStream;
        boolean isLiveAudio;
        ReportUtil.libStatus(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "desc|roomId|roomType|", "switchToBroadcasterPublish", this.mRoom.getRoomId(), this.mRoom.getRoomType().getRoomType());
        if (pair == null) {
            ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "pair is empty");
            RTCEngineImpl.getInstance().engineError(RTCErrorCode.RongRTCCodeParameterError);
            this.releaseRoom(null);
            return;
        }
        List publishLiveStreams = (List)pair.first;
        final IRCRTCSwitchRoleDataCallback callback = (IRCRTCSwitchRoleDataCallback)pair.second;
        if (publishLiveStreams == null || publishLiveStreams.size() == 0) {
            this.onSuccessCallback(null, callback);
            return;
        }
        ArrayList<RCRTCOutputStream> ret = new ArrayList<RCRTCOutputStream>();
        boolean bl = isLiveAudio = this.mRoom.getRoomType() == RCRTCRoomType.LIVE_AUDIO;
        if (isLiveAudio) {
            for (RCRTCOutputStream stream : publishLiveStreams) {
                if (stream == null || stream.getMediaType() != RCRTCMediaType.AUDIO) continue;
                ret.add(stream);
            }
        } else if (this.mRoom.getRoomType() == RCRTCRoomType.LIVE_AUDIO_VIDEO && this.mEngine.mEnableTinyStream && publishLiveStreams.contains(this.mEngine.getDefaultVideoStream()) && (tinyVideoOutStream = this.mEngine.mDefaultVideoStream.getTinyVideoOutStream()) == null) {
            tinyVideoOutStream = new RCTinyVideoOutStream(this.mEngine.mUserId);
            this.mEngine.mDefaultVideoStream.setTinyVideoOutStream(tinyVideoOutStream);
            publishLiveStreams.add(tinyVideoOutStream);
        }
        this.mActionQueue.offer(1, isLiveAudio ? ret : publishLiveStreams, new IRCRTCResultDataCallback<RCRTCLiveInfo>(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SWITCH_TO_BROADCASTER, "code|desc", errorCode.getValue(), "publishStream failed");
                InRoomState.this.sendMessage(5069, (Object)callback);
            }

            @Override
            public void onSuccess(RCRTCLiveInfo data) {
                InRoomState.this.sendMessage(5068, data, callback);
            }
        });
    }

    private void sendModifyResourceToMediaServer(boolean isMute) {
        ReportUtil.appTask(ReportUtil.TAG.MCU_CLIENT_ACTION, "roomId|isMute", this.getRoomId(), isMute);
        if (this.mLiveInfo == null) {
            ReportUtil.appError(ReportUtil.TAG.MCU_CLIENT_ACTION, "desc", "RCRTCLiveInfo is empty");
            return;
        }
        String streamId = "";
        if (this.mRoom.getLocalUser() == null || this.mRoom.getLocalUser().getDefaultVideoStream() == null || TextUtils.isEmpty((CharSequence)(streamId = this.mRoom.getLocalUser().getDefaultVideoStream().getStreamId()))) {
            ReportUtil.appError(ReportUtil.TAG.MCU_CLIENT_ACTION, "desc", "DefaultVideoStream is empty");
            return;
        }
        String sessionId = this.mRoom.getSessionId();
        String configJson = "";
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.putOpt("sessionId", (Object)sessionId);
            jsonObject.putOpt("version", (Object)2);
            JSONArray jsonArray = new JSONArray();
            JSONObject object = new JSONObject();
            object.putOpt("streamId", (Object)streamId);
            object.putOpt("camera", (Object)(isMute ? "off" : "on"));
            jsonArray.put((Object)object);
            jsonObject.putOpt("actions", (Object)jsonArray);
            configJson = jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            ReportUtil.appError(ReportUtil.TAG.MCU_CLIENT_ACTION, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), e.getMessage());
            return;
        }
        SignalManager.getInstance().sendModifyResource(this.mRoom.getRoomId(), sessionId, configJson, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.MCU_CLIENT_ACTION, "code", 0);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
            }
        });
    }

    private void getRTCUserData(final RCRTCOtherRoom otherRoom, final RCRTCRemoteUser remoteUser) {
        SignalManager.getInstance().getRTCUserData(otherRoom.getRoomId(), new IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Object[]>(){

            public void onSuccess(List<RTCUser> rtcUsers, Object[] exarams) {
                String uris = null;
                for (RTCUser user : rtcUsers) {
                    HashMap data;
                    if (!TextUtils.equals((CharSequence)user.getUid(), (CharSequence)remoteUser.getUserId()) || (data = user.getData()) == null) continue;
                    uris = (String)data.get("uris");
                    break;
                }
                InRoomState.this.sendMessage(5078, otherRoom, remoteUser, uris);
            }

            public void onError(IRongCoreEnum.CoreErrorCode coreErrorCode) {
                InRoomState.this.sendMessage(5078, otherRoom, remoteUser, null);
            }
        });
    }

    private void getRTCUserData(String roomId) {
        SignalManager.getInstance().getRTCUserData(roomId, new IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Object[]>(){

            public void onSuccess(List<RTCUser> rtcUsers, Object[] exarams) {
                InRoomState.this.sendMessage(8003, (Object)rtcUsers);
            }

            public void onError(IRongCoreEnum.CoreErrorCode coreErrorCode) {
                InRoomState.this.sendMessage(8004, (Object)coreErrorCode);
            }
        });
    }
}

