/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import android.os.Handler;
import android.os.HandlerThread;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.report.StatusReportParser;
import cn.rongcloud.rtc.core.StatsObserver;
import cn.rongcloud.rtc.core.StatsReport;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;

public class BaseStatusReportManager
implements StatsObserver {
    private static final String TAG = "BaseStatusReportManager";
    protected StatusReportParser mStatusParser;
    protected RTCConnectionHolder mConnection;
    protected IRCRTCStatusReportListener mListener = null;
    protected Handler mHandler;
    private long mIntervalTime;

    public BaseStatusReportManager(RTCConnectionHolder connection, long interval) {
        this.mConnection = connection;
        this.mStatusParser = new StatusReportParser();
        this.mIntervalTime = interval < 100L ? 1000L : interval;
        this.start();
    }

    private void start() {
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Handler handler;
                RTCConnectionHolder connection = BaseStatusReportManager.this.mConnection;
                if (connection != null && BaseStatusReportManager.this.mListener != null) {
                    BaseStatusReportManager.this.onGetStatus(connection);
                }
                if ((handler = BaseStatusReportManager.this.mHandler) != null) {
                    handler.postDelayed((Runnable)this, BaseStatusReportManager.this.mIntervalTime);
                }
            }
        }, this.mIntervalTime);
    }

    protected void onGetStatus(RTCConnectionHolder connection) {
        connection.getStatus(this);
    }

    public void stop() {
        if (this.mHandler != null) {
            this.mHandler.getLooper().quit();
        }
        this.mHandler = null;
        this.mConnection = null;
        this.mStatusParser = null;
        this.mListener = null;
    }

    public void setRTCStatusReportListener(IRCRTCStatusReportListener eventsListener) {
        this.mListener = eventsListener;
    }

    @Override
    public void onComplete(final StatsReport[] reports) {
        Handler handler = this.mHandler;
        if (handler == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                StatusReportParser statusParser = BaseStatusReportManager.this.mStatusParser;
                if (statusParser != null) {
                    statusParser.parseAndCallback(reports, BaseStatusReportManager.this.mListener);
                }
            }
        });
    }
}

