/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.model;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FileDownloadHeader
implements Parcelable {
    private HashMap<String, List<String>> mHeaderMap;
    public static final Parcelable.Creator<FileDownloadHeader> CREATOR = new Parcelable.Creator<FileDownloadHeader>(){

        public FileDownloadHeader createFromParcel(Parcel source) {
            return new FileDownloadHeader(source);
        }

        public FileDownloadHeader[] newArray(int size) {
            return new FileDownloadHeader[size];
        }
    };

    public void add(String name, String value) {
        List<String> values;
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (this.mHeaderMap == null) {
            this.mHeaderMap = new HashMap();
        }
        if ((values = this.mHeaderMap.get(name)) == null) {
            values = new ArrayList<String>();
            this.mHeaderMap.put(name, values);
        }
        if (!values.contains(value)) {
            values.add(value);
        }
    }

    public void add(String line) {
        String[] parsed = line.split(":");
        String name = parsed[0].trim();
        String value = parsed[1].trim();
        this.add(name, value);
    }

    public void removeAll(String name) {
        if (this.mHeaderMap == null) {
            return;
        }
        this.mHeaderMap.remove(name);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeMap(this.mHeaderMap);
    }

    public HashMap<String, List<String>> getHeaders() {
        return this.mHeaderMap;
    }

    public FileDownloadHeader() {
    }

    protected FileDownloadHeader(Parcel in) {
        this.mHeaderMap = in.readHashMap(String.class.getClassLoader());
    }

    public String toString() {
        return this.mHeaderMap.toString();
    }
}

