/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.auth;

public class ValidateUtil {
    public static final int MIN_BUCKET_NAME_LENGTH = 3;
    public static final int MAX_BUCKET_NAME_LENGTH = 63;

    public static String validateBucketName(String bname) {
        if (bname == null) {
            return null;
        }
        if (bname.length() < 3 || bname.length() > 63) {
            return null;
        }
        int previous = 0;
        for (int i = 0; i < bname.length(); ++i) {
            char next = bname.charAt(i);
            if (next >= 'A' && next <= 'Z') {
                return null;
            }
            if (next == ' ' || next == '\t' || next == '\r' || next == '\n') {
                return null;
            }
            if (next == '.') {
                if (previous == 46) {
                    return null;
                }
                if (previous == 45) {
                    return null;
                }
            } else if (next == '-' ? previous == 46 : next < '0' || next > '9' && next < 'a' || next > 'z') {
                return null;
            }
            previous = next;
        }
        if (previous == 46 || previous == 45) {
            return null;
        }
        return bname;
    }
}

