/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.notification;

import android.app.NotificationManager;
import com.liulishuo.filedownloader.util.FileDownloadHelper;

public abstract class BaseNotificationItem {
    private int id;
    private int sofar;
    private int total;
    private String title;
    private String desc;
    private int status = 0;
    private int lastStatus = 0;
    private NotificationManager manager;

    public BaseNotificationItem(int id, String title, String desc) {
        this.id = id;
        this.title = title;
        this.desc = desc;
    }

    public void show(boolean isShowProgress) {
        this.show(this.isChanged(), this.getStatus(), isShowProgress);
    }

    public abstract void show(boolean var1, int var2, boolean var3);

    public void update(int sofar, int total) {
        this.sofar = sofar;
        this.total = total;
        this.show(true);
    }

    public void updateStatus(int status) {
        this.status = status;
    }

    public void cancel() {
        this.getManager().cancel(this.id);
    }

    protected NotificationManager getManager() {
        if (this.manager == null) {
            this.manager = (NotificationManager)FileDownloadHelper.getAppContext().getSystemService("notification");
        }
        return this.manager;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSofar() {
        return this.sofar;
    }

    public void setSofar(int sofar) {
        this.sofar = sofar;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getStatus() {
        this.lastStatus = this.status;
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getLastStatus() {
        return this.lastStatus;
    }

    public boolean isChanged() {
        return this.lastStatus != this.status;
    }
}

