/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.uniapp.ui.component;

import android.view.View;
import androidx.annotation.NonNull;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.ui.action.GraphicPosition;
import com.taobao.weex.ui.action.GraphicSize;
import io.dcloud.feature.uniapp.dom.AbsAttr;
import io.dcloud.feature.uniapp.dom.AbsCSSShorthand;
import io.dcloud.feature.uniapp.dom.AbsEvent;
import io.dcloud.feature.uniapp.dom.AbsStyle;
import io.dcloud.feature.uniapp.ui.action.AbsComponentData;
import java.util.Map;
import java.util.Set;

public abstract class AbsBasicComponent<T extends View> {
    private Object mExtra;
    private String mComponentType;
    private String mRef;
    private GraphicPosition mLayoutPosition;
    private GraphicSize mLayoutSize;
    private boolean mIsLayoutRTL;
    private AbsComponentData mBasicComponentData;
    private float mViewPortWidth = 750.0f;

    public AbsBasicComponent(AbsComponentData basicComponentData) {
        this.mBasicComponentData = basicComponentData;
        this.mRef = basicComponentData.mRef;
        this.mComponentType = basicComponentData.mComponentType;
    }

    public AbsComponentData getBasicComponentData() {
        return this.mBasicComponentData;
    }

    protected void bindComponent(AbsBasicComponent component) {
        this.mComponentType = component.getComponentType();
        this.mRef = component.getRef();
    }

    @NonNull
    public AbsStyle getStyles() {
        return this.mBasicComponentData.getStyles();
    }

    @NonNull
    public AbsAttr getAttrs() {
        return this.mBasicComponentData.getAttrs();
    }

    @NonNull
    public AbsEvent getEvents() {
        return this.mBasicComponentData.getEvents();
    }

    @NonNull
    public AbsCSSShorthand getMargin() {
        return this.mBasicComponentData.getMargin();
    }

    @NonNull
    public AbsCSSShorthand getPadding() {
        return this.mBasicComponentData.getPadding();
    }

    @NonNull
    public AbsCSSShorthand getBorder() {
        return this.mBasicComponentData.getBorder();
    }

    public final void setMargins(@NonNull CSSShorthand margins) {
        this.mBasicComponentData.setMargins(margins);
    }

    public final void setPaddings(@NonNull CSSShorthand paddings) {
        this.mBasicComponentData.setPaddings(paddings);
    }

    public final void setBorders(@NonNull CSSShorthand borders) {
        this.mBasicComponentData.setBorders(borders);
    }

    public final void addAttr(Map<String, Object> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        this.mBasicComponentData.addAttr(attrs);
    }

    public final void addStyle(Map<String, Object> styles) {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        this.mBasicComponentData.addStyle(styles);
    }

    public final void addStyle(Map<String, Object> styles, boolean byPesudo) {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        this.mBasicComponentData.addStyle(styles, byPesudo);
    }

    public final void updateStyle(Map<String, Object> styles, boolean byPesudo) {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        this.mBasicComponentData.getStyles().updateStyle(styles, byPesudo);
    }

    public final void addEvent(Set<String> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        this.mBasicComponentData.addEvent(events);
    }

    public final void addShorthand(Map<String, String> shorthand) {
        if (!shorthand.isEmpty() && this.mBasicComponentData != null) {
            this.mBasicComponentData.addShorthand(shorthand);
        }
    }

    public float getViewPortWidthForFloat() {
        return this.mViewPortWidth;
    }

    public int getViewPortWidth() {
        return Math.round(this.mViewPortWidth);
    }

    public void setViewPortWidth(float mViewPortWidth) {
        this.mViewPortWidth = mViewPortWidth;
    }

    public Object getExtra() {
        return this.mExtra;
    }

    public void updateExtra(Object extra) {
        this.mExtra = extra;
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public String getRef() {
        return this.mRef;
    }

    public void setIsLayoutRTL(boolean isRTL) {
        this.mIsLayoutRTL = isRTL;
    }

    public boolean isLayoutRTL() {
        return this.mIsLayoutRTL;
    }

    public GraphicPosition getLayoutPosition() {
        if (this.mLayoutPosition == null) {
            this.mLayoutPosition = new GraphicPosition(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.mLayoutPosition;
    }

    protected void setLayoutPosition(GraphicPosition mLayoutPosition) {
        this.mLayoutPosition = mLayoutPosition;
    }

    public GraphicSize getLayoutSize() {
        if (this.mLayoutSize == null) {
            this.mLayoutSize = new GraphicSize(0.0f, 0.0f);
        }
        return this.mLayoutSize;
    }

    protected void setLayoutSize(GraphicSize mLayoutSize) {
        this.mLayoutSize = mLayoutSize;
    }

    public float getCSSLayoutTop() {
        return this.mLayoutPosition == null ? 0.0f : this.mLayoutPosition.getTop();
    }

    public float getCSSLayoutBottom() {
        return this.mLayoutPosition == null ? 0.0f : this.mLayoutPosition.getBottom();
    }

    public float getCSSLayoutLeft() {
        return this.mLayoutPosition == null ? 0.0f : this.mLayoutPosition.getLeft();
    }

    public float getCSSLayoutRight() {
        return this.mLayoutPosition == null ? 0.0f : this.mLayoutPosition.getRight();
    }

    public float getLayoutWidth() {
        return this.mLayoutSize == null ? 0.0f : this.mLayoutSize.getWidth();
    }

    public float getLayoutHeight() {
        return this.mLayoutSize == null ? 0.0f : this.mLayoutSize.getHeight();
    }
}

