/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.ksyun.ks3.exception.Ks3Error;
import com.ksyun.ks3.model.Part;
import com.ksyun.ks3.model.PartETag;
import com.ksyun.ks3.model.result.CompleteMultipartUploadResult;
import com.ksyun.ks3.model.result.InitiateMultipartUploadResult;
import com.ksyun.ks3.model.result.ListPartsResult;
import com.ksyun.ks3.services.Ks3Client;
import com.ksyun.ks3.services.handler.CompleteMultipartUploadResponseHandler;
import com.ksyun.ks3.services.handler.InitiateMultipartUploadResponceHandler;
import com.ksyun.ks3.services.handler.ListPartsResponseHandler;
import com.ksyun.ks3.services.handler.UploadPartResponceHandler;
import com.ksyun.ks3.services.request.InitiateMultipartUploadRequest;
import com.ksyun.ks3.services.request.UploadPartRequest;
import cz.msebera.android.httpclient.Header;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiUploader {
    private final String TAG = "MultiUploader";
    private String bucketName;
    private String key;
    private File file;
    private int concurrentNo = 2;
    private long partSize = 0x500000L;
    private String uploadId;
    private AtomicInteger cur;
    private Ks3Client client;
    private static final int INIT_DONE = 0;
    private static final int PARTS_DONE = 1;
    private static final int COMPLETE_DONE = 2;
    private static final int GET_UPLOADED_DONE = 3;
    private static final int LIMIT_DONE = 4;
    final List<PartETag> doneParts = Collections.synchronizedList(new ArrayList());
    List<Integer> leftParts = Collections.synchronizedList(new ArrayList());
    private CompleteMultipartUploadResponseHandler multiHandler;
    private final MyHandler mHandler = new MyHandler();

    private void create(Ks3Client client, String bucketName, String key, File file, String uploadId, long partSize) {
        this.client = client;
        this.bucketName = bucketName;
        this.key = key;
        this.file = file;
        this.uploadId = uploadId;
        this.partSize = partSize;
    }

    public MultiUploader(Ks3Client client, String bucketName, String key, File file, String uploadId, long partSize) {
        this.create(client, bucketName, key, file, uploadId, partSize);
    }

    public MultiUploader(Ks3Client client, String bucketName, String key, File file, String uploadId) {
        this.create(client, bucketName, key, file, uploadId, this.partSize);
    }

    public MultiUploader(Ks3Client client, String bucketName, String key, File file) {
        this.create(client, bucketName, key, file, null, this.partSize);
    }

    public MultiUploader(Ks3Client client, String bucketName, String key, File file, long partSize) {
        this.create(client, bucketName, key, file, null, partSize);
    }

    public void setConcurrentNo(int no) {
        this.concurrentNo = no;
    }

    public void setHandler(CompleteMultipartUploadResponseHandler uploadResponseHandler) {
        this.multiHandler = uploadResponseHandler;
    }

    public String getKey() {
        return this.key;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public boolean upload() {
        if (this.uploadId != null) {
            return false;
        }
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucketName, this.key);
        this.client.initiateMultipartUpload(request, new InitiateMultipartUploadResponceHandler(){

            @Override
            public void onFailure(int statesCode, Ks3Error error, Header[] responceHeaders, String response, Throwable paramThrowable) {
                Log.w((String)"MultiUploader", (String)("init multiupload fail, statesCode=" + statesCode), (Throwable)paramThrowable);
            }

            @Override
            public void onSuccess(int statesCode, Header[] responceHeaders, InitiateMultipartUploadResult result) {
                MultiUploader.this.uploadId = result.getUploadId();
                Log.d((String)"MultiUploader", (String)("init multiupload success, uploadId=" + MultiUploader.this.uploadId + ",key=" + MultiUploader.this.key));
                MultiUploader.this.mHandler.sendEmptyMessage(0);
            }
        });
        return true;
    }

    private List<PartETag> convertPart(List<Part> list) {
        ArrayList<PartETag> res = new ArrayList<PartETag>();
        for (Part p : list) {
            res.add(new PartETag(p.getPartNumber(), p.getETag()));
        }
        return res;
    }

    public void getUploadedParts() {
        final ArrayList res = new ArrayList();
        ListPartsResponseHandler listPartsResponseHandler = new ListPartsResponseHandler(){

            @Override
            public void onFailure(int statesCode, Ks3Error error, Header[] responceHeaders, String response, Throwable paramThrowable) {
                Log.w((String)"MultiUploader", (String)("list parts, statesCode=" + statesCode), (Throwable)paramThrowable);
            }

            @Override
            public void onSuccess(int statesCode, Header[] responceHeaders, ListPartsResult listPartsResult) {
                res.addAll(MultiUploader.this.convertPart(listPartsResult.getParts()));
                if (!listPartsResult.isTruncated()) {
                    MultiUploader.this.mHandler.sendMessage(Message.obtain((Handler)MultiUploader.this.mHandler, (int)3, (Object)res));
                } else {
                    Log.e((String)"MultiUploader", (String)"File size too largs. You may not use phone to upload");
                }
            }
        };
        this.client.listParts(this.bucketName, this.key, this.uploadId, listPartsResponseHandler);
    }

    public List<Integer> getLeftParts(List<PartETag> uploadedParts) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        long start = 0L;
        int partNumber = 1;
        HashSet<Integer> set = new HashSet<Integer>();
        for (PartETag p : uploadedParts) {
            set.add(p.getPartNumber());
        }
        while (start < this.file.length()) {
            if (!set.contains(partNumber)) {
                res.add(partNumber);
            }
            ++partNumber;
            start += this.partSize;
        }
        return res;
    }

    public void reUpload() {
        if (this.uploadId == null) {
            Log.i((String)"MultiUploader", (String)"no upload id, cannot reupload");
            return;
        }
        this.getUploadedParts();
    }

    public void doWithLimit(int startNo, final int N) {
        for (int i = startNo; i < startNo + this.concurrentNo && i < this.leftParts.size(); ++i) {
            int partNumber = this.leftParts.get(i);
            long offset = (long)partNumber * this.partSize - this.partSize;
            UploadPartRequest uploadPartRequest = new UploadPartRequest(this.bucketName, this.key, this.uploadId, this.file, offset, partNumber, Math.min(this.file.length() - offset, this.partSize));
            this.client.uploadPart(uploadPartRequest, new MyUploadPartResponceHandler(this.key, partNumber, this.uploadId){

                @Override
                public void onSuccess(int statesCode, Header[] responceHeaders, PartETag result, String key, int partNo, String uploadId) {
                    result.setPartNumber(partNo);
                    MultiUploader.this.doneParts.add(result);
                    MultiUploader.this.cur.incrementAndGet();
                    if (MultiUploader.this.doneParts.size() >= N) {
                        MultiUploader.this.mHandler.sendEmptyMessage(1);
                    } else if (MultiUploader.this.cur.get() % MultiUploader.this.concurrentNo == 0) {
                        MultiUploader.this.mHandler.sendMessage(Message.obtain((Handler)MultiUploader.this.mHandler, (int)4, (int)MultiUploader.this.cur.get(), (int)N));
                    }
                }

                @Override
                public void onFailure(int statesCode, Ks3Error error, Header[] responceHeaders, String response, Throwable throwable, String key, int partNo, String uploadId) {
                    Log.w((String)"MultiUploader", (String)("upload part fail, uploadId=" + uploadId + ",key=" + key + ",partNo=" + partNo), (Throwable)throwable);
                    if (MultiUploader.this.multiHandler != null) {
                        MultiUploader.this.multiHandler.onFailure(statesCode, error, responceHeaders, response, throwable);
                    }
                }

                @Override
                public void onTaskProgress(double progress, String key, int partNo, String uploadId) {
                    Log.d((String)"MultiUploader", (String)("progress:" + progress + ",key=" + key + ",partNo" + partNo));
                }
            });
        }
    }

    public void reUpload(List<PartETag> uploadedParts) {
        this.leftParts = this.getLeftParts(uploadedParts);
        int N = this.leftParts.size() + uploadedParts.size();
        this.cur = new AtomicInteger(0);
        this.doneParts.addAll(uploadedParts);
        if (this.leftParts.isEmpty()) {
            this.mHandler.sendEmptyMessage(1);
        }
        this.doWithLimit(0, N);
    }

    private void uploadParts() {
        this.reUpload(new ArrayList<PartETag>());
    }

    private void completeUpload() {
        if (this.multiHandler == null) {
            this.multiHandler = new CompleteMultipartUploadResponseHandler(){

                @Override
                public void onFailure(int statesCode, Ks3Error error, Header[] responceHeaders, String response, Throwable paramThrowable) {
                    Log.w((String)"MultiUploader", (String)("complete upload fail, statusCode=" + statesCode), (Throwable)paramThrowable);
                }

                @Override
                public void onSuccess(int statesCode, Header[] responceHeaders, CompleteMultipartUploadResult result) {
                    Log.i((String)"MultiUploader", (String)("complete upload, key=" + MultiUploader.this.key));
                }
            };
        }
        this.client.completeMultipartUpload(this.bucketName, this.key, this.uploadId, this.doneParts, this.multiHandler);
    }

    class MyHandler
    extends Handler {
        MyHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    MultiUploader.this.uploadParts();
                    break;
                }
                case 1: {
                    MultiUploader.this.completeUpload();
                    break;
                }
                case 3: {
                    List res = (List)msg.obj;
                    MultiUploader.this.reUpload(res);
                    break;
                }
                case 4: {
                    int no = msg.arg1;
                    int N = msg.arg2;
                    MultiUploader.this.doWithLimit(no, N);
                }
            }
        }
    }

    abstract class MyUploadPartResponceHandler
    extends UploadPartResponceHandler {
        private String key;
        private int partNo;
        private String uploadId;

        public abstract void onSuccess(int var1, Header[] var2, PartETag var3, String var4, int var5, String var6);

        public abstract void onFailure(int var1, Ks3Error var2, Header[] var3, String var4, Throwable var5, String var6, int var7, String var8);

        public abstract void onTaskProgress(double var1, String var3, int var4, String var5);

        public MyUploadPartResponceHandler(String key, int partNo, String uploadId) {
            this.key = key;
            this.partNo = partNo;
            this.uploadId = uploadId;
        }

        @Override
        public void onTaskProgress(double progress) {
            this.onTaskProgress(progress, this.key, this.partNo, this.uploadId);
        }

        @Override
        public void onSuccess(int statesCode, Header[] responceHeaders, PartETag result) {
            this.onSuccess(statesCode, responceHeaders, result, this.key, this.partNo, this.uploadId);
        }

        @Override
        public void onFailure(int statesCode, Ks3Error error, Header[] responceHeaders, String response, Throwable throwable) {
            this.onFailure(statesCode, error, responceHeaders, response, throwable, this.key, this.partNo, this.uploadId);
        }
    }
}

