/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.thumbplayer;

import android.graphics.Rect;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.thumbplayer.ThumbMediaPlayer;
import com.tencent.liteav.txcplayer.model.d;
import com.tencent.thumbplayer.api.ITPPlayer;
import com.tencent.thumbplayer.api.ITPPlayerListener;
import com.tencent.thumbplayer.api.TPAudioFrameBuffer;
import com.tencent.thumbplayer.api.TPPlayerMsg;
import com.tencent.thumbplayer.api.TPPostProcessFrameBuffer;
import com.tencent.thumbplayer.api.TPSubtitleData;
import com.tencent.thumbplayer.api.TPSubtitleFrameBuffer;
import com.tencent.thumbplayer.api.TPVideoFrameBuffer;
import java.lang.ref.WeakReference;

class ThumbMediaPlayerListener
implements ITPPlayerListener.IOnAudioFrameOutputListener,
ITPPlayerListener.IOnAudioProcessFrameOutputListener,
ITPPlayerListener.IOnCompletionListener,
ITPPlayerListener.IOnErrorListener,
ITPPlayerListener.IOnInfoListener,
ITPPlayerListener.IOnPreparedListener,
ITPPlayerListener.IOnSeekCompleteListener,
ITPPlayerListener.IOnStateChangeListener,
ITPPlayerListener.IOnStopAsyncCompleteListener,
ITPPlayerListener.IOnSubtitleDataListener,
ITPPlayerListener.IOnSubtitleFrameOutListener,
ITPPlayerListener.IOnVideoFrameOutListener,
ITPPlayerListener.IOnVideoProcessFrameOutputListener,
ITPPlayerListener.IOnVideoSizeChangedListener {
    private final WeakReference<ThumbMediaPlayer> mThumbMediaPlayer;
    private final String TAG = ThumbMediaPlayerListener.class.getName();

    public ThumbMediaPlayerListener(ThumbMediaPlayer thumbMediaPlayer) {
        this.mThumbMediaPlayer = new WeakReference<ThumbMediaPlayer>(thumbMediaPlayer);
    }

    void attachToPlayer() {
        ITPPlayer iTPPlayer;
        ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
        if (thumbMediaPlayer != null && (iTPPlayer = thumbMediaPlayer.getTPPPlayer()) != null) {
            iTPPlayer.setOnPreparedListener(this);
            iTPPlayer.setOnCompletionListener(this);
            iTPPlayer.setOnInfoListener(this);
            iTPPlayer.setOnErrorListener(this);
            iTPPlayer.setOnSeekCompleteListener(this);
            iTPPlayer.setOnVideoSizeChangedListener(this);
            iTPPlayer.setOnSubtitleDataListener(this);
            iTPPlayer.setOnSubtitleFrameOutListener(this);
            iTPPlayer.setOnVideoFrameOutListener(this);
            iTPPlayer.setOnAudioFrameOutputListener(this);
            iTPPlayer.setOnVideoProcessFrameOutputListener(this);
            iTPPlayer.setOnAudioProcessFrameOutputListener(this);
            iTPPlayer.setOnPlayerStateChangeListener(this);
            iTPPlayer.setOnStopAsyncCompleteListener(this);
        }
    }

    @Override
    public void onPrepared(ITPPlayer player) {
        LiteavLog.i(this.TAG, "ThumbMediaPlayerListener onPrepared");
        ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
        if (thumbMediaPlayer != null) {
            thumbMediaPlayer.notifyOnPrepared();
        }
    }

    @Override
    public void onCompletion(ITPPlayer player) {
        ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
        if (thumbMediaPlayer != null) {
            thumbMediaPlayer.notifyOnCompletion();
        }
    }

    @Override
    public void onVideoSizeChanged(ITPPlayer player, long width, long height) {
        ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
        if (thumbMediaPlayer != null) {
            LiteavLog.i(this.TAG, "ThumbMediaPlayerListener on:videoSizeChanged:width:" + width + ":height:" + height);
            thumbMediaPlayer.notifyOnVideoSizeChanged((int)width, (int)height, thumbMediaPlayer.getVideoSarNum(), thumbMediaPlayer.getVideoSarDen(), null);
        }
    }

    @Override
    public void onInfo(ITPPlayer player, int what, long arg1, long arg2, Object extraObject) {
        ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
        if (thumbMediaPlayer != null) {
            Object object;
            int n2 = this.transferInfo(what);
            int n3 = (int)arg1;
            if (extraObject != null && extraObject instanceof TPPlayerMsg.TPCDNURLInfo) {
                object = (TPPlayerMsg.TPCDNURLInfo)extraObject;
                LiteavLog.i(this.TAG, "onInfo TPCDNURLInfo:cdnIp:" + ((TPPlayerMsg.TPCDNURLInfo)object).cdnIp + ":uIp:" + ((TPPlayerMsg.TPCDNURLInfo)object).uIp + ": url: " + ((TPPlayerMsg.TPCDNURLInfo)object).url + ":errorStr: " + ((TPPlayerMsg.TPCDNURLInfo)object).errorStr);
            }
            if (extraObject != null && extraObject instanceof TPPlayerMsg.TPDownLoadProgressInfo) {
                String[] stringArray;
                object = (TPPlayerMsg.TPDownLoadProgressInfo)extraObject;
                long l2 = ((TPPlayerMsg.TPDownLoadProgressInfo)object).totalFileSize;
                thumbMediaPlayer.updateBitrate(l2);
                long l3 = ((TPPlayerMsg.TPDownLoadProgressInfo)object).downloadSpeedKBps;
                if (l3 < 0L && ((TPPlayerMsg.TPDownLoadProgressInfo)object).extraInfo != null && (stringArray = ((TPPlayerMsg.TPDownLoadProgressInfo)object).extraInfo.split(",")) != null) {
                    String[] stringArray2 = stringArray;
                    int n4 = stringArray.length;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        String string = stringArray2[i2];
                        if (string == null || !string.contains("httpAvgSpeedKB")) continue;
                        String string2 = string;
                        l3 = Long.valueOf(string2.substring(string2.indexOf(":") + 1, string.length()).trim());
                        break;
                    }
                }
                thumbMediaPlayer.updateTcpSpeed(l3 * 1024L);
            }
            if (extraObject instanceof TPPlayerMsg.TPVideoCropInfo) {
                object = (TPPlayerMsg.TPVideoCropInfo)extraObject;
                LiteavLog.i(this.TAG, "onInfo TPVideoCropInfo:cropBottom:" + ((TPPlayerMsg.TPVideoCropInfo)object).cropBottom + ":cropLeft:" + ((TPPlayerMsg.TPVideoCropInfo)object).cropLeft + ": cropRight: " + ((TPPlayerMsg.TPVideoCropInfo)object).cropRight + ":cropTop: " + ((TPPlayerMsg.TPVideoCropInfo)object).cropTop + ":height:" + ((TPPlayerMsg.TPVideoCropInfo)object).height + ":width:" + ((TPPlayerMsg.TPVideoCropInfo)object).width);
            }
            thumbMediaPlayer.notifyOnInfo(n2, n3, (int)arg2, extraObject);
        }
    }

    private int transferInfo(int what) {
        int n2 = -1;
        switch (what) {
            case 104: {
                n2 = 2008;
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
                if (thumbMediaPlayer == null) break;
                thumbMediaPlayer.onReceiveFirstVideoRenderEvent();
                break;
            }
            case 107: {
                break;
            }
            case 200: {
                n2 = 2007;
                break;
            }
            case 201: {
                n2 = 2014;
                break;
            }
            case 1001: {
                LiteavLog.i(this.TAG, "TP_PLAYER_INFO_LONG0_ALL_DOWNLOAD_FINISH");
                ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
                if (thumbMediaPlayer == null) break;
                thumbMediaPlayer.updateTcpSpeed(0L);
                break;
            }
            case 1006: {
                n2 = 1006;
                break;
            }
            case 4: {
                n2 = 2020;
            }
        }
        return n2;
    }

    @Override
    public void onError(ITPPlayer player, int errorType, int errorCode, long arg1, long arg2) {
        if (errorType != 1000) {
            LiteavLog.w(this.TAG, "onError type: " + errorType + " code: " + errorCode);
            ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
            if (thumbMediaPlayer != null) {
                int n2 = this.transferError(errorType, errorCode);
                if (n2 == -6101) {
                    thumbMediaPlayer.notifyOnError(n2, errorCode);
                    return;
                }
                thumbMediaPlayer.notifyOnError(n2, (int)arg1);
            }
        }
    }

    private int transferError(int errorType, int errorCode) {
        int n2 = 1;
        switch (errorType) {
            case 2000: 
            case 2001: {
                n2 = this.transferSystemPlayerError(errorCode);
                break;
            }
            case 1001: {
                n2 = this.transferGeneralError(errorCode);
                break;
            }
            case 1102: 
            case 1211: 
            case 1221: 
            case 1231: {
                n2 = -1007;
                break;
            }
            case 1100: {
                if (errorCode < 11070000 || errorCode >= 11080000) break;
                n2 = -6101;
                break;
            }
            case 1220: {
                ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
                if (thumbMediaPlayer != null) {
                    String string = thumbMediaPlayer.getTPPPlayer().getPropertyString(0);
                    if (string != null && (string.toLowerCase().contains("hevc") || string.toLowerCase().contains("h265"))) {
                        thumbMediaPlayer.notifyHevcVideoDecoderError();
                    } else {
                        thumbMediaPlayer.notifyVideoDecoderError();
                    }
                }
            }
            case 1210: 
            case 1230: {
                n2 = -1010;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    private int transferSystemPlayerError(int errorCode) {
        int whatError;
        switch (errorCode) {
            case 10001004: {
                whatError = -1004;
                break;
            }
            case 10001007: {
                whatError = -1007;
                break;
            }
            case 10001010: {
                whatError = -1010;
                break;
            }
            case 10000200: {
                whatError = 200;
                break;
            }
            default: {
                whatError = 1;
            }
        }
        return whatError;
    }

    private int transferGeneralError(int errorCode) {
        int n2 = 1;
        switch (errorCode) {
            case 11010101: 
            case 11010103: {
                n2 = -1007;
                break;
            }
            case 11010104: {
                ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
                if (thumbMediaPlayer == null) break;
                String string = thumbMediaPlayer.getTPPPlayer().getPropertyString(0);
                if (string != null && (string.toLowerCase().contains("hevc") || string.toLowerCase().contains("h265"))) {
                    thumbMediaPlayer.notifyHLSKeyError();
                }
                n2 = -1007;
                break;
            }
            case 11010201: 
            case 11010202: 
            case 11010401: 
            case 11010402: {
                n2 = -1010;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    @Override
    public void onSeekComplete(ITPPlayer player) {
        LiteavLog.i(this.TAG, "ThumbMediaPlayerListener onSeekComplete");
        ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
        if (thumbMediaPlayer != null) {
            thumbMediaPlayer.notifyOnSeekComplete();
        }
    }

    @Override
    public void onAudioFrameOut(ITPPlayer player, TPAudioFrameBuffer tpAudioFrameBuffer) {
        LiteavLog.i(this.TAG, "ThumbMediaPlayerListener onAudioFrameOut");
    }

    @Override
    public TPPostProcessFrameBuffer onAudioProcessFrameOut(ITPPlayer player, TPPostProcessFrameBuffer tpPostProcessFrameBuffer) {
        return tpPostProcessFrameBuffer;
    }

    @Override
    public void onStateChange(int preState, int curState) {
        LiteavLog.i(this.TAG, "ThumbMediaPlayerListener onStateChange:preState" + preState + ": curState:" + curState);
    }

    @Override
    public void onStopAsyncComplete(ITPPlayer player) {
        LiteavLog.i(this.TAG, "ThumbMediaPlayerListener onStopAsyncComplete");
    }

    @Override
    public void onSubtitleData(ITPPlayer player, TPSubtitleData tpSubtitleData) {
        ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
        if (thumbMediaPlayer != null && tpSubtitleData != null) {
            LiteavLog.i(this.TAG, "ThumbMediaPlayerListener onSubtitleData:" + tpSubtitleData.subtitleData);
            d d2 = new d(new Rect(0, 0, 1, 1), tpSubtitleData.subtitleData);
            thumbMediaPlayer.notifyOnTimedText(d2);
        }
    }

    @Override
    public void onSubtitleFrameOut(ITPPlayer player, TPSubtitleFrameBuffer tpSubtitleFrameBuffer) {
        LiteavLog.i(this.TAG, "ThumbMediaPlayerListener onSubtitleFrameOut");
        ThumbMediaPlayer thumbMediaPlayer = (ThumbMediaPlayer)this.mThumbMediaPlayer.get();
        if (thumbMediaPlayer != null) {
            thumbMediaPlayer.notifySubtitleFrameData(tpSubtitleFrameBuffer);
        }
    }

    @Override
    public void onVideoFrameOut(ITPPlayer player, TPVideoFrameBuffer tpVideoFrameBuffer) {
        LiteavLog.i(this.TAG, "ThumbMediaPlayerListener onVideoFrameOut");
    }

    @Override
    public TPPostProcessFrameBuffer onVideoProcessFrameOut(ITPPlayer player, TPPostProcessFrameBuffer tpPostProcessFrameBuffer) {
        LiteavLog.i(this.TAG, "ThumbMediaPlayerListener onVideoProcessFrameOut");
        return tpPostProcessFrameBuffer;
    }
}

