/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.api;

import android.graphics.Bitmap;
import android.util.Log;
import com.tencent.thumbplayer.a.a;
import com.tencent.thumbplayer.core.common.TPVideoFrame;
import com.tencent.thumbplayer.core.imagegenerator.ITPImageGeneratorCallback;
import com.tencent.thumbplayer.core.imagegenerator.TPImageGenerator;
import com.tencent.thumbplayer.core.imagegenerator.TPImageGeneratorParams;
import com.tencent.thumbplayer.utils.TPLogUtil;
import java.util.HashMap;
import java.util.Map;

public class TPVideoCapture
implements ITPImageGeneratorCallback {
    private static final String TAG = "TPThumbPlayer[TPVideoCapture.java]";
    private int mWidth = 0;
    private int mHeight = 0;
    private long mRequestedTimeMsToleranceBefore = 0L;
    private long mRequestedTimeMsToleranceAfter = 0L;
    private TPImageGenerator mTpImageGenerator;
    private Map<String, TPVideoCaptureCallBack> mCallBackMap;
    private long mOpaque = 0L;

    public TPVideoCapture(String string) {
        this.mTpImageGenerator = new TPImageGenerator(string, this);
        this.mCallBackMap = new HashMap<String, TPVideoCaptureCallBack>();
        try {
            this.mTpImageGenerator.init();
            return;
        }
        catch (Exception exception) {
            TPLogUtil.e(TAG, "init: " + Log.getStackTraceString((Throwable)exception));
            return;
        }
    }

    public void setSize(int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Size is illegal");
        }
        this.mWidth = n2;
        this.mHeight = n3;
    }

    public void setTimeMsTolerance(long l2, long l3) {
        if (l2 > l3) {
            throw new IllegalArgumentException("Tolerance is illegal");
        }
        this.mRequestedTimeMsToleranceBefore = l2;
        this.mRequestedTimeMsToleranceAfter = l3;
    }

    public void generateImageAsyncAtTime(long l2, TPVideoCaptureCallBack tPVideoCaptureCallBack) {
        ++this.mOpaque;
        TPVideoCapture tPVideoCapture = this;
        this.mCallBackMap.put(tPVideoCapture.generateOpaqueKey(tPVideoCapture.mOpaque, l2), tPVideoCaptureCallBack);
        try {
            this.mTpImageGenerator.generateImageAsyncAtTime(l2, this.mOpaque, this.getParameters());
            return;
        }
        catch (Exception exception) {
            TPLogUtil.e(TAG, "generateImageAsyncAtTime: " + Log.getStackTraceString((Throwable)exception));
            return;
        }
    }

    public void generateImagesAsyncForTimes(long[] lArray, TPVideoCaptureCallBack tPVideoCaptureCallBack) {
        ++this.mOpaque;
        long[] lArray2 = lArray;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            TPVideoCapture tPVideoCapture = this;
            this.mCallBackMap.put(tPVideoCapture.generateOpaqueKey(tPVideoCapture.mOpaque, l2), tPVideoCaptureCallBack);
        }
        try {
            this.mTpImageGenerator.generateImagesAsyncForTimes(lArray, this.mOpaque, this.getParameters());
            return;
        }
        catch (Exception exception) {
            TPLogUtil.e(TAG, "generateImagesAsyncForTimes: " + Log.getStackTraceString((Throwable)exception));
            return;
        }
    }

    public void release() {
        try {
            this.mTpImageGenerator.cancelAllImageGenerations();
            this.mTpImageGenerator.unInit();
        }
        catch (Exception exception) {
            TPLogUtil.e(TAG, "release: " + Log.getStackTraceString((Throwable)exception));
        }
        this.mCallBackMap.clear();
        this.mTpImageGenerator = null;
    }

    private TPImageGeneratorParams getParameters() {
        TPImageGeneratorParams tPImageGeneratorParams = new TPImageGeneratorParams();
        new TPImageGeneratorParams().format = 37;
        tPImageGeneratorParams.width = this.mWidth;
        tPImageGeneratorParams.height = this.mHeight;
        tPImageGeneratorParams.requestedTimeMsToleranceAfter = this.mRequestedTimeMsToleranceAfter;
        tPImageGeneratorParams.requestedTimeMsToleranceBefore = this.mRequestedTimeMsToleranceBefore;
        return tPImageGeneratorParams;
    }

    private String generateOpaqueKey(long l2, long l3) {
        return "opaque_" + l2 + "time_" + l3;
    }

    @Override
    public void onImageGenerationCompleted(int n2, long l2, long l3, long l4, TPVideoFrame tPVideoFrame) {
        TPVideoCaptureCallBack tPVideoCaptureCallBack = this.mCallBackMap.get(this.generateOpaqueKey(l4, l2));
        if (tPVideoCaptureCallBack != null) {
            if (n2 == 0 && tPVideoFrame != null) {
                tPVideoCaptureCallBack.onCaptureSuccess(a.b(tPVideoFrame));
            } else {
                tPVideoCaptureCallBack.onCaptureError(n2);
            }
        }
        this.mCallBackMap.remove(this.generateOpaqueKey(l4, l2));
    }

    public static interface TPVideoCaptureCallBack {
        public void onCaptureSuccess(Bitmap[] var1);

        public void onCaptureError(int var1);
    }
}

