/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.notification;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.service.notification.StatusBarNotification;
import com.heytap.msp.push.notification.PushNotification;

public class NotificationHelper {
    public static StatusBarNotification[] getActiveNotifications(NotificationManager nm, String packageName) {
        StatusBarNotification[] list = null;
        if (Build.VERSION.SDK_INT >= 23) {
            list = nm.getActiveNotifications();
        }
        return list;
    }

    public static boolean isExistNotificationsByPkgAndId(NotificationManager nm, String packageName, int notifyId) {
        StatusBarNotification[] array = NotificationHelper.getActiveNotifications(nm, packageName);
        if (array == null || array.length == 0) {
            return false;
        }
        for (StatusBarNotification notification : array) {
            if (notification.getId() != notifyId) continue;
            return true;
        }
        return false;
    }

    public static NotificationManager getNotificationManager(Context context) {
        NotificationManager nm = null;
        try {
            if (null != context) {
                nm = (NotificationManager)context.getSystemService("notification");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nm;
    }

    public static Notification createDefaultGroupNotification(Context context, String group, PushNotification.Builder childBuild) {
        Notification.Builder groupBuild = new Notification.Builder(context);
        if (Build.VERSION.SDK_INT >= 26) {
            groupBuild.setChannelId("Heytap PUSH");
        }
        if (Build.VERSION.SDK_INT >= 20) {
            groupBuild.setGroup(group);
            groupBuild.setGroupSummary(true);
        }
        if (NotificationHelper.setGroupIcon(groupBuild, childBuild)) {
            return groupBuild.build();
        }
        return null;
    }

    private static boolean setGroupIcon(Notification.Builder groupBuild, PushNotification.Builder childBuild) {
        int iconRes = childBuild.getIconRes();
        int iconLevel = childBuild.getIconLevel();
        Icon icon = childBuild.getIcon();
        if (icon != null && Build.VERSION.SDK_INT >= 23) {
            groupBuild.setSmallIcon(icon);
            return true;
        }
        if (iconRes != 0 && iconLevel != 0) {
            groupBuild.setSmallIcon(iconRes, iconLevel);
            return true;
        }
        if (iconRes != 0) {
            groupBuild.setSmallIcon(iconRes);
            return true;
        }
        return false;
    }
}

