/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.helper;

import android.content.Context;
import android.text.TextUtils;
import com.daya.orchestra.accompany.api.DownloadApi;
import com.daya.orchestra.accompany.callback.ResultCallbackV2;
import com.daya.orchestra.accompany.net.RetrofitClientNoToken;
import com.daya.orchestra.accompany.utils.ALOG;
import com.daya.orchestra.accompany.utils.EncryptUtils;
import com.daya.orchestra.accompany.utils.MyFileUtils;
import com.daya.orchestra.accompany.utils.Utils;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class MusicFileDownloadHelper {
    public static final String BASE_PATH = MyFileUtils.getCacheDir2((Context)Utils.getApp(), "musicFile");

    private MusicFileDownloadHelper() {
    }

    public static MusicFileDownloadHelper getInstance() {
        return MusicFileDownloadHelperHolder.mHelper;
    }

    public void download(final String url, final ResultCallbackV2<String> resultCallback) {
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(@NonNull ObservableEmitter<String> emitter) throws Throwable {
                String downloadSaveTempPath = MusicFileDownloadHelper.this.getDownloadSaveTempPath(url);
                MyFileUtils.createOrExistsFile(downloadSaveTempPath);
                File file = new File(downloadSaveTempPath);
                MusicFileDownloadHelper.this.downloadFile(url, file, resultCallback);
                if (emitter != null) {
                    emitter.onNext((Object)MusicFileDownloadHelper.getDownloadSavePath(url));
                }
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<String>(){

            public void onSubscribe(@NonNull Disposable d) {
            }

            public void onNext(@NonNull String s) {
                if (resultCallback != null) {
                    resultCallback.onSuccess(s);
                }
            }

            public void onError(@NonNull Throwable e) {
                e.printStackTrace();
                if (resultCallback != null) {
                    resultCallback.onFail(-1, "download error");
                }
            }

            public void onComplete() {
            }
        });
    }

    public static boolean checkFileIsExist(String url) {
        String downloadSavePath = MusicFileDownloadHelper.getDownloadSavePath(url);
        File file = new File(downloadSavePath);
        return file.exists();
    }

    public String getDownloadSaveTempPath(String url) {
        String fileEndSuffix = MusicFileDownloadHelper.getFileType(url);
        String fileName = EncryptUtils.encryptMD5ToString(url);
        return BASE_PATH + File.separator + fileName + "_temp" + fileEndSuffix;
    }

    public static String getDownloadSavePath(String url) {
        String fileType = MusicFileDownloadHelper.getFileType(url);
        String fileName = EncryptUtils.encryptMD5ToString(url);
        String path = BASE_PATH + File.separator + fileName + fileType;
        return path;
    }

    public static String getFileType(String url) {
        int lastDot = url.lastIndexOf(".");
        if (lastDot < 0) {
            return "";
        }
        String fileType = url.substring(lastDot).toLowerCase();
        return fileType;
    }

    private void downloadFile(String url, File file, ResultCallbackV2<String> resultCallback) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        try {
            Response response = ((DownloadApi)RetrofitClientNoToken.getInstance().getRetrofit().create(DownloadApi.class)).download(url).execute();
            if (response == null || response.body() == null) {
                return;
            }
            long total = ((ResponseBody)response.body()).contentLength();
            long current = 0L;
            InputStream inputStream = ((ResponseBody)response.body()).byteStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] bytes = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(bytes)) != -1) {
                fileOutputStream.write(bytes, 0, len);
                fileOutputStream.flush();
                current += (long)len;
                if (resultCallback == null) continue;
                int progressPercent = (int)((float)current * 1.0f / (float)total * 100.0f);
                resultCallback.onProgress(progressPercent);
            }
            this.replaceName(file);
            fileOutputStream.flush();
            fileOutputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void replaceName(File file) {
        String name = file.getName();
        ALOG.i("\u4e0b\u8f7d\u5b8c\u6210file:" + name);
        String temp = name.replace("_temp", "");
        ALOG.i("\u66ff\u6362\u4e4b\u540efile:" + temp);
        MyFileUtils.rename(file, temp);
    }

    private static class MusicFileDownloadHelperHolder {
        public static MusicFileDownloadHelper mHelper = new MusicFileDownloadHelper();

        private MusicFileDownloadHelperHolder() {
        }
    }
}

