/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.base;

import androidx.annotation.Nullable;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.text.TextBlock;
import com.wonderkiln.camerakit.CameraProperties;
import com.wonderkiln.camerakit.base.PreviewImpl;
import com.wonderkiln.camerakit.events.EventDispatcher;
import com.wonderkiln.camerakit.utils.Size;
import java.io.File;

public abstract class CameraImpl {
    protected final EventDispatcher mEventDispatcher;
    protected final PreviewImpl mPreview;

    public CameraImpl(EventDispatcher eventDispatcher, PreviewImpl preview) {
        this.mEventDispatcher = eventDispatcher;
        this.mPreview = preview;
    }

    public abstract void start();

    public abstract void stop();

    public abstract void setDisplayAndDeviceOrientation(int var1, int var2);

    public abstract void setFacing(int var1);

    public abstract void setFlash(int var1);

    public abstract void setFocus(int var1);

    public abstract void setMethod(int var1);

    public abstract void setTextDetector(Detector<TextBlock> var1);

    public abstract void setVideoQuality(int var1);

    public abstract void setVideoBitRate(int var1);

    public abstract void setLockVideoAspectRatio(boolean var1);

    public abstract void setZoom(float var1);

    public abstract void modifyZoom(float var1);

    public abstract void setDeviceOrientation(int var1);

    public abstract void setFocusArea(float var1, float var2);

    public abstract void captureImage(ImageCapturedCallback var1);

    public void captureVideo(File videoFile, VideoCapturedCallback callback) {
        this.captureVideo(videoFile, 0, callback);
    }

    public abstract void captureVideo(File var1, int var2, VideoCapturedCallback var3);

    public abstract void stopVideo();

    public abstract Size getCaptureResolution();

    public abstract Size getVideoResolution();

    public abstract Size getPreviewResolution();

    public abstract boolean isCameraOpened();

    public abstract boolean frontCameraOnly();

    @Nullable
    public abstract CameraProperties getCameraProperties();

    public static interface VideoCapturedCallback {
        public void videoCaptured(File var1);

        public void onStart(long var1);
    }

    public static interface ImageCapturedCallback {
        public void imageCaptured(byte[] var1);
    }
}

