/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.manage;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.heytap.mcssdk.utils.SharedPreferenceManager;
import com.heytap.mcssdk.utils.ThreadUtil;
import com.pushsdk.R;

public class NotificatonChannelManager {
    public static final String DEFAULT_NOTIFICATION_CHANNEL_ID = "Heytap PUSH";
    private static final String DEFAULT_NOTIFICATION_CHANNEL_NAME = "System Default Channel";
    private static final int DEFAULT_CHANNEL_IMPORTANCE = 3;

    public void createDefaultChannel(final Context context) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SharedPreferenceManager.getInstance().hasDefaultChannelCreated()) {
                    return;
                }
                String channelName = context.getString(R.string.system_default_channel);
                if (TextUtils.isEmpty((CharSequence)channelName)) {
                    channelName = NotificatonChannelManager.DEFAULT_NOTIFICATION_CHANNEL_NAME;
                }
                boolean hasChannelCreated = NotificatonChannelManager.this.createChannel(context, NotificatonChannelManager.DEFAULT_NOTIFICATION_CHANNEL_ID, channelName, 3);
                SharedPreferenceManager.getInstance().setHasDefaultChannelCreated(hasChannelCreated);
            }
        };
        ThreadUtil.executeOnBackground(runnable);
    }

    @TargetApi(value=26)
    private boolean createChannel(Context context, String channelID, String channelName, int importance) {
        if (context == null) {
            return false;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager == null) {
            return false;
        }
        NotificationChannel channel = new NotificationChannel(channelID, (CharSequence)channelName, importance);
        notificationManager.createNotificationChannel(channel);
        return true;
    }
}

