/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.media.MediaCodec;
import android.media.MediaFormat;
import java.nio.ShortBuffer;
import java.util.ArrayDeque;
import java.util.Queue;

abstract class BaseAudioChannel {
    static final int BUFFER_INDEX_END_OF_STREAM = -1;
    protected static final int BYTE_PER_SAMPLE = 2;
    protected static final int BYTES_PER_SHORT = 2;
    protected static final long MICROSECS_PER_SEC = 1000000L;
    protected final Queue<AudioBuffer> emptyBuffers = new ArrayDeque<AudioBuffer>();
    protected final Queue<AudioBuffer> filledBuffers = new ArrayDeque<AudioBuffer>();
    protected final MediaCodec decoder;
    protected final MediaCodec encoder;
    protected final MediaFormat encodeFormat;
    protected int inputSampleRate;
    protected int inputChannelCount;
    protected int outputChannelCount;
    protected final AudioBuffer overflowBuffer = new AudioBuffer();
    protected MediaFormat actualDecodedFormat;

    BaseAudioChannel(MediaCodec decoder, MediaCodec encoder, MediaFormat encodeFormat) {
        this.decoder = decoder;
        this.encoder = encoder;
        this.encodeFormat = encodeFormat;
    }

    public void setActualDecodedFormat(MediaFormat decodedFormat) {
        this.actualDecodedFormat = decodedFormat;
        this.inputSampleRate = this.actualDecodedFormat.getInteger("sample-rate");
        if (this.inputSampleRate != this.encodeFormat.getInteger("sample-rate")) {
            throw new UnsupportedOperationException("Audio sample rate conversion not supported yet.");
        }
        this.inputChannelCount = this.actualDecodedFormat.getInteger("channel-count");
        this.outputChannelCount = this.encodeFormat.getInteger("channel-count");
        if (this.outputChannelCount != 1 && this.outputChannelCount != 2) {
            throw new UnsupportedOperationException("Output channel count (" + this.outputChannelCount + ") not supported.");
        }
        this.overflowBuffer.presentationTimeUs = 0L;
    }

    protected abstract long sampleCountToDurationUs(long var1, int var3, int var4);

    protected abstract void drainDecoderBufferAndQueue(int var1, long var2);

    protected abstract boolean feedEncoder(long var1);

    protected static class BufferInfo {
        long totaldata;
        long presentationTimeUs;

        protected BufferInfo() {
        }
    }

    protected static class AudioBuffer {
        int bufferIndex;
        long presentationTimeUs;
        ShortBuffer data;

        protected AudioBuffer() {
        }
    }
}

