/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.alibaba.android.bindingx.core.IEventHandler;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.BindingXOrientationHandler;
import com.alibaba.android.bindingx.core.internal.BindingXTimingHandler;
import com.alibaba.android.bindingx.core.internal.BindingXTouchHandler;
import com.alibaba.android.bindingx.core.internal.ExpressionPair;
import com.alibaba.android.bindingx.core.internal.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONObject;

public class BindingXCore {
    private Map<String, Map<String, IEventHandler>> mBindingCouples;
    private final Map<String, ObjectCreator<IEventHandler, Context, PlatformManager>> mInternalEventHandlerCreatorMap = new HashMap<String, ObjectCreator<IEventHandler, Context, PlatformManager>>(8);
    private static final Map<String, ObjectCreator<IEventHandler, Context, PlatformManager>> sGlobalEventHandlerCreatorMap = new HashMap<String, ObjectCreator<IEventHandler, Context, PlatformManager>>(4);
    private final PlatformManager mPlatformManager;

    public BindingXCore(@NonNull PlatformManager platformManager) {
        this.mPlatformManager = platformManager;
        this.registerEventHandler("pan", new ObjectCreator<IEventHandler, Context, PlatformManager>(){

            @Override
            public IEventHandler createWith(@NonNull Context context, @NonNull PlatformManager manager, Object ... extension) {
                return new BindingXTouchHandler(context, manager, extension);
            }
        });
        this.registerEventHandler("orientation", new ObjectCreator<IEventHandler, Context, PlatformManager>(){

            @Override
            public IEventHandler createWith(@NonNull Context context, @NonNull PlatformManager manager, Object ... extension) {
                return new BindingXOrientationHandler(context, manager, extension);
            }
        });
        this.registerEventHandler("timing", new ObjectCreator<IEventHandler, Context, PlatformManager>(){

            @Override
            public IEventHandler createWith(@NonNull Context context, @NonNull PlatformManager manager, Object ... extension) {
                return new BindingXTimingHandler(context, manager, extension);
            }
        });
    }

    public String doBind(@Nullable Context context, @Nullable String instanceId, @NonNull Map<String, Object> params, @NonNull JavaScriptCallback callback, Object ... extension) {
        String eventType = Utils.getStringValue(params, "eventType");
        String anchorInstanceId = Utils.getStringValue(params, "instanceId");
        LogProxy.enableLogIfNeeded(params);
        Object configObj = params.get("options");
        Map<String, Object> configMap = null;
        if (configObj != null && configObj instanceof Map) {
            try {
                configMap = Utils.toMap(new JSONObject((Map)configObj));
            }
            catch (Exception e) {
                LogProxy.e("parse external config failed.\n", e);
            }
        }
        ExpressionPair exitExpressionPair = Utils.getExpressionPair(params, "exitExpression");
        String anchor = Utils.getStringValue(params, "anchor");
        List<Map<String, Object>> expressionArgs = Utils.getRuntimeProps(params);
        Map<String, ExpressionPair> interceptors = Utils.getCustomInterceptors(params);
        return this.doBind(anchor, anchorInstanceId, eventType, configMap, exitExpressionPair, expressionArgs, interceptors, callback, context, instanceId, extension);
    }

    public void doUnbind(@Nullable Map<String, Object> params) {
        if (params == null) {
            return;
        }
        String eventType = Utils.getStringValue(params, "eventType");
        String token = Utils.getStringValue(params, "token");
        this.doUnbind(token, eventType);
    }

    public void doUnbind(@Nullable String token, @Nullable String eventType) {
        LogProxy.d("disable binding [" + token + "," + eventType + "]");
        if (TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)eventType)) {
            LogProxy.d("disable binding failed(0x1) [" + token + "," + eventType + "]");
            return;
        }
        if (this.mBindingCouples == null || this.mBindingCouples.isEmpty()) {
            LogProxy.d("disable binding failed(0x2) [" + token + "," + eventType + "]");
            return;
        }
        Map<String, IEventHandler> handlerMap = this.mBindingCouples.get(token);
        if (handlerMap == null || handlerMap.isEmpty()) {
            LogProxy.d("disable binding failed(0x3) [" + token + "," + eventType + "]");
            return;
        }
        IEventHandler handler = handlerMap.get(eventType);
        if (handler == null) {
            LogProxy.d("disable binding failed(0x4) [" + token + "," + eventType + "]");
            return;
        }
        if (handler.onDisable(token, eventType)) {
            this.mBindingCouples.remove(token);
            LogProxy.d("disable binding success[" + token + "," + eventType + "]");
        } else {
            LogProxy.d("disabled failed(0x4) [" + token + "," + eventType + "]");
        }
    }

    public void doRelease() {
        if (this.mBindingCouples != null) {
            try {
                for (Map<String, IEventHandler> handlerMap : this.mBindingCouples.values()) {
                    if (handlerMap == null || handlerMap.isEmpty()) continue;
                    for (IEventHandler h : handlerMap.values()) {
                        if (h == null) continue;
                        h.onDestroy();
                    }
                }
                this.mBindingCouples.clear();
                this.mBindingCouples = null;
            }
            catch (Exception e) {
                LogProxy.e("release failed", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String doPrepare(@Nullable Context context, @Nullable String instanceId, @Nullable String anchor, @Nullable String anchorInstanceId, @Nullable String eventType, @Nullable Map<String, Object> globalConfig) {
        IEventHandler targetHandler;
        Map<String, IEventHandler> handlerMap;
        String token;
        if (TextUtils.isEmpty((CharSequence)eventType)) {
            LogProxy.e("[doPrepare] failed. can not found eventType");
            return null;
        }
        if (context == null) {
            LogProxy.e("[doPrepare] failed. context or wxInstance is null");
            return null;
        }
        String string = token = TextUtils.isEmpty((CharSequence)anchor) ? this.generateToken() : anchor;
        if (this.mBindingCouples == null) {
            this.mBindingCouples = new HashMap<String, Map<String, IEventHandler>>();
        }
        if ((handlerMap = this.mBindingCouples.get(token)) != null && (targetHandler = handlerMap.get(eventType)) != null) {
            LogProxy.d("you have already enabled binding,[token:" + token + ",type:" + eventType + "]");
            targetHandler.onStart(token, eventType);
            LogProxy.d("enableBinding success.[token:" + token + ",type:" + eventType + "]");
            return token;
        }
        if (handlerMap == null) {
            handlerMap = new HashMap<String, IEventHandler>(4);
            this.mBindingCouples.put(token, handlerMap);
        }
        if ((targetHandler = this.createEventHandler(context, instanceId, eventType)) == null) {
            LogProxy.e("unknown eventType: " + eventType);
            return null;
        }
        targetHandler.setAnchorInstanceId(anchorInstanceId);
        targetHandler.setToken(token);
        targetHandler.setGlobalConfig(globalConfig);
        if (targetHandler.onCreate(token, eventType)) {
            targetHandler.onStart(token, eventType);
            handlerMap.put(eventType, targetHandler);
            LogProxy.d("enableBinding success.[token:" + token + ",type:" + eventType + "]");
            return token;
        }
        LogProxy.e("expression enabled failed. [token:" + token + ",type:" + eventType + "]");
        return null;
    }

    public String doBind(@Nullable String anchor, @Nullable String anchorInstanceId, @Nullable String eventType, @Nullable Map<String, Object> globalConfig, @Nullable ExpressionPair exitExpressionPair, @Nullable List<Map<String, Object>> expressionArgs, @Nullable Map<String, ExpressionPair> interceptors, @Nullable JavaScriptCallback callback, @Nullable Context context, @Nullable String instanceId, Object ... extension) {
        if (TextUtils.isEmpty((CharSequence)eventType) || expressionArgs == null) {
            LogProxy.e("doBind failed,illegal argument.[" + eventType + "," + expressionArgs + "]");
            return null;
        }
        IEventHandler handler = null;
        Map<String, IEventHandler> handlerMap = null;
        String token = anchor;
        if (this.mBindingCouples != null && !TextUtils.isEmpty((CharSequence)anchor) && (handlerMap = this.mBindingCouples.get(anchor)) != null) {
            handler = handlerMap.get(eventType);
        }
        if (handler == null) {
            LogProxy.d("binding not enabled,try auto enable it.[sourceRef:" + anchor + ",eventType:" + eventType + "]");
            token = this.doPrepare(context, instanceId, anchor, anchorInstanceId, eventType, globalConfig);
            if (!TextUtils.isEmpty((CharSequence)token) && this.mBindingCouples != null && (handlerMap = this.mBindingCouples.get(token)) != null) {
                handler = handlerMap.get(eventType);
            }
        }
        if (handler != null) {
            handler.onBindExpression(eventType, globalConfig, exitExpressionPair, expressionArgs, callback);
            LogProxy.d("createBinding success.[exitExp:" + exitExpressionPair + ",args:" + expressionArgs + "]");
            handler.setInterceptors(interceptors);
            handler.setExtensionParams(extension);
        } else {
            LogProxy.e("internal error.binding failed for ref:" + anchor + ",type:" + eventType);
        }
        return token;
    }

    public void onActivityPause() {
        if (this.mBindingCouples == null) {
            return;
        }
        try {
            for (Map<String, IEventHandler> map : this.mBindingCouples.values()) {
                for (IEventHandler h : map.values()) {
                    try {
                        h.onActivityPause();
                    }
                    catch (Exception e) {
                        LogProxy.e("execute activity pause failed.", e);
                    }
                }
            }
        }
        catch (Exception e) {
            LogProxy.e("activity pause failed", e);
        }
    }

    public void onActivityResume() {
        if (this.mBindingCouples == null) {
            return;
        }
        try {
            for (Map<String, IEventHandler> map : this.mBindingCouples.values()) {
                for (IEventHandler h : map.values()) {
                    try {
                        h.onActivityResume();
                    }
                    catch (Exception e) {
                        LogProxy.e("execute activity pause failed.", e);
                    }
                }
            }
        }
        catch (Exception e) {
            LogProxy.e("activity pause failed", e);
        }
    }

    public void registerEventHandler(String eventType, ObjectCreator<IEventHandler, Context, PlatformManager> creator) {
        if (TextUtils.isEmpty((CharSequence)eventType) || creator == null) {
            return;
        }
        this.mInternalEventHandlerCreatorMap.put(eventType, creator);
    }

    public static void registerGlobalEventHandler(String eventType, ObjectCreator<IEventHandler, Context, PlatformManager> creator) {
        if (TextUtils.isEmpty((CharSequence)eventType) || creator == null) {
            return;
        }
        sGlobalEventHandlerCreatorMap.put(eventType, creator);
    }

    public static boolean unregisterGlobalEventHandler(String eventType) {
        return sGlobalEventHandlerCreatorMap.remove(eventType) != null;
    }

    private String generateToken() {
        return UUID.randomUUID().toString();
    }

    @Nullable
    private IEventHandler createEventHandler(@NonNull Context context, @Nullable String instanceId, @NonNull String eventType) {
        if (this.mInternalEventHandlerCreatorMap.isEmpty() || this.mPlatformManager == null) {
            return null;
        }
        ObjectCreator<IEventHandler, Context, PlatformManager> creator = this.mInternalEventHandlerCreatorMap.get(eventType);
        if (creator == null) {
            creator = sGlobalEventHandlerCreatorMap.get(eventType);
        }
        return creator != null ? creator.createWith(context, this.mPlatformManager, instanceId) : null;
    }

    public static interface JavaScriptCallback {
        public void callback(Object var1);
    }

    public static interface ObjectCreator<Type, ParamA, ParamB> {
        public Type createWith(@NonNull ParamA var1, @NonNull ParamB var2, Object ... var3);
    }
}

