/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.stream;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import cn.rongcloud.rtc.api.RCRTCVideoStream;
import cn.rongcloud.rtc.api.stream.view.RCRTCBaseView;
import cn.rongcloud.rtc.api.stream.view.RCRTCRender;
import cn.rongcloud.rtc.api.stream.view.RCRTCRendererEventsListener;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.EglRenderer;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.plugin.player.utils.MeasureHelper;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class RCRTCVideoView
extends SurfaceView
implements SurfaceHolder.Callback,
RCRTCBaseView {
    private static final String TAG = "SurfaceViewRenderer";
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final Object layoutLock = new Object();
    public int rotatedFrameWidth;
    public int rotatedFrameHeight;
    private int frameRotation;
    private boolean enableFixedSize = false;
    private int surfaceWidth;
    private int surfaceHeight;
    private boolean needCallback = true;
    private RCRTCRender renderer;
    private boolean isInitialized;
    private volatile AtomicBoolean allowRenderer = new AtomicBoolean(true);
    public int drawingMode = 0;
    MeasureHelper mCDNMeasureHelper = null;
    private RCRTCVideoStream videoStream;
    private boolean mirrorHasSet = false;
    @Deprecated
    private OnSizeChangedListener onSizeChangedListener;

    public RCRTCVideoView(Context context) {
        super(context);
        ReportUtil.appStatus(ReportUtil.TAG.INITVIDEOVIEW, "identity", this.hashCode());
        this.resourceName = this.getResourceName();
        this.renderer = new RCRTCRender(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mCDNMeasureHelper = new MeasureHelper((View)this);
    }

    public RCRTCVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        ReportUtil.appStatus(ReportUtil.TAG.INITVIDEOVIEW, "identity", this.hashCode());
        this.resourceName = this.getResourceName();
        this.renderer = new RCRTCRender(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mCDNMeasureHelper = new MeasureHelper((View)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(EglBase.Context context, RCRTCVideoStream videoStream) {
        ThreadUtils.checkIsOnMainThread();
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        if (videoStream == null) {
            throw new NullPointerException("videoStream is Null!");
        }
        Object object = this.layoutLock;
        synchronized (object) {
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = 0;
        }
        ReportUtil.libStatus(ReportUtil.TAG.BINDVIDEOVIEW, "streamId|viewIdentity", videoStream.getStreamId(), this.hashCode());
        this.videoStream = videoStream;
        this.renderer.init(context, videoStream);
    }

    @Override
    public void release() {
        this.renderer.release();
        this.videoStream = null;
        this.isInitialized = false;
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale, RendererCommon.GlDrawer drawer) {
        this.renderer.addFrameListener(listener, scale, drawer);
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale) {
        this.renderer.addFrameListener(listener, scale);
    }

    public void removeFrameListener(EglRenderer.FrameListener listener) {
        this.renderer.removeFrameListener(listener);
    }

    public void setEnableHardwareScalar(boolean enabled) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = enabled;
        this.updateSurfaceSize();
    }

    @Override
    public void setRendererEventsListener(RCRTCRendererEventsListener listener) {
        this.renderer.setRendererEventsListener(listener);
    }

    @Override
    public void setMirror(boolean mirror) {
        ReportUtil.libStatus(ReportUtil.TAG.VIDEOVIEW_STATUS, "mirror", mirror);
        this.renderer.setMirror(mirror);
        this.mirrorHasSet = true;
    }

    public void setMirrorInternal(boolean mirror) {
        if (!this.mirrorHasSet) {
            this.renderer.setMirror(mirror);
        }
    }

    @Override
    public void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        boolean isCDNSurface = this.isCDNSurface();
        ReportUtil.libStatus(ReportUtil.TAG.VIDEOVIEW_STATUS, "ScalingType|isCDNSurface", new Object[]{scalingType, isCDNSurface});
        if (isCDNSurface) {
            int aspectRatio = 0;
            if (scalingType == RendererCommon.ScalingType.SCALE_ASPECT_FIT) {
                aspectRatio = 0;
            } else if (scalingType == RendererCommon.ScalingType.SCALE_ASPECT_FILL) {
                aspectRatio = 1;
            } else if (scalingType == RendererCommon.ScalingType.SCALE_ASPECT_BALANCED) {
                aspectRatio = 1;
            }
            this.mCDNMeasureHelper.setAspectRatio(aspectRatio);
        } else {
            this.videoLayoutMeasure.setScalingType(scalingType);
        }
        this.requestLayout();
    }

    public void setScalingType(RendererCommon.ScalingType scalingTypeMatchOrientation, RendererCommon.ScalingType scalingTypeMismatchOrientation) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingTypeMatchOrientation, scalingTypeMismatchOrientation);
    }

    public RendererCommon.ScalingType getScalingType() {
        return this.videoLayoutMeasure.getActualScalingType();
    }

    public void setFpsReduction(float fps) {
        this.renderer.setFpsReduction(fps);
    }

    public void disableFpsReduction() {
        this.renderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.renderer.pauseVideo();
    }

    public void setAllowRenderer(boolean isAllow) {
        this.allowRenderer.set(isAllow);
    }

    public void clearScreen() {
        this.renderer.clearImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthSpec, int heightSpec) {
        if (this.isCDNSurface()) {
            this.mCDNMeasureHelper.doMeasure(widthSpec, heightSpec);
            this.setMeasuredDimension(this.mCDNMeasureHelper.getMeasuredWidth(), this.mCDNMeasureHelper.getMeasuredHeight());
        } else {
            Point size;
            ThreadUtils.checkIsOnMainThread();
            Object object = this.layoutLock;
            synchronized (object) {
                size = this.videoLayoutMeasure.measure(widthSpec, heightSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
            }
            this.setMeasuredDimension(size.x, size.y);
            if (this.rotatedFrameHeight != 0 && this.rotatedFrameWidth != 0 && this.needCallback && this.onSizeChangedListener != null) {
                this.onSizeChangedListener.onChanged(new Size(this.rotatedFrameWidth, this.rotatedFrameHeight));
                this.needCallback = false;
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        this.renderer.setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
        this.updateSurfaceSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
                int drawnFrameHeight;
                int drawnFrameWidth;
                float frameAspectRatio = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
                float layoutAspectRatio = (float)this.getWidth() / (float)this.getHeight();
                if (frameAspectRatio > layoutAspectRatio) {
                    drawnFrameWidth = (int)((float)this.rotatedFrameHeight * layoutAspectRatio);
                    drawnFrameHeight = this.rotatedFrameHeight;
                } else {
                    drawnFrameWidth = this.rotatedFrameWidth;
                    drawnFrameHeight = (int)((float)this.rotatedFrameWidth / layoutAspectRatio);
                }
                int width = Math.min(this.getWidth(), drawnFrameWidth);
                int height = Math.min(this.getHeight(), drawnFrameHeight);
                FinLog.e(TAG, "updateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + width + "x" + height + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
                if (width != this.surfaceWidth || height != this.surfaceHeight) {
                    this.surfaceWidth = width;
                    this.surfaceHeight = height;
                    this.getHolder().setFixedSize(width, height);
                }
            } else {
                this.surfaceHeight = 0;
                this.surfaceWidth = 0;
                this.getHolder().setSizeFromLayout();
            }
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        ReportUtil.appStatus(ReportUtil.TAG.CREATEVIDEOVIEW, "steamId|viewIdentity", this.getStreamId(), this.hashCode());
        ThreadUtils.checkIsOnMainThread();
        this.renderer.createEglSurface(holder.getSurface());
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        ReportUtil.appStatus(ReportUtil.TAG.DESTROYVIDEOVIEW, "steamId|viewIdentity", this.getStreamId(), this.hashCode());
        final CountDownLatch completionLatch = new CountDownLatch(1);
        this.renderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                completionLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(completionLatch);
    }

    private String getStreamId() {
        RCRTCVideoStream videoStream = this.videoStream;
        if (videoStream != null) {
            return videoStream.getStreamId();
        }
        return "";
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.d((String)TAG, (String)("surfaceChanged: format: " + format + " size: " + width + "x" + height));
    }

    @Override
    public void onFrame(VideoFrame frame) {
        this.onFrameResolutionChanged(frame.getRotatedWidth(), frame.getRotatedHeight(), frame.getRotation());
        this.renderer.onFrame(frame);
    }

    public void onFrameResolutionChanged(int videoWidth, int videoHeight, final int rotation) {
        int rotatedHeight;
        final int rotatedWidth = rotation != 0 && rotation != 180 ? videoHeight : videoWidth;
        int n = rotatedHeight = rotation != 0 && rotation != 180 ? videoWidth : videoHeight;
        if (this.rotatedFrameWidth == rotatedWidth && this.rotatedFrameHeight == rotatedHeight && this.frameRotation == rotation) {
            return;
        }
        this.postOrRun(new Runnable(){

            @Override
            public void run() {
                RCRTCVideoView.this.rotatedFrameWidth = rotatedWidth;
                RCRTCVideoView.this.rotatedFrameHeight = rotatedHeight;
                RCRTCVideoView.this.frameRotation = rotation;
                RCRTCVideoView.this.updateSurfaceSize();
                RCRTCVideoView.this.requestLayout();
                if (RCRTCVideoView.this.onSizeChangedListener == null) {
                    return;
                }
                RCRTCVideoView.this.onSizeChangedListener.onChanged(RCRTCVideoView.this.getSize());
            }
        });
    }

    private void postOrRun(Runnable r) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            r.run();
        } else {
            this.post(r);
        }
    }

    private String getResourceName() {
        try {
            return this.hashCode() + "";
        }
        catch (Resources.NotFoundException e) {
            return "";
        }
    }

    public Size getSize() {
        return new Size(this.rotatedFrameWidth, this.rotatedFrameHeight);
    }

    @Deprecated
    public void setOnSizeChangedListener(OnSizeChangedListener onSizeChangedListener) {
        this.onSizeChangedListener = onSizeChangedListener;
    }

    public void setDrawingMode(int drawingMode) {
        this.drawingMode = drawingMode;
    }

    public void setAspectRatio(int aspectRatio) {
        Log.d((String)TAG, (String)("setAspectRatio : " + aspectRatio));
        if (this.mCDNMeasureHelper != null) {
            this.mCDNMeasureHelper.setAspectRatio(aspectRatio);
            this.requestLayout();
        }
    }

    public void setVideoSize(final int videoWidth, final int videoHeight) {
        this.post(new Runnable(){

            @Override
            public void run() {
                FinLog.d(RCRTCVideoView.TAG, "setVideoSize : videoWidth : " + videoWidth + " , videoHeight : " + videoHeight);
                if (videoWidth > 0 && videoHeight > 0 && RCRTCVideoView.this.mCDNMeasureHelper != null) {
                    RCRTCVideoView.this.mCDNMeasureHelper.setVideoSize(videoWidth, videoHeight);
                    RCRTCVideoView.this.getHolder().setFixedSize(videoWidth, videoHeight);
                    RCRTCVideoView.this.requestLayout();
                } else {
                    ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "videoWidth|videoHeight|MeasureHelper", videoWidth, videoHeight, RCRTCVideoView.this.mCDNMeasureHelper != null);
                }
            }
        });
    }

    public void setVideoSampleAspectRatio(final int videoSarNum, final int videoSarDen) {
        this.post(new Runnable(){

            @Override
            public void run() {
                FinLog.d(RCRTCVideoView.TAG, "videoSarNum : " + videoSarNum + " , videoSarDen : " + videoSarDen);
                if (videoSarNum > 0 && videoSarDen > 0 && RCRTCVideoView.this.mCDNMeasureHelper != null) {
                    RCRTCVideoView.this.mCDNMeasureHelper.setVideoSampleAspectRatio(videoSarNum, videoSarDen);
                    RCRTCVideoView.this.requestLayout();
                }
            }
        });
    }

    private boolean isCDNSurface() {
        return this.mCDNMeasureHelper != null && this.drawingMode == 1;
    }

    @Deprecated
    public static interface OnSizeChangedListener {
        public void onChanged(Size var1);
    }

    public class Size {
        public int with;
        public int height;

        public Size(int with, int height) {
            this.with = with;
            this.height = height;
        }

        public int getHW() {
            return this.with == 0 ? 0 : this.height / this.with;
        }
    }
}

