/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.content.Intent;
import android.text.TextUtils;
import android.view.Menu;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.bridge.ModuleFactoryImpl;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.ui.config.ConfigModuleFactory;
import com.taobao.weex.ui.module.WXDomModule;
import com.taobao.weex.ui.module.WXTimerModule;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.cache.RegisterCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WXModuleManager {
    private static volatile ConcurrentMap<String, ModuleFactoryImpl> sModuleFactoryMap = new ConcurrentHashMap<String, ModuleFactoryImpl>();
    private static Map<String, WXModule> sGlobalModuleMap = new HashMap<String, WXModule>();
    private static Map<String, WXDomModule> sDomModuleMap = new HashMap<String, WXDomModule>();
    private static Map<String, Map<String, WXModule>> sInstanceModuleMap = new ConcurrentHashMap<String, Map<String, WXModule>>();
    private static ArrayList<String> mBlackModuleList;

    public static boolean registerModule(Map<String, RegisterCache.ModuleCache> moduleCacheMap) {
        if (moduleCacheMap.isEmpty()) {
            return true;
        }
        final Iterator<Map.Entry<String, RegisterCache.ModuleCache>> iterator = moduleCacheMap.entrySet().iterator();
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> modules = new HashMap<String, Object>();
                while (iterator.hasNext()) {
                    Map.Entry next = (Map.Entry)iterator.next();
                    RegisterCache.ModuleCache value = (RegisterCache.ModuleCache)next.getValue();
                    String moduleName = value.name;
                    if (TextUtils.equals((CharSequence)moduleName, (CharSequence)"dom")) {
                        WXLogUtils.e("Cannot registered module with name 'dom'.");
                        continue;
                    }
                    if (sModuleFactoryMap != null && sModuleFactoryMap.containsKey(moduleName)) {
                        WXLogUtils.w("WXComponentRegistry Duplicate the Module name: " + moduleName);
                    }
                    ModuleFactory factory = value.factory;
                    try {
                        WXModuleManager.registerNativeModule(moduleName, factory);
                    }
                    catch (WXException e) {
                        WXLogUtils.e("registerNativeModule" + e);
                    }
                    if (value.global) {
                        try {
                            Object wxModule = factory.buildInstance();
                            ((WXModule)wxModule).setModuleName(moduleName);
                            sGlobalModuleMap.put(moduleName, wxModule);
                        }
                        catch (Exception e) {
                            WXLogUtils.e(moduleName + " class must have a default constructor without params. ", e);
                        }
                    }
                    try {
                        sModuleFactoryMap.put(moduleName, new ModuleFactoryImpl(factory));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    modules.put(moduleName, factory.getMethods());
                }
                WXSDKManager.getInstance().registerModules(modules);
            }
        });
        return true;
    }

    public static boolean registerModule(final String moduleName, final ModuleFactory factory, final boolean global) throws WXException {
        if (moduleName == null || factory == null) {
            return false;
        }
        if (TextUtils.equals((CharSequence)moduleName, (CharSequence)"dom")) {
            WXLogUtils.e("Cannot registered module with name 'dom'.");
            return false;
        }
        if (RegisterCache.getInstance().cacheModule(moduleName, factory, global)) {
            return true;
        }
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (sModuleFactoryMap != null && sModuleFactoryMap.containsKey(moduleName)) {
                    WXLogUtils.w("WXComponentRegistry Duplicate the Module name: " + moduleName);
                }
                try {
                    WXModuleManager.registerNativeModule(moduleName, factory);
                }
                catch (WXException e) {
                    WXLogUtils.e("registerNativeModule" + e);
                }
                if (global) {
                    try {
                        Object wxModule = factory.buildInstance();
                        ((WXModule)wxModule).setModuleName(moduleName);
                        sGlobalModuleMap.put(moduleName, wxModule);
                    }
                    catch (Exception e) {
                        WXLogUtils.e(moduleName + " class must have a default constructor without params. ", e);
                    }
                }
                WXModuleManager.registerJSModule(moduleName, factory);
                try {
                    sModuleFactoryMap.put(moduleName, new ModuleFactoryImpl(factory));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        return true;
    }

    static boolean registerNativeModule(String moduleName, ModuleFactory factory) throws WXException {
        if (factory == null) {
            return false;
        }
        try {
            if (!sModuleFactoryMap.containsKey(moduleName)) {
                sModuleFactoryMap.put(moduleName, new ModuleFactoryImpl(factory));
            }
        }
        catch (ArrayStoreException e) {
            e.printStackTrace();
            WXLogUtils.e("[WXModuleManager] registerNativeModule Error moduleName:" + moduleName + " Error:" + e.toString());
        }
        return true;
    }

    static boolean registerJSModule(String moduleName, ModuleFactory factory) {
        HashMap<String, Object> modules = new HashMap<String, Object>();
        modules.put(moduleName, factory.getMethods());
        WXSDKManager.getInstance().registerModules(modules);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args) {
        WXSDKInstance instance;
        ModuleFactory factory = ((ModuleFactoryImpl)WXModuleManager.sModuleFactoryMap.get((Object)moduleStr)).mFactory;
        if (factory == null) {
            WXLogUtils.e("[WXModuleManager] module factory not found.");
            return null;
        }
        WXModule wxModule = WXModuleManager.findModule(instanceId, moduleStr, factory);
        if (wxModule == null) {
            return null;
        }
        wxModule.mWXSDKInstance = instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        wxModule.mUniSDKInstance = instance;
        Invoker invoker = factory.getMethodInvoker(methodStr);
        try {
            if (instance != null) {
                IWXUserTrackAdapter userTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
                if (userTrackAdapter != null) {
                    HashMap<String, Serializable> data = new HashMap<String, Serializable>();
                    data.put("errCode", (Serializable)((Object)"101"));
                    data.put("arg", (Serializable)((Object)(moduleStr + "." + methodStr)));
                    data.put("errMsg", (Serializable)((Object)instance.getBundleUrl()));
                    userTrackAdapter.commit(instance.getContext(), null, "invokeModule", null, data);
                }
                Object object = WXModuleManager.dispatchCallModuleMethod(instance, wxModule, args, invoker);
                return object;
            }
            WXLogUtils.e("callModuleMethod >>> instance is null");
            Object userTrackAdapter = null;
            return userTrackAdapter;
        }
        catch (Exception e) {
            WXLogUtils.e("callModuleMethod >>> invoke module:" + moduleStr + ", method:" + methodStr + " failed. ", e);
            Object var9_12 = null;
            return var9_12;
        }
        finally {
            if (wxModule instanceof WXDomModule || wxModule instanceof WXTimerModule) {
                wxModule.mWXSDKInstance = null;
                wxModule.mUniSDKInstance = null;
            }
        }
    }

    private static Object dispatchCallModuleMethod(@NonNull WXSDKInstance instance, @NonNull WXModule wxModule, @NonNull JSONArray args, @NonNull Invoker invoker) throws Exception {
        if (!instance.isPreRenderMode()) {
            return instance.getNativeInvokeHelper().invoke(wxModule, invoker, args);
        }
        if (invoker.isRunOnUIThread()) {
            return null;
        }
        return instance.getNativeInvokeHelper().invoke(wxModule, invoker, args);
    }

    public static boolean hasModule(String module) {
        return sGlobalModuleMap.containsKey(module) || sModuleFactoryMap.containsKey(module);
    }

    private static WXModule findModule(String instanceId, String moduleStr, ModuleFactory factory) {
        WXModule wxModule = sGlobalModuleMap.get(moduleStr);
        if (wxModule == null) {
            Map<String, WXModule> moduleMap = sInstanceModuleMap.get(instanceId);
            if (moduleMap == null) {
                moduleMap = new ConcurrentHashMap<String, WXModule>();
                sInstanceModuleMap.put(instanceId, moduleMap);
            }
            if ((wxModule = moduleMap.get(moduleStr)) == null) {
                try {
                    if (factory instanceof ConfigModuleFactory) {
                        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
                        wxModule = ((ConfigModuleFactory)factory).buildInstance(instance);
                    } else {
                        wxModule = factory.buildInstance();
                    }
                    wxModule.setModuleName(moduleStr);
                }
                catch (Exception e) {
                    WXLogUtils.e(moduleStr + " module build instace failed.", e);
                    return null;
                }
                moduleMap.put(moduleStr, wxModule);
            }
        }
        return wxModule;
    }

    public static void onActivityCreate(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityCreate();
                    continue;
                }
                WXLogUtils.w("onActivityCreate can not find the " + key + " module");
            }
        }
    }

    public static void onActivityStart(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityStart();
                    continue;
                }
                WXLogUtils.w("onActivityStart can not find the " + key + " module");
            }
        }
    }

    public static void onActivityPause(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityPause();
                    continue;
                }
                WXLogUtils.w("onActivityPause can not find the " + key + " module");
            }
        }
    }

    public static void onActivityResume(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityResume();
                    continue;
                }
                WXLogUtils.w("onActivityResume can not find the " + key + " module");
            }
        }
    }

    public static void onActivityStop(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityStop();
                    continue;
                }
                WXLogUtils.w("onActivityStop can not find the " + key + " module");
            }
        }
    }

    public static void onActivityDestroy(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityDestroy();
                    continue;
                }
                WXLogUtils.w("onActivityDestroy can not find the " + key + " module");
            }
        }
    }

    public static boolean onActivityBack(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    return module.onActivityBack();
                }
                WXLogUtils.w("onActivityCreate can not find the " + key + " module");
            }
        }
        return false;
    }

    public static void onActivityResult(String instanceId, int requestCode, int resultCode, Intent data) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityResult(requestCode, resultCode, data);
                    continue;
                }
                WXLogUtils.w("onActivityResult can not find the " + key + " module");
            }
        }
    }

    public static boolean onCreateOptionsMenu(String instanceId, Menu menu) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onCreateOptionsMenu(menu);
                    continue;
                }
                WXLogUtils.w("onActivityResult can not find the " + key + " module");
            }
        }
        return false;
    }

    public static void onRequestPermissionsResult(String instanceId, int requestCode, String[] permissions, int[] grantResults) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onRequestPermissionsResult(requestCode, permissions, grantResults);
                    continue;
                }
                WXLogUtils.w("onActivityResult can not find the " + key + " module");
            }
        }
    }

    public static void destroyInstanceModules(String instanceId) {
        sDomModuleMap.remove(instanceId);
        Map<String, WXModule> moduleMap = sInstanceModuleMap.remove(instanceId);
        if (moduleMap == null || moduleMap.size() < 1) {
            return;
        }
        for (Map.Entry<String, WXModule> entry : moduleMap.entrySet()) {
            WXModule module = entry.getValue();
            if (!(module instanceof Destroyable)) continue;
            ((Destroyable)((Object)module)).destroy();
        }
    }

    public static void createDomModule(WXSDKInstance instance) {
        if (instance != null) {
            sDomModuleMap.put(instance.getInstanceId(), new WXDomModule(instance));
        }
    }

    public static void destoryDomModule(String instanceID) {
        sDomModuleMap.remove(instanceID);
    }

    public static WXDomModule getDomModule(String instanceId) {
        return sDomModuleMap.get(instanceId);
    }

    public static void reload() {
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            for (Map.Entry entry : sModuleFactoryMap.entrySet()) {
                try {
                    WXModuleManager.registerJSModule((String)entry.getKey(), ((ModuleFactoryImpl)entry.getValue()).mFactory);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void registerWhenCreateInstance() {
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            for (Map.Entry entry : sModuleFactoryMap.entrySet()) {
                try {
                    if (((ModuleFactoryImpl)entry.getValue()).hasRigster) continue;
                    WXModuleManager.registerJSModule((String)entry.getKey(), ((ModuleFactoryImpl)entry.getValue()).mFactory);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void resetAllModuleState() {
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            for (Map.Entry entry : sModuleFactoryMap.entrySet()) {
                ((ModuleFactoryImpl)entry.getValue()).hasRigster = false;
            }
        }
    }

    public static void resetModuleState(String module, boolean state) {
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            for (Map.Entry entry : sModuleFactoryMap.entrySet()) {
                try {
                    if (entry.getKey() == null || !((String)entry.getKey()).equals(module)) continue;
                    ((ModuleFactoryImpl)entry.getValue()).hasRigster = state;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static JSONObject getRegisterJsModules() {
        JSONObject data = null;
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            data = new JSONObject();
            for (Map.Entry entry : sModuleFactoryMap.entrySet()) {
                try {
                    if (WXModuleManager.getBlackList().contains(entry.getKey()) || ((ModuleFactoryImpl)entry.getValue()).mFactory == null) continue;
                    String[] methods = ((ModuleFactoryImpl)entry.getValue()).mFactory.getMethods();
                    JSONArray array = WXModuleManager.modulesToJSONArray(methods, ((ModuleFactoryImpl)entry.getValue()).mFactory);
                    data.put((String)entry.getKey(), (Object)array);
                }
                catch (Throwable throwable) {}
            }
        }
        return data;
    }

    private static ArrayList<String> getBlackList() {
        if (mBlackModuleList == null) {
            mBlackModuleList = new ArrayList();
            mBlackModuleList.add("webview");
            mBlackModuleList.add("animation");
            mBlackModuleList.add("binding");
            mBlackModuleList.add("bindingx");
            mBlackModuleList.add("instanceWrap");
            mBlackModuleList.add("meta");
            mBlackModuleList.add("navigator");
            mBlackModuleList.add("expressionBinding");
        }
        return mBlackModuleList;
    }

    public static JSONArray modulesToJSONArray(String[] json, ModuleFactory factory) {
        JSONArray jsonArray = null;
        if (json != null && json.length > 0) {
            for (int i = 0; i < json.length; ++i) {
                if (jsonArray == null) {
                    jsonArray = new JSONArray();
                }
                String sync = ":sync";
                String async = ":async";
                if (json[i].equals("addEventListener") || json[i].equals("removeAllEventListeners")) continue;
                String key = json[i];
                boolean isSync = !factory.getMethodInvoker(key).isRunOnUIThread();
                jsonArray.add((Object)(json[i] + (isSync ? sync : async)));
            }
        }
        return jsonArray;
    }
}

