/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.tools;

import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCCDNInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RCRTCSubscribeState;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCRTCAudioInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCRTCCDNInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoInputStreamImpl;
import cn.rongcloud.rtc.engine.AudienceState;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.ResourceTools;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HandleChatRoomKVTools {
    public static final String TAG = "HandleChatRoomKVTools";
    private RCRoomImpl room;
    private IRCRTCRoomEventsListener eventsListener;
    private AudienceState audienceState;
    private Map<String, JSONObject> cacheRes;

    public HandleChatRoomKVTools(RCRoomImpl room, AudienceState state) {
        this.room = room;
        this.audienceState = state;
        this.eventsListener = room.getEventsListener();
        this.cacheRes = new HashMap<String, JSONObject>();
    }

    public void handleChatRoomKVUpdate(String roomId, Map<String, String> chatRoomKvMap) {
        RCRTCRemoteUser liveUser;
        boolean needNotify;
        if (chatRoomKvMap.isEmpty()) {
            return;
        }
        if (this.room == null || !TextUtils.equals((CharSequence)roomId, (CharSequence)this.room.getRoomId())) {
            FinLog.e(TAG, "ChatRoomKVUpdate: RTCRoom is null || roomId not equals current RTCRoomId");
            return;
        }
        boolean needReSubscribe = false;
        if (chatRoomKvMap.containsKey("RC_ANCHOR_LIST")) {
            needReSubscribe = this.onHandleAnchorListChange(chatRoomKvMap.get("RC_ANCHOR_LIST"));
            chatRoomKvMap.remove("RC_ANCHOR_LIST");
        }
        if (chatRoomKvMap.containsKey("RC_RTC_SESSIONID")) {
            this.room.setSessionId(chatRoomKvMap.get("RC_RTC_SESSIONID"));
            chatRoomKvMap.remove("RC_RTC_SESSIONID");
        }
        String value = null;
        for (Map.Entry<String, String> entry : chatRoomKvMap.entrySet()) {
            if (!entry.getKey().startsWith("RC_RES_")) continue;
            FinLog.i(TAG, "KV :: remote publish" + (String)entry.getValue());
            String userId = ((String)entry.getKey()).substring("RC_RES_".length());
            RCRTCRemoteUser remoteUser = this.room.getRemoteUser(userId);
            if (remoteUser == null) continue;
            if (this.onHandleAnchorResourceChange(roomId, (RCRemoteUserImpl)remoteUser, (String)entry.getValue())) {
                needReSubscribe = true;
            }
            if (TextUtils.isEmpty(value)) {
                value = (String)entry.getValue();
            }
            try {
                JSONObject json = new JSONObject((String)entry.getValue());
                this.cacheRes.put(userId, json);
                if (!TextUtils.isEmpty((CharSequence)value) || !json.has("mcu_uris")) continue;
                value = (String)entry.getValue();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (!TextUtils.isEmpty(value)) {
            try {
                Pair<RCRTCRemoteUser, Boolean> res = HandleChatRoomKVTools.updateLiveStreams(this.room, value, this.room.getRoomId(), this.room.getRoomType(), this.eventsListener);
                if (!needReSubscribe) {
                    needReSubscribe = (Boolean)res.second;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (!(needNotify = this.cacheRes.isEmpty())) {
            for (JSONObject obj : this.cacheRes.values()) {
                String str = obj.optString("uris");
                if (!TextUtils.isEmpty((CharSequence)str) && !TextUtils.equals((CharSequence)"[]", (CharSequence)str)) {
                    needNotify = false;
                    break;
                }
                needNotify = true;
            }
        }
        if (needNotify && (liveUser = this.room.getVirtualLiveUser()) != null && !RongRTCUtils.isEmpty(liveUser.getStreams())) {
            this.room.setVirtualLiveUser(null);
            needReSubscribe = true;
            if (this.eventsListener != null) {
                this.eventsListener.onUnpublishLiveStreams(liveUser.getStreams());
            }
        }
        if (needReSubscribe) {
            this.audienceState.resubscribeStreams();
        }
        if (chatRoomKvMap.containsKey("RC_CDN")) {
            liveUser = this.room.getVirtualLiveUser();
            String json_cdn = chatRoomKvMap.remove("RC_CDN");
            HandleChatRoomKVTools.updateCDNStream(this.room, liveUser, json_cdn, this.room.getRoomId(), this.room.getRoomType(), this.eventsListener);
        }
    }

    private boolean onHandleAnchorResourceChange(String roomId, RCRemoteUserImpl remoteUser, String value) {
        FinLog.d(TAG, "onHandleAnchorResourceChange: userId=" + remoteUser.getUserId() + " , value=" + value);
        if (TextUtils.isEmpty((CharSequence)value)) {
            List<RCRTCInputStream> streams = remoteUser.getStreams();
            if (!RongRTCUtils.isEmpty(streams)) {
                if (this.eventsListener != null) {
                    this.eventsListener.onRemoteUserUnpublishResource(remoteUser, remoteUser.getStreams());
                }
                remoteUser.clearStream();
            }
            return false;
        }
        try {
            return HandleChatRoomKVTools.updateRemoteUserRes(remoteUser, value, this.eventsListener);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Pair<RCRTCRemoteUser, Boolean> updateLiveStreams(RCRoomImpl room, String value, String roomId, RCRTCRoomType roomType, IRCRTCRoomEventsListener eventsListener) throws JSONException {
        RCRTCRemoteUser liveUser;
        RCRTCRemoteUser rCRTCRemoteUser = liveUser = room != null ? room.getVirtualLiveUser() : null;
        if (TextUtils.isEmpty((CharSequence)value)) {
            return Pair.create((Object)liveUser, (Object)false);
        }
        JSONObject obj = new JSONObject(value);
        String uriStr = obj.optString("mcu_uris");
        if (TextUtils.isEmpty((CharSequence)uriStr)) {
            return Pair.create((Object)liveUser, (Object)false);
        }
        JSONArray mcu_uris = new JSONArray(uriStr);
        ArrayList<RCRTCInputStream> currentMCUStreams = new ArrayList<RCRTCInputStream>();
        ArrayList<RCRTCInputStream> newPubStreams = new ArrayList<RCRTCInputStream>();
        boolean needReSubscribe = false;
        for (int i = 0; i < mcu_uris.length(); ++i) {
            RCRTCInputStream stream;
            MediaResourceInfo res = new MediaResourceInfo(mcu_uris.getJSONObject(i), "");
            if (liveUser == null) {
                liveUser = HandleChatRoomKVTools.createUserByMediaInfo(res);
                if (room != null) {
                    room.setVirtualLiveUser(liveUser);
                }
            }
            if ((stream = liveUser.getStream(res.getTag(), res.getType())) == null) {
                if (res.getType() == RCRTCMediaType.AUDIO) {
                    stream = new RCRTCAudioInputStreamImpl(liveUser.getUserId(), true, res);
                } else {
                    stream = new RCVideoInputStreamImpl(liveUser.getUserId(), res);
                    ((RCVideoInputStreamImpl)stream).setStreamType(RCRTCStreamType.NORMAL);
                }
                newPubStreams.add(stream);
                ((RCRemoteUserImpl)liveUser).addStream(stream);
            } else if (!TextUtils.equals((CharSequence)stream.getUri(), (CharSequence)res.getUri())) {
                if (!needReSubscribe) {
                    needReSubscribe = ((RCInputStreamImpl)stream).getSubscribeState() == RCRTCSubscribeState.SUBSCRIBED;
                }
                FinLog.e(TAG, "updateLiveStreams: oldUri=" + stream.getUri() + " , newUri=" + res.getUri());
                ((RCInputStreamImpl)stream).setUri(res.getUri());
            }
            currentMCUStreams.add(stream);
            ResourceTools.liveStreams.put(stream.getStreamId(), stream.getTag());
        }
        if (RongRTCUtils.isEmpty(currentMCUStreams) && room != null) {
            liveUser = room.getVirtualLiveUser();
            needReSubscribe = liveUser != null;
            room.setVirtualLiveUser(null);
            ResourceTools.liveStreams.clear();
        }
        if (eventsListener != null) {
            if (!newPubStreams.isEmpty()) {
                eventsListener.onPublishLiveStreams(newPubStreams);
            }
            if (liveUser != null) {
                List<RCRTCInputStream> streams = liveUser.getStreams();
                streams.removeAll(currentMCUStreams);
                if (!streams.isEmpty()) {
                    eventsListener.onUnpublishLiveStreams(streams);
                }
            }
        }
        return Pair.create((Object)liveUser, (Object)needReSubscribe);
    }

    public static boolean updateRemoteUserRes(RCRemoteUserImpl remoteUser, String value, IRCRTCRoomEventsListener eventsListener) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        JSONObject obj = new JSONObject(value);
        String uriStr = obj.optString("uris");
        if (TextUtils.isEmpty((CharSequence)uriStr)) {
            FinLog.e(TAG, "updateRemoteUserRes uris is null");
            if (!RongRTCUtils.isEmpty(remoteUser.getStreams())) {
                if (eventsListener != null) {
                    eventsListener.onRemoteUserUnpublishResource(remoteUser, remoteUser.getStreams());
                }
                remoteUser.clearStream();
            }
            return false;
        }
        JSONArray uris = new JSONArray(uriStr);
        ArrayList<RCRTCInputStream> temp = new ArrayList<RCRTCInputStream>();
        ArrayList<RCRTCInputStream> newPubStreams = new ArrayList<RCRTCInputStream>();
        boolean needReSubscribe = false;
        for (int i = 0; i < uris.length(); ++i) {
            MediaResourceInfo res = new MediaResourceInfo(uris.getJSONObject(i), remoteUser.getUserId());
            RCRTCInputStream stream = remoteUser.getStream(res.getTag(), res.getType());
            if (stream == null) {
                stream = res.getType() == RCRTCMediaType.AUDIO ? new RCRTCAudioInputStreamImpl(remoteUser.getUserId(), res) : new RCVideoInputStreamImpl(remoteUser.getUserId(), res);
                newPubStreams.add(stream);
                remoteUser.addStream(stream);
            } else {
                if (!TextUtils.equals((CharSequence)stream.getUri(), (CharSequence)res.getUri())) {
                    if (!needReSubscribe) {
                        needReSubscribe = ((RCInputStreamImpl)stream).getSubscribeState() == RCRTCSubscribeState.SUBSCRIBED;
                    }
                    ((RCInputStreamImpl)stream).setUri(res.getUri());
                }
                if (stream.getResourceState() != res.getRCRTCResourceState()) {
                    ((RCInputStreamImpl)stream).setResourceState(res.getRCRTCResourceState());
                    if (TextUtils.equals((CharSequence)"RongCloudRTC", (CharSequence)stream.getTag()) && eventsListener != null) {
                        boolean isMute;
                        boolean bl = isMute = res.getRCRTCResourceState() == RCRTCResourceState.DISABLED;
                        if (res.getType() == RCRTCMediaType.AUDIO) {
                            eventsListener.onRemoteUserMuteAudio(remoteUser, stream, isMute);
                        } else {
                            eventsListener.onRemoteUserMuteVideo(remoteUser, stream, isMute);
                        }
                    }
                }
            }
            temp.add(stream);
        }
        if (eventsListener != null && !newPubStreams.isEmpty()) {
            eventsListener.onRemoteUserPublishResource(remoteUser, newPubStreams);
        }
        List<RCRTCInputStream> streams = remoteUser.getStreams();
        streams.removeAll(temp);
        if (eventsListener != null && !streams.isEmpty()) {
            for (RCRTCInputStream stream : streams) {
                if (!needReSubscribe) {
                    needReSubscribe = ((RCInputStreamImpl)stream).getSubscribeState() == RCRTCSubscribeState.SUBSCRIBED;
                }
                remoteUser.removeStream(stream.getStreamId(), stream.getMediaType());
            }
            eventsListener.onRemoteUserUnpublishResource(remoteUser, streams);
        }
        return needReSubscribe;
    }

    public static RCRTCRemoteUser createUserByMediaInfo(MediaResourceInfo res) {
        int n;
        String userId;
        String realUserId = userId = res.getStreamId();
        if (!TextUtils.isEmpty((CharSequence)userId) && (n = userId.lastIndexOf(95)) > 0 && n < userId.length()) {
            realUserId = userId.substring(0, n);
        }
        return new RCRemoteUserImpl(realUserId, "");
    }

    private boolean onHandleAnchorListChange(String value) {
        FinLog.d(TAG, "onHandleAnchorListChange: " + value);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        try {
            RCRTCRemoteUser liveUser;
            boolean reSubscribe = false;
            JSONArray array = new JSONArray(value);
            ArrayList<RCRTCRemoteUser> currentRemoteUser = new ArrayList<RCRTCRemoteUser>();
            for (int i = 0; i < array.length(); ++i) {
                Object remoteUser = this.room.getRemoteUser(array.getString(i));
                if (remoteUser == null) {
                    remoteUser = this.addRemoteUser(array.optString(i));
                }
                currentRemoteUser.add((RCRTCRemoteUser)remoteUser);
            }
            List<RCRTCRemoteUser> remoteUsers = this.room.getRemoteUsers();
            remoteUsers.removeAll(currentRemoteUser);
            for (RCRTCRemoteUser remoteUser : remoteUsers) {
                if (!reSubscribe) {
                    reSubscribe = HandleChatRoomKVTools.hasSubscribedStream(remoteUser.getStreams());
                }
                this.room.removeRemoteUser(remoteUser.getUserId());
                this.eventsListener.onUserLeft(remoteUser);
                this.cacheRes.remove(remoteUser.getUserId());
            }
            if (this.room.getRemoteUsers().isEmpty() && (liveUser = this.room.getVirtualLiveUser()) != null) {
                this.room.setVirtualLiveUser(null);
                List<RCRTCInputStream> streams = liveUser.getStreams();
                if (!reSubscribe) {
                    reSubscribe = HandleChatRoomKVTools.hasSubscribedStream(streams);
                }
                if (!streams.isEmpty()) {
                    this.eventsListener.onUnpublishLiveStreams(streams);
                }
            }
            return reSubscribe;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean hasSubscribedStream(List<RCRTCInputStream> streams) {
        for (RCRTCInputStream stream : streams) {
            if (((RCInputStreamImpl)stream).getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) continue;
            return true;
        }
        return false;
    }

    private RCRTCRemoteUser addRemoteUser(String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            FinLog.e(TAG, "addRemoteUser: userId is Null");
            return null;
        }
        RCRemoteUserImpl remoteUser = new RCRemoteUserImpl(userId, "");
        this.room.addRemoteUser(remoteUser);
        this.eventsListener.onUserJoined(remoteUser);
        return remoteUser;
    }

    public void ChatRoomKVRemove(String roomId, Map<String, String> chatRoomKvMap) {
        if (this.room == null || !TextUtils.equals((CharSequence)roomId, (CharSequence)this.room.getRoomId())) {
            FinLog.e(TAG, "ChatRoomKVRemove: RTCRoom is null || roomId not equals RTCRoomId");
            return;
        }
        for (Map.Entry<String, String> entry : chatRoomKvMap.entrySet()) {
            String userId;
            RCRTCRemoteUser remoteUser;
            if (!entry.getKey().startsWith("RC_RES_") || (remoteUser = this.room.getRemoteUser(userId = entry.getKey().substring("RC_RES_".length()))) == null) continue;
            List<RCRTCInputStream> streams = remoteUser.getStreams();
            if (!streams.isEmpty()) {
                this.eventsListener.onRemoteUserUnpublishResource(remoteUser, streams);
            }
            ((RCRemoteUserImpl)remoteUser).clearStream();
        }
    }

    public void release() {
        this.room = null;
        this.eventsListener = null;
    }

    public static void updateCDNStream(RCRoomImpl room, RCRTCRemoteUser liveUser, String value, String roomId, RCRTCRoomType roomType, IRCRTCRoomEventsListener eventsListener) {
        try {
            RCRTCCDNInputStream rcrtccdnInputStream = null;
            JSONObject obj = new JSONObject(value);
            String json = obj.optString("cdn_uris");
            FinLog.d(TAG, "cdnUris : " + json);
            if (!TextUtils.isEmpty((CharSequence)json)) {
                RCRTCRoomType roomTypeTmp;
                String localCDNUri = "";
                String cdnServer = "";
                int CDNStreamWidth = 0;
                int CDNStreamHeight = 0;
                int CDNStreamFPS = 0;
                boolean pull_safe = false;
                if (liveUser != null && ((RCRemoteUserImpl)liveUser).getCDNInputStream() != null) {
                    localCDNUri = ((RCRTCCDNInputStreamImpl)((RCRemoteUserImpl)liveUser).getCDNInputStream()).getCDNServer();
                }
                FinLog.d(TAG, "cdnUris->localCDNUri : " + localCDNUri);
                JSONArray jsonArray = new JSONArray(json);
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                if (jsonObject.has("url")) {
                    cdnServer = jsonObject.optString("url");
                }
                if (jsonObject.has("w")) {
                    CDNStreamWidth = jsonObject.optInt("w");
                }
                if (jsonObject.has("h")) {
                    CDNStreamHeight = jsonObject.optInt("h");
                }
                if (jsonObject.has("fps")) {
                    CDNStreamFPS = jsonObject.optInt("fps");
                }
                if (jsonObject.has("pull_safe")) {
                    pull_safe = jsonObject.optBoolean("pull_safe");
                }
                int tmpWidth = CDNStreamWidth;
                int tmpHeight = CDNStreamHeight;
                if (CDNStreamWidth > CDNStreamHeight) {
                    tmpWidth = CDNStreamHeight;
                    tmpHeight = CDNStreamWidth;
                }
                RCRTCParamsType.RCRTCVideoResolution videoResolution = RCRTCParamsType.RCRTCVideoResolution.parseVideoResolution(tmpWidth, tmpHeight);
                RCRTCParamsType.RCRTCVideoFps videoFps = RCRTCParamsType.RCRTCVideoFps.parseVideoFps(CDNStreamFPS);
                String roomIdTmp = "";
                if (room != null) {
                    roomIdTmp = room.getRoomId();
                    roomTypeTmp = room.getRoomType();
                } else {
                    roomIdTmp = roomId;
                    roomTypeTmp = roomType;
                }
                boolean replay = true;
                if (!TextUtils.isEmpty((CharSequence)cdnServer)) {
                    if (liveUser != null) {
                        if (((RCRemoteUserImpl)liveUser).getCDNInputStream() != null) {
                            rcrtccdnInputStream = ((RCRemoteUserImpl)liveUser).getCDNInputStream();
                            if (room != null && room.getCDNStream() != null) {
                                ((RCRTCCDNInputStreamImpl)rcrtccdnInputStream).setStreamConfig(room.getCDNStream().getVideoResolution(), room.getCDNStream().getVideoFps());
                            }
                            ((RCRTCCDNInputStreamImpl)rcrtccdnInputStream).setOriginalMaximum(CDNStreamWidth, CDNStreamHeight);
                            ((RCRTCCDNInputStreamImpl)rcrtccdnInputStream).setHighestFPS(videoFps);
                            ((RCRTCCDNInputStreamImpl)rcrtccdnInputStream).setHighestResolution(videoResolution);
                        } else {
                            rcrtccdnInputStream = new RCRTCCDNInputStreamImpl(cdnServer, roomTypeTmp, roomIdTmp, videoResolution, videoFps, pull_safe, CDNStreamWidth, CDNStreamHeight);
                            ((RCRemoteUserImpl)liveUser).setCDNInputStream(rcrtccdnInputStream);
                        }
                        if (TextUtils.isEmpty((CharSequence)localCDNUri)) {
                            FinLog.d(TAG, "cdnUris->need publish");
                            replay = false;
                            if (eventsListener != null) {
                                eventsListener.onPublishCDNStream(rcrtccdnInputStream);
                            }
                        } else if (!cdnServer.equals(localCDNUri)) {
                            replay = false;
                            RTCEngineImpl.getInstance().sendMessage(5053, (Object)rcrtccdnInputStream);
                        }
                    } else {
                        FinLog.e(TAG, "cdnUris->liveUser is empty.Unable to add CDN stream");
                        if (room.getRemoteUsers().size() == 0 && liveUser == null) {
                            RTCEngineImpl.getInstance().sendMessage(5046, new Object[0]);
                            rcrtccdnInputStream = new RCRTCCDNInputStreamImpl(cdnServer, roomTypeTmp, roomIdTmp, videoResolution, videoFps, pull_safe, CDNStreamWidth, CDNStreamHeight);
                            replay = false;
                            if (eventsListener != null) {
                                eventsListener.onUnpublishCDNStream(rcrtccdnInputStream);
                            }
                        }
                    }
                } else if (!TextUtils.isEmpty((CharSequence)localCDNUri)) {
                    if (liveUser != null) {
                        FinLog.d(TAG, "cdnUris->removeCDNStream");
                        ((RCRemoteUserImpl)liveUser).removeCDNStream();
                    }
                    RTCEngineImpl.getInstance().sendMessage(5046, new Object[0]);
                    FinLog.d(TAG, "cdnUris->need Unpublish");
                    replay = false;
                    if (eventsListener != null) {
                        rcrtccdnInputStream = new RCRTCCDNInputStreamImpl(localCDNUri, roomTypeTmp, roomIdTmp, videoResolution, videoFps, pull_safe, CDNStreamWidth, CDNStreamHeight);
                        eventsListener.onUnpublishCDNStream(rcrtccdnInputStream);
                    }
                }
                if (replay && rcrtccdnInputStream != null && ((RCInputStreamImpl)((Object)rcrtccdnInputStream)).getSubscribeState() == RCRTCSubscribeState.SUBSCRIBED) {
                    int desiredWidth = ((RCRTCCDNInputStreamImpl)rcrtccdnInputStream).getDesiredWidth();
                    int desiredHeight = ((RCRTCCDNInputStreamImpl)rcrtccdnInputStream).getDesiredHeight();
                    if (desiredWidth > 0 && desiredHeight > 0) {
                        ReportUtil.libStatus(ReportUtil.TAG.PLAYER_STATE, "desiredWidth|desiredHeight|highestWidth|highestHeight", desiredWidth, desiredHeight, CDNStreamWidth, CDNStreamHeight);
                        if (CDNStreamWidth > CDNStreamHeight != desiredWidth > desiredHeight) {
                            RCRTCParamsType.RCRTCVideoFps tmpFps = ((RCRTCCDNInputStreamImpl)rcrtccdnInputStream).getDesiredFPS();
                            int tmpDesiredFPS = CDNStreamFPS;
                            if (tmpFps != null) {
                                tmpDesiredFPS = tmpFps.getFps();
                            }
                            RTCEngineImpl.getInstance().sendMessage(5058, desiredHeight, desiredWidth, tmpDesiredFPS);
                        }
                    }
                }
            } else {
                ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "updateCDNStream", "cdn_uris is empty");
            }
        }
        catch (JSONException e) {
            ReportUtil.libError(ReportUtil.TAG.PLAYER_STATE, "updateCDNStream", "JSONException : " + (Object)((Object)e));
        }
    }
}

