/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.os.Handler;
import cn.rongcloud.rtc.api.RCRTCOtherRoom;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCOtherRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCLiveRole;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.imlib.model.Message;
import java.util.List;

public class RCRoomListenerWrapper
extends IRCRTCOtherRoomEventsListener {
    private IRCRTCOtherRoomEventsListener mEventsListener;
    private Handler mCallBackHandler;
    private String roomId;

    public RCRoomListenerWrapper(String roomId, Handler callBackHandler) {
        this.mCallBackHandler = callBackHandler;
        this.roomId = roomId;
    }

    public void setEventsListener(IRCRTCOtherRoomEventsListener eventsListener) {
        this.mEventsListener = eventsListener;
    }

    public void release() {
        this.mCallBackHandler = null;
        this.mEventsListener = null;
    }

    private void postCallback(Runnable runnable) {
        Handler callBackHandler = this.mCallBackHandler;
        if (callBackHandler == null || this.mEventsListener == null) {
            return;
        }
        callBackHandler.post(runnable);
    }

    @Override
    public void onRemoteUserPublishResource(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser, final List<RCRTCInputStream> streams) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERPUBLISHRESOURCE, "isOtherRoom|roomId|userId|resource", true, this.roomId, remoteUser.getUserId(), ReportUtil.streamToString(streams));
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onRemoteUserPublishResource(room, remoteUser, streams);
                }
            }
        });
    }

    @Override
    public void onRemoteUserMuteAudio(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser, final RCRTCInputStream stream, final boolean mute) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERMODIFYRESOURCE, "isOtherRoom|roomId|userId|mediaType|isMute", true, this.roomId, remoteUser.getUserId(), RCRTCMediaType.AUDIO.getDescription(), mute);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onRemoteUserMuteAudio(room, remoteUser, stream, mute);
                }
            }
        });
    }

    @Override
    public void onRemoteUserMuteVideo(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser, final RCRTCInputStream stream, final boolean mute) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERMODIFYRESOURCE, "isOtherRoom|roomId|userId|mediaType|isMute", true, this.roomId, remoteUser.getUserId(), RCRTCMediaType.VIDEO.getDescription(), mute);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onRemoteUserMuteVideo(room, remoteUser, stream, mute);
                }
            }
        });
    }

    @Override
    public void onRemoteUserUnpublishResource(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser, final List<RCRTCInputStream> streams) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERUNPUBLISHRESOURCE, "isOtherRoom|roomId|userId|resource", true, this.roomId, remoteUser.getUserId(), ReportUtil.streamToString(streams));
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onRemoteUserUnpublishResource(room, remoteUser, streams);
                }
            }
        });
    }

    @Override
    public void onUserJoined(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERJOINED, "isOtherRoom|roomId|userId", true, this.roomId, remoteUser.getUserId());
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onUserJoined(room, remoteUser);
                }
            }
        });
    }

    @Override
    public void onUserLeft(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERLEFT, "isOtherRoom|roomId|userId", true, this.roomId, remoteUser.getUserId());
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onUserLeft(room, remoteUser);
                }
            }
        });
    }

    @Override
    public void onUserOffline(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSEROFFLINE, "isOtherRoom|roomId|userId", true, this.roomId, remoteUser.getUserId());
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onUserOffline(room, remoteUser);
                }
            }
        });
    }

    @Override
    public void onLeaveRoom(final RCRTCOtherRoom room, final int reasonCode) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onLeaveRoom(room, reasonCode);
                }
            }
        });
    }

    @Override
    public void onVideoTrackAdd(final RCRTCOtherRoom room, final String userId, final String tag) {
        super.onVideoTrackAdd(room, userId, tag);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onVideoTrackAdd(room, userId, tag);
                }
            }
        });
    }

    @Override
    public void onFirstRemoteVideoFrame(final RCRTCOtherRoom room, final String userId, final String tag) {
        super.onFirstRemoteVideoFrame(room, userId, tag);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onFirstRemoteVideoFrame(room, userId, tag);
                }
            }
        });
    }

    @Override
    public void onReceiveMessage(final RCRTCOtherRoom room, final Message message) {
        super.onReceiveMessage(room, message);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onReceiveMessage(room, message);
                }
            }
        });
    }

    @Override
    public void onKickedByServer(final RCRTCOtherRoom room) {
        super.onKickedByServer(room);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onKickedByServer(room);
                }
            }
        });
    }

    @Override
    public void onSwitchRole(final String userId, final RCRTCLiveRole role) {
        super.onSwitchRole(userId, role);
        ReportUtil.libStatus(ReportUtil.TAG.SWITCH_ROLE, "isOtherRoom|roomId|userId|role", true, this.roomId, userId, role.name());
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCOtherRoomEventsListener mEventsListener = RCRoomListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onSwitchRole(userId, role);
                }
            }
        });
    }
}

