/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import android.opengl.GLES20;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.ugc.videoprocessor.videoeffect.TXCGPUEffectFilterBase;

public class TXCGPURockFilter
extends TXCGPUEffectFilterBase {
    private static final int DURATION_LIVEWAVE_LVMIN = 120;
    private static final int DURATION_LIVEWAVE = 70;
    private static final int INTERVAL = 400;
    private static final String FRAGMENT_SHADER = "precision highp float; \nvarying vec2 textureCoordinate; \nuniform sampler2D inputImageTexture; \nuniform float t; \nuniform float st; \nconst float stride = 7.0; \nconst float interval = 1.0; \nuniform float zMin; \nuniform float zMax; \nuniform vec2 center; \nuniform vec2 offsetR; \nuniform vec2 offsetG; \nuniform vec2 offsetB;\n\nfloat GetFactor(float elapse, float astride, float ainterval, float amp) \n{ \n   float ff = mod(elapse, astride + ainterval) / astride; \n   if (ff > 1.0) \n   { \n       ff = 0.0; \n   } \n   return pow(ff, 3.0) * 1.125 * amp; \n} \nvec2 _uv(vec2 uv, vec2 center, float zz, float min) \n{ \n   return uv + (zz + min) * (center - uv); \n} \nvoid main() \n{ \n   vec4 fout; \n   float zz = GetFactor(t - st, stride, interval, zMax - zMin); \n   float coeff = pow(zz, 0.75); \n   fout.r = texture2D(inputImageTexture, _uv(textureCoordinate, center, zz, zMin) + offsetR * coeff).r;\n   fout.g = texture2D(inputImageTexture, _uv(textureCoordinate, center, zz, zMin) + offsetG * coeff).g;\n   fout.b = texture2D(inputImageTexture, _uv(textureCoordinate, center, zz, zMin) + offsetB * coeff).b;\n   gl_FragColor = vec4(fout.rgb, 1.0); \n}\n";
    private int mZMinLocation = -1;
    private int mZMaxLocation = -1;
    private int mDurationLocation = -1;
    private int mCurrentLocation = -1;
    private int mCenterLocation = -1;
    private int mOffsetRLocation = -1;
    private int mOffsetGLocation = -1;
    private int mOffsetBLocation = -1;
    private DongGanLightParam mDongGanParam = null;

    public TXCGPURockFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", FRAGMENT_SHADER);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
    }

    @Override
    public void onInit(e texturePool) {
        super.onInit(texturePool);
        this.mZMinLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"zMin");
        this.mZMaxLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"zMax");
        this.mDurationLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"t");
        this.mCurrentLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"st");
        this.mCenterLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"center");
        this.mOffsetRLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"offsetR");
        this.mOffsetGLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"offsetG");
        this.mOffsetBLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"offsetB");
    }

    @Override
    public void setNextFrameTimestamp(long pts) {
        long l2;
        super.setNextFrameTimestamp(pts);
        if (this.mDongGanParam == null) {
            this.mDongGanParam = new DongGanLightParam();
            this.mDongGanParam.duration = 8.0f;
            this.mDongGanParam.center = new float[]{0.5f, 0.5f};
            this.mDongGanParam.zoomMin = 0.0f;
            this.mDongGanParam.zoomMax = 0.2f;
        }
        if ((l2 = Math.abs(pts - this.mEffectStartTime)) < 120L) {
            this.mDongGanParam.current = 0.0f;
            this.mDongGanParam.duration = 8.0f;
            this.mDongGanParam.center = new float[]{0.0f, 0.0f};
            this.mDongGanParam.zoomMin = 0.0f;
            this.mDongGanParam.zoomMax = 0.0f;
            this.mDongGanParam.offetRed = new float[]{0.0f, 0.0f};
            this.mDongGanParam.offsetGreen = new float[]{0.0f, 0.0f};
        } else {
            for (int i2 = 1; i2 <= 8; ++i2) {
                if (l2 >= (long)(120 + 70 * i2)) continue;
                this.mDongGanParam.current = i2;
                this.mDongGanParam.duration = 8.0f;
                this.mDongGanParam.center = new float[]{0.5f, 0.5f};
                this.mDongGanParam.zoomMin = 0.0f;
                this.mDongGanParam.zoomMax = 0.3f;
                if (i2 >= 3) {
                    this.mDongGanParam.offetRed = new float[]{-0.1f, 0.0f};
                    this.mDongGanParam.offsetGreen = new float[]{0.0f, 0.1f};
                    break;
                }
                this.mDongGanParam.offetRed = new float[]{0.0f, 0.0f};
                this.mDongGanParam.offsetGreen = new float[]{0.0f, 0.0f};
                break;
            }
            if (l2 > 680L) {
                if (l2 <= 1080L) {
                    this.mDongGanParam.current = 0.0f;
                    this.mDongGanParam.duration = 8.0f;
                    this.mDongGanParam.center = new float[]{0.0f, 0.0f};
                    this.mDongGanParam.zoomMin = 0.0f;
                    this.mDongGanParam.zoomMax = 0.0f;
                    this.mDongGanParam.offetRed = new float[]{0.0f, 0.0f};
                    this.mDongGanParam.offsetGreen = new float[]{0.0f, 0.0f};
                } else {
                    this.mEffectStartTime = -1L;
                }
            }
        }
        this.updateParamsToOpenGL();
    }

    private void updateParamsToOpenGL() {
        TXCGPURockFilter tXCGPURockFilter = this;
        tXCGPURockFilter.setOffset(tXCGPURockFilter.mDongGanParam.offetRed, this.mDongGanParam.offsetGreen, this.mDongGanParam.offsetBlue);
        TXCGPURockFilter tXCGPURockFilter2 = this;
        tXCGPURockFilter2.setFloatVec2OnDraw(tXCGPURockFilter2.mCenterLocation, this.mDongGanParam.center);
        TXCGPURockFilter tXCGPURockFilter3 = this;
        tXCGPURockFilter3.setZoom(tXCGPURockFilter3.mDongGanParam.zoomMin, this.mDongGanParam.zoomMax);
        TXCGPURockFilter tXCGPURockFilter4 = this;
        tXCGPURockFilter4.setDuration(tXCGPURockFilter4.mDongGanParam.duration);
        TXCGPURockFilter tXCGPURockFilter5 = this;
        tXCGPURockFilter5.setCurrent(tXCGPURockFilter5.mDongGanParam.current);
    }

    private void setOffset(float[] r2, float[] g2, float[] b2) {
        TXCGPURockFilter tXCGPURockFilter = this;
        tXCGPURockFilter.setFloatVec2OnDraw(tXCGPURockFilter.mOffsetRLocation, r2);
        TXCGPURockFilter tXCGPURockFilter2 = this;
        tXCGPURockFilter2.setFloatVec2OnDraw(tXCGPURockFilter2.mOffsetGLocation, g2);
        TXCGPURockFilter tXCGPURockFilter3 = this;
        tXCGPURockFilter3.setFloatVec2OnDraw(tXCGPURockFilter3.mOffsetBLocation, b2);
    }

    private void setZoom(float min, float max) {
        TXCGPURockFilter tXCGPURockFilter = this;
        tXCGPURockFilter.setFloatOnDraw(tXCGPURockFilter.mZMinLocation, min);
        TXCGPURockFilter tXCGPURockFilter2 = this;
        tXCGPURockFilter2.setFloatOnDraw(tXCGPURockFilter2.mZMaxLocation, max);
    }

    private void setDuration(float duration) {
        TXCGPURockFilter tXCGPURockFilter = this;
        tXCGPURockFilter.setFloatOnDraw(tXCGPURockFilter.mDurationLocation, duration);
    }

    private void setCurrent(float current) {
        TXCGPURockFilter tXCGPURockFilter = this;
        tXCGPURockFilter.setFloatOnDraw(tXCGPURockFilter.mCurrentLocation, current);
    }

    public static class DongGanLightParam
    extends TXCGPUEffectFilterBase.VideoEffectParams {
        public float zoomMin = 0.0f;
        public float zoomMax = 0.4f;
        public float[] center = new float[]{0.5f, 0.5f};
        public float current = 0.0f;
        public float duration = 10.0f;
        public float[] offetRed = new float[]{0.0f, 0.0f};
        public float[] offsetGreen = new float[]{0.0f, 0.0f};
        public float[] offsetBlue = new float[]{0.0f, 0.0f};
    }
}

