/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FileDownloadSerialQueue {
    private final Object operationLock = new Object();
    private final BlockingQueue<BaseDownloadTask> mTasks = new LinkedBlockingQueue<BaseDownloadTask>();
    private final List<BaseDownloadTask> pausedList = new ArrayList<BaseDownloadTask>();
    private final HandlerThread mHandlerThread = new HandlerThread(FileDownloadUtils.getThreadPoolName("SerialDownloadManager"));
    private final Handler mHandler;
    private static final int WHAT_NEXT = 1;
    public static final int ID_INVALID = 0;
    volatile BaseDownloadTask workingTask;
    final SerialFinishCallback finishCallback;
    volatile boolean paused = false;

    public FileDownloadSerialQueue() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper(), (Handler.Callback)new SerialLoop());
        this.finishCallback = new SerialFinishCallback(new WeakReference<FileDownloadSerialQueue>(this));
        this.sendNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(BaseDownloadTask task) {
        SerialFinishCallback serialFinishCallback = this.finishCallback;
        synchronized (serialFinishCallback) {
            if (this.paused) {
                this.pausedList.add(task);
                return;
            }
            try {
                this.mTasks.put(task);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        SerialFinishCallback serialFinishCallback = this.finishCallback;
        synchronized (serialFinishCallback) {
            if (this.paused) {
                FileDownloadLog.w(this, "require pause this queue(remain %d), but it has already been paused", this.mTasks.size());
                return;
            }
            this.paused = true;
            this.mTasks.drainTo(this.pausedList);
            if (this.workingTask != null) {
                this.workingTask.removeFinishListener(this.finishCallback);
                this.workingTask.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        SerialFinishCallback serialFinishCallback = this.finishCallback;
        synchronized (serialFinishCallback) {
            if (!this.paused) {
                FileDownloadLog.w(this, "require resume this queue(remain %d), but it is still running", this.mTasks.size());
                return;
            }
            this.paused = false;
            this.mTasks.addAll(this.pausedList);
            this.pausedList.clear();
            if (this.workingTask == null) {
                this.sendNext();
            } else {
                this.workingTask.addFinishListener(this.finishCallback);
                this.workingTask.start();
            }
        }
    }

    public int getWorkingTaskId() {
        return this.workingTask != null ? this.workingTask.getId() : 0;
    }

    public int getWaitingTaskCount() {
        return this.mTasks.size() + this.pausedList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseDownloadTask> shutdown() {
        SerialFinishCallback serialFinishCallback = this.finishCallback;
        synchronized (serialFinishCallback) {
            if (this.workingTask != null) {
                this.pause();
            }
            ArrayList<BaseDownloadTask> unDealTaskList = new ArrayList<BaseDownloadTask>(this.pausedList);
            this.pausedList.clear();
            this.mHandler.removeMessages(1);
            this.mHandlerThread.interrupt();
            this.mHandlerThread.quit();
            return unDealTaskList;
        }
    }

    private void sendNext() {
        this.mHandler.sendEmptyMessage(1);
    }

    private static class SerialFinishCallback
    implements BaseDownloadTask.FinishListener {
        private final WeakReference<FileDownloadSerialQueue> mQueueWeakReference;

        SerialFinishCallback(WeakReference<FileDownloadSerialQueue> queueWeakReference) {
            this.mQueueWeakReference = queueWeakReference;
        }

        @Override
        public synchronized void over(BaseDownloadTask task) {
            task.removeFinishListener(this);
            if (this.mQueueWeakReference == null) {
                return;
            }
            FileDownloadSerialQueue queue = (FileDownloadSerialQueue)this.mQueueWeakReference.get();
            if (queue == null) {
                return;
            }
            queue.workingTask = null;
            if (queue.paused) {
                return;
            }
            queue.sendNext();
        }
    }

    private class SerialLoop
    implements Handler.Callback {
        private SerialLoop() {
        }

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    try {
                        if (FileDownloadSerialQueue.this.paused) break;
                        FileDownloadSerialQueue.this.workingTask = (BaseDownloadTask)FileDownloadSerialQueue.this.mTasks.take();
                        FileDownloadSerialQueue.this.workingTask.addFinishListener(FileDownloadSerialQueue.this.finishCallback).start();
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
            }
            return false;
        }
    }
}

