/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.net.Uri;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.font.FontAdapter;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypefaceUtil {
    public static final String FONT_CACHE_DIR_NAME = "font-family";
    private static final String TAG = "TypefaceUtil";
    private static final Map<String, FontDO> sCacheMap = new HashMap<String, FontDO>();
    public static final String ACTION_TYPE_FACE_AVAILABLE = "type_face_available";

    public static void putFontDO(FontDO fontDO) {
        if (fontDO != null && !TextUtils.isEmpty((CharSequence)fontDO.getFontFamilyName())) {
            sCacheMap.put(fontDO.getFontFamilyName(), fontDO);
        }
    }

    public static void registerNativeFont(Map<String, Typeface> fonts) {
        if (fonts != null && fonts.size() > 0) {
            for (Map.Entry<String, Typeface> font : fonts.entrySet()) {
                FontDO fontDO = new FontDO(font.getKey(), font.getValue());
                TypefaceUtil.putFontDO(fontDO);
                if (!WXEnvironment.isApkDebugable()) continue;
                WXLogUtils.d(TAG, "register new typeface: " + font.getKey());
            }
        }
    }

    public static FontDO getFontDO(String fontFamilyName) {
        return sCacheMap.get(fontFamilyName);
    }

    public static void removeFontDO(String fontFamilyName) {
        sCacheMap.remove(fontFamilyName);
    }

    public static void applyFontStyle(Paint paint, int style, int weight, String family) {
        Typeface typeface = paint.getTypeface();
        int oldStyle = typeface == null ? 0 : typeface.getStyle();
        int want = 0;
        if (weight == 1 || (oldStyle & 1) != 0 && weight == -1) {
            want |= 1;
        }
        if (style == 2 || (oldStyle & 2) != 0 && style == -1) {
            want |= 2;
        }
        if (family != null) {
            typeface = TypefaceUtil.getOrCreateTypeface(family, want);
        }
        if (typeface != null) {
            paint.setTypeface(Typeface.create((Typeface)typeface, (int)want));
        } else {
            paint.setTypeface(Typeface.defaultFromStyle((int)want));
        }
        if (style >= 0) {
            int typefaceStyle = paint.getTypeface() != null ? paint.getTypeface().getStyle() : 0;
            int need = style & ~typefaceStyle;
            paint.setTextSkewX((need & 2) != 0 ? -0.2f : 0.0f);
        }
    }

    public static Typeface getOrCreateTypeface(String family, int style) {
        FontDO fontDo = sCacheMap.get(family);
        if (fontDo != null && fontDo.getTypeface() != null) {
            return fontDo.getTypeface();
        }
        return Typeface.create((String)family, (int)style);
    }

    private static void loadFromAsset(FontDO fontDo, String path) {
        try {
            Typeface typeface = Typeface.createFromAsset((AssetManager)WXEnvironment.getApplication().getAssets(), (String)path);
            if (typeface != null) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(TAG, "load asset file success");
                }
                fontDo.setState(2);
                fontDo.setTypeface(typeface);
            } else {
                WXLogUtils.e(TAG, "Font asset file not found " + fontDo.getUrl());
            }
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e.toString());
        }
    }

    public static void loadTypeface(FontDO fontDo, boolean notify) {
        if (fontDo != null && fontDo.getTypeface() == null && (fontDo.getState() == 3 || fontDo.getState() == 0)) {
            boolean result;
            fontDo.setState(1);
            if (fontDo.getType() == 3) {
                Uri uri = Uri.parse((String)fontDo.getUrl());
                TypefaceUtil.loadFromAsset(fontDo, uri.getPath().substring(1));
            } else if (fontDo.getType() == 1) {
                String fullPath;
                String url = fontDo.getUrl();
                String fontFamily = fontDo.getFontFamilyName();
                String fileName = WXFileUtils.md5(url);
                File dir = new File(TypefaceUtil.getFontCacheDir());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!TypefaceUtil.loadLocalFontFile(fullPath = dir.getAbsolutePath() + File.separator + fileName, fontFamily, false)) {
                    TypefaceUtil.downloadFontByNetwork(url, fullPath, fontFamily);
                }
            } else if (!(fontDo.getType() != 2 && fontDo.getType() != 5 || (result = TypefaceUtil.loadLocalFontFile(fontDo.getUrl(), fontDo.getFontFamilyName(), false)))) {
                fontDo.setState(3);
            }
            return;
        }
        if (notify) {
            TypefaceUtil.notifyFontAvailable(false, fontDo);
        }
    }

    private static void downloadFontByNetwork(final String url, final String fullPath, final String fontFamily) {
        IWXHttpAdapter adapter = WXSDKManager.getInstance().getIWXHttpAdapter();
        if (adapter == null) {
            WXLogUtils.e(TAG, "downloadFontByNetwork() IWXHttpAdapter == null");
            return;
        }
        WXRequest request = new WXRequest();
        request.url = url;
        request.method = "GET";
        adapter.sendRequest(request, new IWXHttpAdapter.OnHttpListener(){

            @Override
            public void onHttpStart() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(TypefaceUtil.TAG, "downloadFontByNetwork begin url:" + url);
                }
            }

            @Override
            public void onHeadersReceived(int statusCode, Map<String, List<String>> headers) {
            }

            @Override
            public void onHttpUploadProgress(int uploadProgress) {
            }

            @Override
            public void onHttpResponseProgress(int loadedLength) {
            }

            @Override
            public void onHttpFinish(WXResponse response) {
                FontDO fontDO;
                boolean result;
                int statusCode = 0;
                if (!TextUtils.isEmpty((CharSequence)response.statusCode)) {
                    try {
                        statusCode = Integer.parseInt(response.statusCode);
                    }
                    catch (NumberFormatException e) {
                        statusCode = 0;
                        WXLogUtils.e(TypefaceUtil.TAG, "IWXHttpAdapter onHttpFinish statusCode:" + response.statusCode);
                    }
                }
                if (statusCode >= 200 && statusCode <= 299 && response.originalData != null) {
                    result = WXFileUtils.saveFile(fullPath, response.originalData, (Context)WXEnvironment.getApplication());
                    if (result) {
                        result = TypefaceUtil.loadLocalFontFile(fullPath, fontFamily, true);
                    } else if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.d(TypefaceUtil.TAG, "downloadFontByNetwork() onHttpFinish success, but save file failed.");
                    }
                } else {
                    result = false;
                }
                if (!result && (fontDO = (FontDO)sCacheMap.get(fontFamily)) != null) {
                    fontDO.setState(3);
                }
            }
        });
    }

    private static boolean loadLocalFontFile(String path, String fontFamily, boolean hasNetworkDowload) {
        if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)fontFamily)) {
            return false;
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                return false;
            }
            Typeface typeface = Typeface.createFromFile((String)path);
            if (typeface != null) {
                final FontDO fontDo = sCacheMap.get(fontFamily);
                if (fontDo != null) {
                    fontDo.setState(2);
                    fontDo.setTypeface(typeface);
                    fontDo.setFilePath(path);
                    if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.d(TAG, "load local font file success");
                    }
                    if (hasNetworkDowload) {
                        WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                TypefaceUtil.notifyFontAvailable(true, fontDo);
                            }
                        }, 100L);
                    } else {
                        TypefaceUtil.notifyFontAvailable(true, fontDo);
                    }
                    return true;
                }
            } else {
                WXLogUtils.e(TAG, "load local font file failed, can't create font.");
            }
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e.toString());
        }
        return false;
    }

    private static void notifyFontAvailable(boolean sendBroadcast, FontDO fontDO) {
        FontAdapter fontAdapter;
        if (sendBroadcast) {
            Intent intent = new Intent(ACTION_TYPE_FACE_AVAILABLE);
            intent.putExtra("fontFamily", fontDO.getFontFamilyName());
            intent.putExtra("filePath", fontDO.getFilePath());
            intent.putExtra("fontUrl", fontDO.getUrl());
            LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).sendBroadcast(intent);
        }
        if ((fontAdapter = WXSDKManager.getInstance().getFontAdapter()) != null) {
            fontAdapter.onFontLoad(fontDO.getFontFamilyName(), fontDO.getUrl(), fontDO.getFilePath());
        }
    }

    private static String getFontCacheDir() {
        return WXEnvironment.getApplication().getCacheDir() + "/" + FONT_CACHE_DIR_NAME;
    }
}

