/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vanniktech.emoji.EmojiImageView;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import java.util.List;

public final class EmojiVariantPopup {
    private static final int MARGIN = 2;
    @NonNull
    private final View rootView;
    @Nullable
    private PopupWindow popupWindow;
    @Nullable
    final OnEmojiClickListener listener;
    @Nullable
    EmojiImageView rootImageView;

    public EmojiVariantPopup(@NonNull View rootView, @Nullable OnEmojiClickListener listener) {
        this.rootView = rootView;
        this.listener = listener;
    }

    public void show(@NonNull EmojiImageView clickedImage, @NonNull Emoji emoji) {
        this.dismiss();
        this.rootImageView = clickedImage;
        View content = this.initView(clickedImage.getContext(), emoji, clickedImage.getWidth());
        this.popupWindow = new PopupWindow(content, -2, -2);
        this.popupWindow.setFocusable(true);
        this.popupWindow.setOutsideTouchable(true);
        this.popupWindow.setInputMethodMode(2);
        this.popupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable(clickedImage.getContext().getResources(), (Bitmap)null));
        content.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        Point location = Utils.locationOnScreen((View)clickedImage);
        Point desiredLocation = new Point(location.x - content.getMeasuredWidth() / 2 + clickedImage.getWidth() / 2, location.y - content.getMeasuredHeight());
        this.popupWindow.showAtLocation(this.rootView, 0, desiredLocation.x, desiredLocation.y);
        this.rootImageView.getParent().requestDisallowInterceptTouchEvent(true);
        Utils.fixPopupLocation(this.popupWindow, desiredLocation);
    }

    public void dismiss() {
        this.rootImageView = null;
        if (this.popupWindow != null) {
            this.popupWindow.dismiss();
            this.popupWindow = null;
        }
    }

    private View initView(@NonNull Context context, @NonNull Emoji emoji, int width) {
        View result = View.inflate((Context)context, (int)R.layout.emoji_popup_window_skin, null);
        LinearLayout imageContainer = (LinearLayout)result.findViewById(R.id.emojiPopupWindowSkinPopupContainer);
        List<Emoji> variants = emoji.getBase().getVariants();
        variants.add(0, emoji.getBase());
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        for (final Emoji variant : variants) {
            ImageView emojiImage = (ImageView)inflater.inflate(R.layout.emoji_adapter_item, (ViewGroup)imageContainer, false);
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)emojiImage.getLayoutParams();
            int margin = Utils.dpToPx(context, 2.0f);
            layoutParams.width = width;
            layoutParams.setMargins(margin, margin, margin, margin);
            emojiImage.setImageDrawable(variant.getDrawable(context));
            emojiImage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (EmojiVariantPopup.this.listener != null && EmojiVariantPopup.this.rootImageView != null) {
                        EmojiVariantPopup.this.listener.onEmojiClick(EmojiVariantPopup.this.rootImageView, variant);
                    }
                }
            });
            imageContainer.addView((View)emojiImage);
        }
        return result;
    }
}

