/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.media.player.api;

import cn.rongcloud.rtc.media.player.RCMediaPlayer;
import java.util.Locale;
import org.json.JSONObject;

public class PlayerModuleUtils {
    private static RCMediaPlayer mMediaPlayer = null;
    private static PlayerLogLevel mLogLevel = PlayerLogLevel.LOG_ERROR;

    public static void init(RCMediaPlayer player) {
        mMediaPlayer = player;
    }

    public static String getStatusJSON() {
        String json = "";
        JSONObject jsonObject = new JSONObject();
        try {
            if (mMediaPlayer != null) {
                int vdec = mMediaPlayer.getVideoDecoder();
                switch (vdec) {
                    case 1: {
                        jsonObject.putOpt("codecType", (Object)"avcodec");
                        break;
                    }
                    case 2: {
                        jsonObject.putOpt("codecType", (Object)"MediaCodec");
                        break;
                    }
                    default: {
                        jsonObject.putOpt("codecType", (Object)"");
                    }
                }
                float fpsDecode = mMediaPlayer.getVideoDecodeFramesPerSecond();
                jsonObject.putOpt("fpsDecode", (Object)String.format(Locale.US, "%.2f", Float.valueOf(fpsDecode)));
                float fpsOutput = mMediaPlayer.getVideoOutputFramesPerSecond();
                jsonObject.putOpt("fpsOutput", (Object)String.format(Locale.US, "%.2f", Float.valueOf(fpsOutput)));
                long tcpSpeed = mMediaPlayer.getTcpSpeed();
                jsonObject.putOpt("tcpSpeed", (Object)String.format(Locale.US, "%s", PlayerModuleUtils.formatedSpeed(tcpSpeed, 1000L)));
                json = jsonObject.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    private static String formatedSpeed(long bytes, long elapsed_milli) {
        if (elapsed_milli <= 0L) {
            return "0 B/s";
        }
        if (bytes <= 0L) {
            return "0 B/s";
        }
        return String.format(Locale.US, "%.1f KB/s", Float.valueOf(PlayerModuleUtils.formatedSpeed(bytes)));
    }

    public static float formatedSpeed(long bytes_per_sec) {
        if (bytes_per_sec == -1L) {
            return -1.0f;
        }
        if (bytes_per_sec == 0L) {
            return 0.0f;
        }
        return (float)bytes_per_sec / 1000.0f;
    }

    public static void setPlayerLogLevel(PlayerLogLevel logLevel) {
        mLogLevel = logLevel;
    }

    public static PlayerLogLevel getPlayerLogLevel() {
        return mLogLevel;
    }

    public static enum PlayerLogLevel {
        LOG_VERBOSE(2),
        LOG_DEBUG(3),
        LOG_WARN(5),
        LOG_ERROR(6),
        LOG_FATAL(7);

        private int code;

        public int getCode() {
            return this.code;
        }

        private PlayerLogLevel(int val) {
            this.code = val;
        }
    }
}

