/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.handler;

import com.ksyun.ks3.exception.Ks3Error;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.model.ObjectMetadata;
import com.ksyun.ks3.model.result.HeadObjectResult;
import com.ksyun.ks3.services.handler.Ks3HttpResponceHandler;
import com.ksyun.ks3.util.DateUtil;
import com.ksyun.ks3.util.StringUtils;
import cz.msebera.android.httpclient.Header;

public abstract class HeadObjectResponseHandler
extends Ks3HttpResponceHandler {
    public abstract void onFailure(int var1, Ks3Error var2, Header[] var3, String var4, Throwable var5);

    public abstract void onSuccess(int var1, Header[] var2, HeadObjectResult var3);

    @Override
    public final void onSuccess(int statesCode, Header[] responceHeaders, byte[] response) {
        this.onSuccess(statesCode, responceHeaders, this.parseHeaders(responceHeaders));
    }

    @Override
    public final void onFailure(int statesCode, Header[] responceHeaders, byte[] response, Throwable throwable) {
        Ks3Error error = new Ks3Error(statesCode, response, throwable);
        this.onFailure(statesCode, error, responceHeaders, response == null ? "" : new String(response), throwable);
    }

    @Override
    public final void onProgress(long bytesWritten, long totalSize) {
    }

    @Override
    public final void onStart() {
    }

    @Override
    public final void onFinish() {
    }

    @Override
    public final void onCancel() {
    }

    private HeadObjectResult parseHeaders(Header[] responceHeaders) {
        HeadObjectResult result = new HeadObjectResult();
        ObjectMetadata meta = new ObjectMetadata();
        try {
            for (int i = 0; i < responceHeaders.length; ++i) {
                String dateStr;
                Header h = responceHeaders[i];
                if (HttpHeaders.ETag.toString().equalsIgnoreCase(h.getName())) {
                    result.setETag(h.getValue());
                }
                if (HttpHeaders.LastModified.toString().equalsIgnoreCase(h.getName()) && !StringUtils.isBlank(dateStr = h.getValue())) {
                    result.setLastmodified(DateUtil.ConverToDate(dateStr));
                }
                if (h.getName().startsWith("x-kss-meta-")) {
                    meta.addOrEditUserMeta(h.getName(), h.getValue());
                } else if (h.getName().equalsIgnoreCase(ObjectMetadata.Meta.CacheControl.toString())) {
                    meta.setCacheControl(h.getValue());
                } else if (h.getName().equalsIgnoreCase(ObjectMetadata.Meta.ContentDisposition.toString())) {
                    meta.setContentDisposition(h.getValue());
                } else if (h.getName().equalsIgnoreCase(ObjectMetadata.Meta.ContentEncoding.toString())) {
                    meta.setContentEncoding(h.getValue());
                } else if (h.getName().equalsIgnoreCase(ObjectMetadata.Meta.ContentLength.toString())) {
                    meta.setContentLength(h.getValue());
                } else if (h.getName().equalsIgnoreCase(ObjectMetadata.Meta.ContentType.toString())) {
                    meta.setContentType(h.getValue());
                } else if (h.getName().equalsIgnoreCase(ObjectMetadata.Meta.Expires.toString())) {
                    meta.setExpires(h.getValue());
                } else if (h.getName().equalsIgnoreCase(ObjectMetadata.Meta.XKssObjectTagCount.toString())) {
                    meta.setObjectTagCount(h.getValue());
                }
                result.setObjectMetadata(meta);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return result;
    }
}

