/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.webkit.ClientCertRequest;
import android.webkit.WebView;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.daya.orchestra.accompany.bean.AccompanyStartParams;
import com.daya.orchestra.accompany.bean.MusicSaveParams;
import com.daya.orchestra.accompany.bean.WebConfig;
import com.daya.orchestra.accompany.callback.ResultCallback;
import com.daya.orchestra.accompany.common.AccompanyEventImpl;
import com.daya.orchestra.accompany.common.Config;
import com.daya.orchestra.accompany.common.Constants;
import com.daya.orchestra.accompany.common.WebConstants;
import com.daya.orchestra.accompany.helper.CacheHelper;
import com.daya.orchestra.accompany.utils.ALOG;
import com.daya.orchestra.accompany.utils.Utils;
import com.daya.orchestra.accompany.web.AccompanyActivity;
import com.daya.orchestra.accompany.widget.BaseDelayCheckView;
import java.io.File;
import org.json.JSONObject;

public class AccompanyManager {
    private AccompanyEventImpl mAccompanyEvent;

    private AccompanyManager() {
    }

    public static AccompanyManager getInstance() {
        return AccompanyManagerHolder.mManager;
    }

    public void selectPicture(Fragment fragment, ActivityResultLauncher<Intent> imgSelectResultLauncher) {
        if (this.mAccompanyEvent != null) {
            this.mAccompanyEvent.selectPicture(fragment, imgSelectResultLauncher);
        }
    }

    public void init(Application application, AccompanyEventImpl accompanyEvent) {
        Utils.init(application);
        this.mAccompanyEvent = accompanyEvent;
    }

    public void setWebConfig(WebConfig webConfig) {
        WebConstants.WEB_UA_PARAMS = webConfig.getWeb_UA_params();
        WebConstants.WEB_JS_INTERFACE = webConfig.getWebJsInterfaceName();
        String customWebSocketUrl = webConfig.getCustomWebSocketUrl();
        if (!TextUtils.isEmpty((CharSequence)customWebSocketUrl)) {
            WebConstants.WEB_SOCKET_URL_CUSTOM = customWebSocketUrl;
        }
    }

    public void login(String userId, String userToken) {
        CacheHelper.setUserId(userId);
        CacheHelper.setUserToken(userToken);
    }

    public void setLogDebugMode(boolean isDebug) {
        ALOG.setDebugMode(isDebug);
        Constants.DEBUG = isDebug;
    }

    public void openMusicMergePage(Activity activity, MusicSaveParams musicSaveParams, int requestCode) {
        if (this.mAccompanyEvent != null) {
            this.mAccompanyEvent.openMusicMergePage(activity, musicSaveParams, requestCode);
        }
    }

    public void setLoadingAnimRes(@LayoutRes int layoutRes) {
        this.setLoadingAnimRes(layoutRes, 0);
    }

    public BaseDelayCheckView getDelayCheckAnim(Context context) {
        if (this.mAccompanyEvent != null) {
            return this.mAccompanyEvent.getDelayCheckView(context);
        }
        return null;
    }

    public void setLoadingAnimRes(@LayoutRes int layoutRes, @DrawableRes int iconRes) {
        Config.getInstance().setLoadingRes(layoutRes);
        Config.getInstance().setLoadingBackIconRes(iconRes);
    }

    public void showPermissionTipDialog(FragmentManager fragmentmanager, Context context, String title, String tip) {
        if (this.mAccompanyEvent != null) {
            this.mAccompanyEvent.showPermissionTipDialog(fragmentmanager, context, title, tip);
        }
    }

    public String getBaseServerUrl() {
        if (this.mAccompanyEvent != null) {
            return this.mAccompanyEvent.getBaseServerUrl();
        }
        return "";
    }

    public void toUpload(Activity activity, File file, String bucketName, String uploadPath, ResultCallback<Object> resultCallback) {
        if (this.mAccompanyEvent != null) {
            this.mAccompanyEvent.toUpload(activity, file, bucketName, uploadPath, resultCallback);
        }
    }

    public void loginOut() {
        if (this.mAccompanyEvent != null) {
            this.mAccompanyEvent.logout();
        }
    }

    public void goChat(String userId, String name) {
        if (this.mAccompanyEvent != null) {
            this.mAccompanyEvent.goChat(userId, name);
        }
    }

    public void openWebView(JSONObject jsonObject) {
        if (this.mAccompanyEvent != null) {
            this.mAccompanyEvent.openWebView(jsonObject);
        }
    }

    public boolean onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
        if (this.mAccompanyEvent != null) {
            return this.mAccompanyEvent.onReceivedClientCertRequest(view, request);
        }
        return false;
    }

    public void startAccompany(Context context, AccompanyStartParams params) {
        ALOG.i("startAccompany:" + params.toString());
        Intent intent = new Intent(context, AccompanyActivity.class);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        intent.putExtra("web_url", params.getUrl());
        intent.putExtra("isHideTitle", params.isHideTitle());
        intent.putExtra("isOpenLight", params.isOpenLight());
        int orientation = params.getOrientation();
        if (orientation != -1) {
            intent.putExtra("orientation", orientation);
        }
        int cOrientation = params.getC_orientation();
        if (params.getC_orientation() != -1) {
            intent.putExtra("c_orientation", cOrientation);
        }
        context.startActivity(intent);
    }

    public void clearDelay() {
        CacheHelper.setCustomCache("blankDelayCache", 0);
    }

    private static class AccompanyManagerHolder {
        private static final AccompanyManager mManager = new AccompanyManager();

        private AccompanyManagerHolder() {
        }
    }
}

