/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.js;

import android.app.Activity;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import android.view.Window;
import android.webkit.JavascriptInterface;
import com.daya.orchestra.accompany.common.AccompanyManager;
import com.daya.orchestra.accompany.helper.CacheHelper;
import com.daya.orchestra.accompany.helper.QMUINotchHelper;
import com.daya.orchestra.accompany.utils.ALOG;
import org.json.JSONObject;

public class JsInterfaceAccomPanyUtils {
    private static final String TAG = "JsInterfaceAccomPany";
    private Activity activity;
    JSONObject resultJson;
    public onGetMethodsListener onListener;

    public JsInterfaceAccomPanyUtils(Activity activity) {
        this.activity = activity;
    }

    @JavascriptInterface
    public String getTokenSync() {
        Log.i((String)TAG, (String)"getTokenSync");
        String userToken = CacheHelper.getUserToken();
        return userToken;
    }

    @JavascriptInterface
    public void postMessage(String message) {
        this.activity.runOnUiThread(() -> {
            try {
                String key;
                JSONObject content;
                ALOG.i("receiveMessage:" + message);
                JSONObject jsonObject = new JSONObject(message);
                String api = jsonObject.getString("api");
                if ("back".equals(api)) {
                    this.activity.finish();
                } else if ("login".equals(api)) {
                    AccompanyManager.getInstance().loginOut();
                    this.activity.finish();
                } else if (TextUtils.equals((CharSequence)"cloudLoading", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudLoading(jsonObject);
                    }
                } else if ("openConversationActivity".equals(api)) {
                    JSONObject contentBean = jsonObject.getJSONObject("content");
                    if (null != contentBean) {
                        String userId = contentBean.optString("userId");
                        String name = contentBean.optString("name");
                        AccompanyManager.getInstance().goChat(userId, name);
                    }
                } else if ("videoUpdate".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.videoUpdate(jsonObject);
                    }
                } else if ("setRequestedOrientation".equals(api)) {
                    content = jsonObject.getJSONObject("content");
                    int orientation = content.getInt("orientation");
                    this.activity.setRequestedOrientation(orientation);
                    if (this.onListener != null) {
                        this.onListener.onSendMessage(content.toString());
                    }
                } else if ("keepScreenLongLight".equals(api)) {
                    content = jsonObject.getJSONObject("content");
                    boolean isOpenLight = content.getBoolean("isOpenLight");
                    this.keepScreenLongLight(isOpenLight);
                    if (this.onListener != null) {
                        this.onListener.keepScreenLongLight(jsonObject);
                    }
                } else if ("setStatusBarTextColor".equals(api)) {
                    content = jsonObject.getJSONObject("content");
                    boolean statusBarTextColor = content.getBoolean("statusBarTextColor");
                    if (this.onListener != null) {
                        this.onListener.setStatusBarTextColor(statusBarTextColor, jsonObject);
                    }
                } else if ("isSpecialShapedScreen".equals(api)) {
                    content = jsonObject.getJSONObject("content");
                    content.put("isSpecialShapedScreen", QMUINotchHelper.hasNotch(this.activity));
                    content.put("notchHeight", QMUINotchHelper.getSafeInsetTop(this.activity));
                    if (this.onListener != null) {
                        this.onListener.onSendMessage(jsonObject.toString());
                    }
                } else if ("openWebView".equals(api)) {
                    AccompanyManager.getInstance().openWebView(jsonObject);
                } else if ("openAccompanyWebView".equals(api)) {
                    content = jsonObject.getJSONObject("content");
                    boolean isHideTitle = false;
                    boolean statusBarTextColor = false;
                    boolean isOpenLight = false;
                    int orientation = -1;
                    try {
                        isHideTitle = content.optBoolean("isHideTitle");
                        statusBarTextColor = content.optBoolean("statusBarTextColor");
                        isOpenLight = content.optBoolean("isOpenLight");
                        orientation = content.optInt("orientation");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Intent intent = new Intent();
                    intent.putExtra("url", content.optString("url"));
                    intent.putExtra("isHideTitle", isHideTitle);
                    intent.putExtra("statusBarTextColor", statusBarTextColor);
                    intent.putExtra("isOpenLight", isOpenLight);
                    intent.putExtra("orientation", orientation);
                    if (this.activity != null) {
                        this.activity.startActivity(intent);
                    }
                } else if ("startEvaluating".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.startEvaluating(jsonObject);
                    }
                } else if ("endEvaluating".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.endEvaluating(jsonObject);
                    }
                } else if ("cancelEvaluating".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cancelEvaluating();
                        this.onListener.onSendMessage(message);
                    }
                } else if ("startRecording".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.startRecording(jsonObject);
                    }
                } else if ("pauseRecording".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.pauseRecording(jsonObject);
                    }
                } else if ("resumeRecording".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.resumeRecording(jsonObject);
                    }
                } else if ("isWiredHeadsetOn".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.isWiredHeadsetOn(jsonObject);
                    }
                } else if ("proxyMessage".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.proxyMessage(jsonObject);
                    }
                } else if ("openCamera".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.openCamera(jsonObject);
                    }
                } else if ("closeCamera".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.closeCamera(jsonObject);
                    }
                } else if ("startCapture".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.startCapture(jsonObject);
                    }
                } else if ("endCapture".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.endCapture(jsonObject);
                    }
                } else if ("endRecording".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.endRecording(jsonObject);
                    }
                } else if ("startSoundCheck".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.startSoundCheck(jsonObject);
                    }
                } else if ("endSoundCheck".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.endSoundCheck(jsonObject);
                    }
                } else if ("proxyServiceMessage".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.proxyServiceMessage(jsonObject);
                    }
                } else if ("shareAchievements".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.shareAchievements(jsonObject);
                    }
                } else if ("measureStart".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.measureStart(jsonObject);
                    }
                } else if ("allMeasureEnd".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.allMeasureEnd(jsonObject);
                    }
                } else if ("cloudDetail".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudDetail(jsonObject);
                    }
                } else if ("cloudPlay".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudPlay(jsonObject);
                    }
                } else if ("cloudSuspend".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudSuspend(jsonObject);
                    }
                } else if ("cloudSetCurrentTime".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudSetCurrentTime(jsonObject);
                    }
                } else if ("cloudChangeSpeed".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudChangeSpeed(jsonObject);
                    }
                } else if ("cloudSwitch".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudSwitch(jsonObject);
                    }
                } else if ("cloudVolume".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudVolume(jsonObject);
                    }
                } else if ("cloudGetMediaStatus".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudGetMediaStatus(jsonObject);
                    }
                } else if ("cloudMetronome".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudMetronome(jsonObject);
                    }
                } else if ("cloudDestroy".equals(api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudDestroy(jsonObject);
                    }
                } else if ("joinLiveRoom".equals(api)) {
                    content = jsonObject.getJSONObject("content");
                    if (this.onListener != null) {
                        this.onListener.joinLiveRoom(content.getString("roomId"), content.getString("teacherId"));
                    }
                } else if ("joinChatGroup".equals(api)) {
                    content = jsonObject.getJSONObject("content");
                    if (this.onListener != null) {
                        this.onListener.joinChatGroup(content.getString("type"), content.getString("id"));
                    }
                }
                if ("savePicture".equalsIgnoreCase(api)) {
                    content = jsonObject.getJSONObject("content");
                    if (this.onListener != null) {
                        this.onListener.savePicture(content.getString("base64"), content.getString("uuid"));
                    }
                }
                if (TextUtils.equals((CharSequence)"getToken", (CharSequence)api)) {
                    content = jsonObject.getJSONObject("content");
                    String userToken = CacheHelper.getUserToken();
                    String[] s = userToken.split(" ");
                    content.put("tokenType", (Object)s[0]);
                    content.put("accessToken", (Object)s[1]);
                    if (this.onListener != null) {
                        this.onListener.onSendMessage(jsonObject.toString());
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"goBack", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.onBackPress();
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"setEventTracking", (CharSequence)api)) {
                    content = jsonObject.getJSONObject("content");
                    String eventId = content.optString("type");
                    return;
                }
                if (TextUtils.equals((CharSequence)"limitScreenRecord", (CharSequence)api)) {
                    content = jsonObject.getJSONObject("content");
                    String type = content.optString("type");
                    if (this.activity == null) {
                        return;
                    }
                    if (TextUtils.equals((CharSequence)type, (CharSequence)"1")) {
                        this.activity.getWindow().addFlags(8192);
                    } else {
                        this.activity.getWindow().clearFlags(8192);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"cloudToggleFollow", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.cloudToggleFollow(jsonObject);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"setCache", (CharSequence)api)) {
                    content = jsonObject.getJSONObject("content");
                    key = content.optString("key");
                    String value = content.optString("value");
                    CacheHelper.setCustomCache(key, value);
                    return;
                }
                if (TextUtils.equals((CharSequence)"getCache", (CharSequence)api)) {
                    content = jsonObject.getJSONObject("content");
                    key = content.optString("key");
                    String customCache = CacheHelper.getCustomCache(key);
                    content.put("value", (Object)customCache);
                    if (this.onListener != null) {
                        this.onListener.onSendMessage(jsonObject.toString());
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"openAdjustRecording", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.openAdjustRecording(jsonObject);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"endTune", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.endTune(jsonObject);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"createMusicPlayer", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.createMusicPlayer(jsonObject);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"startTune", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.startTune(jsonObject);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"getDeviceDelay", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.getDeviceDelay(jsonObject);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"finishTune", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.onFinishTune(jsonObject);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"checkSocketStatus", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.checkSocketStatus(jsonObject);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"disconnectSocket", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.disconnectWebSocket();
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"startDelayCheck", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.startDelayCheck(jsonObject);
                    }
                    return;
                }
                if (TextUtils.equals((CharSequence)"closeDelayCheck", (CharSequence)api)) {
                    if (this.onListener != null) {
                        this.onListener.closeDelayCheck();
                    }
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void keepScreenLongLight(boolean isOpenLight) {
        Window window = this.activity.getWindow();
        if (isOpenLight) {
            window.addFlags(128);
        } else {
            window.clearFlags(128);
        }
    }

    public void setOnGetMethodsListener(onGetMethodsListener onListener2) {
        this.onListener = onListener2;
    }

    public static interface onGetMethodsListener {
        public void onSendMessage(String var1);

        public void setStatusBarTextColor(boolean var1, JSONObject var2);

        public void startEvaluating(JSONObject var1);

        public void cloudLoading(JSONObject var1);

        public void startRecording(JSONObject var1);

        public void endRecording(JSONObject var1);

        public void keepScreenLongLight(JSONObject var1);

        public void startSoundCheck(JSONObject var1);

        public void endSoundCheck(JSONObject var1);

        public void endEvaluating(JSONObject var1);

        public void cancelEvaluating();

        public void resumeRecording(JSONObject var1);

        public void pauseRecording(JSONObject var1);

        public void isWiredHeadsetOn(JSONObject var1);

        public void proxyMessage(JSONObject var1);

        public void proxyServiceMessage(JSONObject var1);

        public void openCamera(JSONObject var1);

        public void closeCamera(JSONObject var1);

        public void startCapture(JSONObject var1);

        public void endCapture(JSONObject var1);

        public void videoUpdate(JSONObject var1);

        public void shareAchievements(JSONObject var1);

        public void measureStart(JSONObject var1);

        public void allMeasureEnd(JSONObject var1);

        public void cloudDetail(JSONObject var1);

        public void cloudPlay(JSONObject var1);

        public void cloudSuspend(JSONObject var1);

        public void cloudSetCurrentTime(JSONObject var1);

        public void cloudChangeSpeed(JSONObject var1);

        public void cloudSwitch(JSONObject var1);

        public void cloudVolume(JSONObject var1);

        public void cloudGetMediaStatus(JSONObject var1);

        public void cloudMetronome(JSONObject var1);

        public void cloudDestroy(JSONObject var1);

        public void joinLiveRoom(String var1, String var2);

        public void joinChatGroup(String var1, String var2);

        public void paymentOrder(String var1, String var2, String var3);

        public void savePicture(String var1, String var2);

        public void cloudToggleFollow(JSONObject var1);

        public void onBackPress();

        public void openAdjustRecording(JSONObject var1);

        public void startTune(JSONObject var1);

        public void endTune(JSONObject var1);

        public void createMusicPlayer(JSONObject var1);

        public void getDeviceDelay(JSONObject var1);

        public void onFinishTune(JSONObject var1);

        public void checkSocketStatus(JSONObject var1);

        public void disconnectWebSocket();

        public void startDelayCheck(JSONObject var1);

        public void closeDelayCheck();
    }
}

