/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.services.DownloadMgrInitialParams;
import com.liulishuo.filedownloader.services.ForegroundServiceConfig;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class CustomComponentHolder {
    private DownloadMgrInitialParams initialParams;
    private FileDownloadHelper.ConnectionCountAdapter connectionCountAdapter;
    private FileDownloadHelper.ConnectionCreator connectionCreator;
    private FileDownloadHelper.OutputStreamCreator outputStreamCreator;
    private FileDownloadDatabase database;
    private FileDownloadHelper.IdGenerator idGenerator;
    private ForegroundServiceConfig foregroundServiceConfig;

    public static CustomComponentHolder getImpl() {
        return LazyLoader.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitCustomMaker(DownloadMgrInitialParams.InitCustomMaker initCustomMaker) {
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            this.initialParams = new DownloadMgrInitialParams(initCustomMaker);
            this.connectionCreator = null;
            this.outputStreamCreator = null;
            this.database = null;
            this.idGenerator = null;
        }
    }

    public FileDownloadConnection createConnection(String url) throws IOException {
        return this.getConnectionCreator().create(url);
    }

    public FileDownloadOutputStream createOutputStream(File file) throws IOException {
        return this.getOutputStreamCreator().create(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDownloadHelper.IdGenerator getIdGeneratorInstance() {
        if (this.idGenerator != null) {
            return this.idGenerator;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (this.idGenerator == null) {
                this.idGenerator = this.getDownloadMgrInitialParams().createIdGenerator();
            }
        }
        return this.idGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDownloadDatabase getDatabaseInstance() {
        if (this.database != null) {
            return this.database;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (this.database == null) {
                this.database = this.getDownloadMgrInitialParams().createDatabase();
                CustomComponentHolder.maintainDatabase(this.database.maintainer());
            }
        }
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForegroundServiceConfig getForegroundConfigInstance() {
        if (this.foregroundServiceConfig != null) {
            return this.foregroundServiceConfig;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (this.foregroundServiceConfig == null) {
                this.foregroundServiceConfig = this.getDownloadMgrInitialParams().createForegroundServiceConfig();
            }
        }
        return this.foregroundServiceConfig;
    }

    public int getMaxNetworkThreadCount() {
        return this.getDownloadMgrInitialParams().getMaxNetworkThreadCount();
    }

    public boolean isSupportSeek() {
        return this.getOutputStreamCreator().supportSeek();
    }

    public int determineConnectionCount(int downloadId, String url, String path, long totalLength) {
        return this.getConnectionCountAdapter().determineConnectionCount(downloadId, url, path, totalLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDownloadHelper.ConnectionCountAdapter getConnectionCountAdapter() {
        if (this.connectionCountAdapter != null) {
            return this.connectionCountAdapter;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (this.connectionCountAdapter == null) {
                this.connectionCountAdapter = this.getDownloadMgrInitialParams().createConnectionCountAdapter();
            }
        }
        return this.connectionCountAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDownloadHelper.ConnectionCreator getConnectionCreator() {
        if (this.connectionCreator != null) {
            return this.connectionCreator;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (this.connectionCreator == null) {
                this.connectionCreator = this.getDownloadMgrInitialParams().createConnectionCreator();
            }
        }
        return this.connectionCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDownloadHelper.OutputStreamCreator getOutputStreamCreator() {
        if (this.outputStreamCreator != null) {
            return this.outputStreamCreator;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (this.outputStreamCreator == null) {
                this.outputStreamCreator = this.getDownloadMgrInitialParams().createOutputStreamCreator();
            }
        }
        return this.outputStreamCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadMgrInitialParams getDownloadMgrInitialParams() {
        if (this.initialParams != null) {
            return this.initialParams;
        }
        CustomComponentHolder customComponentHolder = this;
        synchronized (customComponentHolder) {
            if (this.initialParams == null) {
                this.initialParams = new DownloadMgrInitialParams();
            }
        }
        return this.initialParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void maintainDatabase(FileDownloadDatabase.Maintainer maintainer) {
        Iterator iterator = maintainer.iterator();
        long refreshDataCount = 0L;
        long removedDataCount = 0L;
        long resetIdCount = 0L;
        FileDownloadHelper.IdGenerator idGenerator = CustomComponentHolder.getImpl().getIdGeneratorInstance();
        long startTimestamp = System.currentTimeMillis();
        try {
            while (iterator.hasNext()) {
                String targetFilePath;
                boolean isInvalid = false;
                FileDownloadModel model = (FileDownloadModel)iterator.next();
                if (model.getStatus() == 3 || model.getStatus() == 2 || model.getStatus() == -1 || model.getStatus() == 1 && model.getSoFar() > 0L) {
                    model.setStatus((byte)-2);
                }
                if ((targetFilePath = model.getTargetFilePath()) == null) {
                    isInvalid = true;
                } else {
                    File tempFile;
                    File targetFile = new File(targetFilePath);
                    if (model.getStatus() == -2 && FileDownloadUtils.isBreakpointAvailable(model.getId(), model, model.getPath(), null) && !(tempFile = new File(model.getTempFilePath())).exists() && targetFile.exists()) {
                        boolean successRename = targetFile.renameTo(tempFile);
                        if (FileDownloadLog.NEED_LOG) {
                            FileDownloadLog.d(FileDownloadDatabase.class, "resume from the old no-temp-file architecture [%B], [%s]->[%s]", successRename, targetFile.getPath(), tempFile.getPath());
                        }
                    }
                    if (model.getStatus() == 1 && model.getSoFar() <= 0L) {
                        isInvalid = true;
                    } else if (!FileDownloadUtils.isBreakpointAvailable(model.getId(), model)) {
                        isInvalid = true;
                    } else if (targetFile.exists()) {
                        isInvalid = true;
                    }
                }
                if (isInvalid) {
                    iterator.remove();
                    maintainer.onRemovedInvalidData(model);
                    ++removedDataCount;
                    continue;
                }
                int oldId = model.getId();
                int newId = idGenerator.transOldId(oldId, model.getUrl(), model.getPath(), model.isPathAsDirectory());
                if (newId != oldId) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(FileDownloadDatabase.class, "the id is changed on restoring from db: old[%d] -> new[%d]", oldId, newId);
                    }
                    model.setId(newId);
                    maintainer.changeFileDownloadModelId(oldId, model);
                    ++resetIdCount;
                }
                maintainer.onRefreshedValidData(model);
                ++refreshDataCount;
            }
        }
        catch (Throwable throwable) {
            FileDownloadUtils.markConverted(FileDownloadHelper.getAppContext());
            maintainer.onFinishMaintain();
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(FileDownloadDatabase.class, "refreshed data count: %d , delete data count: %d, reset id count: %d. consume %d", refreshDataCount, removedDataCount, resetIdCount, System.currentTimeMillis() - startTimestamp);
            }
            throw throwable;
        }
        FileDownloadUtils.markConverted(FileDownloadHelper.getAppContext());
        maintainer.onFinishMaintain();
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(FileDownloadDatabase.class, "refreshed data count: %d , delete data count: %d, reset id count: %d. consume %d", refreshDataCount, removedDataCount, resetIdCount, System.currentTimeMillis() - startTimestamp);
        }
    }

    private static final class LazyLoader {
        private static final CustomComponentHolder INSTANCE = new CustomComponentHolder();

        private LazyLoader() {
        }
    }
}

