/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.internal.SensorManagerProxy;
import java.util.List;

class SensorManagerProxyImpl
implements SensorManagerProxy {
    private final SensorManager mSensorManager;

    SensorManagerProxyImpl(SensorManager sensorManager) {
        this.mSensorManager = sensorManager;
    }

    @Override
    public boolean registerListener(SensorEventListener listener, int sensorType, int rate, Handler handler) {
        List sensors = this.mSensorManager.getSensorList(sensorType);
        if (sensors.isEmpty()) {
            return false;
        }
        return this.mSensorManager.registerListener(listener, (Sensor)sensors.get(0), rate, handler);
    }

    @Override
    public void unregisterListener(SensorEventListener listener, int sensorType) {
        List sensors = this.mSensorManager.getSensorList(sensorType);
        if (sensors.isEmpty()) {
            return;
        }
        try {
            this.mSensorManager.unregisterListener(listener, (Sensor)sensors.get(0));
        }
        catch (Throwable e) {
            LogProxy.w("Failed to unregister device sensor " + ((Sensor)sensors.get(0)).getName());
        }
    }
}

