/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.audioroute;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.media.AudioManager;

public class AudioControllerWrapper {
    public static final String ACTION_HEADSET_PLUG = "android.intent.action.HEADSET_PLUG";
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED";
    public static final String ACTION_SCO_AUDIO_STATE_UPDATED = "android.media.ACTION_SCO_AUDIO_STATE_UPDATED";
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static final String ACTION_BTADAPTER_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    private static final String TAG = "AudioControllerWrapper";
    AudioManager mAudioManager;
    Context context;
    private int preMode = -1;

    @SuppressLint(value={"WrongConstant"})
    public AudioControllerWrapper(Context context) {
        if (null == context) {
            return;
        }
        this.context = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioManager.setMode(-1);
        this.preMode = this.mAudioManager.getMode();
    }

    public void setSpeakerphoneOn(boolean on) {
        if (null != this.mAudioManager) {
            this.mAudioManager.setSpeakerphoneOn(on);
        }
    }

    public boolean isSpeakerphoneOn() {
        if (null != this.mAudioManager) {
            this.mAudioManager.isSpeakerphoneOn();
        }
        return true;
    }

    public int getMode() {
        if (null != this.mAudioManager) {
            this.mAudioManager.getMode();
        }
        return -1;
    }

    public boolean getScoOn() {
        if (null != this.mAudioManager) {
            return this.mAudioManager.isBluetoothScoOn();
        }
        return false;
    }

    public boolean getA2dpOn() {
        if (null != this.mAudioManager) {
            return this.mAudioManager.isBluetoothA2dpOn();
        }
        return false;
    }

    public boolean getAvailable() {
        if (null != this.mAudioManager) {
            return this.mAudioManager.isBluetoothScoAvailableOffCall();
        }
        return false;
    }

    public boolean isWiredHeadsetOn() {
        if (null != this.mAudioManager) {
            return this.mAudioManager.isWiredHeadsetOn();
        }
        return false;
    }

    public boolean isBluetoothHeadSet() {
        BluetoothAdapter bluetoothAdapter = this.getBluetoothAdapter();
        if (bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
            int profileConnectionState = bluetoothAdapter.getProfileConnectionState(1);
            return profileConnectionState == 2;
        }
        return false;
    }

    @SuppressLint(value={"WrongConstant"})
    public void setSco(boolean on, boolean isRetry, boolean needClose) {
        if (null != this.mAudioManager) {
            if (on) {
                if (!isRetry) {
                    this.preMode = this.mAudioManager.getMode();
                }
                if (needClose) {
                    this.mAudioManager.stopBluetoothSco();
                }
                this.mAudioManager.setMode(3);
                this.mAudioManager.startBluetoothSco();
                this.mAudioManager.setBluetoothScoOn(true);
            } else {
                this.mAudioManager.stopBluetoothSco();
                this.mAudioManager.setBluetoothScoOn(false);
                this.mAudioManager.setMode(this.preMode);
            }
        }
    }

    public void setSco(boolean on, boolean isRetry) {
        this.setSco(on, isRetry, true);
    }

    public BluetoothAdapter getBluetoothAdapter() {
        BluetoothManager bluetoothManager = (BluetoothManager)this.context.getSystemService("bluetooth");
        return bluetoothManager.getAdapter();
    }
}

