/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.base;

import android.text.TextUtils;
import androidx.annotation.RequiresApi;

public class RCRTCParamsType {

    @RequiresApi(api=21)
    public static enum RCRTCScreenShareAudioUsage {
        MEDIA(1),
        GAME(14),
        UNKNOWN(0);

        int value;

        private RCRTCScreenShareAudioUsage(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum RCRTCKickedReason {
        SERVER,
        IM_DISCONNECTED,
        IM_LOGOUT,
        OTHER_CLIENT_LOGIN;

    }

    public static enum AudioCodecType {
        PCMU(0),
        OPUS(111);

        private int val;

        private AudioCodecType(int codec) {
            this.val = codec;
        }

        public int getCodecType() {
            return this.val;
        }
    }

    public static enum LeaveRoomReason {
        NETWORK_NOT_AVAILABLE(1),
        SELF_LEFT(2);

        private int value;

        private LeaveRoomReason(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LeaveRoomReason valueOf(int value) {
            switch (value) {
                case 1: {
                    return NETWORK_NOT_AVAILABLE;
                }
            }
            return SELF_LEFT;
        }
    }

    public static enum RCRTCVideoResolution {
        RESOLUTION_INVALID(0, 0, 0, 0),
        RESOLUTION_144_176(144, 176, 80, 150),
        RESOLUTION_144_256(144, 256, 120, 240),
        RESOLUTION_180_180(180, 180, 100, 200),
        RESOLUTION_180_240(180, 240, 120, 240),
        RESOLUTION_180_320(180, 320, 120, 280),
        RESOLUTION_240_240(240, 240, 120, 280),
        RESOLUTION_240_320(240, 320, 120, 400),
        RESOLUTION_360_360(360, 360, 140, 520),
        RESOLUTION_360_480(360, 480, 150, 650),
        RESOLUTION_360_640(360, 640, 180, 800),
        RESOLUTION_480_480(480, 480, 180, 800),
        RESOLUTION_480_640(480, 640, 200, 900),
        RESOLUTION_480_848(480, 848, 200, 1860),
        RESOLUTION_480_720(480, 720, 200, 1000),
        RESOLUTION_720_960(720, 960, 250, 2000),
        RESOLUTION_720_1280(720, 1280, 250, 2200),
        RESOLUTION_1080_1920(1080, 1920, 400, 4000);

        private int mWidth;
        private int mHeight;
        private int mMinBitRate;
        private int mMaxBitRate;
        private String mLabel;

        public static RCRTCVideoResolution parseVideoResolution(int width, int height) {
            for (RCRTCVideoResolution resolution : RCRTCVideoResolution.values()) {
                if (resolution.getHeight() != height || resolution.getWidth() != width) continue;
                return resolution;
            }
            return RESOLUTION_INVALID;
        }

        public static RCRTCVideoResolution getVideoResolution(String videoProfileLabel) {
            for (RCRTCVideoResolution resolution : RCRTCVideoResolution.values()) {
                if (TextUtils.isEmpty((CharSequence)videoProfileLabel) || !videoProfileLabel.toLowerCase().contains(resolution.getLabel())) continue;
                return resolution;
            }
            return RESOLUTION_INVALID;
        }

        public static RCRTCVideoResolution getVideoResolution(int width, int height) {
            for (RCRTCVideoResolution resolution : RCRTCVideoResolution.values()) {
                if ((width != resolution.getWidth() || height != resolution.getHeight()) && width * height > resolution.getWidth() * resolution.getHeight()) continue;
                return resolution;
            }
            return RESOLUTION_INVALID;
        }

        private RCRTCVideoResolution(int videoWidth, int videoHeight, int minBitRate, int maxBitRate) {
            this.mWidth = videoWidth;
            this.mHeight = videoHeight;
            this.mMinBitRate = minBitRate;
            this.mMaxBitRate = maxBitRate;
            this.mLabel = String.format("%sx%s", videoWidth, videoHeight);
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getMinBitRate() {
            return this.mMinBitRate;
        }

        public int getMaxBitRate() {
            return this.mMaxBitRate;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return String.format("Resolution %s width = %s height = %s minBitRate = %s maxBitRate = %s ", this.name(), this.mWidth, this.mHeight, this.mMinBitRate, this.mMaxBitRate);
        }
    }

    public static enum RCRTCVideoFps {
        Fps_10(10, 1.0f),
        Fps_15(15, 1.0f),
        Fps_24(24, 1.5f),
        Fps_30(30, 1.5f);

        private int mFps;
        private float mMultiplier;

        public static RCRTCVideoFps parseVideoFps(int frame) {
            for (RCRTCVideoFps resolution : RCRTCVideoFps.values()) {
                if (resolution.getFps() != frame) continue;
                return resolution;
            }
            return Fps_15;
        }

        public static RCRTCVideoFps getVideoFps(String videoProfileLabel) {
            for (RCRTCVideoFps frame : RCRTCVideoFps.values()) {
                if (TextUtils.isEmpty((CharSequence)videoProfileLabel) || !videoProfileLabel.toLowerCase().contains(String.format("_%df", frame.getFps()))) continue;
                return frame;
            }
            return Fps_15;
        }

        private RCRTCVideoFps(int videoFps, float multiplier) {
            this.mFps = videoFps;
            this.mMultiplier = multiplier;
        }

        public int getFps() {
            return this.mFps;
        }

        public float getMultiplier() {
            return this.mMultiplier;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum RongRTCVideoCodecs {
        VP8(0),
        H264(1);

        private int val;

        private RongRTCVideoCodecs(int codec) {
            this.val = codec;
        }

        public int getVideoCodec() {
            return this.val;
        }
    }

    public static enum VideoBitrateMode {
        CQ(0),
        VBR(1),
        CBR(2);

        private int value;

        private VideoBitrateMode(int val) {
            this.value = val;
        }

        public static VideoBitrateMode valueOf(int value) {
            VideoBitrateMode mode = CBR;
            switch (value) {
                case 0: {
                    mode = CQ;
                    break;
                }
                case 1: {
                    mode = VBR;
                    break;
                }
                case 2: {
                    mode = CBR;
                }
            }
            return mode;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum NSLevel {
        NS_LOW(0),
        NS_MODERATE(1),
        NS_HIGH(2),
        NS_VERYHIGH(3),
        NS_MUSIC(4);

        private int value;

        private NSLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static NSLevel parseValue(int value) {
            NSLevel mode;
            switch (value) {
                case 0: {
                    mode = NS_LOW;
                    break;
                }
                case 1: {
                    mode = NS_MODERATE;
                    break;
                }
                case 2: {
                    mode = NS_HIGH;
                    break;
                }
                case 3: {
                    mode = NS_VERYHIGH;
                    break;
                }
                default: {
                    mode = NS_MODERATE;
                }
            }
            return mode;
        }
    }

    public static enum NSMode {
        NS_MODE0(0),
        NS_MODE1(1),
        NS_MODE2(2),
        NS_MODE3(3);

        private int value;

        private NSMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static NSMode parseValue(int value) {
            NSMode mode;
            switch (value) {
                case 0: {
                    mode = NS_MODE0;
                    break;
                }
                case 1: {
                    mode = NS_MODE1;
                    break;
                }
                case 2: {
                    mode = NS_MODE2;
                    break;
                }
                case 3: {
                    mode = NS_MODE3;
                    break;
                }
                default: {
                    mode = NS_MODE0;
                }
            }
            return mode;
        }
    }

    public static enum AudioQuality {
        SPEECH(32),
        MUSIC(64),
        MUSIC_HIGH(128);

        int bitrate;

        private AudioQuality(int bitrate) {
            this.bitrate = bitrate;
        }

        public int getBitrate() {
            return this.bitrate;
        }
    }

    public static enum AudioScenario {
        DEFAULT(0),
        MUSIC_CHATROOM(1),
        MUSIC_CLASSROOM(2);

        private int value;

        private AudioScenario(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AudioScenario valueOf(int value) {
            for (AudioScenario mode : AudioScenario.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }
    }

    public static enum AECMode {
        AEC_MODE0(0),
        AEC_MODE1(1),
        AEC_MODE2(2);

        private int value;

        private AECMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AECMode parseValue(int value) {
            AECMode mode;
            switch (value) {
                case 1: {
                    mode = AEC_MODE1;
                    break;
                }
                case 2: {
                    mode = AEC_MODE2;
                    break;
                }
                default: {
                    mode = AEC_MODE0;
                }
            }
            return mode;
        }
    }
}

