/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RCRTC:endInvite", flag=16)
public class EndInviteMessage
extends MessageContent {
    private static final String TAG = "InviteMessage";
    private String inviteSessionId;
    private String inviteInfo;
    public static final Parcelable.Creator<EndInviteMessage> CREATOR = new Parcelable.Creator<EndInviteMessage>(){

        public EndInviteMessage createFromParcel(Parcel source) {
            return new EndInviteMessage(source);
        }

        public EndInviteMessage[] newArray(int size) {
            return new EndInviteMessage[size];
        }
    };

    private EndInviteMessage(Parcel source) {
        this.inviteSessionId = source.readString();
        this.inviteInfo = source.readString();
    }

    public EndInviteMessage(byte[] data) {
        super(data);
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)e);
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("inviteSessionId")) {
                this.inviteSessionId = jsonObj.getString("inviteSessionId");
            }
            if (jsonObj.has("inviteInfo")) {
                this.inviteInfo = jsonObj.getString("inviteInfo");
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.putOpt("inviteSessionId", (Object)this.inviteSessionId);
            jsonObj.putOpt("inviteInfo", (Object)this.inviteInfo);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.inviteSessionId);
        dest.writeString(this.inviteInfo);
    }

    public String getInviteSessionId() {
        return this.inviteSessionId;
    }

    public String getInviteInfo() {
        return this.inviteInfo;
    }

    public String toString() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.putOpt("inviteSessionId", (Object)this.inviteSessionId);
            jsonObj.putOpt("inviteInfo", (Object)this.inviteInfo);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
            return "";
        }
        return jsonObj.toString();
    }
}

