/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.hardware.Camera;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.tools.MultiRoomManager;
import cn.rongcloud.rtc.proxy.message.UnPublishResourceMessage;
import cn.rongcloud.rtc.proxy.message.messagebeans.CDNResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.PKInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import com.google.gson.Gson;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.model.RTCUser;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RongRTCUtils {
    private static final String TAG = "RongRTCUtils";
    public static boolean customRate = false;
    public static boolean VIDEOMODE = false;
    public static boolean isMediaStreamTiny = true;
    public static boolean customFPS = false;
    public static int cameraId = -1;
    private static Gson gson = new Gson();

    public static InputStream downLoadFromUrl(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = conn.getInputStream();
        return inputStream;
    }

    public static String byteArrayToStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        String str = new String(byteArray);
        return str;
    }

    public static double div(double vl1, double vl2) {
        BigDecimal b1 = BigDecimal.valueOf(vl1);
        BigDecimal b2 = BigDecimal.valueOf(vl2);
        return b1.divide(b2, 4, 4).doubleValue();
    }

    public static double formatDouble4(double d) {
        BigDecimal bg = BigDecimal.valueOf(d).setScale(4, RoundingMode.HALF_UP);
        return bg.doubleValue();
    }

    public static int getInt(double number) {
        BigDecimal bd = BigDecimal.valueOf(number).setScale(0, 4);
        return Integer.parseInt(bd.toString());
    }

    public static Process executeCommand(String command) throws IOException, InterruptedException, TimeoutException {
        Process process = Runtime.getRuntime().exec(command);
        Worker worker = new Worker(process);
        worker.start();
        try {
            worker.join(20000L);
            if (worker.exit != null) {
                return process;
            }
        }
        catch (InterruptedException ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
        }
        process.destroy();
        process = null;
        return process;
    }

    public static String StringFormat(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    public static String getDeviceName() {
        if (cameraId == -1) {
            return null;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        }
        catch (Exception e) {
            FinLog.e(TAG, "getCameraInfo failed on index " + cameraId + "  e:" + e);
            return "Unknown";
        }
        String facing = info.facing == 1 ? "front" : "back";
        return "Camera " + cameraId + ", Facing " + facing + ", Orientation " + info.orientation;
    }

    public static boolean resourceNotExist(List<RCRTCInputStream> streamListA, List<? extends RCRTCInputStream> streamListB) {
        boolean tag = true;
        block0: for (int i = 0; i < streamListA.size(); ++i) {
            if (streamListA.get(i) == null) continue;
            for (RCRTCInputStream rCRTCInputStream : streamListB) {
                if (rCRTCInputStream == null) continue;
                String mediaId_A = streamListA.get(i).getStreamId();
                String mediaId_B = rCRTCInputStream.getStreamId();
                if (TextUtils.isEmpty((CharSequence)mediaId_A) || !TextUtils.equals((CharSequence)mediaId_A, (CharSequence)mediaId_B) || streamListA.get(i).getMediaType() != rCRTCInputStream.getMediaType()) continue;
                tag = false;
                break block0;
            }
        }
        return tag;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static String createRoomKey(String inviterRoomId, String inviteeRoomId) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(inviterRoomId);
        stringBuffer.append("|");
        stringBuffer.append(inviteeRoomId);
        return stringBuffer.toString();
    }

    public static String createInviteSessionId() {
        return UUID.randomUUID().toString();
    }

    public static String getUserProfile(String extra) {
        String remoteRoomId = null;
        if (!TextUtils.isEmpty((CharSequence)extra)) {
            try {
                JSONObject jsonExtra = new JSONObject(extra);
                if (jsonExtra != null && jsonExtra.has("roomId")) {
                    remoteRoomId = jsonExtra.getString("roomId");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return remoteRoomId;
    }

    public static String append(String ... values) {
        StringBuilder stringBuilder = new StringBuilder();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(values[i]);
            if (i >= length - 1) continue;
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }

    public static String mapToString(Map map) {
        if (map == null) {
            return "{}";
        }
        StringBuilder str = new StringBuilder("{");
        for (Object o : map.keySet()) {
            Object v = map.get(o);
            str.append(o).append(":");
            if (v == null) {
                str.append("");
            } else if (v instanceof String) {
                str.append(v.toString());
            } else {
                str.append(gson.toJson(o));
            }
            str.append(",");
        }
        str.deleteCharAt(str.length() - 1);
        str.append("}");
        return str.toString();
    }

    public static String getObjectHashCode(Object object) {
        if (object == null) {
            return "";
        }
        return String.valueOf(object.hashCode());
    }

    public static int[] videoResolutionConversion(int CDNStreamWidth, int CDNStreamHeight, int highestWidth, int highestHeight) {
        int tmpWidth = CDNStreamWidth;
        int tmpHeight = CDNStreamHeight;
        if (highestWidth > highestHeight != CDNStreamWidth > CDNStreamHeight) {
            tmpWidth = CDNStreamHeight;
            tmpHeight = CDNStreamWidth;
        }
        ReportUtil.appStatus(ReportUtil.TAG.PLAYER_STATE, "StreamW*H|CDNUrlW*H|HighestW*H", CDNStreamWidth + "*" + CDNStreamHeight, tmpWidth + "*" + tmpHeight, highestWidth + "*" + highestHeight);
        int[] objects = new int[]{tmpWidth, tmpHeight};
        return objects;
    }

    public static Object[] parseRTCUser(List<RTCUser> list, String localUserId) {
        if (RongRTCUtils.isEmpty(list)) {
            return null;
        }
        LinkedHashMap<String, RCRemoteUserImpl> remoteUsers = new LinkedHashMap<String, RCRemoteUserImpl>();
        ArrayList<String> otherRoomIdList = null;
        List<RCOutputStreamImpl> oldStreams = null;
        FinLog.d(TAG, "RTCUser size : " + list.size());
        String extra = null;
        String sourceRoomId = null;
        for (RTCUser user : list) {
            String id = user.getUid();
            FinLog.v(TAG, "uid = " + id);
            HashMap data = user.getData();
            String uris = null;
            if (data != null) {
                uris = (String)data.get("uris");
                extra = (String)data.get("extra");
                sourceRoomId = RongRTCUtils.getUserProfile(extra);
                if (!TextUtils.isEmpty((CharSequence)sourceRoomId)) {
                    if (otherRoomIdList == null) {
                        otherRoomIdList = new ArrayList<String>();
                    }
                    otherRoomIdList.add(sourceRoomId);
                    continue;
                }
            }
            FinLog.v(TAG, "uris = " + uris + " , extra : " + extra);
            if (TextUtils.equals((CharSequence)localUserId, (CharSequence)id)) {
                oldStreams = RCOutputStreamImpl.parseOutputStreams(id, uris);
                continue;
            }
            RCRemoteUserImpl rcRemoteUser = RCRemoteUserImpl.parseRemoteUsers(id, uris);
            remoteUsers.put(id, rcRemoteUser);
        }
        return new Object[]{remoteUsers, otherRoomIdList, oldStreams};
    }

    public static void sendUnpublishedCmd(List<RCOutputStreamImpl> oldStreams, String roomId) {
        if (RongRTCUtils.isEmpty(oldStreams)) {
            return;
        }
        ArrayList<MediaResourceInfo> unPublishResourceList = new ArrayList<MediaResourceInfo>();
        for (RCOutputStreamImpl localStream : oldStreams) {
            unPublishResourceList.add(new MediaResourceInfo(localStream));
        }
        SignalManager.getInstance().rtcPutInnerData(roomId, RCAttributeType.USER, "uris", "[]", new UnPublishResourceMessage(unPublishResourceList), null);
    }

    public static void parseRoomKV(String roomId, RCRoomImpl impl, MultiRoomManager multiRoomManager, HashMap<String, String> roomData) {
        if (roomData == null || roomData.size() == 0) {
            FinLog.w(TAG, "KV not found.");
            return;
        }
        PKInfo info = null;
        String tmpKey = "";
        for (Map.Entry<String, String> entry : roomData.entrySet()) {
            tmpKey = entry.getKey();
            if (TextUtils.equals((CharSequence)tmpKey, (CharSequence)"cdn_uris")) {
                impl.setCDNResourceInfo(RongRTCUtils.setCDNResourceInfo(entry.getValue()));
                continue;
            }
            info = new PKInfo(tmpKey, entry.getValue());
            if (TextUtils.equals((CharSequence)info.getInviteeRoomId(), (CharSequence)roomId) || TextUtils.equals((CharSequence)info.getInviterRoomId(), (CharSequence)roomId)) {
                multiRoomManager.getRoomAttributesElement().put(info);
                continue;
            }
            FinLog.w(TAG, "Not part of the PK list. key :" + tmpKey);
        }
    }

    private static CDNResourceInfo setCDNResourceInfo(String value) {
        CDNResourceInfo info = null;
        try {
            JSONArray array = new JSONArray(value);
            JSONObject jsonObject = array.optJSONObject(0);
            if (jsonObject != null && jsonObject.has("enableInnerCDN")) {
                info = new CDNResourceInfo(jsonObject);
            } else {
                FinLog.w("AbstractBaseState", "didn't find KEY(enableInnerCDN)");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return info;
    }

    public static void localUserKicked(IRongCoreListener.ConnectionStatusListener.ConnectionStatus connectionStatus, String roomId) {
        RCRTCParamsType.RCRTCKickedReason kickedReason = RCRTCParamsType.RCRTCKickedReason.IM_LOGOUT;
        if (connectionStatus == IRongCoreListener.ConnectionStatusListener.ConnectionStatus.SIGN_OUT) {
            ReportUtil.libStatus(ReportUtil.TAG.IMLOGOUT, "roomId", roomId);
        } else {
            kickedReason = RCRTCParamsType.RCRTCKickedReason.OTHER_CLIENT_LOGIN;
            ReportUtil.libStatus(ReportUtil.TAG.KICKEDBYOTHERCLIENT, "roomId", roomId);
        }
        if (RTCEngineImpl.getInstance().getEngineEventListener() != null) {
            RTCEngineImpl.getInstance().getEngineEventListener().onKicked(roomId, kickedReason);
        }
    }

    private static class Worker
    extends Thread {
        private final Process process;
        private Integer exit;

        private Worker(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.exit = this.process.waitFor();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

