/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc.task;

import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.task.PubSubTask;
import cn.rongcloud.rtc.webrtc.task.PubSubTaskQueue;
import java.util.concurrent.locks.LockSupport;

public class TaskCustomerThread
extends Thread {
    private static final String TAG = "TaskCustomerThread";
    private PubSubTaskQueue mTaskQueue;
    private boolean mRunning;

    public TaskCustomerThread(PubSubTaskQueue queue) {
        super(TAG);
        this.mTaskQueue = queue;
        this.mRunning = true;
    }

    @Override
    public void run() {
        while (this.mRunning) {
            FinLog.i(TAG, "run()");
            PubSubTask task = this.mTaskQueue.takeTask();
            if (task == null) {
                FinLog.e(TAG, "takeTask return null");
                continue;
            }
            try {
                FinLog.i(TAG, "task-->" + task);
                task.run();
                FinLog.i(TAG, "lockTask wait()");
                if (task.isSync()) continue;
                LockSupport.park();
            }
            catch (Exception e) {
                e.printStackTrace();
                FinLog.e(TAG, "PubSubTask run Exception: " + e.getMessage());
            }
        }
    }

    void onStop() {
        this.mRunning = false;
    }

    public void notifyTask() {
        FinLog.v(TAG, "notifyTask()");
        LockSupport.unpark(this);
    }
}

