/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.media.player.api;

import cn.rongcloud.rtc.media.player.IMediaPlayer;
import cn.rongcloud.rtc.media.player.MediaInfo;
import cn.rongcloud.rtc.media.player.RCMediaPlayer;
import cn.rongcloud.rtc.media.player.custom.AudioTrackProxy;
import cn.rongcloud.rtc.plugin.player.INetPlayer;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ImplNetPlayer
implements INetPlayer,
AudioTrackProxy.IPcmListener {
    private RCMediaPlayer mUrlMediaPlayer;
    private static final String TAG = ImplNetPlayer.class.getSimpleName();
    ExecutorService mPlayerThreadExecutor = Executors.newSingleThreadExecutor();
    Object waitOb = new Object();
    static final int waitTime = 3000;
    static final int stopWaitTime = 6000;
    INetPlayer.INetPlayerListener mINetPlayerListener;

    public void play(final INetPlayer.Builder builder, final boolean localPlayer) {
        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task|url|count", (Object[])new Object[]{"play outthread", builder.getUrl(), builder.getPlayCount()});
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final long startTime = System.currentTimeMillis();
                if (null == ImplNetPlayer.this.mUrlMediaPlayer) {
                    ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task", (Object[])new Object[]{"new player inthread"});
                    ImplNetPlayer.this.mUrlMediaPlayer = new RCMediaPlayer();
                }
                final AtomicInteger loopCount = new AtomicInteger(builder.getPlayCount());
                if (ImplNetPlayer.this.mUrlMediaPlayer.isPlaying()) {
                    ImplNetPlayer.this.mUrlMediaPlayer.stop();
                }
                ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task", (Object[])new Object[]{"reset inthread"});
                ImplNetPlayer.this.mUrlMediaPlayer.reset();
                ImplNetPlayer.this.mUrlMediaPlayer.setPcmCallBackFlag(true);
                ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task", (Object[])new Object[]{"removeListener inthread"});
                AudioTrackProxy.removeListener(TAG);
                try {
                    ImplNetPlayer.this.mUrlMediaPlayer.setDataSource(builder.getUrl());
                    ImplNetPlayer.this.mUrlMediaPlayer.setSurface(builder.getSurface());
                    ImplNetPlayer.this.mUrlMediaPlayer.setVolume(builder.getVolume(), builder.getVolume());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ImplNetPlayer.this.mUrlMediaPlayer.setOnPreparedListener(new IMediaPlayer.OnPreparedListener(){

                    @Override
                    public void onPrepared(final IMediaPlayer mp) {
                        ImplNetPlayer.this.mPlayerThreadExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task", (Object[])new Object[]{"onPrepared addListener"});
                                AudioTrackProxy.setPlayerAble(localPlayer);
                                AudioTrackProxy.addListener(TAG, ImplNetPlayer.this);
                                ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task|time", (Object[])new Object[]{"onPrepared start", System.currentTimeMillis() - startTime});
                                MediaInfo info = mp.getMediaInfo();
                                INetPlayer.MediaInfo mediaInfo = new INetPlayer.MediaInfo();
                                if (null != info && null != info.mMeta && null != info.mMeta.mVideoStream) {
                                    mediaInfo.mWidth = info.mMeta.mVideoStream.mWidth;
                                    mediaInfo.mHeight = info.mMeta.mVideoStream.mHeight;
                                }
                                ImplNetPlayer.this.mINetPlayerListener.onPrepared(mediaInfo);
                                mp.start();
                            }
                        });
                    }
                });
                ImplNetPlayer.this.mUrlMediaPlayer.setOnErrorListener(new IMediaPlayer.OnErrorListener(){

                    @Override
                    public boolean onError(IMediaPlayer mp, final int what, int extra) {
                        ImplNetPlayer.this.mPlayerThreadExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task|time", (Object[])new Object[]{"onError", System.currentTimeMillis() - startTime});
                                ImplNetPlayer.this.mINetPlayerListener.onError(what);
                            }
                        });
                        return true;
                    }
                });
                ImplNetPlayer.this.mUrlMediaPlayer.setOnCompletionListener(new IMediaPlayer.OnCompletionListener(){

                    @Override
                    public void onCompletion(final IMediaPlayer mp) {
                        ImplNetPlayer.this.mPlayerThreadExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (-1 == loopCount.get()) {
                                    ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task|loopcount", (Object[])new Object[]{"onCompletion start", -1});
                                    mp.start();
                                    ImplNetPlayer.this.mINetPlayerListener.onCompletion(-1);
                                } else {
                                    int count = loopCount.decrementAndGet();
                                    if (0 != count) {
                                        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task|curcount", (Object[])new Object[]{"onCompletion start", count});
                                        mp.start();
                                    }
                                    ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task|curcount", (Object[])new Object[]{"onCompletion", count});
                                    ImplNetPlayer.this.mINetPlayerListener.onCompletion(count);
                                }
                            }
                        });
                    }
                });
                ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task", (Object[])new Object[]{"prepareAsync"});
                ImplNetPlayer.this.mUrlMediaPlayer.prepareAsync();
                ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPLAY, (String)"task", (Object[])new Object[]{"play over"});
            }
        });
    }

    public void play(INetPlayer.Builder builder) {
        this.play(builder, true);
    }

    public void stopSync() {
        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"task", (Object[])new Object[]{"stopSync outthread"});
        FutureTask<Object> futureTask = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Long call() throws Exception {
                AudioTrackProxy.removeListener(TAG);
                try {
                    ImplNetPlayer.this.mUrlMediaPlayer.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ImplNetPlayer.this.mINetPlayerListener.onError(-999);
                }
                return null;
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            try {
                futureTask.get(6000L, TimeUnit.MILLISECONDS);
                ReportUtil.libRes((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"task", (Object[])new Object[]{"stopSync over"});
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"reason", (Object[])new Object[]{"time out"});
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"reason", (Object[])new Object[]{"ExecutionException"});
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"reason", (Object[])new Object[]{"time out"});
        }
    }

    public void releaseSync() {
        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"task", (Object[])new Object[]{"releaseSync outthread"});
        FutureTask<Object> futureTask = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Long call() throws Exception {
                AudioTrackProxy.removeListener(TAG);
                try {
                    ImplNetPlayer.this.mUrlMediaPlayer.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            try {
                futureTask.get(6000L, TimeUnit.MILLISECONDS);
                ReportUtil.libRes((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"task", (Object[])new Object[]{"releaseSync over"});
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"reason", (Object[])new Object[]{"time out"});
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"reason", (Object[])new Object[]{"ExecutionException"});
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"reason", (Object[])new Object[]{"time out"});
        }
    }

    public void stop() {
        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"task", (Object[])new Object[]{"stop outthread"});
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (null != ImplNetPlayer.this.mUrlMediaPlayer) {
                    ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"task", (Object[])new Object[]{"removeListener inthread"});
                    AudioTrackProxy.removeListener(TAG);
                    ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"task", (Object[])new Object[]{"stop inthread"});
                    try {
                        ImplNetPlayer.this.mUrlMediaPlayer.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ImplNetPlayer.this.mINetPlayerListener.onError(-999);
                    }
                    ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSTOP, (String)"task", (Object[])new Object[]{"stop over"});
                }
            }
        });
    }

    public void pause() {
        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPAUSE, (String)"task", (Object[])new Object[]{"pause outthread"});
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (null != ImplNetPlayer.this.mUrlMediaPlayer) {
                    try {
                        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERPAUSE, (String)"task", (Object[])new Object[]{"pause inthread"});
                        ImplNetPlayer.this.mUrlMediaPlayer.pause();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ImplNetPlayer.this.mINetPlayerListener.onError(-999);
                    }
                }
            }
        });
    }

    public void resume() {
        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERRESUME, (String)"task", (Object[])new Object[]{"resume outthread"});
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (null != ImplNetPlayer.this.mUrlMediaPlayer) {
                    try {
                        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERRESUME, (String)"task", (Object[])new Object[]{"resume outthread"});
                        ImplNetPlayer.this.mUrlMediaPlayer.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ImplNetPlayer.this.mINetPlayerListener.onError(-999);
                    }
                }
            }
        });
    }

    public void setVolume(final int volume) {
        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSETVOLUME, (String)"task", (Object[])new Object[]{"setVolume outthread"});
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (null != ImplNetPlayer.this.mUrlMediaPlayer) {
                    float v = volume;
                    ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSETVOLUME, (String)"task", (Object[])new Object[]{"setVolume inthread"});
                    ImplNetPlayer.this.mUrlMediaPlayer.setVolume(v / 100.0f, v / 100.0f);
                }
            }
        });
    }

    public void seek(final long ms) {
        ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSEEK, (String)"task", (Object[])new Object[]{"seek outthread"});
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (null != ImplNetPlayer.this.mUrlMediaPlayer) {
                    ReportUtil.libTask((ReportUtil.TAG)ReportUtil.TAG.NETPLAYERSEEK, (String)"task", (Object[])new Object[]{"seek inthread"});
                    try {
                        ImplNetPlayer.this.mUrlMediaPlayer.seekTo(ms);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ImplNetPlayer.this.mINetPlayerListener.onError(-999);
                    }
                }
            }
        });
    }

    public void setListener(INetPlayer.INetPlayerListener listener) {
        this.mINetPlayerListener = listener;
    }

    @Override
    public void onWrite(byte[] audioData, int offsetInBytes, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
        if (null != this.mINetPlayerListener) {
            this.mINetPlayerListener.onPcm(audioData, offsetInBytes, sizeInBytes, sampleRate, channelCount, audioFormat);
        }
    }

    public long getDuration() {
        FutureTask<Long> futureTask = new FutureTask<Long>(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                if (null != ImplNetPlayer.this.mUrlMediaPlayer) {
                    long duration = ImplNetPlayer.this.mUrlMediaPlayer.getDuration();
                    return duration;
                }
                return null;
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            Long ret = null;
            try {
                ret = futureTask.get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ret = null;
            }
            if (null == ret) {
                return -1L;
            }
            return ret;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public long getCurrentPosition() {
        FutureTask<Long> futureTask = new FutureTask<Long>(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                if (null != ImplNetPlayer.this.mUrlMediaPlayer) {
                    long pos = ImplNetPlayer.this.mUrlMediaPlayer.getCurrentPosition();
                    return pos;
                }
                return null;
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            Long ret = null;
            try {
                ret = futureTask.get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ret = null;
            }
            if (null == ret) {
                return -1L;
            }
            return ret;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return -1L;
    }
}

