/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.RemoteException;
import com.liulishuo.filedownloader.i.IFileDownloadIPCService;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.io.File;
import java.io.IOException;

public class PauseAllMarker
implements Handler.Callback {
    private static final String MAKER_FILE_NAME = ".filedownloader_pause_all_marker.b";
    private static File markerFile;
    private static final Long PAUSE_ALL_CHECKER_PERIOD;
    private static final int PAUSE_ALL_CHECKER_WHAT = 0;
    private HandlerThread pauseAllChecker;
    private Handler pauseAllHandler;
    private final IFileDownloadIPCService serviceHandler;

    public PauseAllMarker(IFileDownloadIPCService serviceHandler) {
        this.serviceHandler = serviceHandler;
    }

    public static void createMarker() {
        File markerFile = PauseAllMarker.markerFile();
        if (!markerFile.getParentFile().exists()) {
            markerFile.getParentFile().mkdirs();
        }
        if (markerFile.exists()) {
            FileDownloadLog.w(PauseAllMarker.class, "marker file " + markerFile.getAbsolutePath() + " exists", new Object[0]);
            return;
        }
        try {
            boolean success = markerFile.createNewFile();
            FileDownloadLog.d(PauseAllMarker.class, "create marker file" + markerFile.getAbsolutePath() + " " + success, new Object[0]);
        }
        catch (IOException e) {
            FileDownloadLog.e(PauseAllMarker.class, "create marker file failed", e);
        }
    }

    private static File markerFile() {
        if (markerFile == null) {
            Context context = FileDownloadHelper.getAppContext();
            markerFile = new File(context.getCacheDir() + File.separator + MAKER_FILE_NAME);
        }
        return markerFile;
    }

    private static boolean isMarked() {
        return PauseAllMarker.markerFile().exists();
    }

    public static void clearMarker() {
        File file = PauseAllMarker.markerFile();
        if (file.exists()) {
            FileDownloadLog.d(PauseAllMarker.class, "delete marker file " + file.delete(), new Object[0]);
        }
    }

    public void startPauseAllLooperCheck() {
        this.pauseAllChecker = new HandlerThread("PauseAllChecker");
        this.pauseAllChecker.start();
        this.pauseAllHandler = new Handler(this.pauseAllChecker.getLooper(), (Handler.Callback)this);
        this.pauseAllHandler.sendEmptyMessageDelayed(0, PAUSE_ALL_CHECKER_PERIOD.longValue());
    }

    public void stopPauseAllLooperCheck() {
        this.pauseAllHandler.removeMessages(0);
        this.pauseAllChecker.quit();
    }

    public boolean handleMessage(Message msg) {
        if (PauseAllMarker.isMarked()) {
            try {
                this.serviceHandler.pauseAllTasks();
            }
            catch (RemoteException e) {
                FileDownloadLog.e((Object)this, e, "pause all failed", new Object[0]);
            }
            finally {
                PauseAllMarker.clearMarker();
            }
        }
        this.pauseAllHandler.sendEmptyMessageDelayed(0, PAUSE_ALL_CHECKER_PERIOD.longValue());
        return true;
    }

    static {
        PAUSE_ALL_CHECKER_PERIOD = 1000L;
    }
}

